/*
 * Decompiled with CFR 0.152.
 */
package s32x.util;

import com.google.common.base.MoreObjects;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import omegadrive.util.BufferUtil;
import omegadrive.util.FileUtil;
import omegadrive.util.Size;
import omegadrive.util.Util;

public class BiosHolder {
    private static final byte[] EMPTY = new byte[1];
    public static final BiosHolder NO_BIOS = new BiosHolder(new BiosData[]{new BiosData(EMPTY), new BiosData(EMPTY), new BiosData(EMPTY)});
    private BiosData[] biosData = new BiosData[BufferUtil.CpuDeviceAccess.values().length];
    private Path sh2m;
    private Path sh2s;
    private Path m68k;

    public BiosHolder(Path sh2m, Path sh2s, Path m68k) {
        this.sh2m = sh2m;
        this.sh2s = sh2s;
        this.m68k = m68k;
        this.init();
    }

    public BiosHolder(BiosData[] biosData) {
        this.biosData = biosData;
    }

    private void init() {
        assert (Files.exists(this.sh2m, new LinkOption[0]));
        assert (Files.exists(this.sh2s, new LinkOption[0]));
        assert (Files.exists(this.m68k, new LinkOption[0]));
        this.biosData[BufferUtil.CpuDeviceAccess.MASTER.ordinal()] = new BiosData(FileUtil.readFileSafe(this.sh2m));
        this.biosData[BufferUtil.CpuDeviceAccess.SLAVE.ordinal()] = new BiosData(FileUtil.readFileSafe(this.sh2s));
        this.biosData[BufferUtil.CpuDeviceAccess.M68K.ordinal()] = new BiosData(FileUtil.readFileSafe(this.m68k));
        assert (this.biosData[BufferUtil.CpuDeviceAccess.MASTER.ordinal()].buffer.capacity() > 0);
        assert (this.biosData[BufferUtil.CpuDeviceAccess.SLAVE.ordinal()].buffer.capacity() > 0);
        assert (this.biosData[BufferUtil.CpuDeviceAccess.M68K.ordinal()].buffer.capacity() > 0);
    }

    public BiosData getBiosData(BufferUtil.CpuDeviceAccess type) {
        return this.biosData[type.ordinal()];
    }

    public static class BiosData {
        public ByteBuffer buffer;
        public int rawSize;
        public int padMask;
        public final String sha1sum;

        public BiosData(byte[] b) {
            this.rawSize = b.length;
            this.padMask = Util.getRomMask(this.rawSize);
            this.buffer = ByteBuffer.wrap(b);
            this.sha1sum = Util.computeSha1Sum(b);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("rawSize", this.rawSize).add("padMask", this.padMask).add("sha1", (Object)this.sha1sum).toString();
        }

        public int readBuffer(int address, Size size) {
            return BufferUtil.readBuffer(this.buffer, address & this.padMask, size);
        }
    }
}

