package m68k.cpu.instructions;

import m68k.cpu.Cpu;
import m68k.cpu.DisassembledInstruction;
import m68k.cpu.Instruction;

/*
//  M68k - Java Amiga MachineCore
//  Copyright (c) 2008-2010, Tony Headford
//  All rights reserved.
//
//  Redistribution and use in source and binary forms, with or without modification, are permitted provided that the
//  following conditions are met:
//
//    o  Redistributions of source code must retain the above copyright notice, this list of conditions and the
//       following disclaimer.
//    o  Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the
//       following disclaimer in the documentation and/or other materials provided with the distribution.
//    o  Neither the name of the M68k Project nor the names of its contributors may be used to endorse or promote
//       products derived from this software without specific prior written permission.
//
//  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
//  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
//  DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
//  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
//  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
*/
public class UNKNOWN implements Instruction
{
	protected final Cpu cpu;

	public UNKNOWN(Cpu cpu)
	{
		this.cpu = cpu;
	}

	public int execute(int opcode)
	{
		cpu.setPC(cpu.getPC() - 2);
		//illegal instruction
		int vector;
		if((opcode & 0xf000) == 0xa000)
		{
			//Line 1010 emulator
			vector = 10;
		}
		else if((opcode & 0xf000) == 0xf000)
		{
			//Line 1111 emulator
			vector = 11;
		}
		else
		{
			//illegal instruction
			vector = 4;
		}

		cpu.raiseException(vector);
		return 34;
	}

	public DisassembledInstruction disassemble(int address, int opcode)
	{
		String inst = "????";
		if((opcode & 0xf000) == 0xa000){
			inst = "line-a";
		} else if((opcode & 0xf000) == 0xf000){
			inst = "line-f";
		}
		//allow disassembly
		return new DisassembledInstruction(address, opcode, inst);
	}
}
