# IBMulator

![IBM PS/1](https://img.shields.io/badge/IBM-PS%2F1-blue) ![License GPLv3](https://img.shields.io/badge/license-GPLv3-orange) ![Nostalgia ON](https://img.shields.io/badge/nostalgia-ON-green)

IBMulator is a free/libre, open source IBM PS/1 computer emulator, able to run with the original ROM. The goal is to create a faithful simulator capable of recreating the look and feel of the real machine.

IBMulator can emulate the following systems:

 * IBM PS/1 model 2011 (286 @ 10MHz)
 * IBM PS/1 model 2121 (386SX @ 16MHz ~ 20MHz)

In order to use the program you'll need the original ROM, which is copyrighted by IBM. You won't find it distributed with this package.

Visit **[www.ibmulator.org](https://www.ibmulator.org)** for screenshots, videos, and FAQs.

You can also find additional information in the [GitHub's Wiki](https://github.com/barotto/IBMulator/wiki).

[![Screenshot of the main interface](./docs/images/normal-mode-thumb.png)](./docs/images/normal-mode.png) [![Screenshot of the realistic interface](./docs/images/realistic-mode-thumb.png)](./docs/images/realistic-mode.png)


## Features

 * **Text-To-Speech system and Accessibility**  
   TTS for both the GUI and DOS, with serial Braille 'n Speak synthetizer emulation. Fully usable with the keyboard with customizable key bindings.
 * **Works with the original IBM ROM.**  
   IBM's peculiar 4-Quad GUI and BASIC programming environment included!
 * **PS/1 Audio Card, AdLib, MPU-401, and Sound Blaster emulation.**  
   The 8-bit DAC and Programmable Sound Generator with 3 voices plus noise of the PS/1 Audio Card is properly supported.
 * **HDD and floppy drive emulation.**  
   You can use standard HDD LBA images and floppy disks in various formats like IMG, HFE, TD0, IMD. The IBM's HDD 8-bit RLL XTA-like proprietary interface is emulated, as well as floppy disks at the magnetic flux changes level.
 * **Sound effects.**  
   Emulation of the working noises generated by the floppy drive, the HDD, and the system unit fans.
 * **Realistic timings.**  
   The 286 and 386 CPUs, the WDL-330P HDD, and the integrated VGA are as painfully slow as in the original machine, for the truest PS/1 experience. The Prefetch Queue is also emulated, so games like JetFighter work as expected.
 * **OpenGL video output with advanced shaders system.**  
   IBMulator is fully compatible with the new RetroArch slang shaders. Multiple scaling options available, including integer scaling.
 * **Audio DSP filters.**  
   Audio channels can be filtered with DSP filters like Low Pass and High Pass (and many others), so that the PC-Speaker can be reproduced as it was originally intended, in all its lo-fi glory.
 * **State recording and resuming.**  
   Multiple savestates are supported, with a practical user interface.
 * **Video capture, screenshots, audio WAV capture, raw MIDI and VGM dumping.**  
   When an audio recording is started, raw music data from the PS/1 PSG and the OPL2 chip is also saved in VGM format.
 * **Full OpenGL GUI.**  
   Triple mode of operation: Compact (à la DOSBox, plus a control bar), Normal (w/ the system unit), and Realistic (whole system, monitor included!), for an added sense of realism.
 * **Adjustable emulation speed.**  
   It can go as slow as 0.01% and as fast as 500% the normal speed (and more, but only if your PC can handle it, of course). You can watch the VGA scanlines being drawn on the screen, slow down a difficult part of a game, or greatly accelerate an unskippable introduction. Audio speed will be adjusted accordingly but capturing will be unaffected and stutter-free.
 * **Serial Hayes-compatible modem emulation.** 
   Connect to modern day BBS services or play with your friends over the network.
 * **Virtual 9-pin dot-matrix color printer emulation.**
 * **Debugging tools.**
 * **Multithreaded.**  
   The GUI, sound rendering and mixing, video capture, and CPU core emulation are on separate threads, so that your i9 beast can have some spare cycles for overclocking that puny 286.
 * **Highly configurable.**  
   You can create your dream PS/1 configuration, with 500MB HDD, 16MB RAM and a blazingly fast 386DX @ 33MHz, if you want to.
 * **Multiplatform.**  
   Runs on Windows and Linux, 64-bit only though because this is the 21st century.

### List of emulated devices

 * CPU Intel 80286 and 80386 (SX & DX), with undefined behaviours, prefetch queue, and instruction timings.
 * IBM PS/1 model 2011, 2121 system boards, with POS and other control registers.
 * Standard PC platform devices: CMOS RTC, 8259 PIC, 8254 PIT, 8237 DMA, 8042 KBD controller.
 * IBM 8-bit XTA and ATA HDD controllers with timings.
 * Intel 82077AA Floppy disk controller (Model 30 mode) with timings and magnetic flux of floppy disks.
 * ATAPI CD-ROM drive (PIO mode).
 * IBM VGA adapter, with per-scanline emulation.
 * IBM PS/1 Audio Card, AdLib, Creative Sound Blaster (2.01, Pro, Pro 2), Roland MPU-401, PC Speaker.
 * Game, Serial (COM), and Parallel (LPT) ports.
 * Parallel 9-pin dot-matrix color printer, Epson FX-80/JX-80, IBM Proprinter, and IBM Graphics Printer interpreters.
 * Serial devices: Hayes-compatible modem, Braille 'n Speak synthetizer.


## System requirements and recommendations

A 64-bit Linux or Windows operating system and a 2GHz dual core processor.

Optimizations have low priority, so a modern-ish CPU and a discrete graphics card are recommended.

For shaders support you'll also need an OpenGL 3.3 compatible graphics adapter.


## Usage

1. Obtain a ROM set.
2. Launch the program.
3. Edit ibmulator.ini and specify the ROM set name.
4. Relaunch and enjoy.

See [USAGE.md](./docs/USAGE.md) for more detailed information.


## Compiling from source

For **Windows** instructions see [BUILD_WINDOWS.md](./docs/BUILD_WINDOWS.md)

For **Linux** instructions see [BUILD_LINUX.md](./docs/BUILD_LINUX.md)


## Thanks

I would like to thank the authors of the following open-source projects.

**GUI & Rendering**

 - **Simple DirectMedia Layer**, https://libsdl.org
 - **RmlUi**, https://github.com/mikke89/RmlUi
 - **GLEW**, https://github.com/nigels-com/glew

**Emulation**

 - **Bochs**, https://bochs.sourceforge.io
 - **DOSBox**, https://www.dosbox.com
 - **MAME**, https://www.mamedev.org
 - **Nuked OPL3**, https://github.com/nukeykt/Nuked-OPL3
 - **MPS Emulator**, https://github.com/GideonZ/1541ultimate

**Audio processing**

 - **libsamplerate**, https://github.com/libsndfile/libsamplerate
 - **bs2b**, https://bs2b.sourceforge.net
 - **Tal-NoiseMaker**, https://sourceforge.net/projects/tal-noisemak3r
 - **MVerb**, https://github.com/martineastwood/mverb
 - **DSPFilters**, https://github.com/vinniefalco/DSPFilters
 - **SDL_sound**, https://icculus.org/SDL_sound/
 - **dr_libs**, https://github.com/mackron/dr_libs

**Other**

 - **LodePNG**, https://lodev.org/lodepng/
 - **stb_image**, https://github.com/nothings/stb
 - **miniz**, https://github.com/richgel999/miniz
 - **tiny file dialogs**, http://tinyfiledialogs.sourceforge.net
 - **intervaltree**, https://github.com/ekg/intervaltree
 - **inih**, https://github.com/benhoyt/inih

IBMulator stands on the shoulders of giants.


## License

IBMulator is distributed under the [GNU GPL version 3](https://www.gnu.org/licenses/gpl-3.0.html) or (at your option) any later version.

For more information, see the COPYING file in the root of the repository.


## Disclaimer

IBMulator is not a product of IBM Corporation nor is it sponsored by IBM Corporation in any way.  
All trademarks and registered trademarks are the property of their respective owners.

*IBMulator is an artisanal, 100% human-made piece of software. No GenAI tools have been used for the creation of this software.*