
# JoyShockMapper
索尼PS4手柄（也叫DualShock4 DS4）、任天堂Switch JoyCons(成对使用)以及Switch Pro手柄有很多共同点。他们有许多现代游戏控制器应有的功能。此外，他们还拥有其最大的竞争对手(微软的Xbox One控制器)所没有的特殊功能： 3轴陀螺仪(以下简称“体感/陀螺仪”)。

我使用JoyShockMapper(JSM)的目标是使你能够使用DS4、JoyCons和Pro手柄畅玩PC端的游戏，甚至比你在它们各自的主机上玩得更好——并演示，证明更多游戏应该包含的操作模式。

**[点击这里](https://github.com/JibbSmart/JoyShockMapper/releases) 下载JoyShockMapper!**

对于开发者来说，这也是一个使用[JoyShockLibrary（JSL）](https://github.com/jibbsmart/JoyShockLibrary) 读取DualShock 4、JoyCons和Pro手柄输入的借鉴参考。它也是“[体感维基（GyroWiki）](http://gyrowiki.jibbsmart.com) ”上描述的许多最佳实践的案例。

JSM在Windows（Win）上工作，它使用JSL从手柄读取输入，而手柄（以下称控制器）只对Win进行编译。但是JSL没有使用Win指定的特性，而JSM只使用特定于Win的代码来模拟键盘和鼠标，并将特定于Win的代码与inputHelpers.cpp隔离开来。因此，我希望其他开发人员能够轻松地让JSL和JSM在其他平台(如Linux或Mac)上工作。

##内容
* **[开发者指南](#开发者指南)**
* **[玩家指南](#玩家指南)**
* **[快速入门](#快速入门)**
* **[指令](#指令)**
  * **[数字输入](#1-数字输入)**
    * **[短按/长按键](#11-短按/长按键)**
       * **[同时下压键](#12-同时下压按键)**
       * **[组合键](#13-组合键)**
       * **[双击按键](#14-双击按键)**
       * **[体感按键](#15-体感按键)**
  * **[模拟板机（力度分层）](#2-模拟板机)**
  * **[摇杆鼠标（视角）](#3-摇杆鼠标)**
  * **[体感鼠标（视角）](#4-体感鼠标)**
  * **[RW校准](#5-RW校准)**
  * **[快速切换](#6-快速切换)**
  * **[其他命令](#7-其他命令)**
* **[难疑解答](#难疑解答)**
* **[已知问题](#已知问题)**
* **[汉化组](汉化组)**
* **[制作组](制作组)**
* **[有用的资源](有用的资源)**
* **[许可证](许可证)**

## 开发者指南
JoyShockMapper是用c++编写的，使用CMake构建。
项目被构造成一组平台无关的头文件，而特定于平台的源文件可以在它们各自的子目录中找到。
以下文件是平台无关的:
1. ```include/InputHelpers.h``` - 这是平台无关的声明包装OS函数调用和特性。
2. ```include/PlatformDefinitions.h``` - 这是一组声明，在处理特定于平台的类型和定义时创建了一个公共基础。
3. ```include/TrayIcon.h``` - 这是一个自包含的模块，用于在Windows中显示一个带有上下文菜单的系统托盘图标。
4. ```include/Whitelister.h``` - 这是另一个自包含的Windows特定模块，它使用套接字与HIDCerberus和白列表JSM通信，Linux实现目前是一个存根。
5. ```main.cpp``` - 它完成了应用程序的所有主要逻辑。它可能有点大，但我选择保持文件结构简单，代价是有一个大的主文件。
Windows实现可以在以下文件中找到:
1. ```src/win32/InputHelpers.cpp```
2. ```src/win32/PlatformDefinitions.cpp```
3. ```src/win32/Whitelister.cpp.cpp```
4. ```include/win32/WindowsTrayIcon.h```
5. ```src/win32/WindowsTrayIcon.cpp```

Linux实现可在以下文件中找到:
1. ```src/linux/InputHelpers.cpp```
2. ```src/linux/PlatformDefinitions.cpp```
3. ```src/linux/Whitelister.cpp.cpp```
4. ```include/linux/StatusNotifierItem.h```
5. ```src/linux/StatusNotifierItem.cpp```

通过在项目根目录下的命令提示符中运行以下命令生成项目:
-窗口:
  * ```mkdir build && cd build```
*创建一个Visual Studio x86配置: ```cmake .. -G "Visual Studio 16 2019" -A Win32 .```
*创建一个Visual Studio x64配置: ```cmake .. -G "Visual Studio 16 2019" -A x64 .```
Linux:
  * ```mkdir build && cd build```
  * ```cmake .. -DCMAKE_CXX_COMPILER=clang++ && cmake --build .```
  
### 特定于Linux的说明
为了建立在Linux上，必须满足以下依赖，与他们各自的开发包:
- gtk + 3
- libappindicator3
- libevdev

由于GCC中的[bug](https://stackoverflow.com/questions/49707184/explicit-specialization-in-non-namespace-scope-does-not-compile-in-gcc)，当前形式的项目将只使用Clang构建。

JoyShockMapper最初是为Windows开发的，它的副作用是代码库中使用的某些类型是特定于Windows的。这些已经在Linux上重新定义。这样做是为了将对应用程序核心逻辑的更改保持在最低限度，并降低导致现有用户回归的可能性。

应用程序需要```rw```访问```/dev/uinput```和 ```/dev/hidraw[0-n]```(实际设备取决于操作系统分配的节点)。这可以通过```chown``` -ing所需的设备节点给运行应用程序的用户来实现，或者通过应用```dist/linux/50-joyshockmapper.rules```中的udev规则，将用户添加到输入组，并重新启动计算机使更改生效。更多关于udev规则的信息可以在
https://wiki.archlinux.org/index.php/Udev#About_udev_rules 找到。

该应用程序将在X11和Wayland上工作，尽管聚焦窗口检测只在X11上工作。

## 玩家指南
最新版本的JoyShockMapper总是可以在[这里](https://github.com/JibbSmart/JoyShockMapper/releases) 找到。你所要做的就是运行JoyShockMapper.exe。

包括一个叫作GyroConfigs的文件夹。这包括为2D和3D游戏创建新配置的模板，以及包含用于简单RW校准的配置文件。


## 快速入门
1.通过USB或蓝牙连接你的DualShock 4（DS4），或通过蓝牙连接你的JoyCons或Pro控制器。

2.运行JoyShockMapper.exe，你将看到一个控制台窗口“欢迎使用JoyShockMapper！”
* 如果你想在启动JSM后连接你的控制器，你可以使用命令RECONNECT\_CONTROLLERS来连接这些控制器。

3.拖入一个配置文件并按enter键加载该文件中的所有设置。
* Configuration文件只是文本文件。文本文件中的每个命令都可以直接输入到控制台窗口中。有关JSM命令的全面指南，请参阅下面的“命令”。
示例配置文件包含在GyroConfigs文件夹中。

4.如果你正在使用一个配置，利用陀螺仪/体感控制，陀螺仪将需要校准(被告知什么是“静止的”)。见“命令”下的“陀螺鼠标输入”获得更多信息，但这里有简短的版本:
* 把所有的控制器放在一个静止的表面上;
* 输入命令RESTART\_GYRO\_CALIBRATION开始对它们进行校准;
* 几秒钟后，输入命令FINISH\_GYRO\_CALIBRATION来完成对它们的校准。

5.一个好的配置文件已经校准了灵敏度设置到有用的RW值。这使得转换灵敏度在不同的游戏之间变得很容易，不同的游戏对于他们自己的灵敏度设置有不同的尺度。更多信息请参见下面的[RW校准](#5-RW校准)。

6.每次游戏窗口进入焦点时，JSM可以自动加载游戏配置文件。将文件放入自动加载文件夹中，挨着可执行文件（exe）。JSM将根据启动的程序的可执行名称查找配置。当它进入焦点并启用自动加载时(默认情况下)，JSM将告诉你它要查找的文件的名称—不区分大小写。你可以通过输入命令```AUTOLOAD = off```来关闭它。你也可以通过```AUTOLOAD = ON```再次启用它。

7.支持控制器的游戏，比如*Apex Legends*，有时候并不能忽略你的控制器（会导致控制器与虚拟键鼠冲突）。像HIDGuardian / HIDCerberus这样的程序允许你屏蔽除*白名单*之外的所有应用程序。如果你已经安装并运行了HIDCerberus，那么可以通过输入命令```WHITELIST_ADD```将JoyShockMapper添加到白名单中，通过命令```WHITELIST_REMOVE```将其删除，并且你可以通过输入```WHITELIST_SHOW```在浏览器中显示HIDCerberus配置页面。

## 命令
只需在JSM控制台窗口中输入命令并按“enter”即可执行命令。你还可以将一些命令放到文本文件中，通过在JSM中输入文件的路径(完整路径或相对于JSM可执行文件的路径)并单击’enter’，执行所有这些命令。我将这样的文件称为“配置文件（configuration file）”。在Windows中，还可以将文件从文件游览器（Explorer）拖放到JSM控制台窗口中，以输入该文件的完整路径。

配置文件还可以包含对其他配置文件的引用。这可以简化在不同游戏中的共享设置——如果你有首选的摇杆和陀螺设置，你可以将它们保存在一个单独的文件中，并让所有其他配置文件引用该文件，而不是将摇杆和体感设置复制上百遍。

*大部分*命令可以被分为4类:

1.**[数字输入](#1-数字输入)**. 这些是最简单的。将控制器按键按下或移动映射到键盘按键或鼠标按键上。有许多可用的映射选项，如短按/长按键，同时下压键和组合键。

2.**[模拟扳机](#2-模拟板机)**. Dualshock 4控制器有2个模拟扳机:L2和R2。JSM可以在扳机的“半按”和“全按”上设置不同的映射，最大化地使用这些扳机。这一功能对于有数字扳机的控制器是不可用的，比如任天堂Pro和Joycons。

3.**[摇杆鼠标](#3-摇杆鼠标)**. 你可以通过摇杆/体感移动鼠标指针。摇杆鼠标有两种模式:

* **标准瞄准**. 你们传统的摇杆瞄准方式。
* **甩枪瞄准**. 地图/视角会根据摇杆倾斜的角度旋转，稍后会做详细解释

4.**[体感鼠标](#4-体感鼠标)**. 用陀螺仪控制鼠标通常比用摇杆要精确的多。可以把陀螺仪想象成一个放在在隐形、无摩擦的鼠标垫上的鼠标。无论你如何舒服地旋转控制器，鼠标垫都可以延伸。对于直接控制视角的游戏来说，固定的鼠标输入提供了快捷的方式来完成小精度的大旋转，而陀螺鼠标输入允许你在相对有限的范围内做出更精确、快速的运动。

5.**[RW校准](#5-RW校准)**. 校准正确可以使*甩枪瞄准*更精确，为陀螺仪和瞄准摇杆设置有意义的现实参考数据，并为允许玩家在不同游戏之间分享相同的灵敏度设置。

6.**[快速切换](#6-快速切换)**. 各种配置可以根据控制器当前按下的按键重新设置，类似于组合按键。例如这可以很方便的处理“武器轮盘”。根据SI命名被称为“快速切换（modeshifts）”。

7.**[其他的命令](#6-其他命令)**. 它们不属于上述类别，但仍然很有用。

因此，让我们深入研究可用的命令。

### 1. 数字输入
数字输入真的很简单。它们的结构大致如下:

```[Controller Input] = [Key or Mouse Button]```

例如，要将方向点映射到左边的F1键，你需要输入:

```LEFT = F1```

JSM的一个重要特性是，适用于DualShock 4的配置同样适用于一对JoyCons或Pro控制器。因为JoyCons的输入比DualShock 4稍微多一点(JoyCons有```SL```和```SR```)，所以按键的名字大多来自任天堂设备。主要的例外是face按键和stick-click（摇杆下压）。因为它们的名字更简洁，摇杆下压以DualShock 4命名:``` L3``` 和```R3```.

face按键是一个更复杂的东西。

Xbox的布局实际上已经成为PC控制器的布局。大多数使用某种控制器的PC玩家都很熟悉Xbox的布局，无论是Xbox控制器、Steam控制器，还是其他可以被游戏理解为Xbox控制器的第三方控制器。即使是DualShock 4的用户也会在某种程度上习惯Xbox face按键的名称。任天堂的设备有相同的正面按键，但布局不同。X和Y互换了，A和B也互换了。任天堂的布局也存在了较长时间，但PC玩家并不太熟悉。

因此，在我看来，最好的解决方案是两种布局都不使用，而是使用一个明确的命名系统，其中的按键名称不采用任何控制器的，但仍然有明显的方向。北、东、南、西，分别用```N```、```E```、```S```、```W```表示。

所以，这里是完整的数字输入列表:

```
UP: d-pad的↑
DOWN: d-pad的↓
LEFT: d-pad的←
RIGHT: d-pad的→
L: L1 or L, 左侧小肩键
ZL: L2 or ZL, 左侧大肩键 (或扳机)
R: R1 or R, 右侧小肩键
ZR: R2 or ZR, 右侧大肩键 (或扳机)
ZRF: 完全下压右扳机, 只有DS4有
ZLF: 完全下压左扳机, 只有DS4有
-: share 或 -
+: option 或 +
HOME: PS 或Home
CAPTURE: 触控板下压 或 Capture
SL: SL, 只有JoyCons有
SR: SR, 只有JoyCons有
L3: 左摇杆下压
R3: 右摇杆下压
N: 朝北按键, △ 或 X
E: 朝东按键, ○ 或 A
S: 朝南按键, ⨉ 或 B
W: 朝西按键, □ 或 Y
LUP: 左摇杆上倾
LDOWN: 左摇杆下倾
LLEFT: 左摇杆左倾
LRIGHT: 左摇杆右倾
LRING: 左摇杆内环/外环
RUP: 右摇杆上倾
RDOWN: 右摇杆下倾
RLEFT: 右摇杆左倾
RRIGHT: 右摇杆右倾
RRING: 右摇杆内环/外环
这些都可以映射到以下键盘和鼠标输入:
0-9: 键盘顶部的数字键
N0-N9: 小键盘的数字键
F1-F29: F1-F29
A-Z: 字母键
UP, DOWN, LEFT, RIGHT: 方向键（箭头键）
LCONTROL, RCONTROL, CONTROL: 左Ctrl, 右Ctrl, 通用Ctrl
LALT, RALT, ALT: 左Alt, 右Alt, 通用Alt
LSHIFT, RSHIFT, SHIFT: 左Shift, 右Shift, 通用Shift
TAB: Tab
ENTER: 回车
LMOUSE, MMOUSE, RMOUSE: 鼠标左键, 中键和右键
BMOUSE, FMOUSE: 鼠标后退键 (第四键)和鼠标前进键(第五键)
SCROLLUP, SCROLLDOWN: 滚轮上, 下
PAGEUP, PAGEDOWN, HOME, END, INSERT, DELETE, BACKSPACE
NONE: 无输出（空）
CALIBRATE: 当收到输入时校准手柄
GYRO_ON, GYRO_OFF: 开启/关闭手柄
GYRO_INVERT, GYRO_INV_X, GYRO_INV_Y: 反转陀螺仪, 或只有 x/y轴
; ' , . / \ [ ] + -
```

例如，在一个R代表’reload（换弹）’, E代表’use（使用）’的游戏中，你可以将□对应为’reload’，△对应为’use’。

```
W = R
N = E
```

#### 1.1短按&长按键
由于键盘比大多数控制器有更多的输入，主机端游戏通常会将多个动作映射到同一个按键上，而PC端会将这些动作映射到不同的键上。为了在控制器上适应键盘映射，JSM允许你将短按和长按映射到不同的键盘/鼠标输入。那么让我们拿着同样的游戏，让它我们可以点击□来’R换弹’或者按住△来’E使用’

```
W = R E
```

如果你想要短按□时’换弹’，但按住时不做任何动作（NONE），你可以参考：

```
W = R NONE
```

体感相关的点击映射会在释放按键大约半秒后应用，但其他映射会非常快速的响应按键。

#### 1.2 同时触发键
JSM还允许将同时按下的按键绑定到不同的映射上。例如，你可以像这样在你的两个小肩键（Bumper）上绑定角色的普通技能和终极技能。

```
L = LSHIFT # 技能1
R = E      # 技能2
L+R = Q    # 终极技能
```

要启用同时绑定，两个按键需要在很短的时间内按下。这样做将忽略单独的按键绑定，并应用指定的绑定，直到其中一个按键被释放。与其他映射一样，同时绑定也支持短按&长按绑定。这个特性非常适合使用DPAD对角线，或者添加JSM特定的特性，比如陀螺仪校准和体感控制，而不需要占用更有用的按键。

#### 1.3 组合键
组合键与同时触发键不同，尽管乍一看是相似的。当按下组合键时，组合键可以覆盖按键映射。这样就可以使用各种不同的实际组合，从而允许使用前后关系进行绑定。这里有个Left 4 Dead 2的例子，它可以让你不用把拇指从左摇杆上移开就能装备物品。

```
W = R E # 换弹/使用
S = SPACE # 跳跃
E = CONTROL # 蹲下 
N = T # 语音沟通

L = Q NONE # 下个武器, 按住以使用Face按键切换.
L,W = 3 # 投掷物
L,S = 4 # 药
L,E = 5 # 大包
L,N = F # 手电筒
```

一个按键可以与多个其他按键连接。在这种情况下，最新的组合键优先于之前的组合键。这可以理解为每次按下组合键时，在映射之上的层堆栈，其中只有顶部是活动的。注意，你不需要使用NONE作为绑定。组合键可以很好地绑定到一个按键，例如一个武器轮盘。

#### 1.4 双击按键
你还可以将按键的双击分配给不同的映射。双击按键与组合按键相似，只是按键本身就是它的组合键的。它支持短按和长按，就像以前的所有条目一样。

```
N = SCROLLDOWN # 切换武器
N,N = X # 切换武器开火模式
```

当在第一次按下后的0.2秒内发生第二次按下时会激活双击映射。在这段时间内，不能设置其他映射，因此常规的点击将引入延迟。此时，时间不能更改。

#### 1.5 体感按键
最后，有一种数字输入的工作方式不同，因为它可能与其他任何输入重叠。有两个输入，但在给定的配置中，你最多只会用到其中一个:

```
GYRO_OFF
GYRO_ON
```

当你分配一个按键到```GYRO_ON```，该按键被按下时，体感鼠标工作。当你分配一个按键到```GYRO_OFF```，该按键被按下时，体感鼠标关闭。这是大多数游戏缺失的一个非常重要的功能，体感瞄准——就像电脑游戏玩家可以暂时通过将鼠标台离鼠标垫“禁用”鼠标,以重新定位,体感玩家可以暂时禁用陀螺为了重新定位它。此绑定不影响与该按键关联的其他映射。这是为了使体感可以与某些游戏动作一起被启用，或者使体感可以立即被禁用或启用，而不管什么短按或长按被映射到那个按键。

对于那些真正需要使用控制器上所有可用按键的游戏，但是其中一个输入很少使用，并且可以很容易地进行切换(比如蹲伏)，所以让这个输入只进行短按是符合逻辑的，并且当你握住它时，让它作为双倍的GYRO_OFF:

```
E = LCONTROL NONE
GYRO_OFF = E
```

或者如果你真的不能腾出一个按键来禁用陀螺仪，你可以使用LEFT\_STICK或RIGHT\_STICK禁用陀螺仪，而输入正在被使用:

```GYRO_OFF = RIGHT_STICK # 当使用摇杆瞄准时关闭体感```

我喜欢使用摇杆瞄准(或甩枪瞄准)的同时与体感瞄准,但这仍然可以比没有禁用体感强...如果你的游戏没有一个明显的功能进行体感瞄准(比如一个专门的“武器开镜”按键,在第三人称动作游戏中很常见)。

```GYRO_ON```在你只需要偶尔精确瞄准的游戏中非常有用。如果ZL让你的角色瞄准他们的弓(就像*塞尔达:荒野之气*或*魔多之影*)，也许这是你唯一需要启用体感瞄准的时候:

```
ZL = RMOUSE   # 用弓瞄准
GYRO_ON = ZL  # 当ZL被按下时使用体感
```

```GYRO_ON```和```GYRO_OFF```也可以作为一个动作绑定到特定的按键。与上面的命令相反，它采用了操作绑定的位置。但你需要它时，你仍然可以找到创造性的方式与短按/长按键或和组合按键正确的绑定体感控制。

请注意，点击应用陀螺相关绑定需要半秒响应。另一种选择是用GYRO_INVERT反转陀螺仪输入。如果你只玩一个joycon，这样的绑定会很方便，因为你没有第二个摇杆。当这个动作被启用时，倒转使它使你可以重新进入手继续在相反的方向!

```
SL + SR = GYRO_OFF GYRO_INVERT  # 当SL SR被同时按下时关闭体感半秒并反转轴向
```

绑定体感的行动，像那些有优先超过分配的体感按键，如果他们冲突。

命令```NO_GYRO_BUTTON```可以用来删除GYRO-ON或-OFF映射，使体感总是启用。要始终禁用它，只需设置```GYRO_ON = NONE```或让```GYRO_SENS```为0。

### 2. 模拟扳机

下面的部分只适用于DS4控制器，因为它是唯一支持的具有模拟扳机的控制器。

模拟扳机报告一个介于0%和100%之间的值，表示你扣动扳机的距离。将一个数字按键绑定到一个模拟扳机是通过一个固定值来实现的。当触发值跨越threashold（临界/阈）值(介于0%和100%之间)时，按键按下被发送。默认的threashold值是0，意味着最轻微地按下扳机发送按键按。这对于响应性很好，但可能会导致意外按压。threashold可以通过运行以下命令自定义:

```
TRIGGER_THRESHOLD = 0.5   #在扳机被按下一半时发送扳机信号
```

两个扳机使用相同的threashold值。值为1.0或更高会使绑定无法达到，而小于0则会使其始终按下。

JSM可以为扳机的完全拉动分配不同的映射，允许你在考虑持有绑定时在每个扳机上有多达4个映射位。处理这些映射的方式是用变量```ZR_MODE```和```ZL_MODE```为R2和L2设置扳机。一旦设置完毕，你就可以将按键分配给```ZRF```和```ZLF```，以便分别使用R2和L2的全拉绑定。在这种情况下，```ZL```和```ZR```被称为软压映射，因为它们在100%完全拉绑定之前激活。下面列出了所有可能的触发模式。

```
NO_FULL (default): 忽略完全下压。 数字扳机手柄，如Switch Pro强制在这种模式下工作
NO_SKIP: 永远不跳过软压映射，完全下压映射将会在扳机完全下压时激活
MUST_SKIP: 只会在扳机快速达到完全下压时触发完全下压映射, 忽略软压映射
MAY_SKIP: 结合 NO_SKIP 和MUST_SKIP: 当在快速完全下压时软压会被忽略, 并且完全下压可以在软压上正常工作
MUST_SKIP_R: 快速反应版本的 MUST_SKIP. 见后文
MAY_SKIP_R: 快速反应版本的 MAY_SKIP. 见后文
```

例如，在《使命召唤》中，当你使用狙击时，你必须屏住呼吸。你可以这样将软压绑定致开镜并将全压绑定到屏息:

```
ZL_MODE = NO_SKIP   # 开启完全下压映射，永远不跳过开镜
ZL = RMOUSE         # 开镜
ZLF = LSHIFT        # 按住以屏息
```

使用NO_SKIP模式使得LSHIFT只有在RMOUSE也处于活动状态时才处于活动状态。然后在右边的扳机上，你可以绑定你不同的攻击绑定:使用跳跃功能，以避免它们之间的冲突，像这样:

```
ZR_MODE = MUST_SKIP # 启动完全下压映射， 软压和完全下压映射不可同时触发的
ZR = LMOUSE         # 开火
ZRF = V G           # 快速软压以使用近战武器; 快速全压以温雷并在松开时投掷出
```

使用MUST_SKIP模式确保一旦你开始射击，完全下压将**不会**使你停止射击并开始近战。

SKIP模式的“响应式”变体启用了不同的行为，可以在特定环境下提供比原始版本更好地体验。一个典型的例子是，软压映射是一个类似于开镜或趴下的模式映射，而该软压映射没有按住或一直按住映射。不同之处在于，软压映射在扳机越过阈值时就会被激活，从而提供所需的响应感觉（快速反应），但如果快速达到全压，则会被忽略，因此仍然允许你以腰射为例。这将导致一个有希望可忽略的范围出错，但授予一个更快速地开镜。

### 3. 摇杆鼠标（视角）
每个摇杆有7种不同的运行方式:

```
AIM: 传统的摇杆瞄准
FLICK: 甩枪瞄准
FLICK_ONLY: flick stick without rotation after tilting the stick
ROTATE_ONLY: flick stick rotation without the initial flick
MOUSE_RING: 将光标位置直接设置屏幕中心相对摇杆的圆上
MOUSE_AREA: 将摇杆映射在一个光标可操作的圆形区域
NO_MOUSE: 不影响鼠标，使用按钮映射(默认)
```

左右摇杆模式设置如下:

```
LEFT_STICK_MODE = NO_MOUSE
RIGHT_STICK_MODE = AIM
```

不管是什么模式,你都可以将输入范围绑定到一个部分或完全倾斜的摇杆。例如,当摇杆完全倾斜时,你可能想要一直按下LSHIFT（以疾跑）:

```
LEFT_RING_MODE = OUTER # 外环是默认的，所以这条命令行是选择性的
LRING = LSHIFT
```

或者你可能想要摇杆部分倾斜时一直按LALT:

```
LEFT_RING_MODE = INNER
LRING = LALT
```

出于向后兼容性的考虑，还有两个额外的选项为```LEFT_STICK_MODE```和```RIGHT_STICK_MODE```对于同时设置相应stick_mode和RING_MODE的LEFT_STICK_MODE和RIGHT_STICK_MODE:

```
INNER_RING: 相同于 _STICK_MODE = NO_MOUSE 和 _RING_MODE = INNER
OUTER_RING: 相同于 _STICK_MODE = NO_MOUSE 和 _RING_MODE = OUTER
```

让我们看看所有不同的操作模式。

当使用```标准瞄准```摇杆模式时，有几个重要的命令:

* **STICK\_SENS** (默认为360.0度/秒) - 当杆完全倾斜时，旋转视角的速度有多快?如果校准正确，默认是360度每秒。
* **STICK\_POWER** (默认1.0) - 将摇杆输入转换为视角旋转速度所用的曲线形状是什么?1.0是一个简单地线性关系(杆的一半倾斜将以STICK\_SENS给出的一半速度旋转)，0.5为平方根，2.0为二次关系，等等。最小值为0.0，这意味着对于STICK\_SENS而言，任何超出STICK\_DEADZONE\_INNER的输入都将被视为全倾。
* **STICK\_AXIS\_X和STICK_AXIS\_Y**(默认标准)-这允许你反转摇杆，如果你愿意的话。你的选项是标准的(默认的)或反向的(翻转轴)。
* **STICK\_ACCELERATION\_RATE**(默认每秒增加倍数为0.0)-当摇杆被完全倾斜时，这个选项允许你随时间增加视角的旋转速度。此设置的单位是STICK\_SENS每秒的乘数。例如，STICK_SENS为100的2.0会使视角在1秒内从每秒100度加速到每秒300度。
* **STICK\_ACCELERATION\_CAP**(默认为1000000.0乘数)-当STICK\_ACCELERATION\_RATE非零时，你可能想设置一个视角旋转速度的限制。例如，将STICK\_ACCELERATION\_CAP设置为2.0意味着你的视角旋转速度不会超过STICK_SENS设置的两倍。当STICK\_ACCELERATION\_RATE为0时，这没有影响。
* **STICK\_DEADZONE\_INNER** 和 **STICK\_DEADZONE\_OUTER** (分别默认为0.15和0.1)——控制器的摇杆可能有点不精确。当你松开摇杆时，它可能不会精确地回到中心。STICK_\DEADZONE\_INNER可以让你说多少摇杆的范围被认为是“中心”。如果摇杆位置在这个距离中心，它将被认为没有摇杆输入。STICK\_DEADZONE\_OUTER对外边缘执行相同的操作。如果棍子的位置在这个距离外边缘，它将被认为是完全压。两者之间的所有东西都相应地进行了缩放。

```FLICK```模式有更少的配置。没有死区和灵敏度。当你将摇杆推向一个方向, JSM只需要把输入的角度,并把它转换成游戏相对于视角的角度, 一切都发生在一瞬间。摇杆一旦被倾斜，旋转X度将立即使游戏中的视角旋转X度。这提供了一种非常自然的方式来快速旋转，对视野外的事件做出反应，或者在不移动控制器的情况下逐步旋转。

由于*甩枪瞄准*模式下摇杆只会水平转动视角，它一般只有实际结合体感瞄准，才可以处理垂直瞄准。

*甩枪瞄准*将使用上面提到的STICK\_DEADZONE\_OUTER来决定摇杆已经被推得足够远，来进行“甩”或旋转。*甩枪瞄准*依赖REAL\_WORLD\_CALIBRATION（[RW校准](#4-RW校准)）来正确工作(后面会讲到，因为它会影响所有转换为鼠标移动的输入)。这是因为JSM只能通过使鼠标移动来将视角指向一个给定的方向，而RW校准帮助JSM计算该怎么移动。本身兼容摇杆的游戏将不需要校准。甩枪瞄准有几个设置参数，如果你真的想玩弄一下:

* **FLICK\_TIME** (默认0.1秒)-当你倾斜摇杆一个方向，视角需要多长时间旋转至指定方向?我发现0.1秒提供了一个完美的，迅猛的动作，同时仍然看起来不错。如果设置的值太低，你可能会看起来像在作弊，立即从一个方向转向另一个方向。
记住，一旦倾斜摇杆将使视角立即旋转。没有必要将摇杆推到底部\*;视角只需要做与摇杆相同的运动。旋转时间只影响动作时长。
* **FLICK\_SNAP\_MODE** (默认没有)-如果没有练习，有时你会弹到一个不同的角度，而不是你想要的。如果你想限制你可以甩动的角度，FLICK\_SNAP\_MODE给你三个选项。默认情况下，NONE是根本不弹。通过练习，我希望玩家们会发现这是最有用的，因为惊喜可以来自任何角度。但你的其他选项是4，它迅速弹到最近的直接向前，直接向左，直接向右，或直接向后。这是90度的间隔。如果你想也能捕捉到45度的间隔，你可以设置FLICK\_SNAP\_MODE为8。
* **FLICK_SNAP_STRENGTH **(默认值1.0)-如果你有一个除了NONE模式之外的snap模式，这个值会给你它的snap（吸附）强度，从0(不吸)到1 (完全吸住)不等。

**\*开发人员注意:DualShock 4的杆输入分辨率很低，以至于过小的摇杆运动会导致卡顿。JSM应用了一些平滑，只是非常小的变化，在甩枪瞄准下，这是非常有效的补偿。更大的移动完全不会被平滑。这些东西在[体感维基](http://gyrowiki.jibbsmart.com)中会更详细的解释。JSM自动为DualShock 4计算不同的平滑阈值，但是你可以通过设置ROTATE\_SMOOTH\_OVERRIDE的数值来覆盖平滑阈值，或者设置为0来禁用平滑，或者设置为-1来抵消自动计算的阈值。

```FLICK_ONLY```和```ROTATE_ONLY```摇杆模式的工作原理和甩枪瞄准一样，只是有些功能被屏蔽了。前者意味着你将得到最初的甩，但没有后续旋转。后者意味着你不会得到最初的甩，但随后的旋转将工作。

当使用```MOUSE_RING```摇杆模式时，倾斜摇杆将把鼠标光标从屏幕中心的位置偏移到摇杆的位置。这种模式主要是为双杆射手准备的。为此，应用程序需要知道你的屏幕分辨率(SCREEN\_RESOLUTION\_X和SCREEN\_RESOLUTION\_Y)以及你希望光标位于屏幕中心的距离(MOUSE\_RING\_RADIUS)。当此模式运行时(即摇杆不是静止的)，所有其他的鼠标移动都被忽略。

当使用```MOUSE_AREA``` stick模式时，STICK值直接设置鼠标位置。因此，将摇杆向右逐渐移动到边缘将会以相同的速度移动光标，其像素数等于```MOUSE_RING_RADIUS```的值;并且把摇杆移回中间将会把光标移回它开始的地方。与前一个模式相反，该模式可以与其他鼠标输入(如体感)一起操作。

当使用```NO_MOUSE```摇杆模式时，JSM将使用摇杆的**上、下、左、右**绑定在十字形门布局。有一个小的方形死区，可以忽略非常小的摇杆移动。

```
# 左摇杆移动
LLEFT = A
LRIGHT = D
LUP = W
LDOWN = S
LEFT_RING_MODE = INNER
LRING = LALT # 慢走
```

### 4. 体感鼠标（视角）
**你需要知道的第一件事是体感鼠标输入**控制器的陀螺仪将经常需要校准。这仅仅意味着告诉应用程序“零（原点）”在哪里。陀螺仪与比例尺一样，需要一个可供比较的参考点，以便准确地给出结果。这是通过保持控制器不动来实现的，或者在你的手中保持控制器不动，然后在很短的一段时间内计算出平均速度。它需要在一段时间内取平均值，因为陀螺仪会捕捉到一点“噪声”——不是由任何真实运动引起的微小变化——但与人试图握住控制器时地抖动相比，这种噪声微不足道。

当你第一次将控制器连接到JSM时，它们都将开始“连续校准”——这只是意味着它们在很长一段时间内收集平均速度。这个累积平均值不断应用到陀螺仪输入，所以如果控制器保持静止足够长的时间，应该没有明显的问题。

如果控制器静止在一个稳定表面，启动体感鼠标，鼠标指针自己在屏幕上移动(即使非常缓慢)时，你的设备就需要校准了。这没关系——我在大多数游戏环节的开始都会这么做，尤其是任天堂设备，它们似乎更需要这一点。

为了校准你的陀螺仪，把你的控制器放在稳定表面，使它不动，然后使用以下命令:

* **RESTART\_GYRO\_CALIBRATION** -所有连接的陀螺仪将开始收集陀螺仪数据，记住到目前为止收集的平均值并将其视为“零”。
* **FINISH_GYRO_CALIBRATION** - 停止收集陀螺仪数据进行校准。JSM将使用它已经从控制器收集的任何内容作为从控制器输入的“零”参考点。

应该只需要一秒钟左右，以获得一个良好参数来校准你的设备。你还可以映射一个**校准**按钮来分别校准每一个控制器。你可以这么设置，假设你使用内置映射:

* 点击你的控制器上的PS、点击触控板、Home或Capture按键来重新启动校准，或者如果控制器已经在校准，则完成校准。
* 按住PS、点击触控板、Home或Capture按键重新启动校准，一旦释放控制器，它就会完成校准。警告:我发现触摸Home键会干扰我的一个JoyCons上的陀螺仪输入，所以如果我按住这个按键校准它，当我松开按键时它会被错误校准。如果遇到这种情况，最好依赖于每个控制器上面的点击切换快捷键，或者使用上面的命令同时校准所有控制器。

陀螺需要校准的原因是它们的物理特性(比如温度)会影响它们的“零”感。通常在一个游戏会话开始时的校准对于其余的游戏会话就足够了，但是在控制器预热后它可能会再次使用校准。如果陀螺的“零点”不正确，当控制器不动时，鼠标就会朝着一个方向移动，那么它就需要校准了。

**你需要知道的第二件事是关于如何选择体感鼠标的灵敏度:

* **GYRO\_SENS** (默认值0.0)-如何旋转控制器来旋转游戏中的视角?值为1意味着旋转控制器将使游戏中的视角旋转相同的角度(在两个轴的范围内)。值为2意味着在游戏中旋转控制器将使角度翻倍。增加gyro sens给你更多移动的自由...在你感到恶心并禁用陀螺仪和重新定位控制器之前。但减少它将给你更多的稳定性以打击小目标。
对于那些你不用直接转动视角，而是用鼠标来控制屏幕上的光标的游戏来说，陀螺仪为1意味着控制器需要完全转动才能从屏幕的一边转到另一边。对于像这样的游戏，你最好拥有一个8或更高，这意味着你只需要转动手柄360/8 = 45度就可以从屏幕的一边移动到另一边。

一个单独的GYRO\_SENS设置可能不足以获得你需要的精度，你需要舒适地操作视角，而不是因恶心而定期禁用陀螺仪和重新定位控制器。

JSM允许你说，“当慢慢旋转时，我想要这种灵敏度。快速旋转时，我需要那种灵敏度。”你可以通过设置两个实际速度阈值和每个阈值的灵敏度来实现这一点。中间的所有东西都是线性插值的。为此，使用MIN\_GYRO\_THRESHOLD, MAX\_GYRO\_THRESHOLD, MIN\_GYRO\_SENS，和MAX\_GYRO\_SENS:

* **MIN_GYRO_THRESHOLD**和**MAX_GYRO_THRESHOLD**(默认0.0度/秒); **MIN\_GYRO\_SENS**和**MAX\_GYRO\_SENS**(默认值0.0)——MIN\_GYRO\_SENS MAX\_GYRO\_SENS与GYRO\_SENS一样,但MIN\_GYRO\_SENS适用于控制器在或低于MIN\_GYRO\_THRESHOLD定义的速度,和MAX_GYRO_SENS适用于控制器是将以上速度由MAX\_GYRO\_THRESHOLD定义的。当控制器以这两个阈值之间的速度转动时，体感灵敏度被相应地插补。阈值以每秒的实际度数为单位。例如，如果你想一下你需要多快的旋转控制器才能在一秒内旋转四分之一圈，也就是每秒90度。设置GYRO\_SENS将覆盖MIN\_GYRO\_SENS和MAX\_GYRO\_SENS为相同的值。你可以通过为命令指定两个值(用空格分隔)来设置不同的**垂直灵敏度**。

**最后**，如果你想的话，还有一些设置你可以调整:

* **GYRO\_AXIS\_X和GYRO\_AXIS\_Y**(默认标准)-这允许你倒置的陀螺仪方向，如果你希望。想要一个左陀螺仪转换为右转?将GYRO\_AXIS\_X设置为INVERTED（倒置）。对于正常的行为，把它设定为STANDARD（标准）。
* **MOUSE\_X\_FROM\_GYRO\_AXIS**和**MOUSE\_Y\_FROM\_GYRO\_AXIS** (默认分别为Y和X)——也许你想通过围绕其本地Z轴滚动控制器来左右旋转视角，而不是围绕其本地Y轴旋转。或者你想使用单个JoyCon玩。这就是你要做的。如果你希望鼠标的移动轴不受陀螺仪的影响，则可以选择X、Y、Z和NONE。
* **GYRO\_CUTOFF\_SPEED** (默认为每秒0.0度)-一些游戏试图通过设置一个最低速度来掩盖无意的小动作，低于这个速度陀螺仪的输入将被忽略。这就是设置。这种感觉并不好。不要使用它。有些游戏甚至不允许你改变或禁用这个“功能”。我实施了它，看看它是否可以被完善。我把它放在那里只是为了让你自己看到它不好，或者让你告诉我它是怎样的。
在与带有大按键的简单UI交互时，没有问题，但如果玩家有意地将控制器转慢(比如跟踪一个缓慢移动的目标)，这就毫无用处，因为它们可能会无意中低于截止速度。即使是一个非常小的截止速度也可能是如此之高，以至于它不可能以与一个非常慢的目标相同的速度移动目标。
有人可能会说，这样的门槛太高了，只需要降低一点就可以了。但如果截止速度足够小以至于它不会让玩家地体验更糟，那么它也可能足够小以至于它实际上什么也做不了。
* **GYRO\_CUTOFF\_RECOVERY** (默认值0.0度/秒)——为了避免GYRO\_CUTOFF\_SPEED的问题让人无法移动光标以同样的速度是非常缓慢的目标,JSM排除之间的转换速度和一个阈值由GYRO\_CUTOFF\_RECOVERY截止。最初的目的是让GYRO\_CUTOFF\_SPEED不可怕，它最终做了一个很好地工作，减少颤抖，即使当GYRO\_CUTOFF\_SPEED被设置为0.0，但我只使用它(可能与平滑结合，下面)作为最后的手段。
* **GYRO\_SMOOTH\_THRESHOLD** (默认0.0度每秒)-可选的，JSM将应用平滑的陀螺输入，以掩盖在高灵敏度颤抖的手。平滑的问题是，它不可避免地引入了延迟，所以游戏不应该让任何平滑应用于任何输入速度超过一个非常小的阈值。任何在此阈值或以上的陀螺仪运动都不会平滑。任何低于这个阈值的东西将根据GYRO\_SMOOTH\_TIME设置平滑，并逐步过渡，从完全平滑到一半的GYRO\_SMOOTH\_THRESHOLD到没有平滑的GYRO\_SMOOTH\_THRESHOLD。
* **GYRO\_SMOOTH\_TIME** (默认为0.125秒)-如果对陀螺输入应用任何平滑(由GYRO_SMOOTH_THRESHOLD决定)，GYRO_SMOOTH_TIME是它被平滑的时间长度。较大的值意味着更平稳的移动，但也会让它感觉迟钝和无响应。把平滑的时间设置得太小，这样就不能掩盖无意的动作。

### 5. RW校准

*甩枪瞄准*，标准瞄准，以及体感瞄准全部依赖于REAL\_WORLD\_CALIBRATION（基于现实校准的数据，RW校准）以提供有效的，可在玩家之间互通的数据，等等。更进一步，如果RW校准数据不正确，那么大部分功能，尤其是*甩枪瞄准*都会出现误差甚至失效。

每款游戏都要求独立的RW校准数据以便这些功能正常工作。这其实使得分享配置文件变得更加容易通用。因为一旦一个人算出了某个游戏的RW校准数据，那么他就可以将数据分享给大家。[体感维基](http://gyrowiki.jibbsmart.com) 有一个游戏数据库和相应的RW校准数据(以及该游戏特有的其他配置)。你可以使用它来避免过多的计算，或者如果游戏不在数据库中，你可以帮助其他玩家自己计算它的RW校准参数并将其贡献给体感维基!

对于鼠标直接控制视角的3D游戏，RW校准是一个倍增器，可以将给定的角度转换为鼠标输入，从而在游戏中将视角转换为相同的角度。

2D游戏鼠标直接控制屏幕上的光标,RW校准的乘数将给定分数完全变成一个鼠标输入,同样的分数满屏幕的宽度(1920 x1080分辨率在游戏分辨率影响光标速度相对于屏幕的大小)。
在我们进入如何准确计算一个好的RW校准参数的给定游戏之前，我们首先需要解决另外两个影响鼠标灵敏度的事情:

* 游戏内鼠标设置
* Windows(系统)鼠标设置

即使RW校准设置正确，游戏中的鼠标设置也会改变视角或光标对鼠标移动的反应:

* 如果你玩启用了鼠标加速的游戏(只有少数游戏有这个设置，而且通常是默认禁用的)，你需要在游戏中禁用它，JSM才能准确工作。
* 大多数游戏都有*鼠标灵敏度设置*，这是鼠标输入的一个简单的乘数。JSM不能读取到到这个值，所以你需要手动告诉它这个值是什么，以便它可以抵消这个值。你可以通过将```IN_GAME_SENS```设置为游戏的鼠标灵敏度来实现这一点。
举个例子，在玩键盘和鼠标时，我的*Quake Champions*鼠标灵敏度是1.8。所以在我的Quake Champions配置文件中，或每当我使用别人的配置文件，我包括命令:```IN_GAME_SENS = 1.8```，以便JSM知道如何抵消它。

*有些*游戏还需要处理另一个因素。**Window(系统)鼠标设置**:

* 在你的Windows鼠标设置中，有一个JSM无法准确计算的“增强指针精度”选项。大多数玩家禁用这个选项，使用JSM时最好也禁用它。
* Windows的指针速度设置通常也会影响游戏中鼠标的行为，但JSM*可以*检测Windows的指针速度设置并对付它。这可以通过简单的命令来完成:```COUNTER_OS_MOUSE_SPEED```。
唯一的问题是有些游戏*不受Windows指针速度设置的影响*。许多现代射击游戏使用“原始输入”来忽略Windows的设置，因此用户可以自由地使用“增强指针精度”和任何他们想在操作系统中不影响游戏的灵敏度设置。如果你已经使用了COUNTER\_OS\_MOUSE\_SPEED，并且意识到你不应该使用它，那么```IGNORE_OS_MOUSE_SPEED```命令将恢复默认行为，这对于使用原始输入的游戏很有用。

总之，在准备共享配置文件供其他人使用时，请考虑是否应该包含COUNTER\_OS\_MOUSE\_SPEED。当使用别人的配置文件时，请记住将文件的IN\_GAME\_SENS设置为*你*在游戏中的鼠标灵敏度。

一旦你完成了这些，你就可以**计算游戏的RW校准数据**了。

对于**3D游戏，鼠标直接控制视角**，最准确的方法来计算一个好的RW校准值，是使甩枪瞄准随着第一次猜测RW校准值，像这样:

```
RIGHT_STICK_MODE = FLICK
REAL_WORLD_CALIBRATION = 40
```

现在，在游戏中，用你的鼠标将你的准心精确地固定在你面前的一个小目标上。向前倾斜你的右摇杆，旋转它，直到你完成了一个完整的转身，当你的指针在你倾斜摇杆之前的相同位置释放摇杆。

JSM记得你做的最后一个*甩枪*和旋转，所以现在你可以简单地输入以下命令:

```CALCULATE_REAL_WORLD_CALIBRATION```

这告诉JSM你的最后一次甩枪旋转了游戏内完整的一圈，你想知道你应该拥有什么RW校准值。JSM会给出类似这样的响应:“建议REAL\_WORLD\_CALIBRATION: 151.5”(假设)。现在你可以验证一切工作正常，通过改变你的RW校准设置如下:

```REAL_WORLD_CALIBRATION = 151.5``` (或JSM提供的任何值)。

现在检查在游戏中，启用甩枪瞄准。如果这个值工作，你在游戏中转动的角度应该与你转动摇杆的角度相匹配。

如果你想做得更精确，你可以做不止一个圈。例如，如果你在不松开摇杆的情况下连续完成了10个圈，以便平均松开摇杆时的不精确性，你可以在CALCULATE\_REAL\_WORLD\_CALIBRATION命令之后添加旋转数量:

```CALCULATE_REAL_WORLD_CALIBRATION 10```

你也可以在非整数回合中这样做，比如用0.5转半圈。

对于*2D游戏，鼠标直接控制屏幕上的光标*，甩枪瞄准在这种游戏中并没有实际的用途，但它仍然是计算RW校准值的最有用的方法。再一次，确保你的IN\_GAME\_SENS和COUNTER\_OS\_MOUSE\_SPEED是根据需要设置的，然后我们将通过在REAL\_WORLD\_CALIBRATION的第一次猜测启用*甩枪瞄准*。

```
RIGHT_STICK_MODE = FLICK
REAL_WORLD_CALIBRATION = 1
```

注意，这一次，我们的第一个RW校准值猜测是1，而不是40。2D光标游戏的RW校准值往往比3D视角游戏的RW校准值要低得多，所以最好降低你的第一次猜测值，而不是过高，这样你就可以完成更多的摇杆旋转，得到更准确地结果。
对于2D光标游戏，一个完整的甩枪旋转应该移动光标从屏幕的一边到另一边。与3D视角游戏不同的是，屏幕的边缘会卡住鼠标的位置，如果我们试图通过它们进行测量，就会干扰结果。在校准3D视角游戏时，如果我们的旋转幅度过大也是可以的，因为我们仍然可以将摇杆向后移动，直到我们精确地落在目标上，这样就可以正常工作了。但是当校准2D光标游戏时，在任何一个方向上超出都意味着一些摇杆输入经过JSM，但是相应的鼠标输入在游戏中会被忽略。

所以，首先手动将鼠标移动到屏幕的左边边缘，然后按你的右棒向前但稍微向右，以避免意外地稍微向左移动(并撞在屏幕的左边)。现在顺时针旋转摇杆，直到你几乎碰到屏幕的另一边，然后松开右边的摇杆。像以前一样，你现在可以让JSM计算一个好的REAL\_WORLD\_CALIBRATION，如下所示:

```CALCULATE_REAL_WORLD_CALIBRATION```

JSM会给你推荐的RW校准。它可能类似于:“建议REAL\_WORLD\_CALIBRATION: 5.3759”。

你不需要告诉JSM你是在为2D游戏还是3D游戏校准。*甩枪瞄准*和其他设置依赖RW校准计算这样的3D游戏,但没有直接关联之间的3D游戏的工作方式(在角度和旋转速度)2D游戏的工作方式(在二维平面上),所以校准2D光标游戏这么做更方便描述。

有了这样一个经过校准的2D游戏，你可以选择你的陀螺仪或其他设置，通过思考你想要多少转动你的控制器来移动整个屏幕。当GYRO\_SENS为1将需要一个完整的旋转控制器从屏幕的一边移动到另一边，这是相当不合理的! 但是一个陀螺仪8意味着你只需要转动控制器1 / 8(45度)就可以从另一边移动，这应该是相当合理的。

### 6. 快速切换
前几节中描述的所有设置都是分配(即:使用等号'=')，可以像常规按键映射一样使用连字符。这被称为modeshift（快速切换），因为当特定按键被启用时，你正在重新配置控制器。唯一的例外是```AUTOLOAD=[ON|OFF]```命令，因为它与控制器映射无关而被排除，以及```NO_GYRO_BUTTON```，因为它与```GYRO_OFF = NONE```相同。

例如在*DOOM 2016*中，当你打开武器轮时，你可以使用正确的摇杆:

```
RIGHT_STICK_MODE = FLICK # 使用甩枪瞄准
GYRO_OFF = R3 # 使用体感，当按下右摇杆时停用

R = Q # 上一件武器/使用武器轮盘

R,GYRO_ON = NONE # 当R被按下时停用体感
R,RIGHT_STICK_MODE = MOUSE_AREA # 使用摇杆选择轮盘武器
```

其他的想法包括改变陀螺仪灵敏度时，瞄准下，或只有当完全扣动扳机。

```
GYRO_SENS = 1 0.8 # 低垂直灵敏度

ZL_MODE = NO_SKIP # 使用完全下压
ZL = RMOUSE # 开镜
ZLF = NONE # 完全下压状态下无映射

ZLF,GYRO_SENS = 0.5 0.4 # 完全下压状态下灵敏度减半
```

这些命令的功能与组合键绑定完全相同，但是如果有多个组合处于活动状态，那么最新的命令具有优先级。而且，无论映射是否处于活动状态，只要按键处于关闭状态，组合就处于活动状态。还值得注意的是，在摇杆模式改变的特殊情况下，释放组合按键回到正常模式后，摇杆输入将被忽略，直到它回到中心。在上面的*DOOM*的例子中，这防止了在释放组合键时出现意外的甩枪。

要移除一个已存在的modeshift，你必须给该组合键分配```NONE```。

```ZLF,GYRO_SENS = NONE```

### 7. 其他命令
还有一些不属于上述类别但有用的命令:

* **RESET\_MAPPINGS** - 这将重置所有JSM的设置为默认值。这样，在进行大的更改时，你不必手动取消按键映射或其他设置。始终使用RESET\_MAPPINGS命令启动配置文件可能会很有用。唯一的例外是校准状态和自动加载。
* **RECONNECT\_CONTROLLERS** - 在JSM启动后连接的控制器将被忽略，直到你告诉它RECONNECT\_CONTROLLERS为止。当这发生时，所有陀螺仪校准将重置所有控制器。
* **JOYCON\_GYRO\_MASK**  (默认IGNORE_LEFT) -大多数使用体感控制开关的游戏忽略左JoyCon的陀螺仪，以避免混淆行为时，JoyCon是分开运行的。这是JSM中的默认行为。但是你也可以选择IGNORE\_RIGHT、IGNORE\_BOTH或USE\_BOTH。
* **# 留言** - 以“#”开头的行或行中的任何部分都将被忽略。使用它来组织/注释你的配置文件，或临时删除你以后可能要添加的命令。

## 难疑解答
一些在Switch或PS4上作为控制器的第三方设备可能无法使用JoyShockMapper。JSM只支持原装控制器。尽管如此，问题仍然会出现。伸出援手，希望我们能找出问题所在。
但首先，这里有一些值得首先检查的常见问题。

JoyShockMapper控制台将告诉你连接了多少设备，并将输出大多数输入的信息(按键按下或释放，倾斜摇杆)。然而，测试陀螺仪工作的唯一方法是启用它，看看你是否能移动鼠标。最快的方法来检查是否陀螺仪输入工作没有加载配置是进入命令GYRO_SENS = 1，然后移动控制器。不要忘记，如果鼠标在移动，即使控制器没有移动，那么你可能需要校准陀螺仪。

许多JSM用户依赖于像HIDGuardian这样的工具来隐藏游戏中的控制器输入。如果JSM不能识别你的控制器，也许你还没有白名单JoyShockMapper。

在某些情况下，JSM控制台会对控制器输入做出响应，而鼠标会对陀螺仪运动做出响应，但你正在玩的游戏不会对它做出响应。当你以管理员身份启动游戏时，可能会发生这种情况。为了向游戏发送键盘和鼠标事件，JoyShockMapper还必须具有管理员权限。

一些用户发现摇杆输入在一个或多个方向上没有响应。这可能会发生，如果摇杆没有使用足够的范围，它可用。在这种情况下，增加STICK\_DEADZONE\_OUTER可以有所帮助。同样的道理，当摇杆被按下时，即使没有被触碰，它也可能会报告方向。当STICK\_DEADZONE\_INNER太小时就会发生这种情况。

## 已知问题
### 回报率
只有当JoyShockMapper从控制器获得新指令时，才会发送新的鼠标和键盘操作。这意味着，如果游戏和显示器的刷新率高于控制器的轮询率，有时游戏和显示器将在不移动鼠标的情况下更新，即使你通常希望鼠标移动。DualShock 4每秒发送250条消息，这对于极高的刷新率显示来说已经足够了。但是JoyCons和Pro控制器每秒发送66.67条消息，这意味着当你在每秒66.67帧以上播放(和显示)时，你可能会遇到卡顿的动作。未来版本的JoyShockMapper可以通过将消息重复到所需的刷新速率来解决这个问题。

### 蓝牙连接
JoyCons和Pro控制器只能通过蓝牙连接。即使通过USB连接，它们目前仍然只能通过蓝牙通信。一些蓝牙适配器跟不上这些设备，导致输入滞后。当连接多个设备时(例如使用一对JoyCons时)，这种情况尤其常见。JSM或JoyShockLibrary对此无能为力。

对DualShock 4的蓝牙支持是JoyShockMapper的新功能，并不是所有人都能使用。如果你遇到任何问题，请让我知道。

## 汉化组
如果你认为翻译有任何问题，或者建议，请反馈致QQ：2896378152 或邮箱：lkitdqwb@gmail.com
未来我也会对体感维基（GyroWiki），YouTube视频和JoyShockMapper软件做翻译以及转载

## 制作组
我是 Julian "Jibb" Smart, 我制作了JoyShockMapper. 从 v1.3开始, JoyShockMapper已经从大量的社区贡献中受益。非常感谢以下贡献者:
* Nicolas（代码）
* Bryan Rumsey（图标设计）
* Contributer (图标设计)
* Sunny Ye (迁移/翻译)
* Romeo Calota (linux/general portability)

看一下更新日志，更好地了解谁贡献了什么。特别是Nicolas，他经常贡献很多工作。他负责很多很酷的生活质量和高级的映射功能。
JoyShockMapper非常依赖于用于读取控制器输入的[JoyShockLibrary](https://github.com/jibbsmart/JoyShockLibrary)。请查看该项目，看看之前的工作是如何使JoyShockLibrary成为可能的。

## 有用的资源
* [GyroWiki（体感维基）](http://gyrowiki.jibbsmart.com) - 所有可以体感控制的好游戏:
* 为什么陀螺控制使游戏更好;
* 开发人员如何更好地实现陀螺仪控制;
* 如何使用JoyShockMapper;
* 用户可编辑的用户配置集合和使用JoyShockMapper与一堆游戏的提示。

## 许可证
JoyShockMapper is licensed under the MIT License - see LICENSE.md.
