<h1 align="center">
  <br>
  <a href="[https://github.com/Lime3DS]"><img src="https://raw.githubusercontent.com/Lime3DS/Lime3DS/1b1c4f29d4280c750702459fd9a6ada539a4e9a9/dist/lime.svg" alt="Lime3DS" width="200"></a>
  <br>
  <b>Lime3DS</b>
  <br>
</h1>

![GitHub Release](https://img.shields.io/github/v/release/Lime3DS/Lime3DS?label=Current%20Release)
![GitHub Downloads](https://img.shields.io/github/downloads/Lime3DS/Lime3DS/total?logo=github&label=GitHub%20Downloads)
![Flathub Downloads](https://img.shields.io/flathub/downloads/io.github.lime3ds.Lime3DS?logo=Flathub&label=Flathub%20Downloads)
![](https://github.com/Lime3DS/Lime3DS/actions/workflows/build.yml/badge.svg)

<b>Lime3DS</b> is a project which aims to revive and continue work on Citra, a popular open-source 3DS emulator which ceased development.

# Installation

### Windows & MacOS

Download the latest release from [Releases](https://github.com/Lime3DS/Lime3DS/releases).

#### Windows Version Differences
There is no emulation specific difference between the MSVC and MSYS2 versions of Lime3DS, they are just two different compilers used to create a Lime3DS executable. However, there are a few functional differences:
* MSVC generates a smaller file
* Microsoft developed [MSVC](https://learn.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist) and is closed source while [MSYS2](https://www.msys2.org/) is open-source
* MSVC requires the installation of [Microsoft Visual C++ runtime](https://learn.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist), if not already installed, which can require a restart to finish the install. If you have issues with the Microsoft Visual C++ runtimes, you should try the MSYS2 install
* There have been reports where MSVC has not worked while MSYS2 does

---
### Android
The recommended method of downloading Lime3DS on Android is via Obtainium:
1. Download and install Obtainium from [here](https://github.com/ImranR98/Obtainium/releases) (use the file named `app-release.apk`)
2. Open Obtainium and click 'Add App'
3. Type `https://github.com/Lime3DS/Lime3DS` into the 'App Source URL' section
4. Click 'Add'
5. Click 'Install' (or 'Update' if you have an existing APK install)
6. Lime3DS is now ready to use

Using Obtainium will allow for quick and easy installation of updates.
\
\
\
Alternatively, you can install the latest APK from the [Releases](https://github.com/Lime3DS/Lime3DS/releases) page.

This will require a new APK to be manually downloaded each time an update is released.

---
### Linux

Lime3DS is available as an AppImage on the [Releases](https://github.com/Lime3DS/Lime3DS/releases) page.

We are also on Flathub:

<a href=https://flathub.org/apps/io.github.lime3ds.Lime3DS><img width='180' alt='Download on Flathub' src='https://dl.flathub.org/assets/badges/flathub-badge-en.png'/></a>

# Build Instructions
Please refer to our website's [wiki](https://github.com/Lime3DS/Lime3DS/wiki/Building-From-Source) in order to find building instructions for Windows, Linux, Android and MacOS

# Compatibility Reporting
Reports for game compatibility can be made here: https://github.com/Lime3DS/compatibility-list

Please ensure that you have read the contributing document before submitting a report.

# Minimum Requirements
Below are the minimum requirements to run Lime3DS:
### Desktop
```
Operating System: Windows 10 (64-bit), MacOS Ventura, or modern 64-bit Linux
CPU: x86-64 (64-bit) CPU. Single core performance higher than 1,800 on Passmark
GPU: OpenGL 4.3 or Vulkan 1.1 support
Memory: 2GB of RAM. 4GB is recommended
```
### Android
```
Operating System: Android 9.0+
CPU: Snapdragon 835 SoC or better
GPU: OpenGL ES 3.2 or Vulkan 1.1 support
Memory: 2GB of RAM. 4GB is recommended
```

# What's next?
We keep a public roadmap of what features/bug fixes are planned to be included in the next update or two.
You can find this at https://github.com/Lime3DS/Lime3DS/milestones.

# How can I contribute?
If you believe you can help with this project, please lend us your talent! We're a team of passionate enthusiasts who need all the help we can get.

If there is an issue you want solved or a feature you want implemented, feel free to open a pull request.

<sup>(Please don't repeatedly merge `master` into your PR's branch. A maintainer will update the branch for you if/ when it is appropriate to do so)</sup>

Additionally, we are accepting language translations on [Transifex](https://app.transifex.com/lime3ds/lime3ds). If you know a non-english language listed on our Transifex page, please feel free to contribute.

> [!NOTE]  
> We are not currently accepting new languages for translation. Please do not request for new languages or language variants to be added.

# Discord
Join our Discord community to discuss the project or talk with the developers.

[![](https://dcbadge.vercel.app/api/server/4ZjMpAp3M6)](https://discord.gg/4ZjMpAp3M6)
