#!/bin/ksh
#
# MTXtoBAF.sh - Convert MTX tape files to MTXL loadable files
#
# Dirty hack alert.
#
# MTX tapes start with header and system variables.
# The system variables base is often 0xf8f2,
# This means there are 0x0259 bytes of system variables.
# This script strips off the system variables, producing a file which starts
# with the first basic block.
# MTXL.COM can load some (but not all) of these files.
#

for f in \
"AGROVATA.mtx" \
"Alice in Wonderland (1983) (Continental Software).mtx" \
"Arcazion (1985) (Chris Sawyer) [a1].mtx" \
"Backgammon (1983) (Continental Software) [a1].mtx" \
"Boris and the Bats (1984) (TRi-Com Software).mtx" \
"Bouncing Bill (1984) Brian Rogers.mtx" \
"Cobra (19xx) (Xaviersine Audio Products).mtx" \
"Contact Bridge II (1984) (Continental Software).mtx" \
"Johnny Rebel (19xx) [a1].mtx" \
"Kommand (Chris Sawyer) (19xx).mtx" \
"Marbles (19xx).mtx" \
"Pontoon Blackjack (19xx) (Continental Software).mtx" \
"Qogo (1984) (Continental Software) [a1].mtx" \
"Salty Sam (1984) (Syntaxsoft).mtx" \
"SNAPPO.mtx" \
"Space Invasion (1998) (PD).mtx" \
"Super Minefield (1984) (Continental Software) [a1].mtx" \
"Tapeworm (1984)(Continental Software)[a].mtx" \
"Target Zone (1985) (Syntaxsoft) [a1].mtx" \
"Vortex by Paul Daniels (19xx) (PD).mtx" \
; do
	f2=`dd "if=../tapes/$f" bs=1 skip=1 count=8 2> /dev/null`
	f2=${f2%% *}
	dd "if=../tapes/$f" of=$f2.BAF bs=1 skip=619 2> /dev/null
done 
