/*

diag.h - Diagnostic code

*/

#ifndef DIAG_H
#define	DIAG_H

/*...sincludes:0:*/
#include <stdlib.h>
#include <stdarg.h>

#include "types.h"

/*...vtypes\46\h:0:*/
/*...e*/

#define	DIAGM_CONSOLE               0x00000001
#define	DIAGM_FILE                  0x00000002
#define	DIAGM_RING                  0x00000004

#define	DIAG_ALWAYS                   0
#define	DIAG_WIN_UNKNOWN_KEY          1
#define	DIAG_MEM_IOBYTE               2
#define	DIAG_MEM_SUBPAGE              3
#define	DIAG_MEM_DUMP                 4
#define	DIAG_VID_STATUS               5
#define	DIAG_VID_REGISTERS            6
#define	DIAG_VID_ADDRESS              7
#define	DIAG_VID_DATA                 8
#define	DIAG_VID_REFRESH              9
#define	DIAG_VID_MARKERS             10
#define	DIAG_VID_TIME_CHECK          11
#define	DIAG_VID_TIME_CHECK_ABORT    12
#define	DIAG_VID_TIME_CHECK_DROP     13
#define	DIAG_KBD_WIN_KEY             14
#define	DIAG_KBD_DRIVE               15
#define	DIAG_KBD_SENSE               16
#define	DIAG_KBD_AUTO_TYPE           17
#define	DIAG_KBD_REMAP               18
#define	DIAG_JOY_INIT                19
#define	DIAG_JOY_USAGE               20
#define	DIAG_SND_REGISTERS           21
#define	DIAG_SND_LATENCY             22
#define	DIAG_SND_INIT                23
#define	DIAG_CTC_REGISTERS           24
#define	DIAG_CTC_PENDING             25
#define	DIAG_CTC_INTERRUPT           26
#define	DIAG_MON_HW                  27
#define	DIAG_MON_KBD_WIN_KEY         28
#define	DIAG_MON_KBD_MAP_TH          29
#define	DIAG_SDXFDC_PORT             30
#define	DIAG_SDXFDC_HW               31
#define	DIAG_SDXFDC_DATA             32
#define	DIAG_SDXFDC_STATUS           33
#define	DIAG_SIDISC_FILE             34
#define	DIAG_SIDISC_ADDRESS          35
#define	DIAG_SIDISC_DATA             36
#define	DIAG_PRINT                   37
#define	DIAG_CPM_DRIVER              38
#define	DIAG_CPM_CBIOS               39
#define	DIAG_CPM_BDOS_FILE           40
#define	DIAG_CPM_BDOS_OTHER          41
#define	DIAG_Z80_INSTRUCTIONS        42
#define	DIAG_Z80_INSTRUCTIONS_NEW    43
#define	DIAG_Z80_TIME                44
#define	DIAG_Z80_TIME_IPERIOD        45
#define	DIAG_Z80_INTERRUPTS          46
#define	DIAG_BAD_PORT_DISPLAY        47
#define	DIAG_BAD_PORT_IGNORE         48
#define	DIAG_PANEL_HACK              49
#define	DIAG_TAPE                    50
#define	DIAG_SPEED                   51
#define	DIAG_SPEED_UP                52
#define	DIAG_EXIT                    53
#define DIAG_HW_WIN                  54	/* RPi */
#define DIAG_HW_KBD                  55	/* RPi */
#define	DIAG_DART_PORTS              56
#define	DIAG_DART_CFG                57
#define DIAG_DART_DATA               58
#define	DIAG_SPEC_PORTS              59
#define	DIAG_SPEC_INTERRUPTS         60
#define	DIAG_ALL_COUNT               61
/* The below are actions, and should not be activated by -diag-all */
#define	DIAG_ACT_VID_REGS            61
#define	DIAG_ACT_Z80_REGS            62
#define	DIAG_ACT_MEM_DUMP            63
#define	DIAG_ACT_SNA_LOAD            64
#define	DIAG_ACT_SNA_SAVE            65
#define	DIAG_ACT_TAP_REWIND          66
#define	DIAG_ACT_VID_DUMP_VDP        67
#define	DIAG_VID_AUTO_DUMP_VDP       68
#define	DIAG_ACT_VID_SNAPSHOT        69
#define	DIAG_VID_AUTO_SNAPSHOT       70
#define	DIAG_COUNT                   71	/* Must be last entry and largest value */

extern unsigned int diag_methods;

extern unsigned int diag_method_of(const char *s);

extern BOOLEAN diag_flags[DIAG_COUNT];

extern BOOLEAN diag_flag_of(const char *s);

extern void diag_message(unsigned int flag, const char *fmt, ...);

extern void diag_control(int c);

extern void diag_init(void);

extern void diag_term(void);

#endif
