/*

memu.h - Structure to hold MEMU configuration

*/

#ifndef H_MEMU
#define H_MEMU

/*...sincludes:0:*/
#include "types.h"
#include "sid.h"

/*...vtypes\46\h:0:*/
/*...vsid\46\h:0:*/
/*...e*/

typedef struct s_cfg
	{
	int vid_emu;
	int vid_width_scale;
	int vid_height_scale;
	int mon_emu;
	int mon_width_scale;
	int mon_height_scale;
	int kbd_emu;
	int joy_emu;
	int snd_emu;
	double latency;
	int ui_opts;
	int iperiod;
	int tracks_sdxfdc[2];
	const char *fn_sdxfdc[2];
	int sid_emu;
	const char *sid_fn[N_SIDISC];
	const char *rom_fn[8];
	const char *fn_print;
	const char *tape_name_prefix;
	const char *tape_fn;
	const char *fn_serial_in[2];
	const char *fn_serial_out[2];
	BOOLEAN tape_disable;
	int screen_refresh;
	} CFG;

extern CFG cfg;

extern void memu_reset(void);
extern void usage(void);

#endif
