/*

monprom.c - Character generator PROM

Disclaimer: Although I hope this will be pixel perfect, it was created working
from a printout of a scan of the FDX manual (as found on mtxinfo.de).
I don't have access to a real FDX or a image of its character generator PROM.

*/

/*...sincludes:0:*/
#include "types.h"
#include "monprom.h"

/*...vtypes\46\h:0:*/
/*...vmonprom\46\h:0:*/
/*...e*/

#define	ROW(b7,b6,b5,b4,b3,b2,b1,b0) ( ((b7)<<7) | ((b6)<<6) | ((b5)<<5) | ((b4)<<4) | ((b3)<<3) | ((b2)<<2) | ((b1)<<1) | (b0))

byte mon_alpha_prom[0x100][GLYPH_HEIGHT] =
	{
	/* graphics set 1 */

		{ /* dot */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* omega */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,1,1,0,0,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* degree */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* copyright */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,1,1,0,1,0),
		ROW(0,1,0,1,0,0,1,0),
		ROW(0,1,0,1,1,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* disk icon */
		ROW(0,0,0,0,0,0,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,0,0,0,0,0,1,0),
		ROW(1,0,0,0,0,0,1,0),
		ROW(1,0,0,1,0,0,1,0),
		ROW(1,0,0,0,0,0,1,0),
		ROW(1,0,0,1,0,0,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* sigma */
		ROW(0,0,0,0,0,0,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* integral */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,1,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(1,0,1,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bell */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(1,0,0,0,0,0,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* left arrow */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* right arrow */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* down arrow */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(1,0,0,1,0,0,1,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* up arrow */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(1,0,0,1,0,0,1,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* double down arrow */
		ROW(0,0,0,0,0,0,0,0),
		ROW(1,0,0,1,0,0,1,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(1,0,0,1,0,0,1,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* triangle */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,1,0),
		ROW(0,0,0,0,1,1,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,1,1,1,0),
		ROW(0,0,0,0,0,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* sqrt */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(1,1,0,0,1,0,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* pi */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* heart */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,0,1,1,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* diamond */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* spade */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* club */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* tm */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,1,1,0,1,1,0,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* x cross */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* + cross */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,1,1,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* divide */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* sims $ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,1,0,0,1,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* cent */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* king */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* queen */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* rook */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,1,0,1,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* knight */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bishop */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,1,0,1,1,1,0,0),
		ROW(1,1,0,1,1,1,1,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* pawn */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

	/* alpha set */

		{ /* space */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ! */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* " */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* # */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* $ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,1,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* % */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,0,0,0,1,0),
		ROW(0,1,1,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,1,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* & */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,1,0,0,1,0,0,0),
		ROW(0,1,0,0,1,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,1,0,0,1,0,1,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ' */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ( */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ) */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* * */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* + */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* , */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* - */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* . */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},


		{ /* / */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 0 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,1,0,1,1,0,1,0),
		ROW(0,1,1,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 1 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 2 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 3 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 4 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 5 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,1,1,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 6 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 7 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 8 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 9 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* : */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ; */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* < */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* = */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* > */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ? */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* @ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,1,0,0,1,0,1,0),
		ROW(0,1,0,1,0,1,1,0),
		ROW(0,1,0,0,1,1,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* A */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* B */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* C */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* D */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* E */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,1,1,1,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* F */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,1,1,1,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* G */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,1,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* H */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* I */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* J */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,1,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* K */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,1,0,0,1,0,0,0),
		ROW(0,1,1,1,0,0,0,0),
		ROW(0,1,0,0,1,0,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* L */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* M */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,0,0,1,1,0),
		ROW(0,1,0,1,1,0,1,0),
		ROW(0,1,0,1,1,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* N */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,0,0,0,1,0),
		ROW(0,1,0,1,0,0,1,0),
		ROW(0,1,0,0,1,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* O */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* P */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* Q */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,1,0,1,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* R*/
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,1,0,0,1,0,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* S */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* T */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* U */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* V */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* W */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,1,1,0,1,0),
		ROW(0,1,0,1,1,0,1,0),
		ROW(0,1,1,0,0,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* X */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* Y */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* Z */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* [ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* \ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ] */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ^ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* _ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(1,1,1,1,1,1,1,1),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ` */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* a */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* b */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,1,1,1,0,0),
		ROW(0,1,1,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,0,0,0,1,0),
		ROW(0,1,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* c */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* d */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* e */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* f */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,1,0,0,1,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* g */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		},

		{ /* h */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,1,1,1,0,0),
		ROW(0,1,1,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* i */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* j */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		},

		{ /* k */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,1,0,0,1,0,0,0),
		ROW(0,1,0,1,0,0,0,0),
		ROW(0,1,1,0,1,0,0,0),
		ROW(0,1,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* l */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* m */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,0,1,0,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* n */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* o */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* p */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,1,1,1,0,0),
		ROW(0,1,1,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,1,0,0,0,1,0),
		ROW(0,1,0,1,1,1,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		},

		{ /* q */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		},

		{ /* r */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,1,1,1,0,0),
		ROW(0,1,1,0,0,0,1,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* s */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,1,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,1,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* t */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,1,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* u */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* v */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* w */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,1,0,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* x */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* y */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,0,1,0),
		ROW(0,1,0,0,0,1,1,0),
		ROW(0,0,1,1,1,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		},

		{ /* z */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* { */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* | */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* } */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ~ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* block */
		ROW(0,0,0,0,0,0,0,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(1,1,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		},

	/* graphics set 2 */

		{ /* line draw - */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(1,1,1,1,1,1,1,1),
		ROW(1,1,1,1,1,1,1,1),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* line draw | */
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		},

		{ /* line draw br corner */
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(1,1,1,1,1,0,0,0),
		ROW(1,1,1,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* line draw bl corner */
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,1,1,1),
		ROW(0,0,0,0,1,1,1,1),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* line draw tr corner */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(1,1,1,1,0,0,0,0),
		ROW(1,1,1,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		},

		{ /* line draw tl corner */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,1,1,1),
		ROW(0,0,0,1,1,1,1,1),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		},

		{ /* line draw l tee */
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(1,1,1,1,1,0,0,0),
		ROW(1,1,1,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		},

		{ /* line draw r tee */
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,1,1,1),
		ROW(0,0,0,1,1,1,1,1),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		},

		{ /* line draw u tee */
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(1,1,1,1,1,1,1,1),
		ROW(1,1,1,1,1,1,1,1),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* line draw d tee */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(1,1,1,1,1,1,1,1),
		ROW(1,1,1,1,1,1,1,1),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		},

		{ /* line draw cross */
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(1,1,1,1,1,1,1,1),
		ROW(1,1,1,1,1,1,1,1),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		},

		{ /* bar 0 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(1,1,1,1,1,1,1,1),
		},

		{ /* bar 1 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(1,1,1,1,1,1,1,1),
		},

		{ /* bar 2 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(1,1,1,1,1,1,1,1),
		},

		{ /* bar 3 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(1,1,1,1,1,1,1,1),
		},

		{ /* bar 4 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(1,1,1,1,1,1,1,1),
		},

		{ /* bar 5 or more */
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(1,1,1,1,1,1,1,1),
		},

		{ /* bar cap 0 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		},

		{ /* bar cap 1 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		},

		{ /* bar cap 2 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		},

		{ /* bar cap 3 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		},

		{ /* bar cap 4 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		},

		{ /* bar cap 5 or more */
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		},

		{ /* bar line 1 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bar line 2 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bar line 3 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bar line 4 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bar line 5 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bar line 6 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bar line 7 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bar line 8 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* bar line 9 */
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

	/* alternate alpha set */

		{ /* space */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ! */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* " */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* pound */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,1,0,0,1,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* $ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,1,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* % */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,1,1,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,1,1,0),
		ROW(0,0,0,0,0,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* & */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,1,1,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ' */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ( */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ) */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* * */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* + */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* , */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* - */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* . */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* / */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 0 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,0,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,0,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 1 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 2 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 3 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 4 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,1,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 5 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 6 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,1,1,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 7 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 8 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 9 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,1,1,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* : */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ; */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* < */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* = */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* > */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* ? */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* @ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,1,1,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,1,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* A */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* B */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* C */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* D */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,1,0,0,1,0),
		ROW(0,0,0,1,0,0,1,0),
		ROW(0,0,0,1,0,0,1,0),
		ROW(0,0,0,1,0,0,1,0),
		ROW(0,0,0,1,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* E */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* F */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* G */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* H */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* I */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* J */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* K */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* L */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* M */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,0,1,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* N */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,0,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,0,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* O */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* P */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* Q */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,1,1,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* R */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* S */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* T */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* U */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* V */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* W */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* X */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* Y */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* Z */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* left arrow */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* half */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,1,0),
		},

		{ /* right arrow */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* up arrow */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* _ */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* - */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* a */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* b */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* c */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* d */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* e */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* f */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* g */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,1,1,0,0),
		},

		{ /* h */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* i */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* j */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		},

		{ /* k */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,1,0,1,0,0,0),
		ROW(0,0,1,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* l */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* m */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,0,1,0,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* n */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* o */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* p */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		},

		{ /* q */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,0,1,0),
		},

		{ /* r */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,1,1,1,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* s */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,1,0,0,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,1,1,1,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* t */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,1,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* u */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* v */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* w */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,1,0,1,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* x */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,1,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* y */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,1,0,0,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,1,1,1,0),
		},

		{ /* z */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,1,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 1/4 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,1,0,0,0,0),
		ROW(0,0,0,0,0,0,1,0),
		ROW(0,0,0,0,0,1,1,0),
		ROW(0,0,0,0,1,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		},

		{ /* double bar */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,0,1,1,0),
		ROW(0,0,1,1,0,1,1,0),
		ROW(0,0,1,1,0,1,1,0),
		ROW(0,0,1,1,0,1,1,0),
		ROW(0,0,1,1,0,1,1,0),
		ROW(0,0,1,1,0,1,1,0),
		ROW(0,0,1,1,0,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* 3/4 */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,1,1,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,1,1,0,0,1,0),
		ROW(0,0,0,0,0,1,1,0),
		ROW(0,0,0,0,1,0,1,0),
		ROW(0,0,0,1,1,1,1,0),
		ROW(0,0,0,0,0,0,1,0),
		},

		{ /* divide */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,1,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

		{ /* block */
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,1,1,1,1,1,0),
		ROW(0,0,0,0,0,0,0,0),
		ROW(0,0,0,0,0,0,0,0),
		},

	};

byte mon_graphic_prom[0x100][GLYPH_HEIGHT];

byte mon_blank_prom[GLYPH_HEIGHT] =
	{ /* blank */
	ROW(0,0,0,0,0,0,0,0),
	ROW(0,0,0,0,0,0,0,0),
	ROW(0,0,0,0,0,0,0,0),
	ROW(0,0,0,0,0,0,0,0),
	ROW(0,0,0,0,0,0,0,0),
	ROW(0,0,0,0,0,0,0,0),
	ROW(0,0,0,0,0,0,0,0),
	ROW(0,0,0,0,0,0,0,0),
	ROW(0,0,0,0,0,0,0,0),
	ROW(0,0,0,0,0,0,0,0),
	};

/*...smon_init_prom:0:*/
void mon_init_prom(void)
	{
	int i;
	for ( i = 0; i < 0x100; i++ )
		{
		byte b0 = ( i & 0x01 ) ? 0xf0 : 0x00;
		byte b1 = ( i & 0x02 ) ? 0x0f : 0x00;
		byte b2 = ( i & 0x04 ) ? 0xf0 : 0x00;
		byte b3 = ( i & 0x08 ) ? 0x0f : 0x00;
		byte b4 = ( i & 0x10 ) ? 0xf0 : 0x00;
		byte b5 = ( i & 0x20 ) ? 0x0f : 0x00;
		byte b6 = ( i & 0x40 ) ? 0xf0 : 0x00;
		byte b7 = ( i & 0x80 ) ? 0x0f : 0x00;
		mon_graphic_prom[i][0] =
		mon_graphic_prom[i][1] =
		mon_graphic_prom[i][2] = (b0|b1);
		mon_graphic_prom[i][3] =
		mon_graphic_prom[i][4] = (b2|b3);
		mon_graphic_prom[i][5] =
		mon_graphic_prom[i][6] = (b4|b5);
		mon_graphic_prom[i][7] =
		mon_graphic_prom[i][8] =
		mon_graphic_prom[i][9] = (b6|b7);
		}
	}
/*...e*/
