# Vectrexy Compatibility List

## Status Values
* Great
* Good
* Meh
* MissingOp
* ViaNotImplemented
* InvalidRead
* InvalidWrite
* IllegalInstr
* MaybeMusicOnly
* NoBoot - Black screen after title screen, or doesn't progress further
* BrokenRom

## Commercial Released Roms

### Games

| Rom                                                  | Alternate                                                    | Status            | Comment                                                |
| ---------------------------------------------------- | ------------------------------------------------------------ | ----------------- | ------------------------------------------------------ |
| Armor Attack (1982)                                  |                                                              | Great             |                                                        |
|                                                      | Armor Attack (1982) (Spinner Hack)                           | InvalidRead       | [VecxSame] Invalid Cartridge read at $10ad             |
|                                                      | Armor Attack (1982) (Spinner Hack) [a1]                      | InvalidRead       | Invalid Cartridge read at $10ad                        |
|                                                      | Armor Attack (1982) [b1]                                     | BrokenRom         | Doesn't run in VIDE nor Vecx                           |
| Bedlam (1983)                                        |                                                              | Great             |                                                        |
|                                                      | Bedlam (1983) (Spinner Hack)                                 | MissingOp         |                                                        |
|                                                      | Bedlam (1983) [b1]                                           | InvalidRead       |                                                        |
|                                                      | Bedlam (1983) [b2]                                           | ViaNotImplemented |                                                        |
|                                                      | Bedlam (1983) [b3]                                           | MissingOp         |                                                        |
| Berzerk (1982)                                       |                                                              | Great             |                                                        |
|                                                      | Berzerk (1982) (Bugfixed Prototype)                          |                   |                                                        |
|                                                      | Berzerk (1982) (Bugfixed Prototype) [o1]                     |                   |                                                        |
| Blitz! - Action Football (1982)                      |                                                              | Great             |                                                        |
|                                                      | Blitz! - Action Football (1982) [b1]                         |                   |                                                        |
|                                                      | Blitz! - Action Football (1982) [b2]                         |                   |                                                        |
| Clean Sweep (1982)                                   |                                                              | Great             | But need to disable undefined logging                  |
|                                                      | Clean Sweep (1982) [b1]                                      |                   |                                                        |
|                                                      | Clean Sweep (Mr Boston Version) (1982)                       |                   |                                                        |
| Cosmic Chasm (1982)                                  |                                                              | Great             |                                                        |
| Fortress of Narzod (1982)                            |                                                              | Great             |                                                        |
|                                                      | Fortress of Narzod (1982) [b1]                               | BrokenRom         | Doesn't run in VIDE nor Vecx                           |
| Heads Up - Action Soccer (1983)                      |                                                              | Great             |                                                        |
|                                                      | Heads Up - Action Soccer (1983) [b1]                         | BrokenRom         | Doesn't run in VIDE nor Vecx                           |
| Hyperchase (1982)                                    |                                                              | Great             |                                                        |
|                                                      | Hyperchase (1982) [b1]                                       | IllegalInstr      | cpuOp.addrMode != AddressingMode::Illegal              |
| Mine Storm (1982)                                    |                                                              | Great             |                                                        |
|                                                      | Mine Storm (1982) (Karrsoft Hack) [h1]                       | Great             |                                                        |
|                                                      | Mine Storm (1982) (RLB Hack) [b1]                            | InvalidRead       | [VecxSame] Invalid Cartridge read at $7fc8             |
|                                                      | Mine Storm (1982) (RLB Hack) [b1][o1]                        | InvalidRead       | Invalid Cartridge read at $7fc8                        |
|                                                      | Mine Storm (1982) (RLB Hack) [b1][o2]                        | InvalidRead       | Invalid Cartridge read at $7fc8                        |
|                                                      | Mine Storm (1982) (RLB Hack) [h1]                            | Good              | Invalid Cartridge read at $3409 on shoot spawned enemy |
|                                                      | Mine Storm (1982) (RLB Hack) [o1]                            | Good              |                                                        |
|                                                      | Mine Storm (1982) (RLB Hack) [o2]                            | Good              |                                                        |
| Mine Storm II (1983)                                 |                                                              | Great             |                                                        |
|                                                      | Mine Storm II (1983) (Fred Taft Hack) [h1]                   |                   |                                                        |
|                                                      | Mine Storm II (1983) (Spinner Hack)                          |                   |                                                        |
| Narrow Escape (2-D Version by Fred Taft) (1983) [h1] |                                                              | Great             |                                                        |
| Polar Rescue (1983)                                  |                                                              | Great             |                                                        |
|                                                      | Polar Rescue (1983) [a1]                                     |                   |                                                        |
|                                                      | Polar Rescue (1983) [a1][o1]                                 |                   |                                                        |
|                                                      | Polar Rescue (1983) [b1]                                     |                   |                                                        |
| Pole Position (1982)                                 |                                                              | Great             | Invalid reads (code error).                            |
|                                                      | Pole Position (1982) (Spinner Hack)                          |                   |                                                        |
|                                                      | Pole Position (1982) [b1]                                    |                   |                                                        |
|                                                      | Pole Position (1982) [f1]                                    |                   |                                                        |
| Rip-Off (1982)                                       |                                                              | Great             |                                                        |
|                                                      | Rip-Off (1982) [b1]                                          |                   |                                                        |
| Scramble (1982)                                      |                                                              | Great             | Invalid Cartridge read at $1000 (code error?)          |
|                                                      | Scramble (1982) [b1]                                         | IllegalInstr      | [VecxSame] Lots of errors. Investigate.                |
| Solar Quest (1982)                                   |                                                              | Great             |                                                        |
|                                                      | Solar Quest (1982) (Spinner Hack)                            |                   |                                                        |
|                                                      | Solar Quest (1982) [b1]                                      |                   |                                                        |
| Space Wars (1982)                                    |                                                              | Great             |                                                        |
|                                                      | Space Wars (1982) [b1]                                       |                   |                                                        |
| Spike (1983)                                         |                                                              | Great             |                                                        |
| Spinball (1983)                                      |                                                              | Great             |                                                        |
|                                                      | Spinball (1983) [b1]                                         |                   |                                                        |
|                                                      | Spinball (1983) [b2]                                         |                   |                                                        |
| Star Castle (1983)                                   |                                                              | Great             |                                                        |
|                                                      | Star Castle (1983) (Spinner Hack)                            |                   |                                                        |
|                                                      | Star Castle (1983) [b1]                                      |                   |                                                        |
| Star Hawk (1982)                                     |                                                              | Great             |                                                        |
|                                                      | Star Hawk (1982) [b1]                                        |                   |                                                        |
| Star Ship (1982)                                     |                                                              | Great             |                                                        |
| Star Trek - The Motion Picture (1982)                |                                                              | Great             |                                                        |
|                                                      | Star Trek - The Motion Picture (1982) (controller hack) [h1] |                   |                                                        |
|                                                      | Star Trek - The Motion Picture (1982) [a1]                   |                   |                                                        |
|                                                      | Star Trek - The Motion Picture (1982) [b1]                   |                   |                                                        |
|                                                      | Star Trek - The Motion Picture (1982) [o1]                   |                   |                                                        |
| Web Warp (1983)                                      |                                                              | Great             |                                                        |
|                                                      | Web Wars (1983)                                              |                   |                                                        |
|                                                      | Web Wars (1983) [b1]                                         |                   |                                                        |

### Light Pen

| Rom                              | Alternate                             | Status            | Comment                                                   |
| -------------------------------- | ------------------------------------- | ----------------- | --------------------------------------------------------- |
| Animaction (1983) (light pen)    |                                       | InvalidWrite      | Writes to Cartridge ROM not allowed                       |
|                                  | Animaction (1983) (light pen) [b1]    | ViaNotImplemented | Also IllegalInstr but maybe bug in cart (vecx same).      |
| Art Master (1983) (light pen)    |                                       | Good?             | Can't get past the first screen, maybe emulate light pen? |
|                                  | Art Master (1983) (light pen) [b1]    | InvalidRead       | Invalid Cartridge read at $2803                           |
| Melody Master (1983) (light pen) |                                       |                   |                                                           |
|                                  | Melody Master (1983) (light pen) [b1] |                   |                                                           |

### 3D Imager

| Rom                      | Alternate                     | Status            | Comment                                               |
| ------------------------ | ----------------------------- | ----------------- | ----------------------------------------------------- |
| 3-D Mine Storm (1983)    |                               | Good              |                                                       |
|                          | 3-D Mine Storm (1983) [b1]    | ViaNotImplemented | Via Unexpected value for CA2 bits                     |
| 3-D Narrow Escape (1983) |                               |                   |                                                       |
|                          | 3-D Narrow Escape (1983) [b1] |                   |                                                       |
|                          | 3-D Narrow Escape (1983) [b2] |                   |                                                       |
|                          | 3-D Narrow Escape (1983) [b3] | InvalidWrite      | Write to unmapped range of value $86 at address $c7ff |


## Commercial Unreleased Roms

| Rom                                | Alternate                                           | Status | Comment   |
| ---------------------------------- | --------------------------------------------------- | ------ | --------- |
| Dark Tower (1983) (Prototype)      |                                                     | Good?  | Not sure. |
|                                    | Dark Tower (1983) (Prototype) (Fred Taft Hack) [h1] |        |           |
|                                    | Dark Tower (1983) (Prototype) [b1]                  |        |           |
|                                    | Dark Tower (1983) (Prototype) [b2]                  |        |           |
|                                    | Dark Tower (1983) (Prototype) [b3]                  |        |           |
| Dual Vectrex Test #1 (1983) (PD)   |                                                     |        |           |
|                                    | Dual Vectrex Test #1 (1983) (PD) [b1]               |        |           |
| Dual Vectrex Test #2 (1983) (PD)   |                                                     |        |           |
|                                    | Dual Vectrex Test #2 (1983) (PD) [b1]               |        |           |
| Engine Analyzer (1983) (light pen) |                                                     |        |           |
| Spectrum I+ Demo (1982) (PD)       |                                                     | Good?  |           |
| Test Rev. 4 (1982) (PD)            |                                                     | Good   |           |
|                                    | Test Rev. 4 (1982) (PD) [b1]                        |        |           |
| Tour De France (1983) (Prototype)  |                                                     | Good   |           |
| Vectrex BIOS (1982)                |                                                     |        |           |

## Homebrew Roms

### Games

| Rom                                                          | Status       | Comment                                                          |
| ------------------------------------------------------------ | ------------ | ---------------------------------------------------------------- |
| 0ldsk00l Demo by Manu (2002) (PD)                            | Good         |                                                                  |
| 3-D Demo by Chris (Mar 06) (2000) (PD)                       | InvalidRead  | Read from unmapped range at address $a813                        |
| 3-D Demo by Chris (Mar 08) (2000) (PD)                       | InvalidRead  | Read from unmapped range at address $c5d8                        |
| 3-D Scrolling Demo by Christopher Tumber (2001) (PD)         | Good?        |                                                                  |
| 4-D Rotating Cube Demo (19xx) (PD)                           | Great        |                                                                  |
| 8Ball by Christopher Tumber (2001) (PD)                      | Good         | Text renders off screen                                          |
| Abyss Demo (1999) (PD)                                       | Good         | Writes to Cartridge ROM not allowed                              |
| All Good Things by John Dondzila (1996)                      | Good         | Writes to Cartridge ROM not allowed, small font render at bottom |
| All Your Base Demo by Manu (2001) (PD)                       | Great        |                                                                  |
| Alpha Demo (2001) (PD)                                       | Good?        | Only prints A to H                                               |
| Animation Demo by Manu (2002) (PD)                           | Good?        | Just a star spinning                                             |
| Arsek by Marq (2000) (PD)                                    | Good?        | Renders a skeleton face                                          |
| Battle Earth Terror Hazard & Vecsports Boxing (2000) (PD)    | Great        |                                                                  |
| Battle Earth Terror Hazard V1 by Manu (2000) (PD)            | Good         | Font/score render not quite right                                |
| Battle Earth Terror Hazard V2 by Manu (2000) (PD)            | Good         |                                                                  |
| Battle Earth Terror Hazard V3 by Manu (2000) (PD)            | Good         |                                                                  |
| Battle Earth Terror Hazard V4 by Manu (2000) (PD)            | Good         | Bottom render cut off                                            |
| Battlezone Demo by Christopher Tumber (2001) (PD)            | Meh          | Rendering glitches: looks like beam off not working near edge    |
| BB2 Demo by Manu (2002) (PD)                                 | Good         | Font render glitched                                             |
| BCor-FTS Demo by Clay Cowgill (1997) (PD)                    | Good         | Bottom render cut off                                            |
| Birds of Prey by John Dondzila (1999)                        | Good         | Invalid Cartridge read at $1bf4 (cart bug?)                      |
| Calibration Demo (19xx) (Christopher Tumber) (PD)            | Great        |                                                                  |
| CGM Example by Marq (2000) (PD)                              | Good?        |                                                                  |
| Collision Test by Manu (2000) (PD)                           | Great        |                                                                  |
| Curved Lines Demo (1998) (PD)                                | Good?        | Guessing rendering isn't exactly right                           |
| Disc Duel Demo (1997) (PD)                                   | InvalidWrite | Writes to Cartridge ROM not allowed                              |
| Etch-a-Sketch by Jeff Woolsey (1985) (light pen) (PD)        |              |                                                                  |
| Etch-a-Sketch by Jeff Woolsey (1985) (light pen) (PD) [b1]   |              |                                                                  |
| Exec Rom Dumper (2000) (Ronen Habot)                         | Good         | Bottom render cut off                                            |
| Gravitrex by John Dondzila (2002)                            | Great        |                                                                  |
| Joystick Demo by Manu (2000) (PD)                            |              |                                                                  |
| Line Demo (2001) (PD)                                        |              |                                                                  |
| Lines and Digitized Sounds Demo (1998) (PD)                  |              |                                                                  |
| Lunar Lander Demo by Thomas Landspurg (19xx) (PD)            |              |                                                                  |
| Mad Planetoids Demo by John Dondzila (2001) (PD)             |              |                                                                  |
| Madonna's Get Into the Groove by Chris Salomon (1998) (PD)   |              |                                                                  |
| Mike's Molecules Demo by Mike Blackwell (1985) (PD)          |              |                                                                  |
| Mike's Molecules Demo by Mike Blackwell (1985) (PD) [a1]     |              |                                                                  |
| Mike's Molecules Demo by Mike Blackwell (1985) (PD) [b1]     |              |                                                                  |
| Missile Lords by Christopher Tumber (2001) (PD)              |              |                                                                  |
| Moon Lander Demo by Clay Cowgill (1997) (PD)                 |              |                                                                  |
| Moon Lander Demo by Clay Cowgill (1997) (PD) [a1]            |              |                                                                  |
| My Bonnie Lies Over The Ocean by Jeff Woolsey (1985) (PD)    |              |                                                                  |
| Nona3 by Manu (Mar 10) (2003)                                |              |                                                                  |
| Omega Chase (Final Version) (1998) (PD)                      |              |                                                                  |
| Omega Chase by Christopher Tumber (2000) (PD)                |              |                                                                  |
| Patriots by John Dondzila (1996)                             |              |                                                                  |
| Patriots by John Dondzila (1996) [a1]                        |              |                                                                  |
| Patriots by John Dondzila (1996) [b1]                        |              |                                                                  |
| Patriots III - BALListics Busters by John Dondzila (1996)    |              |                                                                  |
| Patriots III - BALListics Busters by John Dondzila (2002)    |              |                                                                  |
| Patriots Remix by John Dondzila (1999)                       |              |                                                                  |
| Philly Classic 3 Demo (2002) (PD)                            |              |                                                                  |
| Pokemon Demo 1 by Manu (2000) (PD)                           |              |                                                                  |
| Pokemon Demo 2 by Manu (2000) (PD)                           |              |                                                                  |
| Pokemon Demo 3 by Manu and Marq (2000) (PD)                  |              |                                                                  |
| Pokemon Demo 4 - Psyduck's Eyes by Manu (2000) (PD)          |              |                                                                  |
| POP Demo by Christopher Tumber (19xx) (PD)                   |              |                                                                  |
| Pythagorian Theorem by Rob Mitchell (2002) (PD)              |              |                                                                  |
| Repulse by John Dondzila (1999)                              |              |                                                                  |
| Rockaroids Remix - 3rd Rock by John Dondzila (1996)          |              |                                                                  |
| Rockaroids Remix - 3rd Rock by John Dondzila (1996) [a1]     |              |                                                                  |
| Rocket Sledge Demo (1985) (PD)                               |              |                                                                  |
| Ronen's Game Cart (2000) (Ronen Habot)                       |              |                                                                  |
| Rotation Demo by Manu (2000) (PD)                            |              |                                                                  |
| Rounders by Ronen Habot (2000) (PD)                          |              |                                                                  |
| SAW Gallery 1 by Christopher Tumber (1999) (PD)              |              |                                                                  |
| SAW Gallery 2 by Christopher Tumber (1999) (PD)              |              |                                                                  |
| SAW Gallery 3 by Christopher Tumber (1999) (PD)              |              |                                                                  |
| Scorefont 3 by Manu (Aug 26) (2002)                          |              |                                                                  |
| Space16 Demo by Manu (2000) (PD)                             |              |                                                                  |
| Spike Goes Skiing (1998) (PD)                                |              |                                                                  |
| Spike Goes Skiing Demo V.03 (1998) (PD)                      |              |                                                                  |
| Spike Hoppin' by John Dondzila (1998)                        |              |                                                                  |
| Spike Hoppin' by John Dondzila (1998) [b1]                   |              |                                                                  |
| Spike Hoppin' by John Dondzila (1998) [b2]                   |              |                                                                  |
| Spike's Slam Pit Demo by Gauze (2001) (PD)                   |              |                                                                  |
| Spike's Water Balloons (Analog) by John Dondzila (2001) (PD) |              |                                                                  |
| Star Fire Spirits by John Dondzila (1999)                    |              |                                                                  |
| Star Fire Spirits by John Dondzila (1999) [a1]               |              |                                                                  |
| Star Seige by John Dondzila (1999)                           |              |                                                                  |
| Star Spangles Banner Music Demo by Jeff Woolsey (1985) (PD)  |              |                                                                  |
| Tank Demo 1 (19xx) (PD)                                      |              |                                                                  |
| Tank Demo 2 (2001) (PD)                                      |              |                                                                  |
| Taulukko Demo by Manu (2002) (PD)                            |              |                                                                  |
| Text Demo (2001) (PD)                                        |              |                                                                  |
| This is Just a Non-Playable Demo (1999) (PD)                 |              |                                                                  |
| Tono Demo by Marq & Antti (2000) (PD)                        |              |                                                                  |
| Tsunami by Christopher Tumber (2001) (PD)                    |              |                                                                  |
| Tsunami by Christopher Tumber (2001) (PD) [a1]               |              |                                                                  |
| Tsunami by Christopher Tumber (2001) (PD) [a2]               |              |                                                                  |
| Vaboom! by Ronen Habot (2000) (PD)                           |              |                                                                  |
| Vaboom! by Ronen Habot (2000) (PD) [a1]                      |              |                                                                  |
| Vecmania Part 1 (1999) (PD)                                  |              |                                                                  |
| Vecmania Part 1 (1999) (PD) [a1]                             |              |                                                                  |
| Vecmania Part 2 (1999) (PD)                                  |              |                                                                  |
| Vecsports Boxing Demo by Manu (2000) (PD)                    |              |                                                                  |
| Vecsports Boxing With Sound Demo by Manu (2000) (PD)         |              |                                                                  |
| VecSports Kingpin Bowling by Manu (V0.2) (2002)              |              |                                                                  |
| VecSports Kingpin Bowling by Manu (V0.3) (2002)              |              |                                                                  |
| VecSports Kingpin Bowling by Manu (V0.4) (Aug 26) (2002)     |              |                                                                  |
| VecSports Kingpin Bowling Demo by Manu (Aug 19) (2002)       |              |                                                                  |
| Vectopia by John Dondzila (2001) (PD)                        |              |                                                                  |
| Vector Vaders by John Dondzila (1996)                        |              |                                                                  |
| Vector Vaders by John Dondzila (1996) [a1]                   |              |                                                                  |
| Vector Vaders by John Dondzila (1996) [b1]                   |              |                                                                  |
| Vector Vaders Remix by John Dondzila (1999)                  |              |                                                                  |
| Vectrace (2000) (Ronen Habot)                                |              |                                                                  |
| Vectrace (2000) (Ronen Habot) [a1]                           |              |                                                                  |
| Vectrace (2000) (Ronen Habot) [a2]                           |              |                                                                  |
| Vectrex Bootstrap Loader by Jeff Woolsey (1985) (PD)         |              |                                                                  |
| Vectrex Demo 1 by Manu (2000) (PD)                           |              |                                                                  |
| Vectrex Demo 2 by Manu (2000) (PD)                           |              |                                                                  |
| Vectrex Demo 3 by Manu (2000) (PD)                           |              |                                                                  |
| Vectrex Maze by Chris Salomon (1998) (PD)                    |              |                                                                  |
| Vectrex Pong (1998) (PD)                                     |              |                                                                  |
| Vectrexians (1999) (PD)                                      |              |                                                                  |
| VecVoice Demo by Richard Hutchinson (2002)                   |              |                                                                  |
| Version Nine by Christopher Tumber (1999) (PD)               |              |                                                                  |
| Version Nine by Christopher Tumber (1999) (PD) [a1]          |              |                                                                  |
| Version Nine by Christopher Tumber (2000) (PD)               |              |                                                                  |
| Verzerk by Alex Herbert (2002)                               |              |                                                                  |
| Vexperience - B.E.T.H. & Vecsports Boxing by Manu (2000)     |              |                                                                  |
| V-Frogger by Chris Salomon (1998) (PD)                       |              |                                                                  |
| V-Frogger by Chris Salomon (1998) (PD) [a1]                  |              |                                                                  |
| V-Frogger by Chris Salomon, Sound by Kurt Woloch (2001) (PD) |              |                                                                  |
| Vimpula by Manu (2002) (PD)                                  |              |                                                                  |
| Wormhole by John Dondzila (2001) (PD)                        |              |                                                                  |
| ZZAP - Scrolling Space Game Demo (1989) (PD)                 |              |                                                                  |

### Audio

| Rom                                                          | Status | Comment |
| ------------------------------------------------------------ | ------ | ------- |
| 'NO' Sound by Chris Salomon (1998) (PD)                      |        |         |
| Arkanoid - Revenge of DOH Sound by Chris Salomon (1998) (PD) |        |         |
| Axel F - Beverly Hills Cop by Chris Salomon (1998) (PD)      |        |         |
| Axel F - Beverly Hills Cop by Chris Salomon (1998) (PD) [a1] |        |         |
| Bach Prelude #1 by Jeff Woolsey (1985) (PD)                  |        |         |
| Bebop Best Sound by Chris Salomon (1998) (PD)                |        |         |
| Bebop Sound by Chris Salomon (1998) (PD)                     |        |         |
| Bubble Bobble (Diamond Room) by Chris Salomon (1998) (PD)    |        |         |
| Bubble Bobble Sound 0 by Chris Salomon (1998) (PD)           |        |         |
| Bubble Bobble Sound 1 by Chris Salomon (1998) (PD)           |        |         |
| Bubble Bobble Sound 2 by Chris Salomon (1998) (PD)           |        |         |
| Bubble Bobble Sound 2best by Chris Salomon (1998) (PD)       |        |         |
| Bubble Bobble Sound 3 by Chris Salomon (1998) (PD)           |        |         |
| Commando - High Score Sound by Chris Salomon (1998) (PD)     |        |         |
| Count05 Sound by Chris Salomon (1998) (PD)                   |        |         |
| Dr. Who Theme by Chris Salomon (1998) (PD)                   |        |         |
| Fast Food Sound 1 by Chris Salomon (1998) (PD)               |        |         |
| Fast Food Sound 2 by Chris Salomon (1998) (PD)               |        |         |
| Ghosts 'n' Goblins Sound 7 by Chris Salomon (1998) (PD)      |        |         |
| Ghosts 'n' Goblins Sound 8 by Chris Salomon (1998) (PD)      |        |         |
| Ghosts 'n' Goblins Sound 9 by Chris Salomon (1998) (PD)      |        |         |
| Ghosts 'n' Goblins Sound 9best by Chris Salomon (1998) (PD)  |        |         |
| Ghouls 'n' Ghosts Sound by Chris Salomon (1998) (PD)         |        |         |
| Great Giana Sisters (Bonus) by Chris Salomon (1998) (PD)     |        |         |
| Great Giana Sisters (Ingame) by Chris Salomon (1998) (PD)    |        |         |
| Great Giana Sisters (Title) by Chris Salomon (1998) (PD)     |        |         |
| Hey, Music Lover Sound by Chris Salomon (1998) (PD)          |        |         |
| Jaws Theme Music by Chris Salomon (1998) (PD)                |        |         |
| Klax (Level Begin) Sound by Chris Salomon (1998) (PD)        |        |         |
| Labyrinth Rev 1 by Chris Salomon (1998) (PD)                 |        |         |
| Labyrinth Rev 2 by Chris Salomon (1998) (PD)                 |        |         |
| Labyrinth Rev 3 by Chris Salomon (1998) (PD)                 |        |         |
| Labyrinth Rev 4 (Vector Rouge) by Chris Salomon (1998) (PD)  |        |         |
| Misfits 1 Music by Chris Salomon (1998) (PD)                 |        |         |
| Monty on the Run HiScore Sound by Chris Salomon (1998) (PD)  |        |         |
| Monty on the Run Sound by Chris Salomon (1998) (PD)          |        |         |
| Monty on the Run Sound by Chris Salomon (1998) (PD) [a1]     |        |         |
| Music Demo (2001) (PD)                                       |        |         |
| 'NO' Sound by Chris Salomon (1998) (PD)                      |        |         |
| Pac-Mania Sound 1 by Chris Salomon (1998) (PD)               |        |         |
| Pac-Mania Sound 2 by Chris Salomon (1998) (PD)               |        |         |
| Pac-Mania Sound 4 by Chris Salomon (1998) (PD)               |        |         |
| Rainbow Islands Sound by Chris Salomon (1998) (PD)           |        |         |
| Real Ghostbusters Sound by Chris Salomon (1998) (PD)         |        |         |
| Robin Hood Sound by Chris Salomon (1998) (PD)                |        |         |
| ROM Music Demo by Manu (2000) (PD)                           |        |         |
| Song Demo by Christopher Tumber (1998) (PD)                  |        |         |
| Sound1 Demo (19xx) (PD)                                      |        |         |
| Star Wars Sound by Chris Salomon (1998) (PD)                 |        |         |
| Star Wars Theme by Chris Salomon (1998) (PD)                 |        |         |
| Turrican 1 Sound by Chris Salomon (1998) (PD)                |        |         |
| Turrican 2 Sound by Chris Salomon (1998) (PD)                |        |         |
| We Wish You a Merry Christmas by J. Woolsey (1985) (PD)      |        |         |
| We Wish You a Merry Christmas by J. Woolsey (1985) (PD) [a1] |        |         |
| We Wish You a Merry Christmas by J. Woolsey (1986) (PD)      |        |         |
| YM001 Sound by Chris Salomon (1998) (PD)                     |        |         |
| Zombies from the Crypt Music by Chris Salomon (1998) (PD)    |        |         |
