# 11. UART

The Mikey UART is a pretty standard serial kind of thing. However, since most of the communicating world has managed to bolix up the definitions and use of the so-called standards of serial communications, I will attempt to explain all of our UARTs functions. Yes, I will leave something out so as to continue to trick earthlings into thinking that I am human.

## 11.1 Connector Signals

The UART connects to the REDEYE connector which has pins. There is 1 data pin. This signal is bi-directional serial data. Its idle state is open-collector with a pull-up resistor to +5. There is one ground pin, and one VCC pin.

(A design error causes the power up state of the output to be TTL high, ALL code must set the TXOPEN bit in order to fix this. Its not my fault.)

There is also a signal called NOEXP which indicates the presence of a plug in the REDEYE socket.

Any devices other than RedEye will need to have an intelligent protocol to distinguish themselves from a RedEye type device. See the RedEye specification for protocol details.

## 11.2 Baud Rate

The baud rate is generated by TIMER4 according to the equation

```
CLOCK4 / (TIMER4 + 1) / 8
```

The minimum number that can be used in TIMER4 is 1, the maximum number is 255. The fastest CLOCK4 is 1MHz, the slowest is 15625 Hz. This gives a baud rate maximum of 62.5 Kbaud and a minimum of 7.63 baud. The settings for the common baud rates are:

| BaudRate | CLOCK4 | TIMER4 | Actual |
| --- | --- | --- | --- |
| 62500 | 1us | 1 | 62500 |
| 9600 | 1us | 12 | 9615 |
| 2400 | 1us | 51 | 2404 |
| 1200 | 1us | 103 | 1202 |
| 300 | 2us | 207 | 300.5 |

## 11.3 Data Format

The serial data format is the standard 11 bits. We do not offer a choice.

The standard bits are:

- 1 start bit (binary 0);
- 8 data bits, LSB first;
- 1 parity bit (or 9th bit as defined by the control byte);
- 1 stop bit (binary 1).

The parity (or 9th) bit operates as follows:

- **Receive:** The state of the 9th bit is always available for read in the control byte. In addition, the parity of the received character is calculated and if it does not match the setting of the parity select bit in the control byte, the parity error bit will be set. Receive parity error can not be disabled. If you don't want it, don't read it.
- **Transmit:** The 9th bit is always sent. It is either the result of a parity calculation on the transmit data byte or it is the value set in the parity select bit in the control register. The choice is made by the parity enable bit in the control byte. For example: If PAREN is '1' and PAREVEN is '0', then the 9th bit will be the result of an 'odd' parity calculation on the transmit data byte. If PAREN is '0', then the 9th bit will be whatever the state of PAREVEN is.

We have just discovered that the calculation for parity includes the parity bit itself. Most of us don't like that, but it is too late to change it.

## 11.4 Break

A break of any length can be transmitted by setting the transmit break bit in the control register. The break will continue as long as the bit is set.

A 'break' is defined as a start bit, a data value of 0 (same as a permanent start bit), and the absence of a stop bit at the expected time.

The receiver requires that a break lasts 24 bit times before it is recognized. There are many 'standard' break lengths, this is the one we chose.

## 11.5 Transmitter Status Bits

There are 2 status bits for the transmitter, TXRDY (transmit buffer ready) and TXEMPTY (transmitter totally done).

If TXRDY is a '1', then the contents of the transmit holding register have been loaded into the transmit shift register and the holding register is now available to be loaded with the next byte to be transmitted. This bit is also set to '1' after a reset.

If TXEMPTY is a '1', then BOTH the transmit holding register and the transmit shift register have been emptied and there are no more bits going out the serial data line.

## 11.6 Errors

There are 3 receive errors, parity error (already explained), framing error, and overrun error. Once received, these error bits remain set until they are cleared by writing to the control byte with the reset error bit set. Writing to the control byte with the reset error bit cleared has no effect on the errors. Note that the reset error bit is NOT an error enable bit. Receive errors are always enabled.

Framing error indicates that a non-zero character has been received without the appropriate stop bit.

Overrun error indicates that a character (of any kind or error) has been received and the previously received character has not yet been read from the receive buffer.

## 11.7 Unusual Interrupt Condition

Well, we did screw something up after all. Both the transmit and receive interrupts are 'level' sensitive, rather than 'edge' sensitive. This means that an interrupt will be continuously generated as long as it is enabled and its UART buffer is ready. As a result, the software must disable the interrupt prior to clearing it.

Sorry.

## 11.8 left out

I left something out. I know what it is but by the next time I revise this spec, I may have forgotten.

.

..

...

I have forgotten.
