#include "inner.h"

color_t colors_48sx[ NB_COLORS ] = {
    /* UI4X_COLOR_HP_LOGO */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xAC,
     .rgb = 0xCCA96B,
     },
    /* UI4X_COLOR_HP_LOGO_BG */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x41,
     .rgb = 0x404040,
     },
    /* UI4X_COLOR_48GX_128K_RAM */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xB9,
     .rgb = 0xCAB890,
     },
    /* UI4X_COLOR_FRAME */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0x00,
     .rgb = 0x000000,
     },
    /* UI4X_COLOR_UPPER_FACEPLATE_EDGE_TOP */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x7C,
     .rgb = 0x9B7654,
     },
    /* UI4X_COLOR_UPPER_FACEPLATE */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x63,
     .rgb = 0x7C5E43,
     },
    /* UI4X_COLOR_UPPER_FACEPLATE_EDGE_BOTTOM */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x4F,
     .rgb = 0x644B35,
     },
    /* UI4X_COLOR_FACEPLATE_EDGE_TOP */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x58,
     .rgb = 0x6D4E4E,
     },
    /* UI4X_COLOR_FACEPLATE */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x49,
     .rgb = 0x5A4040,
     },
    /* UI4X_COLOR_FACEPLATE_EDGE_BOTTOM */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x3C,
     .rgb = 0x4C3636,
     },
    /* UI4X_COLOR_KEYPAD_HIGHLIGHT */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x30,
     .rgb = 0x3C2A2A,
     },
    /* UI4X_COLOR_BUTTON_EDGE_TOP */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x5B,
     .rgb = 0x6D5D5D,
     },
    /* UI4X_COLOR_BUTTON */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x51,
     .rgb = 0x5A4D4D,
     },
    /* UI4X_COLOR_BUTTON_EDGE_BOTTOM */
    {
     .a = 0xFF,
     .mono_rgb = 0x00,
     .gray_rgb = 0x45,
     .rgb = 0x4C4141,
     },
    /* UI4X_COLOR_PIXEL_OFF */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xCD,
     .rgb = 0xCADD5C,
     },
    /* UI4X_COLOR_PIXEL_GREY_1 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0xa9,
     .rgb = 0x478691,
     },
    /* UI4X_COLOR_PIXEL_GREY_2 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x69,
     .rgb = 0x0d6c6f,
     },
    /* UI4X_COLOR_PIXEL_ON */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x14,
     .rgb = 0x253d54,
     },
    /* UI4X_COLOR_BLACK_PIXEL_OFF */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xCD,
     .rgb = 0xf5f5f5,
     },
    /* UI4X_COLOR_BLACK_PIXEL_GREY_1 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0xa9,
     .rgb = 0xa5a5a5,
     },
    /* UI4X_COLOR_BLACK_PIXEL_GREY_2 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x69,
     .rgb = 0x454545,
     },
    /* UI4X_COLOR_BLACK_PIXEL_ON */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x14,
     .rgb = 0x151515,
     },
    /* UI4X_COLOR_LABEL */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xFF,
     .rgb = 0xFFFFFF,
     },
    /* UI4X_COLOR_ALPHA */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xFF,
     .rgb = 0xFFFFFF,
     },
    /* UI4X_COLOR_SHIFT_LEFT */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xE6,
     .rgb = 0xFFA600,
     },
    /* UI4X_COLOR_SHIFT_RIGHT */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xA9,
     .rgb = 0x00D2FF,
     },
};

#define KB_LINE_HEIGHT 50
#define KB_COLUMN_WIDTH_6_KEYS 50
#define KB_COLUMN_WIDTH_5_KEYS 60

button_t buttons_48sx[ NB_HP48_KEYS ] = {
    {
     .x = 0,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "A",
     .left = 0,
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "B",
     .left = 0,
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "C",
     .left = 0,
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "D",
     .left = 0,
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "E",
     .left = 0,
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "F",
     .left = 0,
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },

    {
     .x = 0,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "MTH",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "G",
     .left = "PRINT",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "PRG",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "H",
     .left = "I/O",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "CST",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "I",
     .left = "MODES",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "VAR",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "J",
     .left = "MEMORY",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = up_width,
     .label_graphic_h = up_height,
     .label_graphic = up_bitmap,
     .letter = "K",
     .left = "LIBRARY",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "NXT",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "L",
     .left = "PREV",
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },

    {
     .x = 0,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = quote_width,
     .label_graphic_h = quote_height,
     .label_graphic = quote_bitmap,
     .letter = "M",
     .left = "UP",
     .highlight = false,
     .right = "HOME",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "STO",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "N",
     .left = "DEF",
     .highlight = false,
     .right = "RCL",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "EVAL",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "O",
     .left = "\x80Q",
     .highlight = false,
     .right = "\x80NUM",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = left_width,
     .label_graphic_h = left_height,
     .label_graphic = left_bitmap,
     .letter = "P",
     .left = "GRAPH",
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = down_width,
     .label_graphic_h = down_height,
     .label_graphic = down_bitmap,
     .letter = "Q",
     .left = "REVIEW",
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = right_width,
     .label_graphic_h = right_height,
     .label_graphic = right_bitmap,
     .letter = "R",
     .left = "SWAP",
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },

    {
     .x = 0,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "SIN",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "S",
     .left = "ASIN",
     .highlight = false,
     .right = "\x07",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "COS",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "T",
     .left = "ACOS",
     .highlight = false,
     .right = "\x08",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "TAN",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "U",
     .left = "ATAN",
     .highlight = false,
     .right = "\x09",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = sqrt_width,
     .label_graphic_h = sqrt_height,
     .label_graphic = sqrt_bitmap,
     .letter = "V",
     .left = "\x0a",
     .highlight = false,
     .right = "\x0b",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = power_width,
     .label_graphic_h = power_height,
     .label_graphic = power_bitmap,
     .letter = "W",
     .left = "\x0c",
     .highlight = false,
     .right = "LOG",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = inv_width,
     .label_graphic_h = inv_height,
     .label_graphic = inv_bitmap,
     .letter = "X",
     .left = "\x0d",
     .highlight = false,
     .right = "LN",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },

    {
     .x = 0,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 86,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "ENTER",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "EQUATION",
     .highlight = false,
     .right = "MATRIX",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = neg_width,
     .label_graphic_h = neg_height,
     .label_graphic = neg_bitmap,
     .letter = "Y",
     .left = "EDIT",
     .highlight = false,
     .right = "VISIT",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "EEX",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "Z",
     .left = "2D",
     .highlight = false,
     .right = "3D",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "DEL",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "PURGE",
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = bs_width,
     .label_graphic_h = bs_height,
     .label_graphic = bs_bitmap,
     .letter = 0,
     .left = "DROP",
     .highlight = false,
     .right = "CLR",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },

    {
     .x = 0,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = alpha_width,
     .label_graphic_h = alpha_height,
     .label_graphic = alpha_bitmap,
     .letter = 0,
     .left = "USR",
     .highlight = false,
     .right = "ENTRY",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "7",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "SOLVE",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "8",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "PLOT",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "9",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "ALGEBRA",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = div_width,
     .label_graphic_h = div_height,
     .label_graphic = div_bitmap,
     .letter = 0,
     .left = "( )",
     .highlight = false,
     .right = "#",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },

    {
     .x = 0,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_SHIFT_LEFT,
     .label = 0,
     .label_graphic_w = shl_width,
     .label_graphic_h = shl_height,
     .label_graphic = shl_bitmap,
     .letter = 0,
     .left = 0,
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "4",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "TIME",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "5",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "STAT",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "6",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "UNITS",
     .highlight = true,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = mul_width,
     .label_graphic_h = mul_height,
     .label_graphic = mul_bitmap,
     .letter = 0,
     .left = "[ ]",
     .highlight = false,
     .right = "_",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },

    {
     .x = 0,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_SHIFT_RIGHT,
     .label = 0,
     .label_graphic_w = shr_width,
     .label_graphic_h = shr_height,
     .label_graphic = shr_bitmap,
     .letter = 0,
     .left = 0,
     .highlight = false,
     .right = 0,
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "1",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "RAD",
     .highlight = false,
     .right = "POLAR",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "2",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "STACK",
     .highlight = false,
     .right = "ARG",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "3",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "CMD",
     .highlight = false,
     .right = "MENU",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = minus_width,
     .label_graphic_h = minus_height,
     .label_graphic = minus_bitmap,
     .letter = 0,
     .left = "\x0e",
     .highlight = false,
     .right = "\x0f",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },

    {
     .x = 0,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "ON",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "CONT",
     .highlight = false,
     .right = "OFF",
     .below = "ATTN",
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "0",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "= ",
     .highlight = false,
     .right = " \x80",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = ".",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = ",",
     .highlight = false,
     .right = " \x10",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = "SPC",
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "\x11 ",
     .highlight = false,
     .right = " \x12",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
    {
     .x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label = 0,
     .label_graphic_w = plus_width,
     .label_graphic_h = plus_height,
     .label_graphic = plus_bitmap,
     .letter = 0,
     .left = "{ }",
     .highlight = false,
     .right = ": :",
     .below = 0,
     .css_class = 0,
     .css_id = 0,
     .hpkey = -1,
     },
};
