#include <stddef.h>

#include "bitmaps_misc.h"
#include "inner.h"

color_t colors_50g[ NB_COLORS ] = {
    /* UI4X_COLOR_HP_LOGO */
    {
     .a = 0xff,
     .mono_rgb = 0xff,
     .gray_rgb = 0xB0,
     .rgb = 0xB0B0B8,
     },
    /* UI4X_COLOR_HP_LOGO_BG */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x68,
     .rgb = 0x131313,
     },
    /* UI4X_COLOR_48GX_128K_RAM */
    {
     .a = 0xff,
     .mono_rgb = 0xff,
     .gray_rgb = 0xF0,
     .rgb = 0xF0F0F0,
     },
    /* UI4X_COLOR_FRAME */
    {
     .a = 0xff,
     .mono_rgb = 0xff,
     .gray_rgb = 0x00,
     .rgb = 0x000000,
     },
    /* UI4X_COLOR_UPPER_FACEPLATE_EDGE_TOP */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x80,
     .rgb = 0x000000,
     },
    /* UI4X_COLOR_UPPER_FACEPLATE */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x68,
     .rgb = 0x262626,
     },
    /* UI4X_COLOR_UPPER_FACEPLATE_EDGE_BOTTOM */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x54,
     .rgb = 0x000000,
     },
    /* UI4X_COLOR_FACEPLATE_EDGE_TOP */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x58,
     .rgb = 0x585858,
     },
    /* UI4X_COLOR_FACEPLATE */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x4A,
     .rgb = 0x272727,
     },
    /* UI4X_COLOR_FACEPLATE_EDGE_BOTTOM */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x40,
     .rgb = 0x404040,
     },
    /* UI4X_COLOR_KEYPAD_HIGHLIGHT */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x68,
     .rgb = 0x4f6165,
     },
    /* UI4X_COLOR_BUTTON_EDGE_TOP */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x68,
     .rgb = 0x4b4b4b,
     },
    /* UI4X_COLOR_BUTTON */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x58,
     .rgb = 0x3f3f3f,
     },
    /* UI4X_COLOR_BUTTON_EDGE_BOTTOM */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x4A,
     .rgb = 0x3d3d3d,
     },
    /* UI4X_COLOR_PIXEL_OFF */
    {
     .a = 0xff,
     .mono_rgb = 0xff,
     .gray_rgb = 0xCD,
     .rgb = 0xcdcdcd,
     },
    /* UI4X_COLOR_PIXEL_GREY_1 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0xa9,
     .rgb = 0xa5a5a5,
     },
    /* UI4X_COLOR_PIXEL_GREY_2 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x69,
     .rgb = 0x454545,
     },
    /* UI4X_COLOR_PIXEL_ON */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x14,
     .rgb = 0x151515,
     },
    /* UI4X_COLOR_BLACK_PIXEL_OFF */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xCD,
     .rgb = 0xf5f5f5,
     },
    /* UI4X_COLOR_BLACK_PIXEL_GREY_1 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0xa9,
     .rgb = 0xa5a5a5,
     },
    /* UI4X_COLOR_BLACK_PIXEL_GREY_2 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x69,
     .rgb = 0x454545,
     },
    /* UI4X_COLOR_BLACK_PIXEL_ON */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x14,
     .rgb = 0x151515,
     },
    /* UI4X_COLOR_LABEL */
    {
     .a = 0xff,
     .mono_rgb = 0xff,
     .gray_rgb = 0xff,
     .rgb = 0xffffff,
     },
    /* UI4X_COLOR_ALPHA */
    {
     .a = 0xff,
     .mono_rgb = 0xff,
     .gray_rgb = 0xDC,
     .rgb = 0x67c184,
     },
    /* UI4X_COLOR_SHIFT_LEFT */
    {
     .a = 0xff,
     .mono_rgb = 0xff,
     .gray_rgb = 0xDC,
     .rgb = 0x82b1ff,
     },
    /* UI4X_COLOR_SHIFT_RIGHT */
    {
     .a = 0xff,
     .mono_rgb = 0xff,
     .gray_rgb = 0xA9,
     .rgb = 0xff8a80,
     },
};

#define KB_LINE_HEIGHT 48
#define KB_COLUMN_WIDTH_6_KEYS 50
#define KB_COLUMN_WIDTH_5_KEYS 60

button_t buttons_50g[ NB_HP50g_KEYS ] = {
    {.x = 0,
     .y = 0,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "Y=",
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = "F1",
     /*  */
      .css_class = "menu",
     .css_id = "F1",
     .label = "F1",
     .letter = "A",
     .left = "Y=",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_A          },

    {.x = KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "WIN",
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = "F2",
     /*  */
      .css_class = "menu",
     .css_id = "F2",
     .label = "F2",
     .letter = "B",
     .left = "WIN",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_B          },

    {.x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "GRAPH",
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = "F3",
     /*  */
      .css_class = "menu",
     .css_id = "F3",
     .label = "F3",
     .letter = "C",
     .left = "GRAPH",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_C          },

    {.x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "2D/3D",
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = "F4",
     /*  */
      .css_class = "menu",
     .css_id = "F4",
     .label = "F4",
     .letter = "D",
     .left = "2D/3D",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_D          },

    {.x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "TBLSET",
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = "F5",
     /*  */
      .css_class = "menu",
     .css_id = "F5",
     .label = "F5",
     .letter = "E",
     .left = "TBLSET",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_E          },

    {.x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "TABLE",
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = "F6",
     /*  */
      .css_class = "menu",
     .css_id = "F6",
     .label = "F6",
     .letter = "F",
     .left = "TABLE",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_F          },

    {.x = 0,
     .y = 1 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "FILES",
     .highlight = false,
     .right_sdl = "BEGIN",
     .label_sdl = "APPS",
     /*  */
      .css_class = "function",
     .css_id = "APPS",
     .label = "APPS",
     .letter = "G",
     .left = "FILES",
     .right = "BEGIN",
     .below = NULL,
     .hpkey = HP50g_KEY_G          },

    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 1 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "CUSTOM",
     .highlight = false,
     .right_sdl = "END",
     .label_sdl = "MODE",
     /*  */
      .css_class = "function",
     .css_id = "MODE",
     .label = "MODE",
     .letter = "H",
     .left = "CUSTOM",
     .right = "END",
     .below = NULL,
     .hpkey = HP50g_KEY_H          },

    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 1 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "i",
     .highlight = false,
     .right_sdl = "I",
     .label_sdl = "TOOL",
     /*  */
      .css_class = "function",
     .css_id = "TOOL",
     .label = "TOOL",
     .letter = "I",
     .left = "i",
     .right = "I",
     .below = NULL,
     .hpkey = HP50g_KEY_I          },

    {.x = 4.25 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0.75 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = up_width,
     .label_graphic_h = up_height,
     .label_graphic = up_bitmap,
     .left_sdl = NULL,
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = NULL,
     /*  */
      .css_class = "arrow",
     .css_id = "UP",
     .label = "⬆",
     .letter = "",
     .left = "",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_UP         },

    {.x = 0,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "UPDIR",
     .highlight = false,
     .right_sdl = "COPY",
     .label_sdl = "VAR",
     /*  */
      .css_class = "function",
     .css_id = "VAR",
     .label = "VAR",
     .letter = "J",
     .left = "UPDIR",
     .right = "COPY",
     .below = NULL,
     .hpkey = HP50g_KEY_J          },

    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "RCL",
     .highlight = false,
     .right_sdl = "CUT",
     .label_sdl = "STO",
     /*  */
      .css_class = "function",
     .css_id = "STO",
     .label = "STO⏵",
     .letter = "K",
     .left = "RCL",
     .right = "CUT",
     .below = NULL,
     .hpkey = HP50g_KEY_K          },

    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "PREV",
     .highlight = false,
     .right_sdl = "PASTE",
     .label_sdl = "NXT",
     /*  */
      .css_class = "function",
     .css_id = "NXT",
     .label = "NXT",
     .letter = "L",
     .left = "PREV",
     .right = "PASTE",
     .below = NULL,
     .hpkey = HP50g_KEY_L          },

    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 1.4 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = left_width,
     .label_graphic_h = left_height,
     .label_graphic = left_bitmap,
     .left_sdl = NULL,
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = NULL,
     /*  */
      .css_class = "arrow",
     .css_id = "LEFT",
     .label = "⬅",
     .letter = "",
     .left = "",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_LEFT       },

    {.x = 4.25 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = down_width,
     .label_graphic_h = down_height,
     .label_graphic = down_bitmap,
     .left_sdl = NULL,
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = NULL,
     /*  */
      .css_class = "arrow",
     .css_id = "DOWN",
     .label = "⬇",
     .letter = "",
     .left = "",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_DOWN       },

    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 1.4 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = right_width,
     .label_graphic_h = right_height,
     .label_graphic = right_bitmap,
     .left_sdl = NULL,
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = NULL,
     /*  */
      .css_class = "arrow",
     .css_id = "RIGHT",
     .label = "➡",
     .letter = "",
     .left = "",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_RIGHT      },

    {.x = 0,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "CMD",
     .highlight = false,
     .right_sdl = "UNDO",
     .label_sdl = "HIST",
     /*  */
      .css_class = "function",
     .css_id = "HIST",
     .label = "HIST",
     .letter = "M",
     .left = "CMD",
     .right = "UNDO",
     .below = NULL,
     .hpkey = HP50g_KEY_M          },

    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "PRG",
     .highlight = false,
     .right_sdl = "CHARS",
     .label_sdl = "EVAL",
     /*  */
      .css_class = "function",
     .css_id = "EVAL",
     .label = "EVAL",
     .letter = "N",
     .left = "PRG",
     .right = "CHARS",
     .below = NULL,
     .hpkey = HP50g_KEY_N          },

    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = quote_width,
     .label_graphic_h = quote_height,
     .label_graphic = quote_bitmap,
     .left_sdl = "MTRW",
     .highlight = false,
     .right_sdl = "EQW",
     .label_sdl = "'",
     /*  */
      .css_class = "function",
     .css_id = "QUOTE",
     .label = "'",
     .letter = "O",
     .left = "MTRW",
     .right = "EQW",
     .below = NULL,
     .hpkey = HP50g_KEY_O          },

    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "MTH",
     .highlight = false,
     .right_sdl = "CAT",
     .label_sdl = "SYMB",
     /*  */
      .css_class = "function",
     .css_id = "SYMB",
     .label = "SYMB",
     .letter = "P",
     .left = "MTH",
     .right = "CAT",
     .below = NULL,
     .hpkey = HP50g_KEY_P          },

    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = bs_width,
     .label_graphic_h = bs_height,
     .label_graphic = bs_bitmap,
     .left_sdl = "DEL",
     .highlight = false,
     .right_sdl = "CLEAR",
     .label_sdl = "⬅",
     /*  */
      .css_class = "function",
     .css_id = "BACKSPACE",
     .label = "⬅",
     .letter = "",
     .left = "DEL",
     .right = "CLEAR",
     .below = NULL,
     .hpkey = HP50g_KEY_BACKSPACE  },

    {.x = 0,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = power_width,
     .label_graphic_h = power_height,
     .label_graphic = power_bitmap,
     .left_sdl = "\x16",
     .highlight = false,
     .right_sdl = "LN",
     .label_sdl = "Y<sup>x</sup>",
     /*  */
      .css_class = "function",
     .css_id = "POW",
     .label = "Y<sup>x</sup>",
     .letter = "Q",
     .left = "𝑒<sup>x</sup>",
     .right = "LN",
     .below = NULL,
     .hpkey = HP50g_KEY_Q          },

    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = sqrt_width,
     .label_graphic_h = sqrt_height,
     .label_graphic = sqrt_bitmap,
     .left_sdl = "\x13",
     .highlight = false,
     .right_sdl = "\x14",
     .label_sdl = "√𝓍",
     /*  */
      .css_class = "function",
     .css_id = "SQRT",
     .label = "√𝓍",
     .letter = "R",
     .left = "𝓍<sup>2</sup>",
     .right = "<sup>x</sup>√𝓎",
     .below = NULL,
     .hpkey = HP50g_KEY_R          },

    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "ASIN",
     .highlight = false,
     .right_sdl = "\x09",
     .label_sdl = "SIN",
     /*  */
      .css_class = "function",
     .css_id = "SIN",
     .label = "SIN",
     .letter = "S",
     .left = "ASIN",
     .right = "∑",
     .below = NULL,
     .hpkey = HP50g_KEY_S          },

    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "ACOS",
     .highlight = false,
     .right_sdl = "\x07",
     .label_sdl = "COS",
     /*  */
      .css_class = "function",
     .css_id = "COS",
     .label = "COS",
     .letter = "T",
     .left = "ACOS",
     .right = "∂",
     .below = NULL,
     .hpkey = HP50g_KEY_T          },

    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "ATAN",
     .highlight = false,
     .right_sdl = "\x08",
     .label_sdl = "TAN",
     /*  */
      .css_class = "function",
     .css_id = "TAN",
     .label = "TAN",
     .letter = "U",
     .left = "ATAN",
     .right = "∫",
     .below = NULL,
     .hpkey = HP50g_KEY_U          },

    {.x = 0,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "\x15",
     .highlight = false,
     .right_sdl = "LOG",
     .label_sdl = "EEX",
     /*  */
      .css_class = "function",
     .css_id = "EEX",
     .label = "EEX",
     .letter = "V",
     .left = "10<sup>𝓍</sup>",
     .right = "LOG",
     .below = NULL,
     .hpkey = HP50g_KEY_V          },

    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = neg_width,
     .label_graphic_h = neg_height,
     .label_graphic = neg_bitmap,
     .left_sdl = "\x60",
     .highlight = false,
     .right_sdl = "=",
     .label_sdl = "+/-",
     /*  */
      .css_class = "function",
     .css_id = "NEG",
     .label = "+/-",
     .letter = "W",
     .left = "≠",
     .right = "=",
     .below = NULL,
     .hpkey = HP50g_KEY_W          },

    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "\x3b",
     .highlight = false,
     .right_sdl = "\x3c",
     .label_sdl = "X",
     /*  */
      .css_class = "function",
     .css_id = "X",
     .label = "𝓍",
     .letter = "X",
     .left = "≤",
     .right = "&gt;",
     .below = NULL,
     .hpkey = HP50g_KEY_X          },

    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = inv_width,
     .label_graphic_h = inv_height,
     .label_graphic = inv_bitmap,
     .left_sdl = "\x3f",
     .highlight = false,
     .right_sdl = "\x3e",
     .label_sdl = "1/𝓍",
     /*  */
      .css_class = "function",
     .css_id = "INV",
     .label = "1/𝓍",
     .letter = "Y",
     .left = "≥",
     .right = ">",
     .below = NULL,
     .hpkey = HP50g_KEY_Y          },

    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = div_width,
     .label_graphic_h = div_height,
     .label_graphic = div_bitmap,
     .left_sdl = "ABS ",
     .highlight = false,
     .right_sdl = "ARG",
     .label_sdl = "÷",
     /*  */
      .css_class = "core-number",
     .css_id = "DIVIDE",
     .label = "÷",
     .letter = "Z",
     .left = "ABS",
     .right = "ARG",
     .below = NULL,
     .hpkey = HP50g_KEY_Z          },

    {.x = 0,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_ALPHA,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "USER",
     .highlight = false,
     .right_sdl = "ENTRY",
     .label_sdl = "ALPHA",
     /*  */
      .css_class = "alpha",
     .css_id = "ALPHA",
     .label = "ALPHA",
     .letter = NULL,
     .left = "USER",
     .right = "ENTRY",
     .below = NULL,
     .hpkey = HP50g_KEY_ALPHA      },

    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "S.SLV",
     .highlight = false,
     .right_sdl = "N.SLV",   //"NUM.SLV",
      .label_sdl = "7",
     /*  */
      .css_class = "core-number",
     .css_id = "SEVEN",
     .label = "7",
     .letter = NULL,
     .left = "S.SLV",
     .right = "NUM.SLV",
     .below = NULL,
     .hpkey = HP50g_KEY_7          },

    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "EXP",    //"EXP&LN",
      .highlight = false,
     .right_sdl = "TRIG",
     .label_sdl = "8",
     /*  */
      .css_class = "core-number",
     .css_id = "EIGHT",
     .label = "8",
     .letter = NULL,
     .left = "EXP&amp;LN",
     .right = "TRIG",
     .below = NULL,
     .hpkey = HP50g_KEY_8          },

    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "FIN.",   //"FINANCE",
      .highlight = false,
     .right_sdl = "TIME",
     .label_sdl = "9",
     /*  */
      .css_class = "core-number",
     .css_id = "NINE",
     .label = "9",
     .letter = NULL,
     .left = "FINANCE",
     .right = "TIME",
     .below = NULL,
     .hpkey = HP50g_KEY_9          },

    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = mul_width,
     .label_graphic_h = mul_height,
     .label_graphic = mul_bitmap,
     .left_sdl = "\x19 ",
     .highlight = false,
     .right_sdl = "\x1c",
     .label_sdl = "×",
     /*  */
      .css_class = "core-number",
     .css_id = "MULTIPLY",
     .label = "×",
     .letter = NULL,
     .left = "[ ]",
     .right = "\" \"",
     .below = NULL,
     .hpkey = HP50g_KEY_MULTIPLY   },

    {.x = 0,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_SHIFT_LEFT,
     .label_graphic_w = shl_width,
     .label_graphic_h = shl_height,
     .label_graphic = shl_bitmap,
     .left_sdl = NULL,
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = "⮢",
     /*  */
      .css_class = "shift-left",
     .css_id = "SHIFT-LEFT",
     .label = "⮢",
     .letter = NULL,
     .left = "",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_SHIFT_LEFT },

    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "CALC",
     .highlight = false,
     .right_sdl = "ALG",
     .label_sdl = "4",
     /*  */
      .css_class = "core-number",
     .css_id = "FOUR",
     .label = "4",
     .letter = NULL,
     .left = "CALC",
     .right = "ALG",
     .below = NULL,
     .hpkey = HP50g_KEY_4          },

    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "MATR.",  //"MATRICES",
      .highlight = false,
     .right_sdl = "STAT",
     .label_sdl = "5",
     /*  */
      .css_class = "core-number",
     .css_id = "FIVE",
     .label = "5",
     .letter = NULL,
     .left = "MATRICES",
     .right = "STAT",
     .below = NULL,
     .hpkey = HP50g_KEY_5          },

    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "CNVRT",  //"CONVERT",
      .highlight = false,
     .right_sdl = "UNITS",
     .label_sdl = "6",
     /*  */
      .css_class = "core-number",
     .css_id = "SIX",
     .label = "6",
     .letter = NULL,
     .left = "CONVERT",
     .right = "UNITS",
     .below = NULL,
     .hpkey = HP50g_KEY_6          },

    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = minus_width,
     .label_graphic_h = minus_height,
     .label_graphic = minus_bitmap,
     .left_sdl = "\x17 ",
     .highlight = false,
     .right_sdl = "\x1a",
     .label_sdl = "-",
     /*  */
      .css_class = "core-number",
     .css_id = "MINUS",
     .label = "-",
     .letter = NULL,
     .left = "( )",
     .right = "_",
     .below = NULL,
     .hpkey = HP50g_KEY_MINUS      },

    {.x = 0,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_SHIFT_RIGHT,
     .label_graphic_w = shr_width,
     .label_graphic_h = shr_height,
     .label_graphic = shr_bitmap,
     .left_sdl = NULL,
     .highlight = false,
     .right_sdl = NULL,
     .label_sdl = "⮣",
     /*  */
      .css_class = "shift-right",
     .css_id = "SHIFT-RIGHT",
     .label = "⮣",
     .letter = NULL,
     .left = "",
     .right = NULL,
     .below = NULL,
     .hpkey = HP50g_KEY_SHIFT_RIGHT},

    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "ARITH",
     .highlight = false,
     .right_sdl = "CMPLX",
     .label_sdl = "1",
     /*  */
      .css_class = "core-number",
     .css_id = "ONE",
     .label = "1",
     .letter = NULL,
     .left = "ARITH",
     .right = "CMPLX",
     .below = NULL,
     .hpkey = HP50g_KEY_1          },

    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "DEF",
     .highlight = false,
     .right_sdl = "LIB",
     .label_sdl = "2",
     /*  */
      .css_class = "core-number",
     .css_id = "TWO",
     .label = "2",
     .letter = NULL,
     .left = "DEF",
     .right = "LIB",
     .below = NULL,
     .hpkey = HP50g_KEY_2          },

    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "\x23",
     .highlight = false,
     .right_sdl = "BASE",
     .label_sdl = "3",
     /*  */
      .css_class = "core-number",
     .css_id = "THREE",
     .label = "3",
     .letter = NULL,
     .left = "#",
     .right = "BASE",
     .below = NULL,
     .hpkey = HP50g_KEY_3          },

    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = plus_width,
     .label_graphic_h = plus_height,
     .label_graphic = plus_bitmap,
     .left_sdl = "\x1d ",
     .highlight = false,
     .right_sdl = "\x1b",
     .label_sdl = "+",
     /*  */
      .css_class = "core-number",
     .css_id = "PLUS",
     .label = "+",
     .letter = NULL,
     .left = "{ }",
     .right = "« »",
     .below = NULL,
     .hpkey = HP50g_KEY_PLUS       },

    {.x = 0,
     .y = 9 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "CONT",
     .highlight = false,
     .right_sdl = "OFF",
     .label_sdl = "ON",
     /*  */
      .css_class = "core",
     .css_id = "ON",
     .label = "ON",
     .letter = NULL,
     .left = "CONT",
     .right = "OFF",
     .below = "CANCEL",
     .hpkey = HP50g_KEY_ON         },

    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 9 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "\x7e",
     .highlight = false,
     .right_sdl = "\x03",
     .label_sdl = "0",
     /*  */
      .css_class = "core-number",
     .css_id = "ZERO",
     .label = "0",
     .letter = NULL,
     .left = "∞",
     .right = "→",
     .below = NULL,
     .hpkey = HP50g_KEY_0          },

    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 9 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "\x1e",
     .highlight = false,
     .right_sdl = "\x01",
     .label_sdl = ".",
     /*  */
      .css_class = "core",
     .css_id = "PERIOD",
     .label = ".",
     .letter = NULL,
     .left = ": :",
     .right = "↲",
     .below = NULL,
     .hpkey = HP50g_KEY_PERIOD     },

    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 9 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "\x05 ",
     .highlight = false,
     .right_sdl = "\x02",
     .label_sdl = "SPC",
     /*  */
      .css_class = "core",
     .css_id = "SPC",
     .label = "SPC",
     .letter = NULL,
     .left = "𝚷",
     .right = ",",
     .below = NULL,
     .hpkey = HP50g_KEY_SPACE      },

    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 9 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = NULL,
     .left_sdl = "ANS ",
     .highlight = false,
     .right_sdl = "\x06NUM",
     .label_sdl = "ENTER",
     /*  */
      .css_class = "enter",
     .css_id = "ENTER",
     .label = "ENTER",
     .letter = NULL,
     .left = "ANS",
     .right = "→NUM",
     .below = NULL,
     .hpkey = HP50g_KEY_ENTER      },
};
