/////////////////////////////////////////////////////////
//
// Attract-Mode Frontend - "Attrac-Man" Layout
//
/////////////////////////////////////////////////////////
//
// Define the playfield
//
// #  = no go
//    = go, no dot or energizer
// .  = dot
// o  = energizer
// ~  = ghost decision point, no dot
// c  = ghost decision point, player start, no dot
// ,  = ghost decision point, dot
// ;  = ghost decision point, dot, but random for player AI
// _  = ghost jail (TODO: engine support)
// 

::playfield <- [
	"#########################################################",
	"#,.....,........,.          ~          .,........,.....,#",
	"#.#####.########.###########_###########.########.#####.#",
	"#.#####.########.#######################.########.#####.#",
	"#,..o..;.....,##.#######################.##,.....;..o..,#",
	"#############.##.#######################.##.#############",
	"#############.##.#######################.##.#############",
	"       ,.....,##.#######################.##,.....,       ",
	"#######.#####.##.#######################.##.#####.#######",
	"#######.#####.##.#######################.##.#####.#######",
	"#,.....,.....,..,.          ~          .,..,.....,.....,#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#.########################## ##########################.#",
	"#,.....o..,################# #################,..o.....,#",
	"#.########.################# #################.########.#",
	"#.########.################# #################.########.#",
	"#,.....,..,..,............. c .............,..,..,.....,#",
	"#######.#####.#############################.#####.#######",
	"#######.#####.#############################.#####.#######",
	"       ,.....,#############################,.....,       ",
	"#########################################################",
];

// Initialize field and actor variables
::field <- [];
::GhostHouse <- [ 0, 0 ];
::PlayerStart <- [ 0, 0 ];

foreach ( l in ::playfield )
{
	local f = [];
	foreach (c in l)
	{
		switch (c.tochar()) {
		case "_":
			f.append(0);
			if (::GhostHouse[0] == 0) {
				::GhostHouse[0] = f.len()-1;
				::GhostHouse[1] = ::field.len()-1;
			}
			break;
		case "#":
			f.append(0); break;
		case ".":
			f.append(2); break;
		case "o":
			f.append(3); break;
		case "c":
			::PlayerStart[0] = f.len();
			::PlayerStart[1] = ::field.len();
		case "~":
			f.append(4); break;
		case ",":
			f.append(6); break;
		case ";":
			f.append(7); break;
		default:
			f.append(1); break;
		}
	}
	::field.append(f);
}

// FIXME: engine requires width - 1
::GridSize <- [ (::field[0].len() - 1), ::field.len() ];
