INSERT INTO app_os (id, name) VALUES
(1, 'windows'),
(2, 'android'),
(3, 'linux'),
(4, 'macos'),
(5, 'ios');


INSERT INTO app_emulator_possible_paths (os_id, possible_path, android_package_name, android_activity_name, description, is_default, priority) VALUES
-- RetroArch para Windows
(1, 'C:\\RetroArch-Win32\\retroarch.exe', NULL, NULL, 'RetroArch Win32', 0, 1),
(1, 'C:\\RetroArch-Win64\\retroarch.exe', NULL, NULL, 'RetroArch Win64', 1, 2),
(1, 'C:\\RetroArch-MSVC10-Win32\\retroarch.exe', NULL, NULL, 'RetroArch MSVC10 Win32', 0, 3),
(1, 'C:\\RetroArch-MSVC10-Win64\\retroarch.exe', NULL, NULL, 'RetroArch MSVC10 Win64', 0, 4),
(1, 'C:\\RetroArch-MSVC05-Win32\\retroarch.exe', NULL, NULL, 'RetroArch MSVC05 Win32', 0, 5),
(1, 'C:\\Program Files\\RetroArch\\retroarch.exe', NULL, NULL, 'RetroArch Program Files Win32', 0, 6),
(1, 'C:\\Program Files\\RetroArch-Win64\\retroarch.exe', NULL, NULL, 'RetroArch Program Files Win64', 0, 7),
(1, 'C:\\Program Files (x86)\\RetroArch\\retroarch.exe', NULL, NULL, 'RetroArch Program Files Win32', 0, 8),
(1, 'C:\\Program Files (x86)\\RetroArch-Win64\\retroarch.exe', NULL, NULL, 'RetroArch Program Files Win64', 0, 9),
-- RetroArch Steam
(1, 'C:\\Program Files (x86)\\Steam\\steamapps\\common\\RetroArch\\retroarch.exe', NULL, NULL, 'RetroArch Steam Win32', 0, 10),
(1, 'D:\\Program Files (x86)\\Steam\\steamapps\\common\\RetroArch\\retroarch.exe', NULL, NULL, 'RetroArch Steam Win64', 0, 11),
(1, 'C:\\Program Files\\Steam\\steamapps\\common\\RetroArch\\retroarch.exe', NULL, NULL, 'RetroArch Steam Win32', 0, 12),
(1, 'D:\\Program Files\\Steam\\steamapps\\common\\RetroArch\\retroarch.exe', NULL, NULL, 'RetroArch Steam Win64', 0, 13),


-- RetroArch para Android (con packages y activities)
(2, 'com.retroarch.aarch64', 'com.retroarch.aarch64', 'com.retroarch.browser.retroactivity.RetroActivityFuture', 'Actividad principal para lanzar juegos (funciona)', 1, 1),
(2, 'com.retroarch.aarch64', 'com.retroarch.aarch64', 'com.retroarch.browser.mainmenu.MainMenuActivity', 'Menú principal de RetroArch', 0, 2),
(2, 'com.retroarch.aarch64', 'com.retroarch.aarch64', 'com.retroarch.browser.retroactivity.RetroActivity', 'Actividad alternativa para juegos', 0, 3),
(2, 'com.retroarch', 'com.retroarch', 'com.retroarch.browser.retroactivity.RetroActivityFuture', 'Actividad principal para package estándar', 0, 4),
(2, 'com.retroarch', 'com.retroarch', 'com.retroarch.browser.mainmenu.MainMenuActivity', 'Menú principal para package estándar', 0, 5),
(2, 'com.retroarch.ra32', 'com.retroarch.ra32', 'com.retroarch.browser.retroactivity.RetroActivityFuture', 'Actividad principal para package ra32', 0, 6),
(2, 'com.retroarch.ra32', 'com.retroarch.ra32', 'com.retroarch.browser.mainmenu.MainMenuActivity', 'Menú principal para package ra32', 0, 7),

-- RetroArch para Linux
(3, '~/Applications/RetroArch-Linux*.AppImage', NULL, NULL, 'RetroArch Linux', 1, 1),
(3, '~/.local/share/applications/RetroArch-Linux*.AppImage', NULL, NULL, 'RetroArch Linux', 0, 2),
(3, '~/.local/bin/RetroArch-Linux*.AppImage', NULL, NULL, 'RetroArch Linux', 0, 3),
(3, '~/bin/RetroArch-Linux*.AppImage', NULL, NULL, 'RetroArch Linux', 0, 4),
(3, '/var/lib/flatpak/exports/bin/org.libretro.RetroArch', NULL, NULL, 'RetroArch Linux', 0, 5),
(3, '~/.local/share/flatpak/exports/bin/org.libretro.RetroArch', NULL, NULL, 'RetroArch Linux', 0, 6);


INSERT INTO app_systems (id, screenscraper_id, ra_id, real_name, folder_name, primary_color, secondary_color, launch_date, description) VALUES
-- Nintendo Systems
(1, 3, 7, 'Nintendo Entertainment System', 'nes', '#ff0000', '#ebecdf', '1983-07-15', 'The revolutionary 8-bit console that brought gaming into millions of homes worldwide.'),
(2, 4, 3, 'Super Nintendo Entertainment System', 'snes', '#ff0000', '#a47fe0', '1990-11-21', 'The 16-bit powerhouse that revolutionized gaming with Mode 7 graphics.'),
(3, 9, 4, 'Game Boy', 'gb', '#ff0000', '#e478a5', '1989-04-21', 'Nintendo''s groundbreaking handheld console that made portable gaming a reality, featuring four hours of gameplay on just four AA batteries.'),
(4, 10, 6, 'Game Boy Color', 'gbc', '#ff0000', '#62dad0', '1998-10-21', 'The colorful evolution of the Game Boy, offering backward compatibility with original Game Boy games while introducing vibrant 56-color graphics.'),
(5, 12, 5, 'Game Boy Advance', 'gba', '#ff0000', '#aa7fee', '2001-03-21', 'Nintendo''s 32-bit handheld powerhouse featuring a bright backlit screen, wireless adapter support, and legendary titles like Advance Wars and Fire Emblem.'),
(6, 14, 2, 'Nintendo 64', 'n64', '#ff0000', '#f8d471', '1996-06-23', 'The innovative 64-bit console with groundbreaking 3D graphics and analog stick control, home to masterpieces like Super Mario 64 and GoldenEye 007.'),
(7, 15, 18, 'Nintendo DS', 'ds', '#ff0000', '#9dc5db', '2004-11-21', 'Nintendo''s dual-screen handheld featuring touch controls and microphone input, bringing innovative gameplay with titles like Nintendogs and Brain Age.'),
(8, 13, 16, 'GameCube', 'gc', '#ff0000', '#a7a7a7ff', '2001-09-14', 'Nintendo''s compact home console with mini-disc format, featuring high-quality graphics and memorable titles like Super Smash Bros. Melee and Animal Crossing.'),
(9, 211, 24, 'Pokemon Mini', 'mini', '#ff0000', '#f8d471', '2001-12-16', 'The tiny LCD-based handheld console dedicated to Pokémon games, featuring simple gameplay and collectible Pokémon-themed designs.'),
(10, 11, 28, 'Virtual Boy', 'vb', '#ff0000', '#f09191', '1995-07-21', 'Nintendo''s experimental 3D console with red monochrome graphics, featuring unique stereoscopic gameplay experiences.'),
(11, 15, 78, 'Nintendo DSi', 'dsi', '#ff0000', '#f8d471', '2008-11-01', 'Enhanced version of the Nintendo DS with cameras, SD card slot, and downloadable games from the DSi Shop.'),
-- Sega Systems
(12, 1, 1, 'Mega Drive', 'md', '#2f8ffd', '#7e7e7e', '1988-10-29', 'Sega''s 16-bit powerhouse that challenged Nintendo''s dominance with blast processing and iconic games like Sonic the Hedgehog.'),
(13, 2, 11, 'Master System', 'sms', '#2f8ffd', '#7e7e7e', '1985-10-20', 'Sega''s 8-bit console that competed with the NES, featuring built-in games and excellent arcade ports.'),
(14, 21, 15, 'Game Gear', 'gg', '#2f8ffd', '#7e7e7e', '1990-10-06', 'Sega''s color handheld system that rivaled the Game Boy with its bright backlit screen and TV tuner accessory.'),
(15, 20, 9, 'Sega CD', 'scd', '#2f8ffd', '#7e7e7e', '1991-12-12', 'CD-ROM add-on for the Genesis/Mega Drive, bringing full-motion video and CD-quality audio to home gaming.'),
(16, 19, 10, '32X', '32x', '#2f8ffd', '#7e7e7e', '1994-11-21', 'The Genesis/Mega Drive''s 32-bit add-on that enhanced graphics capabilities with polygon rendering.'),
(17, 22, 39, 'Saturn', 'sat', '#2f8ffd', '#7e7e7e', '1994-11-22', 'Sega''s 32-bit console known for excellent 2D graphics and arcade-perfect ports like Virtua Fighter.'),
(18, 23, 40, 'Dreamcast', 'dc', '#2f8ffd', '#fff3d1', '1998-11-27', 'Sega''s final console featuring built-in internet connectivity and innovative games like Shenmue and Jet Set Radio.'),
(19, 109, 33, 'SG-1000', 'sg1k', '#2f8ffd', '#fff3d1', '1983-07-15', 'Sega''s first home video game console, known for its library of arcade ports and 8-bit graphics.'),
-- Sony Systems
(20, 57, 12, 'PlayStation', 'ps1', '#7824ff', '#c4caff', '1994-12-03', 'Sony''s revolutionary 32-bit console that introduced CD-based gaming and 3D graphics to the mainstream market.'),
(21, 58, 21, 'PlayStation 2', 'ps2', '#7824ff', '#c4caff', '2000-03-04', 'The best-selling video game console of all time, featuring DVD playback and backward compatibility with original PlayStation games.'),
(22, 61, 41, 'PlayStation Portable', 'psp', '#7824ff', '#c4caff', '2004-12-12', 'Sony''s multimedia handheld featuring console-quality graphics, multimedia capabilities, and wireless connectivity.'),
-- Atari Systems
(23, 26, 25, 'Atari 2600', '2600', '#ff006a', '#fd8966', '1977-09-11', 'The console that popularized home video gaming with interchangeable cartridges and iconic games like Pong and Space Invaders.'),
(24, 41, 51, 'Atari 7800', '7800', '#ff006a', '#fd8966', '1986-05-01', 'Atari''s backward-compatible console featuring enhanced graphics and improved sound over the 2600.'),
(25, 28, 13, 'Atari Lynx', 'lynx', '#ff006a', '#fd8966', '1989-09-01', 'The first handheld console with a color LCD screen, featuring scaling and rotation capabilities.'),
(26, 27, 17, 'Atari Jaguar', 'jag', '#ff006a', '#fd8966', '1993-11-23', 'Atari''s final console, marketed as the first 64-bit gaming system with unique controller design.'),
(27, 171, 77, 'Atari Jaguar CD', 'jcd', '#ff006a', '#fd8966', '1995-09-21', 'CD-ROM add-on for the Atari Jaguar, expanding storage capacity and multimedia capabilities.'),
-- NEC Systems
(28, 31, 8, 'PC Engine', 'pce', '#c9eb09', '#d1ec6e', '1987-10-30', 'NEC''s 16-bit console known for excellent arcade ports and the first console CD-ROM system.'),
(29, 114, 76, 'PC Engine CD', 'pccd', '#c9eb09', '#d1ec6e', '1988-12-04', 'CD-ROM add-on that brought enhanced audio and larger games to the PC Engine/TurboGrafx-16.'),
(30, 72, 49, 'PC-FX', 'pcfx', '#c9eb09', '#d1ec6e', '1994-12-23', 'NEC''s 32-bit console focusing on full-motion video and anime-style games.'),
-- SNK Systems
(31, 82, 14, 'Neo Geo Pocket Color', 'ngp', '#FF9800', '#666666', '1998-10-28', 'SNK''s handheld console featuring excellent fighting games and a precise microswitched joystick.'),
(32, 70, 56, 'Neo Geo CD', 'ngcd', '#FF9800', '#666666', '1994-09-09', 'Home version of SNK''s arcade system using CDs to reduce cartridge costs while maintaining arcade quality.'),
-- Other Handhelds
(33, 46, 53, 'WonderSwan Color', 'ws', '#c134da', '#666666', '1999-03-04', 'Bandai''s handheld console designed by Game Boy creator Gunpei Yokoi, featuring excellent battery life.'),
(34, 207, 63, 'Watara Supervision', 'wsv', '#c134da', '#666666', '1992-01-01', 'Portable gaming system with black and white LCD screen and unique vertical orientation games.'),
-- Retro Computers/Consoles
(35, 104, 23, 'Magnavox Odyssey 2', 'mo2', '#4CAF50', '#ffffff', '1978-09-12', 'Early home console featuring a built-in keyboard and educational games alongside traditional arcade-style titles.'),
(36, 48, 44, 'ColecoVision', 'cv', '#795548', '#ffffff', '1982-08-01', 'Advanced 8-bit console known for superior arcade ports and the pack-in game Donkey Kong.'),
(37, 115, 45, 'Intellivision', 'intv', '#E91E63', '#ffffff', '1979-12-03', 'Mattel''s home console featuring advanced graphics for its time and unique disc-shaped controllers.'),
(38, 102, 46, 'Vectrex', 'vect', '#607D8B', '#ffffff', '1982-11-01', 'Unique vector graphics console with built-in monochrome monitor, offering wireframe 3D-style games.'),
(39, 90, 69, 'Mega Duck', 'duck', '#3F51B5', '#ffffff', '1993-01-01', 'Portable gaming system that was Game Boy compatible, popular in certain European markets.'),
-- Other Systems
(40, 75, 27, 'Arcade', 'arc', '#f5a700', '#8aa7a5', '1971-01-01', 'The birthplace of video gaming, featuring coin-operated machines with cutting-edge graphics and gameplay.'),
(41, 29, 43, '3DO Interactive Multiplayer', '3do', '#ff58acff', '#8aa7a5', '1993-10-04', 'High-end 32-bit console featuring advanced multimedia capabilities and CD-based games.'),
(42, 113, 29, 'MSX', 'msx', '#00f7b9', '#8aa7a5', '1983-06-27', 'Standardized home computer platform popular in Japan and Europe, featuring consistent hardware across manufacturers.'),
(43, 80, 57, 'Fairchild Channel F', 'chf', '#00BCD4', '#8aa7a5', '1976-08-01', 'The first programmable ROM cartridge-based home video game console, pioneering the cartridge system.'),
(44, 65, 37, 'Amstrad CPC', 'cpc', '#8BC34A', '#6c8382', '1984-04-01', 'Popular 8-bit home computer in Europe, known for colorful graphics and built-in tape deck or disk drive.'),
(45, 86, 38, 'Apple II', 'a2', '#7869ff', '#8aa7a5', '1977-04-01', 'Influential home computer that helped establish the personal computer market with color graphics and expansion slots.'),
(46, 216, 80, 'Uzebox', 'uze', '#a0ff07', '#8aa7a5', '2008-01-01', 'Open-source retro-minimalist 8-bit game console designed for learning and hobbyist development.'),
(47, 263, 71, 'Arduboy', 'ard', '#00b9a7', '#8aa7a5', '2014-01-01', 'Credit card-sized game system inspired by the Game Boy, featuring an OLED screen and open-source development.'),
(48, 221, 47, 'PC-8000/8800', '8088', '#aa43ff', '#8aa7a5', '1979-01-01', 'Fujitsu''s line of home computers popular in Japan, known for their robust software library and business applications.'),
(49, 262, 72, 'WASM-4', 'wasm4', '#6ed817', '#8aa7a5', '2020-01-01', 'A fantasy console for making, sharing, and playing tiny games that run in web browsers using WebAssembly.'),
(50, 94, 73, 'Arcadia 2001', 'a2001', '#ff43a1', '#8aa7a5', '1982-01-01', 'Early 8-bit home console with interchangeable cartridges, known for its simple graphics and sound capabilities.'),

-- Nintendo 3DS
(51, 17, 0, 'Nintendo 3DS', '3ds', '#ff0000', '#9dc5db', '2011-02-26', 'Nintendo''s handheld console featuring glasses-free 3D technology, dual screens, and backward compatibility with DS games.'),

-- Nintendo Wii
(52, 16, 0, 'Nintendo Wii', 'wii', '#ff0000', '#d1ec6e', '2006-11-19', 'Nintendo''s innovative home console with motion-sensing controls, revolutionizing gaming for all ages.'),

-- Other Arcade Systems
(100, 56, 27, 'NAOMI', 'naomi', '#fd3b00', '#ffa379', '1998-01-01', 'Sega''s arcade system board based on Dreamcast hardware for commercial arcade games.'),
(101, 230, 27, 'NAOMI 2', 'naomi2', '#fd3b00', '#ffa379', '2000-01-01', 'Enhanced version of NAOMI arcade system with improved graphics capabilities.'),
(102, 227, 27, 'NAOMI GD-ROM', 'naomigd', '#fd3b00', '#ffa379', '2001-01-01', 'NAOMI system using GD-ROM discs for larger capacity arcade games.'),
(103, 53, 27, 'Atomiswave', 'aw', '#00e700', '#81d69e', '2003-01-01', 'Sammy Corporation''s arcade system board compatible with Dreamcast software.'),

-- Virtual systems
(1000, 3, 7, 'Family Computer', 'fc', '#ff0000', '#ebecdf', '1983-07-15', 'The Japanese version of the Nintendo Entertainment System (NES), known for its iconic library of games and cultural impact in Japan.'),
(1001, 4, 3, 'Super Family Computer', 'sfc', '#ff0000', '#a47fe0', '1990-11-21', 'The Japanese version of the Super Nintendo Entertainment System (SNES), celebrated for its advanced graphics and sound capabilities, as well as its extensive game library.'),
(1002, 1, 1, 'Genesis', 'genesis', '#2f8ffd', '#7e7e7e', '1988-10-29', 'Known as the Mega Drive outside North America, this console is famous for its fast-paced games and iconic titles like Sonic the Hedgehog.'),
(1003, 2, 11, 'Mark III', 'mark3', '#2f8ffd', '#7e7e7e', '1985-10-20', 'The Japanese version of the Sega Master System, recognized for its strong library of arcade ports and unique peripherals.'),
(1004, 31, 8, 'TurboGrafx-16', 'tg16', '#c9eb09', '#d1ec6e', '1987-10-30', 'Known as the PC Engine in Japan, this console is celebrated for its innovative design and early adoption of CD-ROM technology.'),
(1005, 114, 76, 'TurboGrafx-CD', 'tgcd', '#c9eb09', '#d1ec6e', '1988-12-04', 'The CD-ROM add-on for the TurboGrafx-16/PC Engine, enhancing game audio and storage capacity.'),
(1006, 75, 27, 'Final Burn Neo', 'fbneo', '#ff7b00', '#8aa7a5', '1971-01-01', 'A popular arcade emulator known for its extensive support of classic arcade games from various manufacturers.'),
(1007, 75, 27, 'MAME', 'mame', '#00ccff', '#8aa7a5', '1971-01-01', 'Multiple Arcade Machine Emulator (MAME) is a widely used emulator that preserves and plays classic arcade games.'),
(1008, 75, 27, 'CPS1', 'cps1', '#4c79ff', '#8aa7a5', '1988-01-01', 'Capcom Play System 1 (CPS1) is an arcade system board known for iconic fighting games like Street Fighter II.'),
(1009, 75, 27, 'CPS2', 'cps2', '#4c79ff', '#8aa7a5', '1993-01-01', 'Capcom Play System 2 (CPS2) is an upgraded version of CPS1, featuring enhanced graphics and sound for classic titles.'),
(1010, 75, 27, 'CPS3', 'cps3', '#4c79ff', '#8aa7a5', '1996-01-01', 'Capcom Play System 3 (CPS3) is the third iteration of Capcom''s arcade system, known for games like Street Fighter III with advanced graphics and gameplay.'),
(1011, 75, 27, 'Neo Geo', 'neogeo', '#FF9800', '#666666', '1990-01-01', 'SNK''s Multi Video System (MVS) is an arcade system board that allows multiple games to be played on a single cabinet, known for its fighting game library.');





-- Nuevos datos consolidados para app_emulators
-- Formato: (id, os_id, system_id, name, is_standalone, core_filename, is_default)

-- Windows (os_id = 1) - RetroArch cores
INSERT INTO app_emulators (id, os_id, system_id, name, is_standalone, core_filename, is_default, is_ra_compatible) VALUES
-- Nintendo Entertainment System (system_id = 1)
(1, 1, 1, 'FCEUmm', 0, 'fceumm_libretro.dll', 1, 1),
(2, 1, 1, 'Mesen', 0, 'mesen_libretro.dll', 0, 1),
(3, 1, 1, 'QuickNES', 0, 'quicknes_libretro.dll', 0, 0),
(4, 1, 1, 'Nestopia', 0, 'nestopia_libretro.dll', 0, 0),

-- Super Nintendo (system_id = 2)
(5, 1, 2, 'Snes9x', 0, 'snes9x_libretro.dll', 1, 1),
(6, 1, 2, 'Mesen-S', 0, 'mesen_s_libretro.dll', 0, 1),
(7, 1, 2, 'Snes9x 2010', 0, 'snes9x2010_libretro.dll', 0, 0),
(8, 1, 2, 'Snes9x 2005 Plus', 0, 'snes9x2005_plus_libretro.dll', 0, 0),
(9, 1, 2, 'bsnes', 0, 'bsnes_libretro.dll', 0, 0),
(10, 1, 2, 'bsnes HD', 0, 'bsnes_hd_beta_libretro.dll', 0, 0),

-- Game Boy (system_id = 3)
(11, 1, 3, 'Gambatte', 0, 'gambatte_libretro.dll', 1, 1),
(12, 1, 3, 'SameBoy', 0, 'sameboy_libretro.dll', 0, 0),
(13, 1, 3, 'Gearboy', 0, 'gearboy_libretro.dll', 0, 1),
(14, 1, 3, 'TGB Dual', 0, 'tgbdual_libretro.dll', 0, 0),

-- Game Boy Color (system_id = 4)
(15, 1, 4, 'Gambatte', 0, 'gambatte_libretro.dll', 1, 1),
(16, 1, 4, 'SameBoy', 0, 'sameboy_libretro.dll', 0, 0),
(17, 1, 4, 'Gearboy', 0, 'gearboy_libretro.dll', 0, 1),
(18, 1, 4, 'TGB Dual', 0, 'tgbdual_libretro.dll', 0, 0),

-- Game Boy Advance (system_id = 5)
(19, 1, 5, 'mGBA', 0, 'mgba_libretro.dll', 1, 1),
(20, 1, 5, 'VBA-M', 0, 'vba_m_libretro.dll', 0, 1),
(21, 1, 5, 'VBA Next', 0, 'vba_next_libretro.dll', 0, 1),
(22, 1, 5, 'gpSP', 0, 'gpsp_libretro.dll', 0, 0),

-- Nintendo 64 (system_id = 6)
(23, 1, 6, 'Mupen64Plus-Next', 0, 'mupen64plus_next_libretro.dll', 1, 1),
(24, 1, 6, 'ParaLLEl N64', 0, 'parallel_n64_libretro.dll', 0, 1),

-- Nintendo DS (system_id = 7)
(25, 1, 7, 'DeSmuME', 0, 'desmume_libretro.dll', 0, 1),
(26, 1, 7, 'melonDS', 0, 'melonds_libretro.dll', 0, 1),
(27, 1, 7, 'melonDS DS', 0, 'melondsds_libretro.dll', 0, 1),
(28, 1, 7, 'DeSmuME 2015', 0, 'desmume2015_libretro.dll', 1, 0),

-- GameCube (system_id = 8)
(29, 1, 8, 'Dolphin', 0, 'dolphin_libretro.dll', 1, 0),

-- Mini (system_id = 9)
(30, 1, 9, 'PokeMini ', 0, 'pokemini_libretro.dll', 1, 1),

-- Virtual Boy (system_id = 10)
(31, 1, 10, 'Mednafen VB', 0, 'mednafen_vb_libretro.dll', 1, 1),

-- Nintendo DSi (system_id = 11)
(32, 1, 11, 'melonDS DS', 0, 'melondsds_libretro.dll', 1, 1),

-- Sega Mega Drive (system_id = 12)
(33, 1, 12, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.dll', 1, 1),
(34, 1, 12, 'PicoDrive', 0, 'picodrive_libretro.dll', 0, 1),
(35, 1, 12, 'BlastEm', 0, 'blastem_libretro.dll', 0, 0),

-- Sega Master System (system_id = 13)
(36, 1, 13, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.dll', 1, 1),
(37, 1, 13, 'Gearsystem', 0, 'gearsystem_libretro.dll', 0, 1),
(38, 1, 13, 'SMS Plus GX', 0, 'smsplus_libretro.dll', 0, 0),
(39, 1, 13, 'PicoDrive', 0, 'picodrive_libretro.dll', 0, 0),

-- Sega Game Gear (system_id = 14)
(40, 1, 14, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.dll', 1, 1),
(41, 1, 14, 'Gearsystem', 0, 'gearsystem_libretro.dll', 0, 1),
(42, 1, 14, 'SMS Plus GX', 0, 'smsplus_libretro.dll', 0, 0),
(43, 1, 14, 'PicoDrive', 0, 'picodrive_libretro.dll', 0, 0),

-- Sega CD (system_id = 15)
(44, 1, 15, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.dll', 1, 1),
(45, 1, 15, 'PicoDrive', 0, 'picodrive_libretro.dll', 1, 1),

-- Sega 32X (system_id = 16)
(46, 1, 16, 'PicoDrive', 0, 'picodrive_libretro.dll', 1, 1),

-- Sega Saturn (system_id = 17)
(47, 1, 17, 'Mednafen Saturn', 0, 'mednafen_saturn_libretro.dll', 1, 1),
(48, 1, 17, 'Kronos', 0, 'kronos_libretro.dll', 0, 0),
(49, 1, 17, 'YabaSanshiro', 0, 'yabasanshiro_libretro.dll', 0, 0),
(50, 1, 17, 'Yabause', 0, 'yabause_libretro.dll', 0, 0),

-- Dreamcast (system_id = 18)
(51, 1, 18, 'Flycast', 0, 'flycast_libretro.dll', 1, 1),

-- Sega SG-1000 (system_id = 19)
(52, 1, 19, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.dll', 1, 1),
(53, 1, 19, 'Gearsystem', 0, 'gearsystem_libretro.dll', 0, 0),
(54, 1, 19, 'BlueMSX', 0, 'bluemsx_libretro.dll', 0, 1),

-- Sony PlayStation (system_id = 20)
(55, 1, 20, 'Beetle PSX HW', 0, 'mednafen_psx_hw_libretro.dll', 1, 1),
(56, 1, 20, 'Beetle PSX', 0, 'mednafen_psx_libretro.dll', 0, 1),
(57, 1, 20, 'SwanStation', 0, 'swanstation_libretro.dll', 0, 1),
(58, 1, 20, 'PCSX ReARMed', 0, 'pcsx_rearmed_libretro.dll', 0, 1),

-- Sony PlayStation 2 (system_id = 21)
(59, 1, 21, 'LRPS2', 0, 'pcsx2_libretro.dll', 1, 0),
(60, 1, 21, 'PCSX2', 0, 'pcsx2_libretro.dll', 0, 0),

-- Sony PlayStation Portable (system_id = 22)
(61, 1, 22, 'PPSSPP', 0, 'ppsspp_libretro.dll', 1, 1),

-- Atari 2600 (system_id = 23)
(62, 1, 23, 'Stella', 0, 'stella_libretro.dll', 1, 1),
(63, 1, 23, 'Stella 2014', 0, 'stella2014_libretro.dll', 0, 0),
(64, 1, 23, 'Stella 2023', 0, 'stella2023_libretro.dll', 0, 0),

-- Atari 7800 (system_id = 24)
(65, 1, 24, 'ProSystem', 0, 'prosystem_libretro.dll', 1, 1),
(66, 1, 24, 'MAME', 0, 'mame_libretro.dll', 0, 0),

-- Atari Lynx (system_id = 25)
(67, 1, 25, 'Handy', 0, 'handy_libretro.dll', 1, 1),
(68, 1, 25, 'Beetle Lynx', 0, 'mednafen_lynx_libretro.dll', 0, 1),
(69, 1, 25, 'Holani', 0, 'holani_libretro.dll', 0, 0),

-- Atari Jaguar (system_id = 26)
(70, 1, 26, 'Virtual Jaguar', 0, 'virtualjaguar_libretro.dll', 1, 1),

-- Atari Jaguar CD (system_id = 27)
-- Standalone only in windows

-- PC Engine (system_id = 27)
(71, 1, 28, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro.dll', 1, 1),
(72, 1, 28, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro.dll', 0, 1),
(73, 1, 28, 'Beetle PCE', 0, 'mednafen_pce_libretro.dll', 0, 0),

-- PC Engine CD / TurboGrafx-CD (system_id = 28)
(74, 1, 29, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro.dll', 1, 1),
(75, 1, 29, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro.dll', 0, 1),
(76, 1, 29, 'Beetle PCE', 0, 'mednafen_pce_libretro.dll', 0, 0),

-- PC FX (system_id = 29)
(77, 1, 30, 'Mednafen PC-FX', 0, 'mednafen_pcfx_libretro.dll', 1, 1),

-- Neo Geo Pocket (system_id = 30)
(78, 1, 31, 'Beetle NeoPop', 0, 'mednafen_ngp_libretro.dll', 1, 1),
(79, 1, 31, 'RACE', 0, 'race_libretro.dll', 0, 0),

-- Neo Geo CD (system_id = 31)
(80, 1, 32, 'NeoCD', 0, 'neocd_libretro.dll', 1, 1),
(81, 1, 32, 'FinalBurn Neo', 0, 'fbneo_libretro.dll', 0, 0),

-- WonderSwan / WonderSwan Color (system_id = 33)
(82, 1, 33, 'Beetle Cygne', 0, 'mednafen_wswan_libretro.dll', 1, 1),

-- Watara Supervision (system_id = 34)
(83, 1, 34, 'Potator', 0, 'potator_libretro.dll', 1, 1),

-- Magnavox Odyssey2 (system_id = 35)
(84, 1, 35, 'o2em', 0, 'o2em_libretro.dll', 1, 1),

-- ColecoVision (system_id = 36)
(85, 1, 36, 'BlueMSX', 0, 'bluemsx_libretro.dll', 1, 1),
(86, 1, 36, 'Gearcoleco', 0, 'gearcoleco_libretro.dll', 0, 0),

-- Intellivision (system_id = 37)
(87, 1, 37, 'FreeIntv', 0, 'freeintv_libretro.dll', 1, 1),

-- Vectrex (system_id = 38)
(88, 1, 38, 'Vecx', 0, 'vecx_libretro.dll', 1, 1),

-- Mega Duck (system_id = 39)
(89, 1, 39, 'SameDuck', 0, 'sameduck_libretro.dll', 1, 1),

-- Arcade (system_id = 40)
(90, 1, 40, 'FinalBurn Neo', 0, 'fbneo_libretro.dll', 1, 1),
(91, 1, 40, 'MAME', 0, 'mame_libretro.dll', 0, 0),
(92, 1, 40, 'MAME 2010', 0, 'mame2010_libretro.dll', 0, 0),
(93, 1, 40, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.dll', 0, 0),
(94, 1, 40, 'MAME 2003', 0, 'mame2003_libretro.dll', 0, 0),
(95, 1, 40, 'MAME 2000', 0, 'mame2000_libretro.dll', 0, 0),
(96, 1, 40, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.dll', 0, 0),
(97, 1, 40, 'Geolith', 0, 'geolith_libretro.dll', 0, 0),
(98, 1, 40, 'Flycast', 0, 'flycast_libretro.dll', 0, 1),
(99, 1, 40, 'Kronos', 0, 'kronos_libretro.dll', 0, 0),
(100, 1, 40, 'DICE', 0, 'dice_libretro.dll', 0, 0),

-- 3DO Interactive Multiplayer (system_id = 41)
(101, 1, 41, 'Opera', 0, 'opera_libretro.dll', 1, 1),

-- MSX (system_id = 42)
(102, 1, 42, 'blueMSX', 0, 'bluemsx_libretro.dll', 1, 1),
(103, 1, 42, 'fMSX', 0, 'fmsx_libretro.dll', 0, 1),

-- Fairchild Channel F (system_id = 43)
(104, 1, 43, 'FreeChaF', 0, 'freechaf_libretro.dll', 1, 1),

-- Amstrad CPC (system_id = 44)
(105, 1, 44, 'Caprice32', 0, 'cap32_libretro.dll', 1, 1),
(106, 1, 44, 'CrocoDS', 0, 'crocods_libretro.dll', 0, 0),

-- Apple II (system_id = 45)
(107, 1, 45, 'MAME', 0, 'mame_libretro.dll', 1, 1),

-- Uzebox (system_id = 46)
(108, 1, 46, 'Uzem', 0, 'uzem_libretro.dll', 1, 1),

-- Arduboy (system_id = 47)
(109, 1, 47, 'Arduous', 0, 'arduous_libretro.dll', 1, 1),
(110, 1, 47, 'Ardens', 0, 'ardens_libretro.dll', 0, 1),

-- PC-8000/8800 (system_id = 48)
(111, 1, 48, 'QUASI88', 0, 'quasi88_libretro.dll', 1, 1),

-- WASM-4 (system_id = 49)
(112, 1, 49, 'WASM-4', 0, 'wasm4_libretro.dll', 1, 1),

-- Arcadia 2001 (system_id = 50)
(113, 1, 50, 'MAME', 0, 'mame_libretro.dll', 1, 0),

-- NAOMI (system_id = 100)
(114, 1, 100, 'Flycast', 0, 'flycast_libretro.dll', 1, 0),

-- NAOMI 2 (system_id = 101)
(115, 1, 101, 'Flycast', 0, 'flycast_libretro.dll', 1, 0),

-- NAOMI GD-ROM (system_id = 102)
(116, 1, 102, 'Flycast', 0, 'flycast_libretro.dll', 1, 0),

-- Atomiswave (system_id = 103)
(117, 1, 103, 'Flycast', 0, 'flycast_libretro.dll', 1, 0),

-- Nintendo 3DS (system_id = 51)
(118, 1, 51, 'Citra', 0, 'citra_libretro.dll', 1, 0),
(119, 1, 51, 'Citra 2018', 0, 'citra2018_libretro.dll', 0, 0),

-- Nintendo Wii (system_id = 52)
(120, 1, 52, 'Dolphin', 0, 'dolphin_libretro.dll', 1, 0),

-- Family Computer (system_id = 1000)
(1000, 1, 1000, 'FCEUmm', 0, 'fceumm_libretro.dll', 1, 1),
(1001, 1, 1000, 'Mesen', 0, 'mesen_libretro.dll', 0, 1),
(1002, 1, 1000, 'QuickNES', 0, 'quicknes_libretro.dll', 0, 0),
(1003, 1, 1000, 'Nestopia', 0, 'nestopia_libretro.dll', 0, 0),

-- Super Family Computer (system_id = 1001)
(1004, 1, 1001, 'Snes9x', 0, 'snes9x_libretro.dll', 1, 1),
(1005, 1, 1001, 'Mesen-S', 0, 'mesen_s_libretro.dll', 0, 1),
(1006, 1, 1001, 'Snes9x 2010', 0, 'snes9x2010_libretro.dll', 0, 0),
(1007, 1, 1001, 'Snes9x 2005 Plus', 0, 'snes9x2005_plus_libretro.dll', 0, 0),
(1008, 1, 1001, 'bsnes', 0, 'bsnes_libretro.dll', 0, 0),
(1009, 1, 1001, 'bsnes HD', 0, 'bsnes_hd_beta_libretro.dll', 0, 0),

-- Genesis (system_id = 1002)
(1010, 1, 1002, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.dll', 1, 1),
(1011, 1, 1002, 'PicoDrive', 0, 'picodrive_libretro.dll', 0, 1),
(1012, 1, 1002, 'BlastEm', 0, 'blastem_libretro.dll', 0, 0),

-- Mark III (system_id = 1003)
(1013, 1, 1003, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.dll', 1, 1),
(1014, 1, 1003, 'Gearsystem', 0, 'gearsystem_libretro.dll', 0, 1),
(1015, 1, 1003, 'SMS Plus GX', 0, 'smsplus_libretro.dll', 0, 0),
(1016, 1, 1003, 'PicoDrive', 0, 'picodrive_libretro.dll', 0, 0),

-- TurboGrafx-16 (system_id = 1004)
(1017, 1, 1004, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro.dll', 1, 1),
(1018, 1, 1004, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro.dll', 0, 1),
(1019, 1, 1004, 'Beetle PCE', 0, 'mednafen_pce_libretro.dll', 0, 0),

-- TurboGrafx-CD (system_id = 1005)
(1020, 1, 1005, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro.dll', 1, 1),
(1021, 1, 1005, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro.dll', 0, 1),
(1022, 1, 1005, 'Beetle PCE', 0, 'mednafen_pce_libretro.dll', 0, 0),

-- Final Burn Neo (system_id = 1006)
(1023, 1, 1006, 'FinalBurn Neo', 0, 'fbneo_libretro.dll', 1, 1),

-- MAME (system_id = 1007)
(1024, 1, 1007, 'MAME', 0, 'mame_libretro.dll', 1, 0),
(1025, 1, 1007, 'MAME 2010', 0, 'mame2010_libretro.dll', 0, 0),
(1026, 1, 1007, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.dll', 0, 0),
(1027, 1, 1007, 'MAME 2003', 0, 'mame2003_libretro.dll', 0, 0),
(1028, 1, 1007, 'MAME 2000', 0, 'mame2000_libretro.dll', 0, 0),

-- CPS1 (system_id = 1008)
(1029, 1, 1008, 'FinalBurn Neo', 0, 'fbneo_libretro.dll', 1, 1),
(1030, 1, 1008, 'MAME', 0, 'mame_libretro.dll', 0, 0),
(1031, 1, 1008, 'MAME 2010', 0, 'mame2010_libretro.dll', 0, 0),
(1032, 1, 1008, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.dll', 0, 0),
(1033, 1, 1008, 'MAME 2003', 0, 'mame2003_libretro.dll', 0, 0),
(1034, 1, 1008, 'MAME 2000', 0, 'mame2000_libretro.dll', 0, 0),
(1035, 1, 1008, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.dll', 0, 0),
(1036, 1, 1008, 'Geolith', 0, 'geolith_libretro.dll', 0, 0),
(1037, 1, 1008, 'Flycast', 0, 'flycast_libretro.dll', 0, 1),
(1038, 1, 1008, 'Kronos', 0, 'kronos_libretro.dll', 0, 0),
(1039, 1, 1008, 'DICE', 0, 'dice_libretro.dll', 0, 0),

-- CPS2
(1040, 1, 1009, 'FinalBurn Neo', 0, 'fbneo_libretro.dll', 1, 1),
(1041, 1, 1009, 'MAME', 0, 'mame_libretro.dll', 0, 0),
(1042, 1, 1009, 'MAME 2010', 0, 'mame2010_libretro.dll', 0, 0),
(1043, 1, 1009, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.dll', 0, 0),
(1044, 1, 1009, 'MAME 2003', 0, 'mame2003_libretro.dll', 0, 0),
(1045, 1, 1009, 'MAME 2000', 0, 'mame2000_libretro.dll', 0, 0),
(1046, 1, 1009, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.dll', 0, 0),
(1047, 1, 1009, 'Geolith', 0, 'geolith_libretro.dll', 0, 0),
(1048, 1, 1009, 'Flycast', 0, 'flycast_libretro.dll', 0, 1),
(1049, 1, 1009, 'Kronos', 0, 'kronos_libretro.dll', 0, 0),
(1050, 1, 1009, 'DICE', 0, 'dice_libretro.dll', 0, 0),

-- CPS3
(1051, 1, 1010, 'FinalBurn Neo', 0, 'fbneo_libretro.dll', 1, 1),
(1052, 1, 1010, 'MAME', 0, 'mame_libretro.dll', 0, 0),
(1053, 1, 1010, 'MAME 2010', 0, 'mame2010_libretro.dll', 0, 0),
(1054, 1, 1010, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.dll', 0, 0),
(1055, 1, 1010, 'MAME 2003', 0, 'mame2003_libretro.dll', 0, 0),
(1056, 1, 1010, 'MAME 2000', 0, 'mame2000_libretro.dll', 0, 0),
(1057, 1, 1010, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.dll', 0, 0),
(1058, 1, 1010, 'Geolith', 0, 'geolith_libretro.dll', 0, 0),
(1059, 1, 1010, 'Flycast', 0, 'flycast_libretro.dll', 0, 1),
(1060, 1, 1010, 'Kronos', 0, 'kronos_libretro.dll', 0, 0),
(1061, 1, 1010, 'DICE', 0, 'dice_libretro.dll', 0, 0),

-- NEO GEO
(1062, 1, 1011, 'FinalBurn Neo', 0, 'fbneo_libretro.dll', 1, 1),
(1063, 1, 1011, 'MAME', 0, 'mame_libretro.dll', 0, 0),
(1064, 1, 1011, 'MAME 2010', 0, 'mame2010_libretro.dll', 0, 0),
(1065, 1, 1011, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.dll', 0, 0),
(1066, 1, 1011, 'MAME 2003', 0, 'mame2003_libretro.dll', 0, 0),
(1067, 1, 1011, 'MAME 2000', 0, 'mame2000_libretro.dll', 0, 0),
(1068, 1, 1011, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.dll', 0, 0),
(1069, 1, 1011, 'Geolith', 0, 'geolith_libretro.dll', 0, 0),
(1070, 1, 1011, 'Flycast', 0, 'flycast_libretro.dll', 0, 1),
(1071, 1, 1011, 'Kronos', 0, 'kronos_libretro.dll', 0, 0),
(1072, 1, 1011, 'DICE', 0, 'dice_libretro.dll', 0, 0),




-- ANDROID
-- Nintendo Entertainment System (system_id = 1)
(10000, 2, 1, 'FCEUmm', 0, 'fceumm_libretro_android.so', 1, 1),
(10001, 2, 1, 'Mesen', 0, 'mesen_libretro_android.so', 0, 1),
(10002, 2, 1, 'QuickNES', 0, 'quicknes_libretro_android.so', 0, 0),
(10003, 2, 1, 'Nestopia', 0, 'nestopia_libretro_android.so', 0, 0),

-- Super Nintendo (system_id = 2)
(10004, 2, 2, 'Snes9x', 0, 'snes9x_libretro_android.so', 1, 1),
(10005, 2, 2, 'Mesen-S', 0, 'mesen_s_libretro_android.so', 0, 1),
(10006, 2, 2, 'Snes9x 2010', 0, 'snes9x2010_libretro_android.so', 0, 0),
(10007, 2, 2, 'Snes9x 2005 Plus', 0, 'snes9x2005_plus_libretro_android.so', 0, 0),
(10008, 2, 2, 'bsnes', 0, 'bsnes_libretro_android.so', 0, 0),
(10009, 2, 2, 'bsnes HD', 0, 'bsnes_hd_beta_libretro_android.so', 0, 0),

-- Game Boy (system_id = 3)
(10010, 2, 3, 'Gambatte', 0, 'gambatte_libretro_android.so', 1, 1),
(10011, 2, 3, 'SameBoy', 0, 'sameboy_libretro_android.so', 0, 0),
(10012, 2, 3, 'Gearboy', 0, 'gearboy_libretro_android.so', 0, 1),
(10013, 2, 3, 'TGB Dual', 0, 'tgbdual_libretro_android.so', 0, 0),

-- Game Boy Color (system_id = 4)
(10014, 2, 4, 'Gambatte', 0, 'gambatte_libretro_android.so', 1, 1),
(10015, 2, 4, 'SameBoy', 0, 'sameboy_libretro_android.so', 0, 0),
(10016, 2, 4, 'Gearboy', 0, 'gearboy_libretro_android.so', 0, 1),
(10017, 2, 4, 'TGB Dual', 0, 'tgbdual_libretro_android.so', 0, 0),

-- Game Boy Advance (system_id = 5)
(10018, 2, 5, 'mGBA', 0, 'mgba_libretro_android.so', 1, 1),
(10019, 2, 5, 'VBA-M', 0, 'vba_libretro_android.so', 0, 1),
(10020, 2, 5, 'VBA Next', 0, 'vba_next_libretro_android.so', 0, 1),
(10021, 2, 5, 'gpSP', 0, 'gpsp_libretro_android.so', 0, 0),

-- Nintendo 64 (system_id = 6)
(10022, 2, 6, 'Mupen64Plus-Next', 0, 'mupen64plus_next_gles3_libretro_android.so', 1, 1),
(10023, 2, 6, 'ParaLLEl N64', 0, 'parallel_n64_libretro_android.so', 0, 1),

-- Nintendo DS (system_id = 7)
(10024, 2, 7, 'DeSmuME', 0, 'desmume_libretro_android.so', 0, 1),
(10025, 2, 7, 'melonDS', 0, 'melonds_libretro_android.so', 0, 1),
(10026, 2, 7, 'melonDS DS', 0, 'melondsds_libretro_android.so', 0, 1),
(10027, 2, 7, 'DeSmuME 2015', 0, 'desmume2015_libretro_android.so', 1, 0),

-- GameCube (system_id = 8)
(10028, 2, 8, 'Dolphin', 0, 'dolphin_libretro_android.so', 1, 0),

-- Mini (system_id = 9)
(10029, 2, 9, 'PokeMini ', 0, 'pokemini_libretro_android.so', 1, 1),

-- Virtual Boy (system_id = 10)
(10030, 2, 10, 'Mednafen VB', 0, 'mednafen_vb_libretro_android.so', 1, 1),

-- Nintendo DSi (system_id = 11)
(10031, 2, 11, 'melonDS DS', 0, 'melondsds_libretro_android.so', 1, 1),

-- Sega Mega Drive (system_id = 12)
(10032, 2, 12, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro_android.so', 1, 1),
(10033, 2, 12, 'PicoDrive', 0, 'picodrive_libretro_android.so', 0, 1),
(10034, 2, 12, 'Genesis Plus GX Wide', 0, 'genesis_plus_gx_wide_libretro_android.so', 0, 0),

-- Sega Master System (system_id = 13)
(10035, 2, 13, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro_android.so', 1, 1),
(10036, 2, 13, 'Gearsystem', 0, 'gearsystem_libretro_android.so', 0, 1),
(10037, 2, 13, 'SMS Plus GX', 0, 'smsplus_libretro_android.so', 0, 0),
(10038, 2, 13, 'PicoDrive', 0, 'picodrive_libretro_android.so', 0, 0),
(10039, 2, 13, 'Genesis Plus GX Wide', 0, 'genesis_plus_gx_wide_libretro_android.so', 0, 0),

-- Sega Game Gear (system_id = 14)
(10040, 2, 14, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro_android.so', 1, 1),
(10041, 2, 14, 'Gearsystem', 0, 'gearsystem_libretro_android.so', 0, 1),
(10042, 2, 14, 'SMS Plus GX', 0, 'smsplus_libretro_android.so', 0, 0),
(10043, 2, 14, 'PicoDrive', 0, 'picodrive_libretro_android.so', 0, 0),
(10044, 2, 14, 'Genesis Plus GX Wide', 0, 'genesis_plus_gx_wide_libretro_android.so', 0, 0),

-- Sega CD (system_id = 15)
(10045, 2, 15, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro_android.so', 1, 1),
(10046, 2, 15, 'PicoDrive', 0, 'picodrive_libretro_android.so', 1, 1),
(10047, 2, 15, 'Genesis Plus GX Wide', 0, 'genesis_plus_gx_wide_libretro_android.so', 0, 0),

-- Sega 32X (system_id = 16)
(10048, 2, 16, 'PicoDrive', 0, 'picodrive_libretro_android.so', 1, 1),

-- Sega Saturn (system_id = 17)
(10049, 2, 17, 'Mednafen Saturn', 0, 'mednafen_saturn_libretro_android.so', 1, 1),
(10050, 2, 17, 'YabaSanshiro', 0, 'yabasanshiro_libretro_android.so', 0, 0),
(10051, 2, 17, 'Yabause', 0, 'yabause_libretro_android.so', 0, 0),

-- Dreamcast (system_id = 18)
(10052, 2, 18, 'Flycast', 0, 'flycast_libretro_android.so', 1, 1),

-- Sega SG-1000 (system_id = 19)
(10053, 2, 19, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro_android.so', 1, 1),
(10054, 2, 19, 'Gearsystem', 0, 'gearsystem_libretro_android.so', 0, 0),
(10055, 2, 19, 'BlueMSX', 0, 'bluemsx_libretro_android.so', 0, 1),
(10056, 2, 19, 'Genesis Plus GX Wide', 0, 'genesis_plus_gx_wide_libretro_android.so', 0, 0),

-- Sony PlayStation (system_id = 20)
(10057, 2, 20, 'Beetle PSX HW', 0, 'mednafen_psx_hw_libretro_android.so', 1, 1),
(10058, 2, 20, 'Beetle PSX', 0, 'mednafen_psx_libretro_android.so', 0, 1),
(10059, 2, 20, 'SwanStation', 0, 'swanstation_libretro_android.so', 0, 1),
(10060, 2, 20, 'PCSX ReARMed', 0, 'pcsx_rearmed_libretro_android.so', 0, 1),



-- Sony PlayStation Portable (system_id = 22)
(10061, 2, 22, 'PPSSPP', 0, 'ppsspp_libretro_android.so', 1, 1),

-- Atari 2600 (system_id = 23)
(10062, 2, 23, 'Stella', 0, 'stella_libretro_android.so', 1, 1),
(10063, 2, 23, 'Stella 2014', 0, 'stella2014_libretro_android.so', 0, 0),
(10064, 2, 23, 'Stella 2023', 0, 'stella2023_libretro_android.so', 0, 0),

-- Atari 7800 (system_id = 24)
(10065, 2, 24, 'ProSystem', 0, 'prosystem_libretro_android.so', 1, 1),
    
-- Atari Lynx (system_id = 25)
(10066, 2, 25, 'Handy', 0, 'handy_libretro_android.so', 1, 1),
(10067, 2, 25, 'Beetle Lynx', 0, 'mednafen_lynx_libretro_android.so', 0, 1),
(10068, 2, 25, 'Holani', 0, 'holani_libretro_android.so', 0, 0),

-- Atari Jaguar (system_id = 26)
(10069, 2, 26, 'Virtual Jaguar', 0, 'virtualjaguar_libretro_android.so', 1, 1),

-- Atari Jaguar CD (system_id = 27)

-- PC Engine (system_id = 27)
(10070, 2, 28, 'Beetle SuperGrafx', 0, 'mednafen_supergrafx_libretro_android.so', 1, 1),
(10071, 2, 28, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro_android.so', 0, 1),
(10072, 2, 28, 'Beetle PCE', 0, 'mednafen_pce_libretro_android.so', 0, 0),
(10073, 2, 28, 'Geargrafx', 0, 'geargrafx_libretro_android.so', 0, 0),

-- PC Engine CD / TurboGrafx-CD (system_id = 28)
(10074, 2, 29, 'Beetle SuperGrafx', 0, 'mednafen_supergrafx_libretro_android.so', 1, 1),
(10075, 2, 29, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro_android.so', 0, 1),
(10076, 2, 29, 'Beetle PCE', 0, 'mednafen_pce_libretro_android.so', 0, 0),

-- PC FX (system_id = 29)
(10077, 2, 30, 'Beetle PC-FX', 0, 'mednafen_pcfx_libretro_android.so', 1, 1),

-- Neo Geo Pocket (system_id = 30)
(10078, 2, 31, 'Beetle NeoPop', 0, 'mednafen_ngp_libretro_android.so', 1, 1),
(10079, 2, 31, 'RACE', 0, 'race_libretro_android.so', 0, 0),

-- Neo Geo CD (system_id = 31)
(10080, 2, 32, 'NeoCD', 0, 'neocd_libretro_android.so', 1, 1),

-- WonderSwan / WonderSwan Color (system_id = 33)
(10082, 2, 33, 'Beetle Cygne', 0, 'mednafen_wswan_libretro_android.so', 1, 1),

-- Watara Supervision (system_id = 34)
(10083, 2, 34, 'Potator', 0, 'potator_libretro_android.so', 1, 1),

-- Magnavox Odyssey 2 (system_id = 35)
(10084, 2, 35, 'o2em', 0, 'o2em_libretro_android.so', 1, 1),

-- ColecoVision (system_id = 36)
(10085, 2, 36, 'BlueMSX', 0, 'bluemsx_libretro_android.so', 1, 1),
(10086, 2, 36, 'Gearcoleco', 0, 'gearcoleco_libretro_android.so', 0, 0),

-- Intellivision (system_id = 37)
(10087, 2, 37, 'FreeIntv', 0, 'freeintv_libretro_android.so', 1, 1),

-- Vectrex (system_id = 38)
(10088, 2, 38, 'Vecx', 0, 'vecx_libretro_android.so', 1, 1),

-- Mega Duck (system_id = 39)
(10089, 2, 39, 'SameDuck', 0, 'sameduck_libretro_android.so', 1, 1),

-- Arcade (system_id = 40)
(10090, 2, 40, 'FinalBurn Neo', 0, 'fbneo_libretro_android.so', 1, 1),
(10091, 2, 40, 'MAME', 0, 'mame_libretro_android.so', 0, 0),
(10092, 2, 40, 'MAME 2010', 0, 'mame2010_libretro_android.so', 0, 0),
(10093, 2, 40, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro_android.so', 0, 0),
(10094, 2, 40, 'MAME 2003', 0, 'mame2003_libretro_android.so', 0, 0),
(10095, 2, 40, 'MAME 2000', 0, 'mame2000_libretro_android.so', 0, 0),
(10096, 2, 40, 'FB Alpha 2012', 0, 'fbalpha2012_libretro_android.so', 0, 0),
(10097, 2, 40, 'Geolith', 0, 'geolith_libretro_android.so', 0, 0),
(10098, 2, 40, 'Flycast', 0, 'flycast_libretro_android.so', 0, 1),
(10099, 2, 40, 'DICE', 0, 'dice_libretro_android.so', 0, 0),

-- 3DO Interactive Multiplayer (system_id = 41)
(10101, 2, 41, 'Opera', 0, 'opera_libretro_android.so', 1, 1),

-- MSX (system_id = 42)
(10102, 2, 42, 'blueMSX', 0, 'bluemsx_libretro_android.so', 1, 1),
(10103, 2, 42, 'fMSX', 0, 'fmsx_libretro_android.so', 0, 1),

-- Fairchild Channel F (system_id = 43)
(10104, 2, 43, 'FreeChaF', 0, 'freechaf_libretro_android.so', 1, 1),

-- Amstrad CPC (system_id = 44)
(10105, 2, 44, 'Caprice32', 0, 'cap32_libretro_android.so', 1, 1),
(10106, 2, 44, 'CrocoDS', 0, 'crocods_libretro_android.so', 0, 0),

-- Apple II (system_id = 45)
-- Standalone only

-- Uzebox (system_id = 46)
(10108, 2, 46, 'Uzem', 0, 'uzem_libretro_android.so', 1, 1),

-- Arduboy (system_id = 47)
(10109, 2, 47, 'Arduous', 0, 'arduous_libretro_android.so', 1, 1),
(10110, 2, 47, 'Ardens', 0, 'ardens_libretro_android.so', 0, 1),

-- PC-8000/8800 (system_id = 48)
(10111, 2, 48, 'QUASI88', 0, 'quasi88_libretro_android.so', 1, 1),

-- WASM-4 (system_id = 49)
(10112, 2, 49, 'WASM-4', 0, 'wasm4_libretro_android.so', 1, 1),

-- Arcadia 2001 (system_id = 50)
-- Standalone Only

-- NAOMI (system_id = 100)
(10114, 2, 100, 'Flycast', 0, 'flycast_libretro_android.so', 1, 0),

-- NAOMI 2 (system_id = 101)
(10115, 2, 101, 'Flycast', 0, 'flycast_libretro_android.so', 1, 0),

-- NAOMI GD-ROM (system_id = 102)
(10116, 2, 102, 'Flycast', 0, 'flycast_libretro_android.so', 1, 0),

-- Atomiswave (system_id = 103)
(10117, 2, 103, 'Flycast', 0, 'flycast_libretro_android.so', 1, 0),

-- Nintendo 3DS (system_id = 51)
(10118, 2, 51, 'Citra', 0, 'citra_libretro_android.so', 1, 0),

-- Nintendo Wii (system_id = 52)
(10119, 2, 52, 'Dolphin', 0, 'dolphin_libretro_android.so', 1, 0),

-- Sony PlayStation 2 (system_id = 21)
(10120, 2, 21, 'Play!', 0, 'play_libretro_android.so', 1, 0),

-- Family Computer (system_id = 1000)
(11000, 2, 1000, 'FCEUmm', 0, 'fceumm_libretro_android.so', 1, 1),
(11001, 2, 1000, 'Mesen', 0, 'mesen_libretro_android.so', 0, 1),
(11002, 2, 1000, 'QuickNES', 0, 'quicknes_libretro_android.so', 0, 0),
(11003, 2, 1000, 'Nestopia', 0, 'nestopia_libretro_android.so', 0, 0),

-- Super Family Computer (system_id = 1001)
(11004, 2, 1001, 'Snes9x', 0, 'snes9x_libretro_android.so', 1, 1),
(11005, 2, 1001, 'Mesen-S', 0, 'mesen_s_libretro_android.so', 0, 1),
(11006, 2, 1001, 'Snes9x 2010', 0, 'snes9x2010_libretro_android.so', 0, 0),
(11007, 2, 1001, 'Snes9x 2005 Plus', 0, 'snes9x2005_plus_libretro_android.so', 0, 0),
(11008, 2, 1001, 'bsnes', 0, 'bsnes_libretro_android.so', 0, 0),
(11009, 2, 1001, 'bsnes HD', 0, 'bsnes_hd_beta_libretro_android.so', 0, 0),

-- Genesis (system_id = 1002)
(11010, 2, 1002, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro_android.so', 1, 1),
(11011, 2, 1002, 'PicoDrive', 0, 'picodrive_libretro_android.so', 0, 1),
(11012, 2, 1002, 'BlastEm', 0, 'blastem_libretro_android.so', 0, 0),
(11013, 2, 1002, 'Genesis Plus GX Wide', 0, 'genesis_plus_gx_wide_libretro_android.so', 0, 0),

-- Mark III (system_id = 1003)
(11014, 2, 1003, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro_android.so', 1, 1),
(11015, 2, 1003, 'Gearsystem', 0, 'gearsystem_libretro_android.so', 0, 1),
(11016, 2, 1003, 'SMS Plus GX', 0, 'smsplus_libretro_android.so', 0, 0),
(11017, 2, 1003, 'PicoDrive', 0, 'picodrive_libretro_android.so', 0, 0),
(11018, 2, 1003, 'Genesis Plus GX Wide', 0, 'genesis_plus_gx_wide_libretro_android.so', 0, 0),

-- TurboGrafx-16 (system_id = 1004)
(11019, 2, 1004, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro_android.so', 1, 1),
(11020, 2, 1004, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro_android.so', 0, 1),
(11021, 2, 1004, 'Beetle PCE', 0, 'mednafen_pce_libretro_android.so', 0, 0),

-- TurboGrafx-CD (system_id = 1005)
(11022, 2, 1005, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro_android.so', 1, 1),
(11023, 2, 1005, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro_android.so', 0, 1),
(11024, 2, 1005, 'Beetle PCE', 0, 'mednafen_pce_libretro_android.so', 0, 0),

-- Final Burn Neo (system_id = 1006)
(11025, 2, 1006, 'FinalBurn Neo', 0, 'fbneo_libretro_android.so', 1, 1),

-- MAME (system_id = 1007)
(11026, 2, 1007, 'MAME', 0, 'mame_libretro_android.so', 1, 0),
(11027, 2, 1007, 'MAME 2010', 0, 'mame2010_libretro_android.so', 0, 0),
(11028, 2, 1007, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro_android.so', 0, 0),
(11029, 2, 1007, 'MAME 2003', 0, 'mame2003_libretro_android.so', 0, 0),
(11030, 2, 1007, 'MAME 2000', 0, 'mame2000_libretro_android.so', 0, 0),

-- CPS1 (system_id = 1008)
(11031, 2, 1008, 'FinalBurn Neo', 0, 'fbneo_libretro_android.so', 1, 1),
(11032, 2, 1008, 'MAME', 0, 'mame_libretro_android.so', 0, 0),
(11033, 2, 1008, 'MAME 2010', 0, 'mame2010_libretro_android.so', 0, 0),
(11034, 2, 1008, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro_android.so', 0, 0),
(11035, 2, 1008, 'MAME 2003', 0, 'mame2003_libretro_android.so', 0, 0),
(11036, 2, 1008, 'MAME 2000', 0, 'mame2000_libretro_android.so', 0, 0),
(11037, 2, 1008, 'FB Alpha 2012', 0, 'fbalpha2012_libretro_android.so', 0, 0),
(11038, 2, 1008, 'Geolith', 0, 'geolith_libretro_android.so', 0, 0),
(11039, 2, 1008, 'Flycast', 0, 'flycast_libretro_android.so', 0, 1),
(11040, 2, 1008, 'DICE', 0, 'dice_libretro_android.so', 0, 0),

-- CPS2
(11041, 2, 1009, 'FinalBurn Neo', 0, 'fbneo_libretro_android.so', 1, 1),
(11042, 2, 1009, 'MAME', 0, 'mame_libretro_android.so', 0, 0),
(11043, 2, 1009, 'MAME 2010', 0, 'mame2010_libretro_android.so', 0, 0),
(11044, 2, 1009, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro_android.so', 0, 0),
(11045, 2, 1009, 'MAME 2003', 0, 'mame2003_libretro_android.so', 0, 0),
(11046, 2, 1009, 'MAME 2000', 0, 'mame2000_libretro_android.so', 0, 0),
(11047, 2, 1009, 'FB Alpha 2012', 0, 'fbalpha2012_libretro_android.so', 0, 0),
(11048, 2, 1009, 'Geolith', 0, 'geolith_libretro_android.so', 0, 0),
(11049, 2, 1009, 'Flycast', 0, 'flycast_libretro_android.so', 0, 1),
(11050, 2, 1009, 'DICE', 0, 'dice_libretro_android.so', 0, 0),

-- CPS3
(11051, 2, 1010, 'FinalBurn Neo', 0, 'fbneo_libretro_android.so', 1, 1),
(11052, 2, 1010, 'MAME', 0, 'mame_libretro_android.so', 0, 0),
(11053, 2, 1010, 'MAME 2010', 0, 'mame2010_libretro_android.so', 0, 0),
(11054, 2, 1010, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro_android.so', 0, 0),
(11055, 2, 1010, 'MAME 2003', 0, 'mame2003_libretro_android.so', 0, 0),
(11056, 2, 1010, 'MAME 2000', 0, 'mame2000_libretro_android.so', 0, 0),
(11057, 2, 1010, 'FB Alpha 2012', 0, 'fbalpha2012_libretro_android.so', 0, 0),
(11058, 2, 1010, 'Geolith', 0, 'geolith_libretro_android.so', 0, 0),
(11059, 2, 1010, 'Flycast', 0, 'flycast_libretro_android.so', 0, 1),
(11060, 2, 1010, 'DICE', 0, 'dice_libretro_android.so', 0, 0),

-- NEO GEO
(11061, 2, 1011, 'FinalBurn Neo', 0, 'fbneo_libretro_android.so', 1, 1),
(11062, 2, 1011, 'MAME', 0, 'mame_libretro_android.so', 0, 0),
(11063, 2, 1011, 'MAME 2010', 0, 'mame2010_libretro_android.so', 0, 0),
(11064, 2, 1011, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro_android.so', 0, 0),
(11065, 2, 1011, 'MAME 2003', 0, 'mame2003_libretro_android.so', 0, 0),
(11066, 2, 1011, 'MAME 2000', 0, 'mame2000_libretro_android.so', 0, 0),
(11067, 2, 1011, 'FB Alpha 2012', 0, 'fbalpha2012_libretro_android.so', 0, 0),
(11068, 2, 1011, 'Geolith', 0, 'geolith_libretro_android.so', 0, 0),
(11069, 2, 1011, 'Flycast', 0, 'flycast_libretro_android.so', 0, 1),
(11070, 2, 1011, 'DICE', 0, 'dice_libretro_android.so', 0, 0),

-- LINUX
-- Nintendo Entertainment System (system_id = 1)
(20000, 3, 1, 'FCEUmm', 0, 'fceumm_libretro.so', 1, 1),
(20001, 3, 1, 'Mesen', 0, 'mesen_libretro.so', 0, 1),
(20002, 3, 1, 'QuickNES', 0, 'quicknes_libretro.so', 0, 0),
(20003, 3, 1, 'Nestopia', 0, 'nestopia_libretro.so', 0, 0),

-- Super Nintendo (system_id = 2)
(20004, 3, 2, 'Snes9x', 0, 'snes9x_libretro.so', 1, 1),
(20005, 3, 2, 'Mesen-S', 0, 'mesen_s_libretro.so', 0, 1),
(20006, 3, 2, 'Snes9x 2010', 0, 'snes9x2010_libretro.so', 0, 0),
(20007, 3, 2, 'Snes9x 2005 Plus', 0, 'snes9x2005_plus_libretro.so', 0, 0),
(20008, 3, 2, 'bsnes', 0, 'bsnes_libretro.so', 0, 0),
(20009, 3, 2, 'bsnes HD', 0, 'bsnes_hd_beta_libretro.so', 0, 0),

-- Game Boy (system_id = 3)
(20010, 3, 3, 'Gambatte', 0, 'gambatte_libretro.so', 1, 1),
(20011, 3, 3, 'SameBoy', 0, 'sameboy_libretro.so', 0, 0),
(20012, 3, 3, 'Gearboy', 0, 'gearboy_libretro.so', 0, 1),
(20013, 3, 3, 'TGB Dual', 0, 'tgbdual_libretro.so', 0, 0),

-- Game Boy Color (system_id = 4)
(20014, 3, 4, 'Gambatte', 0, 'gambatte_libretro.so', 1, 1),
(20015, 3, 4, 'SameBoy', 0, 'sameboy_libretro.so', 0, 0),
(20016, 3, 4, 'Gearboy', 0, 'gearboy_libretro.so', 0, 1),
(20017, 3, 4, 'TGB Dual', 0, 'tgbdual_libretro.so', 0, 0),

-- Game Boy Advance (system_id = 5)
(20018, 3, 5, 'mGBA', 0, 'mgba_libretro.so', 1, 1),
(20019, 3, 5, 'VBA-M', 0, 'vba_m_libretro.so', 0, 1),
(20020, 3, 5, 'VBA Next', 0, 'vba_next_libretro.so', 0, 1),
(20021, 3, 5, 'gpSP', 0, 'gpsp_libretro.so', 0, 0),

-- Nintendo 64 (system_id = 6)
(20022, 3, 6, 'Mupen64Plus-Next', 0, 'mupen64plus_next_libretro.so', 1, 1),
(20023, 3, 6, 'ParaLLEl N64', 0, 'parallel_n64_libretro.so', 0, 1),

-- Nintendo DS (system_id = 7)
(20024, 3, 7, 'DeSmuME', 0, 'desmume_libretro.so', 0, 1),
(20025, 3, 7, 'melonDS', 0, 'melonds_libretro.so', 0, 1),
(20026, 3, 7, 'melonDS DS', 0, 'melondsds_libretro.so', 0, 1),
(20027, 3, 7, 'DeSmuME 2015', 0, 'desmume2015_libretro.so', 1, 0),

-- GameCube (system_id = 8)
(20028, 3, 8, 'Dolphin', 0, 'dolphin_libretro.so', 1, 0),

-- Mini (system_id = 9)
(20029, 3, 9, 'PokeMini ', 0, 'pokemini_libretro.so', 1, 1),

-- Virtual Boy (system_id = 10)
(20030, 3, 10, 'Mednafen VB', 0, 'mednafen_vb_libretro.so', 1, 1),

-- Nintendo DSi (system_id = 11)
(20031, 3, 11, 'melonDS DS', 0, 'melondsds_libretro.so', 1, 1),

-- Sega Mega Drive (system_id = 12)
(20032, 3, 12, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.so', 1, 1),
(20033, 3, 12, 'PicoDrive', 0, 'picodrive_libretro.so', 0, 1),
(20034, 3, 12, 'BlastEm', 0, 'blastem_libretro.so', 0, 0),

-- Sega Master System (system_id = 13)
(20035, 3, 13, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.so', 1, 1),
(20036, 3, 13, 'Gearsystem', 0, 'gearsystem_libretro.so', 0, 1),
(20037, 3, 13, 'SMS Plus GX', 0, 'smsplus_libretro.so', 0, 0),
(20038, 3, 13, 'PicoDrive', 0, 'picodrive_libretro.so', 0, 0),

-- Sega Game Gear (system_id = 14)
(20039, 3, 14, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.so', 1, 1),
(20040, 3, 14, 'Gearsystem', 0, 'gearsystem_libretro.so', 0, 1),
(20041, 3, 14, 'SMS Plus GX', 0, 'smsplus_libretro.so', 0, 0),
(20042, 3, 14, 'PicoDrive', 0, 'picodrive_libretro.so', 0, 0),

-- Sega CD (system_id = 15)
(20043, 3, 15, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.so', 1, 1),
(20044, 3, 15, 'PicoDrive', 0, 'picodrive_libretro.so', 1, 1),

-- Sega 32X (system_id = 16)
(20045, 3, 16, 'PicoDrive', 0, 'picodrive_libretro.so', 1, 1),

-- Sega Saturn (system_id = 17)
(20046, 3, 17, 'Mednafen Saturn', 0, 'mednafen_saturn_libretro.so', 1, 1),
(20047, 3, 17, 'Kronos', 0, 'kronos_libretro.so', 0, 0),
(20048, 3, 17, 'YabaSanshiro', 0, 'yabasanshiro_libretro.so', 0, 0),
(20049, 3, 17, 'Yabause', 0, 'yabause_libretro.so', 0, 0),

-- Dreamcast (system_id = 18)
(20050, 3, 18, 'Flycast', 0, 'flycast_libretro.so', 1, 1),

-- Sega SG-1000 (system_id = 19)
(20051, 3, 19, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.so', 1, 1),
(20052, 3, 19, 'Gearsystem', 0, 'gearsystem_libretro.so', 0, 0),
(20053, 3, 19, 'BlueMSX', 0, 'bluemsx_libretro.so', 0, 1),

-- Sony PlayStation (system_id = 20)
(20054, 3, 20, 'Beetle PSX HW', 0, 'mednafen_psx_hw_libretro.so', 1, 1),
(20055, 3, 20, 'Beetle PSX', 0, 'mednafen_psx_libretro.so', 0, 1),
(20056, 3, 20, 'SwanStation', 0, 'swanstation_libretro.so', 0, 1),
(20057, 3, 20, 'PCSX ReARMed', 0, 'pcsx_rearmed_libretro.so', 0, 1),

-- Sony PlayStation 2 (system_id = 21)
(20058, 3, 21, 'LRPS2', 0, 'pcsx2_libretro.so', 1, 0),
(20059, 3, 21, 'PCSX2', 0, 'pcsx2_libretro.so', 0, 0),

-- Sony PlayStation Portable (system_id = 22)
(20060, 3, 22, 'PPSSPP', 0, 'ppsspp_libretro.so', 1, 1),

-- Atari 2600 (system_id = 23)
(20061, 3, 23, 'Stella', 0, 'stella_libretro.so', 1, 1),
(20062, 3, 23, 'Stella 2014', 0, 'stella2014_libretro.so', 0, 0),
(20063, 3, 23, 'Stella 2023', 0, 'stella2023_libretro.so', 0, 0),

-- Atari 7800 (system_id = 24)
(20064, 3, 24, 'ProSystem', 0, 'prosystem_libretro.so', 1, 1),
(20065, 3, 24, 'MAME', 0, 'mame_libretro.so', 0, 0),

-- Atari Lynx (system_id = 25)
(20066, 3, 25, 'Handy', 0, 'handy_libretro.so', 1, 1),
(20067, 3, 25, 'Beetle Lynx', 0, 'mednafen_lynx_libretro.so', 0, 1),
(20068, 3, 25, 'Holani', 0, 'holani_libretro.so', 0, 0),

-- Atari Jaguar (system_id = 26)
(20069, 3, 26, 'Virtual Jaguar', 0, 'virtualjaguar_libretro.so', 1, 1),

-- PC Engine (system_id = 27)
(20070, 3, 27, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro.so', 1, 1),
(20071, 3, 27, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro.so', 0, 1),
(20072, 3, 27, 'Beetle PCE', 0, 'mednafen_pce_libretro.so', 0, 0),

-- PC Engine CD / TurboGrafx-CD (system_id = 28)
(20073, 3, 28, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro.so', 1, 1),
(20074, 3, 28, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro.so', 0, 1),
(20075, 3, 28, 'Beetle PCE', 0, 'mednafen_pce_libretro.so', 0, 0),

-- PC FX (system_id = 29)
(20076, 3, 29, 'Mednafen PC-FX', 0, 'mednafen_pcfx_libretro.so', 1, 1),

-- Neo Geo Pocket (system_id = 30)
(20077, 3, 30, 'Beetle NeoPop', 0, 'mednafen_ngp_libretro.so', 1, 1),
(20078, 3, 30, 'RACE', 0, 'race_libretro.so', 0, 0),

-- Neo Geo CD (system_id = 31)
(20079, 3, 31, 'NeoCD', 0, 'neocd_libretro.so', 1, 1),
(20080, 3, 32, 'FinalBurn Neo', 0, 'fbneo_libretro.so', 0, 0),

-- WonderSwan / WonderSwan Color (system_id = 33)
(20081, 3, 33, 'Beetle Cygne', 0, 'mednafen_wswan_libretro.so', 1, 1),

-- Watara Supervision (system_id = 34)
(20082, 3, 34, 'Potator', 0, 'potator_libretro.so', 1, 1),

-- Magnavox Odyssey2 (system_id = 35)
(20083, 3, 35, 'o2em', 0, 'o2em_libretro.so', 1, 1),

-- ColecoVision (system_id = 36)
(20084, 3, 36, 'BlueMSX', 0, 'bluemsx_libretro.so', 1, 1),
(20085, 3, 36, 'Gearcoleco', 0, 'gearcoleco_libretro.so', 0, 0),

-- Intellivision (system_id = 37)
(20086, 3, 37, 'FreeIntv', 0, 'freeintv_libretro.so', 1, 1),

-- Vectrex (system_id = 38)
(20087, 3, 38, 'Vecx', 0, 'vecx_libretro.so', 1, 1),

-- Mega Duck (system_id = 39)
(20088, 3, 39, 'SameDuck', 0, 'sameduck_libretro.so', 1, 1),

-- Arcade (system_id = 40)
(20089, 3, 40, 'FinalBurn Neo', 0, 'fbneo_libretro.so', 1, 1),
(20090, 3, 40, 'MAME', 0, 'mame_libretro.so', 0, 0),
(20091, 3, 40, 'MAME 2010', 0, 'mame2010_libretro.so', 0, 0),
(20092, 3, 40, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.so', 0, 0),
(20093, 3, 40, 'MAME 2003', 0, 'mame2003_libretro.so', 0, 0),
(20094, 3, 40, 'MAME 2000', 0, 'mame2000_libretro.so', 0, 0),
(20095, 3, 40, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.so', 0, 0),
(20096, 3, 40, 'Geolith', 0, 'geolith_libretro.so', 0, 0),
(20097, 3, 40, 'Flycast', 0, 'flycast_libretro.so', 0, 1),
(20098, 3, 40, 'Kronos', 0, 'kronos_libretro.so', 0, 0),
(20099, 3, 40, 'DICE', 0, 'dice_libretro.so', 0, 0),

-- 3DO Interactive Multiplayer (system_id = 41)
(20100, 3, 41, 'Opera', 0, 'opera_libretro.so', 1, 1),

-- MSX (system_id = 42)
(20101, 3, 42, 'blueMSX', 0, 'bluemsx_libretro.so', 1, 1),
(20102, 3, 42, 'fMSX', 0, 'fmsx_libretro.so', 0, 1),

-- Fairchild Channel F (system_id = 43)
(20103, 3, 43, 'FreeChaF', 0, 'freechaf_libretro.so', 1, 1),

-- Amstrad CPC (system_id = 44)
(20104, 3, 44, 'Caprice32', 0, 'cap32_libretro.so', 1, 1),
(20105, 3, 44, 'CrocoDS', 0, 'crocods_libretro.so', 0, 0),

-- Apple II (system_id = 45)
(20106, 3, 45, 'MAME', 0, 'mame_libretro.so', 1, 1),

-- Uzebox (system_id = 46)
(20107, 3, 46, 'Uzem', 0, 'uzem_libretro.so', 1, 1),

-- Arduboy (system_id = 47)
(20108, 3, 47, 'Arduous', 0, 'arduous_libretro.so', 1, 1),
(20109, 3, 47, 'Ardens', 0, 'ardens_libretro.so', 0, 1),

-- PC-8000/8800 (system_id = 48)
(20110, 3, 48, 'QUASI88', 0, 'quasi88_libretro.so', 1, 1),

-- WASM-4 (system_id = 49)
(20111, 3, 49, 'WASM-4', 0, 'wasm4_libretro.so', 1, 1),

-- Arcadia 2001 (system_id = 50)
(20112, 3, 50, 'MAME', 0, 'mame_libretro.so', 1, 0),

-- NAOMI (system_id = 100)
(20113, 3, 100, 'Flycast', 0, 'flycast_libretro.so', 1, 0),

-- NAOMI 2 (system_id = 101)
(20114, 3, 101, 'Flycast', 0, 'flycast_libretro.so', 1, 0),

-- NAOMI GD-ROM (system_id = 102)
(20115, 3, 102, 'Flycast', 0, 'flycast_libretro.so', 1, 0),

-- Atomiswave (system_id = 103)
(20116, 3, 103, 'Flycast', 0, 'flycast_libretro.so', 1, 0),

-- Nintendo 3DS (system_id = 51)
(20117, 3, 51, 'Citra', 0, 'citra_libretro.so', 1, 0),
(20118, 3, 51, 'Citra 2018', 0, 'citra2018_libretro.so', 0, 0),

-- Nintendo Wii (system_id = 52)
(20119, 3, 52, 'Dolphin', 0, 'dolphin_libretro.so', 1, 0),

-- Family Computer (system_id = 1000)
(21000, 3, 1000, 'FCEUmm', 0, 'fceumm_libretro.so', 1, 1),
(21001, 3, 1000, 'Mesen', 0, 'mesen_libretro.so', 0, 1),
(21002, 3, 1000, 'QuickNES', 0, 'quicknes_libretro.so', 0, 0),
(21003, 3, 1000, 'Nestopia', 0, 'nestopia_libretro.so', 0, 0),

-- Super Family Computer (system_id = 1001)
(21004, 3, 1001, 'Snes9x', 0, 'snes9x_libretro.so', 1, 1),
(21005, 3, 1001, 'Mesen-S', 0, 'mesen_s_libretro.so', 0, 1),
(21006, 3, 1001, 'Snes9x 2010', 0, 'snes9x2010_libretro.so', 0, 0),
(21007, 3, 1001, 'Snes9x 2005 Plus', 0, 'snes9x2005_plus_libretro.so', 0, 0),
(21008, 3, 1001, 'bsnes', 0, 'bsnes_libretro.so', 0, 0),
(21009, 3, 1001, 'bsnes HD', 0, 'bsnes_hd_beta_libretro.so', 0, 0),

-- Genesis (system_id = 1002)
(21010, 3, 1002, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.so', 1, 1),
(21011, 3, 1002, 'PicoDrive', 0, 'picodrive_libretro.so', 0, 1),
(21012, 3, 1002, 'BlastEm', 0, 'blastem_libretro.so', 0, 0),

-- Mark III (system_id = 1003)
(21013, 3, 1003, 'Genesis Plus GX', 0, 'genesis_plus_gx_libretro.so', 1, 1),
(21014, 3, 1003, 'Gearsystem', 0, 'gearsystem_libretro.so', 0, 1),
(21015, 3, 1003, 'SMS Plus GX', 0, 'smsplus_libretro.so', 0, 0),
(21016, 3, 1003, 'PicoDrive', 0, 'picodrive_libretro.so', 0, 0),

-- TurboGrafx-16 (system_id = 1004)
(21017, 3, 1004, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro.so', 1, 1),
(21018, 3, 1004, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro.so', 0, 1),
(21019, 3, 1004, 'Beetle PCE', 0, 'mednafen_pce_libretro.so', 0, 0),

-- TurboGrafx-CD (system_id = 1005)
(21020, 3, 1005, 'Mednafen SuperGrafx', 0, 'mednafen_supergrafx_libretro.so', 1, 1),
(21021, 3, 1005, 'Beetle PCE Fast', 0, 'mednafen_pce_fast_libretro.so', 0, 1),
(21022, 3, 1005, 'Beetle PCE', 0, 'mednafen_pce_libretro.so', 0, 0),

-- Final Burn Neo (system_id = 1006)
(21023, 3, 1006, 'FinalBurn Neo', 0, 'fbneo_libretro.so', 1, 1),

-- MAME (system_id = 1007)
(21024, 3, 1007, 'MAME', 0, 'mame_libretro.so', 1, 0),
(21025, 3, 1007, 'MAME 2010', 0, 'mame2010_libretro.so', 0, 0),
(21026, 3, 1007, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.so', 0, 0),
(21027, 3, 1007, 'MAME 2003', 0, 'mame2003_libretro.so', 0, 0),
(21028, 3, 1007, 'MAME 2000', 0, 'mame2000_libretro.so', 0, 0),

-- CPS1 (system_id = 1008)
(21029, 3, 1008, 'FinalBurn Neo', 0, 'fbneo_libretro.so', 1, 1),
(21030, 3, 1008, 'MAME', 0, 'mame_libretro.so', 0, 0),
(21031, 3, 1008, 'MAME 2010', 0, 'mame2010_libretro.so', 0, 0),
(21032, 3, 1008, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.so', 0, 0),
(21033, 3, 1008, 'MAME 2003', 0, 'mame2003_libretro.so', 0, 0),
(21034, 3, 1008, 'MAME 2000', 0, 'mame2000_libretro.so', 0, 0),
(21035, 3, 1008, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.so', 0, 0),
(21036, 3, 1008, 'Geolith', 0, 'geolith_libretro.so', 0, 0),
(21037, 3, 1008, 'Flycast', 0, 'flycast_libretro.so', 0, 1),
(21038, 3, 1008, 'Kronos', 0, 'kronos_libretro.so', 0, 0),
(21039, 3, 1008, 'DICE', 0, 'dice_libretro.so', 0, 0),

-- CPS2
(21040, 3, 1009, 'FinalBurn Neo', 0, 'fbneo_libretro.so', 1, 1),
(21041, 3, 1009, 'MAME', 0, 'mame_libretro.so', 0, 0),
(21042, 3, 1009, 'MAME 2010', 0, 'mame2010_libretro.so', 0, 0),
(21043, 3, 1009, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.so', 0, 0),
(21044, 3, 1009, 'MAME 2003', 0, 'mame2003_libretro.so', 0, 0),
(21045, 3, 1009, 'MAME 2000', 0, 'mame2000_libretro.so', 0, 0),
(21046, 3, 1009, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.so', 0, 0),
(21047, 3, 1009, 'Geolith', 0, 'geolith_libretro.so', 0, 0),
(21048, 3, 1009, 'Flycast', 0, 'flycast_libretro.so', 0, 1),
(21049, 3, 1009, 'Kronos', 0, 'kronos_libretro.so', 0, 0),
(21050, 3, 1009, 'DICE', 0, 'dice_libretro.so', 0, 0),

-- CPS3
(21051, 3, 1010, 'FinalBurn Neo', 0, 'fbneo_libretro.so', 1, 1),
(21052, 3, 1010, 'MAME', 0, 'mame_libretro.so', 0, 0),
(21053, 3, 1010, 'MAME 2010', 0, 'mame2010_libretro.so', 0, 0),
(21054, 3, 1010, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.so', 0, 0),
(21055, 3, 1010, 'MAME 2003', 0, 'mame2003_libretro.so', 0, 0),
(21056, 3, 1010, 'MAME 2000', 0, 'mame2000_libretro.so', 0, 0),
(21057, 3, 1010, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.so', 0, 0),
(21058, 3, 1010, 'Geolith', 0, 'geolith_libretro.so', 0, 0),
(21059, 3, 1010, 'Flycast', 0, 'flycast_libretro.so', 0, 1),
(21060, 3, 1010, 'Kronos', 0, 'kronos_libretro.so', 0, 0),
(21061, 3, 1010, 'DICE', 0, 'dice_libretro.so', 0, 0),

-- NEO GEO
(21062, 3, 1011, 'FinalBurn Neo', 0, 'fbneo_libretro.so', 1, 1),
(21063, 3, 1011, 'MAME', 0, 'mame_libretro.so', 0, 0),
(21064, 3, 1011, 'MAME 2010', 0, 'mame2010_libretro.so', 0, 0),
(21065, 3, 1011, 'MAME 2003-Plus', 0, 'mame2003_plus_libretro.so', 0, 0),
(21066, 3, 1011, 'MAME 2003', 0, 'mame2003_libretro.so', 0, 0),
(21067, 3, 1011, 'MAME 2000', 0, 'mame2000_libretro.so', 0, 0),
(21068, 3, 1011, 'FB Alpha 2012', 0, 'fbalpha2012_libretro.so', 0, 0),
(21069, 3, 1011, 'Geolith', 0, 'geolith_libretro.so', 0, 0),
(21070, 3, 1011, 'Flycast', 0, 'flycast_libretro.so', 0, 1),
(21071, 3, 1011, 'Kronos', 0, 'kronos_libretro.so', 0, 0),
(21072, 3, 1011, 'DICE', 0, 'dice_libretro.so', 0, 0);



INSERT INTO app_system_extensions (system_id, extension, is_primary) VALUES
-- NES .3dsen .3DSEN .fds .FDS .nes .NES .unf .UNF .unif .UNIF .7z .7Z .zip .ZIP
(1, '.nes', 1),
(1, '.NES', 0),
(1, '.unf', 0),
(1, '.UNF', 0),
(1, '.unif', 0),
(1, '.UNIF', 0),
(1, '.fds', 0),
(1, '.FDS', 0),
(1, '.3dsen', 0),
(1, '.3DSEN', 0),
(1, '.7z', 0),
(1, '.7Z', 0),
(1, '.zip', 0),
(1, '.ZIP', 0),
-- SNES .bin .BIN .bml .BML .bs .BS .bsx .BSX .dx2 .DX2 .fig .FIG .gd3 .GD3 .gd7 .GD7 .mgd .MGD .sfc .SFC .smc .SMC .st .ST .swc .SWC .7z .7Z .zip .ZIP
(2, '.sfc', 1),
(2, '.SFC', 0),
(2, '.smc', 0),
(2, '.SMC', 0),
(2, '.bs', 0),
(2, '.BS', 0),
(2, '.bsx', 0),
(2, '.BSX', 0),
(2, '.dx2', 0),
(2, '.DX2', 0),
(2, '.fig', 0),
(2, '.FIG', 0),
(2, '.gd3', 0),
(2, '.GD3', 0),
(2, '.gd7', 0),
(2, '.GD7', 0),
(2, '.mgd', 0),
(2, '.MGD', 0),
(2, '.bml', 0),
(2, '.BML', 0),
(2, '.st', 0),
(2, '.ST', 0),
(2, '.swc', 0),
(2, '.SWC', 0),
(2, '.7z', 0),
(2, '.7Z', 0),
(2, '.zip', 0),
(2, '.ZIP', 0),
-- GB .bs .BS .cgb .CGB .dmg .DMG .gb .GB .gbc .GBC .sgb .SGB .sfc .SFC .smc .SMC .7z .7Z .zip .ZIP
(3, '.gb', 1),
(3, '.GB', 0),
(3, '.gbc', 0),
(3, '.GBC', 0),
(3, '.dmg', 0),
(3, '.DMG', 0),
(3, '.cgb', 0),
(3, '.CGB', 0),
(3, '.sgb', 0),
(3, '.SGB', 0),
(3, '.sfc', 0),
(3, '.SFC', 0),
(3, '.smc', 0),
(3, '.SMC', 0),
(3, '.bs', 0),
(3, '.BS', 0),
(3, '.7z', 0),
(3, '.7Z', 0),
(3, '.zip', 0),
(3, '.ZIP', 0),
-- GBC .bs .BS .cgb .CGB .dmg .DMG .gb .GB .gbc .GBC .sgb .SGB .sfc .SFC .smc .SMC .7z .7Z .zip .ZIP
(4, '.gbc', 1),
(4, '.GBC', 0),
(4, '.gb', 0),
(4, '.GB', 0),
(4, '.dmg', 0),
(4, '.DMG', 0),
(4, '.cgb', 0),
(4, '.CGB', 0),
(4, '.sgb', 0),
(4, '.SGB', 0),
(4, '.sfc', 0),
(4, '.SFC', 0),
(4, '.smc', 0),
(4, '.SMC', 0),
(4, '.bs', 0),
(4, '.BS', 0),
(4, '.7z', 0),
(4, '.7Z', 0),
(4, '.zip', 0),
(4, '.ZIP', 0),
-- GBA .agb .AGB .bin .BIN .cgb .CGB .dmg .DMG .gb .GB .gba .GBA .gbc .GBC .sgb .SGB .7z .7Z .zip .ZIP
(5, '.gba', 1),
(5, '.GBA', 0),
(5, '.agb', 0),
(5, '.AGB', 0),
(5, '.gb', 0),
(5, '.GB', 0),
(5, '.gbc', 0),
(5, '.GBC', 0),
(5, '.dmg', 0),
(5, '.DMG', 0),
(5, '.cgb', 0),
(5, '.CGB', 0),
(5, '.sgb', 0),
(5, '.SGB', 0),
(5, '.bin', 0),
(5, '.BIN', 0),
(5, '.7z', 0),
(5, '.7Z', 0),
(5, '.zip', 0),
(5, '.ZIP', 0),
-- N64 .bin .BIN .d64 .D64 .n64 .N64 .ndd .NDD .u1 .U1 .v64 .V64 .z64 .Z64 .7z .7Z .zip .ZIP
(6, '.n64', 1),
(6, '.N64', 0),
(6, '.z64', 0),
(6, '.Z64', 0),
(6, '.v64', 0),
(6, '.V64', 0),
(6, '.u1', 0),
(6, '.U1', 0),
(6, '.d64', 0),
(6, '.D64', 0),
(6, '.bin', 0),
(6, '.BIN', 0),
(6, '.7z', 0),
(6, '.7Z', 0),
(6, '.zip', 0),
(6, '.ZIP', 0),
-- NDS .app .APP .bin .BIN .nds .NDS .7z .7Z .zip .ZIP
(7, '.nds', 1),
(7, '.NDS', 0),
(7, '.bin', 0),
(7, '.BIN', 0),
(7, '.app', 0),
(7, '.APP', 0),
(7, '.7z', 0),
(7, '.7Z', 0),
(7, '.zip', 0),
(7, '.ZIP', 0),
-- GC .ciso .CISO .dff .DFF .dol .DOL .elf .ELF .gcm .GCM .gcz .GCZ .iso .ISO .json .JSON .m3u .M3U .rvz .RVZ .tgc .TGC .wad .WAD .wbfs .WBFS .wia .WIA .7z .7Z .zip .ZIP
(8, '.iso', 1),
(8, '.ISO', 0),
(8, '.gcm', 0),
(8, '.GCM', 0),
(8, '.wbfs', 0),
(8, '.WBFS', 0),
(8, '.dol', 0),
(8, '.DOL', 0),
(8, '.elf', 0),
(8, '.ELF', 0),
(8, '.ciso', 0),
(8, '.CISO', 0),
(8, '.dff', 0),
(8, '.DFF', 0),
(8, '.gcz', 0),
(8, '.GCZ', 0),
(8, '.json', 0),
(8, '.JSON', 0),
(8, '.m3u', 0),
(8, '.M3U', 0),
(8, '.rvz', 0),
(8, '.RVZ', 0),
(8, '.tgc', 0),
(8, '.TGC', 0),
(8, '.wad', 0),
(8, '.WAD', 0),
(8, '.wia', 0),
(8, '.WIA', 0),
(8, '.7z', 0),
(8, '.7Z', 0),
(8, '.zip', 0),
(8, '.ZIP', 0),
-- Pokemon Mini .min .MIN .7z .7Z .zip .ZIP
(9, '.min', 1),
(9, '.MIN', 0),
(9, '.7z', 0),
(9, '.7Z', 0),
(9, '.zip', 0),
(9, '.ZIP', 0),
-- Virtual Boy .bin .BIN .vb .VB .vboy .VBOY .7z .7Z .zip .ZIP
(10, '.vb', 1),
(10, '.VB', 0),
(10, '.vboy', 0),
(10, '.VBOY', 0),
(10, '.bin', 0),
(10, '.BIN', 0),
(10, '.7z', 0),
(10, '.7Z', 0),
(10, '.zip', 0),
(10, '.ZIP', 0),
-- Nintendo DSi .nds .NDS .dsi .DSI .7z .7Z .zip .ZIP
(11, '.dsi', 1),
(11, '.DSI', 0),
(11, '.nds', 0),
(11, '.NDS', 0),
(11, '.7z', 0),
(11, '.7Z', 0),
(11, '.zip', 0),
(11, '.ZIP', 0),
-- Mega Drive .32x .32X .68k .68K .bin .BIN .bms .BMS .chd .CHD .cue .CUE .gen .GEN .gg .GG .iso .ISO .m3u .M3U .md .MD .mdx .MDX .sg .SG .sgd .SGD .smd .SMD .sms .SMS .7z .7Z .zip .ZIP
(12, '.md', 1),
(12, '.MD', 0),
(12, '.gen', 0),
(12, '.GEN', 0),
(12, '.smd', 0),
(12, '.SMD', 0),
(12, '.sms', 0),
(12, '.SMS', 0),
(12, '.gg', 0),
(12, '.GG', 0),
(12, '.32x', 0),
(12, '.32X', 0),
(12, '.68k', 0),
(12, '.68K', 0),
(12, '.bin', 0),
(12, '.BIN', 0),
(12, '.bms', 0),
(12, '.BMS', 0),
(12, '.chd', 0),
(12, '.CHD', 0),
(12, '.cue', 0),
(12, '.CUE', 0),
(12, '.iso', 0),
(12, '.ISO', 0),
(12, '.m3u', 0),
(12, '.M3U', 0),
(12, '.mdx', 0),
(12, '.MDX', 0),
(12, '.sg', 0),
(12, '.SG', 0),
(12, '.sgd', 0),
(12, '.SGD', 0),
(12, '.7z', 0),
(12, '.7Z', 0),
(12, '.zip', 0),
(12, '.ZIP', 0),
-- Master System .68k .68K .bin .BIN .bms .BMS .chd .CHD .col .COL .cue .CUE .gen .GEN .gg .GG .iso .ISO .m3u .M3U .md .MD .mdx .MDX .rom .ROM .sg .SG .sgd .SGD .smd .SMD .sms .SMS .7z .7Z .zip .ZIP
(13, '.sms', 1),
(13, '.SMS', 0),
(13, '.md', 0),
(13, '.MD', 0),
(13, '.gen', 0),
(13, '.GEN', 0),
(13, '.smd', 0),
(13, '.SMD', 0),
(13, '.gg', 0),
(13, '.GG', 0),
(13, '.68k', 0),
(13, '.68K', 0),
(13, '.bin', 0),
(13, '.BIN', 0),
(13, '.bms', 0),
(13, '.BMS', 0),
(13, '.chd', 0),
(13, '.CHD', 0),
(13, '.cue', 0),
(13, '.CUE', 0),
(13, '.col', 0),
(13, '.COL', 0),
(13, '.iso', 0),
(13, '.ISO', 0),
(13, '.m3u', 0),
(13, '.M3U', 0),
(13, '.mdx', 0),
(13, '.MDX', 0),
(13, '.rom', 0),
(13, '.ROM', 0),
(13, '.sg', 0),
(13, '.SG', 0),
(13, '.sgd', 0),
(13, '.SGD', 0),
(13, '.7z', 0),
(13, '.7Z', 0),
(13, '.zip', 0),
(13, '.ZIP', 0),
-- Game Gear .68k .68K .bin .BIN .bms .BMS .chd .CHD .col .COL .cue .CUE .gen .GEN .gg .GG .iso .ISO .m3u .M3U .md .MD .mdx .MDX .rom .ROM .sg .SG .sgd .SGD .smd .SMD .sms .SMS .7z .7Z .zip .ZIP
(14, '.gg', 1),
(14, '.GG', 0),
(14, '.md', 0),
(14, '.MD', 0),
(14, '.gen', 0),
(14, '.GEN', 0),
(14, '.smd', 0),
(14, '.SMD', 0),
(14, '.68k', 0),
(14, '.68K', 0),
(14, '.bin', 0),
(14, '.BIN', 0),
(14, '.bms', 0),
(14, '.BMS', 0),
(14, '.chd', 0),
(14, '.CHD', 0),
(14, '.cue', 0),
(14, '.CUE', 0),
(14, '.col', 0),
(14, '.COL', 0),
(14, '.iso', 0),
(14, '.ISO', 0),
(14, '.m3u', 0),
(14, '.M3U', 0),
(14, '.mdx', 0),
(14, '.MDX', 0),
(14, '.rom', 0),
(14, '.ROM', 0),
(14, '.sg', 0),
(14, '.SG', 0),
(14, '.sgd', 0),
(14, '.SGD', 0),
(14, '.7z', 0),
(14, '.7Z', 0),
(14, '.zip', 0),
(14, '.ZIP', 0),
-- Sega CD .68k .68K .bin .BIN .bms .BMS .chd .CHD .cue .CUE .gen .GEN .gg .GG .iso .ISO .m3u .M3U .md .MD .mdx .MDX .sg .SG .sgd .SGD .smd .SMD .sms .SMS .7z .7Z .zip .ZIP
(15, '.iso', 1),
(15, '.ISO', 0),
(15, '.md', 0),
(15, '.MD', 0),
(15, '.gen', 0),
(15, '.GEN', 0),
(15, '.smd', 0),
(15, '.SMD', 0),
(15, '.sms', 0),
(15, '.SMS', 0),
(15, '.gg', 0),
(15, '.GG', 0),
(15, '.68k', 0),
(15, '.68K', 0),
(15, '.bin', 0),
(15, '.BIN', 0),
(15, '.bms', 0),
(15, '.BMS', 0),
(15, '.chd', 0),
(15, '.CHD', 0),
(15, '.cue', 0),
(15, '.CUE', 0),
(15, '.m3u', 0),
(15, '.M3U', 0),
(15, '.mdx', 0),
(15, '.MDX', 0),
(15, '.sg', 0),
(15, '.SG', 0),
(15, '.sgd', 0),
(15, '.SGD', 0),
(15, '.7z', 0),
(15, '.7Z', 0),
(15, '.zip', 0),
(15, '.ZIP', 0),
-- Saturn .bin .BIN .ccd .CCD .chd .CHD .cue .CUE .iso .ISO .m3u .M3U .mds .MDS .toc .TOC .7z .7Z .zip .ZIP
(17, '.iso', 1),
(17, '.ISO', 0),
(17, '.bin', 0),
(17, '.BIN', 0),
(17, '.ccd', 0),
(17, '.CCD', 0),
(17, '.chd', 0),
(17, '.CHD', 0),
(17, '.cue', 0),
(17, '.CUE', 0),
(17, '.m3u', 0),
(17, '.M3U', 0),
(17, '.mds', 0),
(17, '.MDS', 0),
(17, '.toc', 0),
(17, '.TOC', 0),
(17, '.7z', 0),
(17, '.7Z', 0),
(17, '.zip', 0),
(17, '.ZIP', 0),
-- Dreamcast .cdi .CDI .chd .CHD .cue .CUE .dat .DAT .elf .ELF .gdi .GDI .iso .ISO .lst .LST .m3u .M3U .7z .7Z .zip .ZIP
(18, '.iso', 1),
(18, '.ISO', 0),
(18, '.gdi', 0),
(18, '.GDI', 0),
(18, '.cdi', 0),
(18, '.CDI', 0),
(18, '.chd', 0),
(18, '.CHD', 0),
(18, '.cue', 0),
(18, '.CUE', 0),
(18, '.dat', 0),
(18, '.DAT', 0),
(18, '.elf', 0),
(18, '.ELF', 0),
(18, '.lst', 0),
(18, '.LST', 0),
(18, '.m3u', 0),
(18, '.M3U', 0),
(18, '.7z', 0),
(18, '.7Z', 0),
(18, '.zip', 0),
(18, '.ZIP', 0),
-- SG-1000 .68k .68K .bin .BIN .bms .BMS .chd .CHD .cue .CUE .gen .GEN .gg .GG .iso .ISO .m3u .M3U .md .MD .mdx .MDX .ri .RI .rom .ROM .sg .SG .sgd .SGD .smd .SMD .sms .SMS .7z .7Z .zip .ZIP
(19, '.sms', 1),
(19, '.SMS', 0),
(19, '.md', 0),
(19, '.MD', 0),
(19, '.gen', 0),
(19, '.GEN', 0),
(19, '.smd', 0),
(19, '.SMD', 0),
(19, '.gg', 0),
(19, '.GG', 0),
(19, '.68k', 0),
(19, '.68K', 0),
(19, '.bin', 0),
(19, '.BIN', 0),
(19, '.bms', 0),
(19, '.BMS', 0),
(19, '.chd', 0),
(19, '.CHD', 0),
(19, '.cue', 0),
(19, '.CUE', 0),
(19, '.iso', 0),
(19, '.ISO', 0),
(19, '.m3u', 0),
(19, '.M3U', 0),
(19, '.mdx', 0),
(19, '.MDX', 0),
(19, '.ri', 0),
(19, '.RI', 0),
(19, '.rom', 0),
(19, '.ROM', 0),
(19, '.sg', 0),
(19, '.SG', 0),
(19, '.sgd', 0),
(19, '.SGD', 0),
(19, '.7z', 0),
(19, '.7Z', 0),
(19, '.zip', 0),
(19, '.ZIP', 0),
-- PlayStation .bin .BIN .cbn .CBN .ccd .CCD .chd .CHD .cue .CUE .ecm .ECM .exe .EXE .img .IMG .iso .ISO .m3u .M3U .mdf .MDF .mds .MDS .minipsf .MINIPSF .pbp .PBP .psexe .PSEXE .psf .PSF .toc .TOC .z .Z .znx .ZNX .7z .7Z .zip .ZIP
(20, '.iso', 1),
(20, '.ISO', 0),
(20, '.bin', 0),
(20, '.BIN', 0),
(20, '.cue', 0),
(20, '.CUE', 0),
(20, '.chd', 0),
(20, '.CHD', 0),
(20, '.ccd', 0),
(20, '.CCD', 0),
(20, '.ecm', 0),
(20, '.ECM', 0),
(20, '.exe', 0),
(20, '.EXE', 0),
(20, '.img', 0),
(20, '.IMG', 0),
(20, '.mdf', 0),
(20, '.MDF', 0),
(20, '.mds', 0),
(20, '.MDS', 0),
(20, '.pbp', 0),
(20, '.PBP', 0),
(20, '.psexe', 0),
(20, '.PSEXE', 0),
(20, '.psf', 0),
(20, '.PSF', 0),
(20, '.minipsf', 0),
(20, '.MINIPSF', 0),
(20, '.toc', 0),
(20, '.TOC', 0),
(20, '.z', 0),
(20, '.Z', 0),
(20, '.znx', 0),
(20, '.ZNX', 0),
(20, '.7z', 0),
(20, '.7Z', 0),
(20, '.zip', 0),
(20, '.ZIP', 0),
-- PlayStation 2 .bin .BIN .chd .CHD .ciso .CISO .cso .CSO .dump .DUMP .elf .ELF .gz .GZ .m3u .M3U .mdf .MDF .img .IMG .iso .ISO .isz .ISZ .ngr .NRG .zso .ZSO
(21, '.iso', 1),
(21, '.ISO', 0),
(21, '.bin', 0),
(21, '.BIN', 0),
(21, '.chd', 0),
(21, '.CHD', 0),
(21, '.ciso', 0),
(21, '.CISO', 0),
(21, '.cso', 0),
(21, '.CSO', 0),
(21, '.dump', 0),
(21, '.DUMP', 0),
(21, '.elf', 0),
(21, '.ELF', 0),
(21, '.gz', 0),
(21, '.GZ', 0),
(21, '.m3u', 0),
(21, '.M3U', 0),
(21, '.mdf', 0),
(21, '.MDF', 0),
(21, '.img', 0),
(21, '.IMG', 0),
(21, '.isz', 0),
(21, '.ISZ', 0),
(21, '.ngr', 0),
(21, '.NRG', 0),
(21, '.zso', 0),
(21, '.ZSO', 0),
-- PSP .chd .CHD .cso .CSO .elf .ELF .iso .ISO .pbp .PBP .prx .PRX .7z .7Z .zip .ZIP
(22, '.iso', 1),
(22, '.ISO', 0),
(22, '.pbp', 0),
(22, '.PBP', 0),
(22, '.cso', 0),
(22, '.CSO', 0),
(22, '.chd', 0),
(22, '.CHD', 0),
(22, '.elf', 0),
(22, '.ELF', 0),
(22, '.prx', 0),
(22, '.PRX', 0),
(22, '.7z', 0),
(22, '.7Z', 0),
(22, '.zip', 0),
(22, '.ZIP', 0),
-- Atari 2600 .a26 .A26 .bin .BIN .7z .7Z .zip .ZIP
(23, '.a26', 1),
(23, '.A26', 0),
(23, '.bin', 0),
(23, '.BIN', 0),
(23, '.7z', 0),
(23, '.7Z', 0),
(23, '.zip', 0),
(23, '.ZIP', 0),
-- Atari 7800 .a78 .A78 .bin .BIN .7z .7Z .zip .ZIP
(24, '.a78', 1),
(24, '.A78', 0),
(24, '.bin', 0),
(24, '.BIN', 0),
(24, '.7z', 0),
(24, '.7Z', 0),
(24, '.zip', 0),
(24, '.ZIP', 0),
-- Atari Lynx .lnx .LNX .o .O .7z .7Z .zip .ZIP
(25, '.lnx', 1),
(25, '.LNX', 0),
(25, '.o', 0),
(25, '.O', 0),
(25, '.7z', 0),
(25, '.7Z', 0),
(25, '.zip', 0),
(25, '.ZIP', 0),
-- Atari Jaguar .abs .ABS .bin .BIN .cdi .CDI .cof .COF .cue .CUE .j64 .J64 .jag .JAG .prg .PRG .rom .ROM .7z .7Z .zip .ZIP
(26, '.jag', 1),
(26, '.JAG', 0),
(26, '.j64', 0),
(26, '.J64', 0),
(26, '.bin', 0),
(26, '.BIN', 0),
(26, '.cdi', 0),
(26, '.CDI', 0),
(26, '.cue', 0),
(26, '.CUE', 0),
(26, '.cof', 0),
(26, '.COF', 0),
(26, '.abs', 0),
(26, '.ABS', 0),
(26, '.prg', 0),
(26, '.PRG', 0),
(26, '.rom', 0),
(26, '.ROM', 0),
(26, '.7z', 0),
(26, '.7Z', 0),
(26, '.zip', 0),
(26, '.ZIP', 0),
-- Atari Jaguar CD .abs .ABS .bin .BIN .cdi .CDI .cof .COF .cue .CUE .j64 .J64 .jag .JAG .prg .PRG .rom .ROM .7z .7Z .zip .ZIP
(27, '.cdi', 1),
(27, '.CDI', 0),
(27, '.jag', 0),
(27, '.JAG', 0),
(27, '.j64', 0),
(27, '.J64', 0),
(27, '.bin', 0),
(27, '.BIN', 0),
(27, '.cue', 0),
(27, '.CUE', 0),
(27, '.cof', 0),
(27, '.COF', 0),
(27, '.abs', 0),
(27, '.ABS', 0),
(27, '.prg', 0),
(27, '.PRG', 0),
(27, '.rom', 0),
(27, '.ROM', 0),
(27, '.7z', 0),
(27, '.7Z', 0),
(27, '.zip', 0),
(27, '.ZIP', 0),
-- PC Engine .ccd .CCD .chd .CHD .cue .CUE .img .IMG .iso .ISO .m3u .M3U .pce .PCE .rom .ROM .sgx .SGX .toc .TOC .7z .7Z .zip .ZIP
(28, '.pce', 1),
(28, '.PCE', 0),
(28, '.sgx', 0),
(28, '.SGX', 0),
(28, '.rom', 0),
(28, '.ROM', 0),
(28, '.iso', 0),
(28, '.ISO', 0),
(28, '.img', 0),
(28, '.IMG', 0),
(28, '.ccd', 0),
(28, '.CCD', 0),
(28, '.chd', 0),
(28, '.CHD', 0),
(28, '.cue', 0),
(28, '.CUE', 0),
(28, '.m3u', 0),
(28, '.M3U', 0),
(28, '.toc', 0),
(28, '.TOC', 0),
(28, '.7z', 0),
(28, '.7Z', 0),
(28, '.zip', 0),
(28, '.ZIP', 0),
-- PC Engine CD .ccd .CCD .chd .CHD .cue .CUE .img .IMG .iso .ISO .m3u .M3U .pce .PCE .sgx .SGX .toc .TOC .7z .7Z .zip .ZIP
(29, '.iso', 1),
(29, '.ISO', 0),
(29, '.img', 0),
(29, '.IMG', 0),
(29, '.ccd', 0),
(29, '.CCD', 0),
(29, '.chd', 0),
(29, '.CHD', 0),
(29, '.cue', 0),
(29, '.CUE', 0),
(29, '.m3u', 0),
(29, '.M3U', 0),
(29, '.pce', 0),
(29, '.PCE', 0),
(29, '.sgx', 0),
(29, '.SGX', 0),
(29, '.toc', 0),
(29, '.TOC', 0),
(29, '.7z', 0),
(29, '.7Z', 0),
(29, '.zip', 0),
(29, '.ZIP', 0),
-- PC-FX .ccd .CCD .chd .CHD .cue CUE .m3u .M3U .toc .TOC .7z .7Z .zip .ZIP
(30, '.chd', 1),
(30, '.CHD', 0),
(30, '.ccd', 0),
(30, '.CCD', 0),
(30, '.cue', 0),
(30, '.CUE', 0),
(30, '.m3u', 0),
(30, '.M3U', 0),
(30, '.toc', 0),
(30, '.TOC', 0),
(30, '.7z', 0),
(30, '.7Z', 0),
(30, '.zip', 0),
(30, '.ZIP', 0),
-- Neo Geo Pocket Color .ngc .NGC .ngp .NGP .ngpc .NGPC .npc .NPC .7z .7Z .zip .ZIP
(31, '.ngpc', 1),
(31, '.NGPC', 0),
(31, '.ngc', 0),
(31, '.NGC', 0),
(31, '.ngp', 0),
(31, '.NGP', 0),
(31, '.npc', 0),
(31, '.NPC', 0),
(31, '.7z', 0),
(31, '.7Z', 0),
(31, '.zip', 0),
(31, '.ZIP', 0),
-- Neo Geo CD .chd .CHD .cue .CUE
(32, '.chd', 1),
(32, '.CHD', 0),
(32, '.cue', 0),
(32, '.CUE', 0),
-- Wonderswan Color .pc2 .PC2 .ws .WS .wsc .WSC .7z .7Z .zip .ZIP
(33, '.wsc', 1),
(33, '.WSC', 0),
(33, '.ws', 0),
(33, '.WS', 0),
(33, '.pc2', 0),
(33, '.PC2', 0),
(33, '.7z', 0),
(33, '.7Z', 0),
(33, '.zip', 0),
(33, '.ZIP', 0),
-- Watara Supervision .bin .BIN .sv .SV .7z .7Z .zip .ZIP
(34, '.sv', 1),
(34, '.SV', 0),
(34, '.bin', 0),
(34, '.BIN', 0),
(34, '.7z', 0),
(34, '.7Z', 0),
(34, '.zip', 0),
(34, '.ZIP', 0),
-- Magnavox Odyssey2 .bin .BIN .7z .7Z .zip .ZIP
(35, '.bin', 1),
(35, '.BIN', 0),
(35, '.7z', 0),
(35, '.7Z', 0),
(35, '.zip', 0),
(35, '.ZIP', 0),
-- ColecoVision .bin .BIN .cas .CAS .col .COL .cv .CV .dsk .DSK .m3u .M3U .mx1 .MX1 .mx2 .MX2 .ri .RI .rom .ROM .sc .SC .sg .SG .7z .7Z .zip .ZIP
(36, '.rom', 1),
(36, '.ROM', 0),
(36, '.bin', 0),
(36, '.BIN', 0),
(36, '.cas', 0),
(36, '.CAS', 0),
(36, '.col', 0),
(36, '.COL', 0),
(36, '.cv', 0),
(36, '.CV', 0),
(36, '.dsk', 0),
(36, '.DSK', 0),
(36, '.m3u', 0),
(36, '.M3U', 0),
(36, '.mx1', 0),
(36, '.MX1', 0),
(36, '.mx2', 0),
(36, '.MX2', 0),
(36, '.ri', 0),
(36, '.RI', 0),
(36, '.sc', 0),
(36, '.SC', 0),
(36, '.sg', 0),
(36, '.SG', 0),
(36, '.7z', 0),
(36, '.7Z', 0),
(36, '.zip', 0),
(36, '.ZIP', 0),
--Intellivision .bin .BIN .int .INT .rom .ROM .7z .7Z .zip .ZIP
(37, '.int', 1),
(37, '.INT', 0),
(37, '.bin', 0),
(37, '.BIN', 0),
(37, '.rom', 0),
(37, '.ROM', 0),
(37, '.7z', 0),
(37, '.7Z', 0),
(37, '.zip', 0),
(37, '.ZIP', 0),
-- Vectrex .bin .BIN .gam .GAM .vc .VC .vec .VEC .7z .7Z .zip .ZIP
(38, '.vec', 1),
(38, '.VEC', 0),
(38, '.vc', 0),
(38, '.VC', 0),
(38, '.bin', 0),
(38, '.BIN', 0),
(38, '.gam', 0),
(38, '.GAM', 0),
(38, '.7z', 0),
(38, '.7Z', 0),
(38, '.zip', 0),
(38, '.ZIP', 0),
-- Mega Duck .bin .BIN .7z .7Z .zip .ZIP
(39, '.bin', 1),
(39, '.BIN', 0),
(39, '.7z', 0),
(39, '.7Z', 0),
(39, '.zip', 0),
(39, '.ZIP', 0),
-- Arcade .bat .BAT .cmd .CMD .gam .GAM .lnk .LNK .neo .NEO .7z .7Z .zip .ZIP
(40, '.zip', 1),
(40, '.NEO', 0),
(40, '.bat', 0),
(40, '.BAT', 0),
(40, '.cmd', 0),
(40, '.CMD', 0),
(40, '.gam', 0),
(40, '.GAM', 0),
(40, '.lnk', 0),
(40, '.LNK', 0),
(40, '.7z', 0),
(40, '.7Z', 0),
(40, '.neo', 0),
(40, '.ZIP', 0),
-- 3DO .bin .BIN .chd .CHD .cue .CUE .iso .ISO .7z .7Z .zip .ZIP
(41, '.iso', 1),
(41, '.ISO', 0),
(41, '.bin', 0),
(41, '.BIN', 0),
(41, '.chd', 0),
(41, '.CHD', 0),
(41, '.cue', 0),
(41, '.CUE', 0),
(41, '.7z', 0),
(41, '.7Z', 0),
(41, '.zip', 0),
(41, '.ZIP', 0),
-- MSX .cas .CAS .col .COL .di1 .DI1 .di2 .DI2 .dmk .DMK .dsk .DSK .fd1 .FD1 .fd2 .FD2 .m3u .M3U .mx1 .MX1 .mx2 .MX2 .ogv .OGV .ri .RI .rom .ROM .sc .SC .sg .SG .wav .WAV .xsa .XSA .7z .7Z .zip .ZIP
(42, '.rom', 1),
(42, '.ROM', 0),
(42, '.cas', 0),
(42, '.CAS', 0),
(42, '.col', 0),
(42, '.COL', 0),
(42, '.di1', 0),
(42, '.DI1', 0),
(42, '.di2', 0),
(42, '.DI2', 0),
(42, '.dmk', 0),
(42, '.DMK', 0),
(42, '.dsk', 0),
(42, '.DSK', 0),
(42, '.fd1', 0),
(42, '.FD1', 0),
(42, '.fd2', 0),
(42, '.FD2', 0),
(42, '.m3u', 0),
(42, '.M3U', 0),
(42, '.mx1', 0),
(42, '.MX1', 0),
(42, '.mx2', 0),
(42, '.MX2', 0),
(42, '.ogv', 0),
(42, '.OGV', 0),
(42, '.ri', 0),
(42, '.RI', 0),
(42, '.sc', 0),
(42, '.SC', 0),
(42, '.sg', 0),
(42, '.SG', 0),
(42, '.wav', 0),
(42, '.WAV', 0),
(42, '.xsa', 0),
(42, '.XSA', 0),
(42, '.7z', 0),
(42, '.7Z', 0),
(42, '.zip', 0),
(42, '.ZIP', 0),
-- Fairchild Channel F .bin .BIN .7z .7Z .zip .ZIP
(43, '.bin', 1),
(43, '.BIN', 0),
(43, '.7z', 0),
(43, '.7Z', 0),
(43, '.zip', 0),
(43, '.ZIP', 0),
-- Amstrad CPC .cdt .CDT .cpr .CPR .dsk .DSK .kcr .KCR .m3u .M3U .sna .SNA .tap .TAR .voc .VOC .7z .7Z .zip .ZIP
(44, '.dsk', 1),
(44, '.DSK', 0),
(44, '.cdt', 0),
(44, '.CDT', 0),
(44, '.cpr', 0),
(44, '.CPR', 0),
(44, '.kcr', 0),
(44, '.KCR', 0),
(44, '.m3u', 0),
(44, '.M3U', 0),
(44, '.sna', 0),
(44, '.SNA', 0),
(44, '.tap', 0),
(44, '.TAP', 0),
(44, '.voc', 0),
(44, '.VOC', 0),
(44, '.7z', 0),
(44, '.7Z', 0),
(44, '.zip', 0),
(44, '.ZIP', 0),
-- Apple II .do .DO .dsk .DSK .nib .NIB .po .PO
(45, '.dsk', 1),
(45, '.DSK', 0),
(45, '.do', 0),
(45, '.DO', 0),
(45, '.nib', 0),
(45, '.NIB', 0),
(45, '.po', 0),
(45, '.PO', 0),
-- Uzebox .uze .UZE .7z .7Z .zip .ZIP
(46, '.uze', 1),
(46, '.UZE', 0),
(46, '.7z', 0),
(46, '.7Z', 0),
(46, '.zip', 0),
(46, '.ZIP', 0),
-- Arduboy .arduboy .ARDUBOY .hex .HEX .7z .7Z .zip .ZIP
(47, '.arduboy', 1),
(47, '.ARDUBOY', 0),
(47, '.hex', 0),
(47, '.HEX', 0),
(47, '.7z', 0),
(47, '.7Z', 0),
(47, '.zip', 0),
(47, '.ZIP', 0),
-- PC8000/PC8800 .88d .88D .cmt .CMT .d88 .D88 .m3u .M3U .t88 .T88 .u88 .U88
(48, '.d88', 1),
(48, '.D88', 0),
(48, '.88d', 0),
(48, '.88D', 0),
(48, '.cmt', 0),
(48, '.CMT', 0),
(48, '.m3u', 0),
(48, '.M3U', 0),
(48, '.t88', 0),
(48, '.T88', 0),
(48, '.u88', 0),
(48, '.U88', 0),
-- WASM .wasm .WASM
(49, '.wasm', 1),
(49, '.WASM', 0),
-- Arcadia 2001 .bin .BIN .7z .7Z .zip .ZIP
(50, '.bin', 1),
(50, '.BIN', 0),
(50, '.7z', 0),
(50, '.7Z', 0),
(50, '.zip', 0),
(50, '.ZIP', 0),
-- Naomi .bin .BIN .dat .DAT .elf .ELF .lst .LST .7z .7Z .zip .ZIP
(100, '.bin', 1),
(100, '.BIN', 0),
(100, '.dat', 0),
(100, '.DAT', 0),
(100, '.elf', 0),
(100, '.ELF', 0),
(100, '.lst', 0),
(100, '.LST', 0),
(100, '.7z', 0),
(100, '.7Z', 0),
(100, '.zip', 0),
(100, '.ZIP', 0),
-- Naomi 2 .bin .BIN .dat .DAT .elf .ELF .lst .LST .7z .7Z .zip .ZIP
(101, '.bin', 1),
(101, '.BIN', 0),
(101, '.dat', 0),
(101, '.DAT', 0),
(101, '.elf', 0),
(101, '.ELF', 0),
(101, '.lst', 0),
(101, '.LST', 0),
(101, '.7z', 0),
(101, '.7Z', 0),
(101, '.zip', 0),
(101, '.ZIP', 0),
-- Naomi GD .bin .BIN .dat .DAT .elf .ELF .lst .LST .7z .7Z .zip .ZIP
(102, '.bin', 1),
(102, '.BIN', 0),
(102, '.dat', 0),
(102, '.DAT', 0),
(102, '.elf', 0),
(102, '.ELF', 0),
(102, '.lst', 0),
(102, '.LST', 0),
(102, '.7z', 0),
(102, '.7Z', 0),
(102, '.zip', 0),
(102, '.ZIP', 0),
-- Atomiswave .bin .BIN .dat .DAT .elf .ELF .lst .LST .7z .7Z .zip .ZIP
(103, '.bin', 1),
(103, '.BIN', 0),
(103, '.dat', 0),
(103, '.DAT', 0),
(103, '.elf', 0),
(103, '.ELF', 0),
(103, '.lst', 0),
(103, '.LST', 0),
(103, '.7z', 0),
(103, '.7Z', 0),
(103, '.zip', 0),
(103, '.ZIP', 0),
-- Nintendo 3DS .3ds .3DS .3dsx .3DSX .app .APP .axf .AXF .cci .CCI .cxi .CXI .elf .ELF .7z .7Z .zip .ZIP
(51, '.3ds', 1),
(51, '.3DS', 0),
(51, '.3dsx', 0),
(51, '.3DSX', 0),
(51, '.app', 0),
(51, '.APP', 0),
(51, '.axf', 0),
(51, '.AXF', 0),
(51, '.cci', 0),
(51, '.CCI', 0),
(51, '.cxi', 0),
(51, '.CXI', 0),
(51, '.elf', 0),
(51, '.ELF', 0),
(51, '.7z', 0),
(51, '.7Z', 0),
(51, '.zip', 0),
(51, '.ZIP', 0),
-- Nintendo Wii .ciso .CISO .dff .DFF .dol .DOL .elf .ELF .gcm .GCM .gcz .GCZ .iso .ISO .json .JSON .m3u .M3U .rvz .RVZ .tgc .TGC .wad .WAD .wbfs .WBFS .wia .WIA .7z .7Z .zip .ZIP
(52, '.iso', 1),
(52, '.ISO', 0),
(52, '.ciso', 0),
(52, '.CISO', 0),
(52, '.dff', 0),
(52, '.DFF', 0),
(52, '.dol', 0),
(52, '.DOL', 0),
(52, '.elf', 0),
(52, '.ELF', 0),
(52, '.gcm', 0),
(52, '.GCM', 0),
(52, '.gcz', 0),
(52, '.GCZ', 0),
(52, '.json', 0),
(52, '.JSON', 0),
(52, '.m3u', 0),
(52, '.M3U', 0),
(52, '.rvz', 0),
(52, '.RVZ', 0),
(52, '.tgc', 0),
(52, '.TGC', 0),
(52, '.wad', 0),
(52, '.WAD', 0),
(52, '.wbfs', 0),
(52, '.WBFS', 0),
(52, '.wia', 0),
(52, '.WIA', 0),
(52, '.7z', 0),
(52, '.7Z', 0),
(52, '.zip', 0),
(52, '.ZIP', 0),
-- Famicom .3dsen .3DSEN .fds .FDS .nes .NES .unf .UNF .unif .UNIF .7z .7Z .zip .ZIP
(1000, '.nes', 1),
(1000, '.NES', 0),
(1000, '.unf', 0),
(1000, '.UNF', 0),
(1000, '.unif', 0),
(1000, '.UNIF', 0),
(1000, '.fds', 0),
(1000, '.FDS', 0),
(1000, '.3dsen', 0),
(1000, '.3DSEN', 0),
(1000, '.7z', 0),
(1000, '.7Z', 0),
(1000, '.zip', 0),
(1000, '.ZIP', 0),
-- Super Famicom .smc .SMC .sfc .SFC .fig .FIG .bs .BS .swc .SWC .gd3 .GD3 .7z .7Z .zip .ZIP
(1001, '.sfc', 1),
(1001, '.SFC', 0),
(1001, '.smc', 0),
(1001, '.SMC', 0),
(1001, '.fig', 0),
(1001, '.FIG', 0),
(1001, '.bs', 0),
(1001, '.BS', 0),
(1001, '.swc', 0),
(1001, '.SWC', 0),
(1001, '.gd3', 0),
(1001, '.GD3', 0),
(1001, '.7z', 0),
(1001, '.7Z', 0),
(1001, '.zip', 0),
(1001, '.ZIP', 0),
-- Genesis  .32x .32X .68k .68K .bin .BIN .bms .BMS .chd .CHD .cue .CUE .gen .GEN .gg .GG .iso .ISO .m3u .M3U .md .MD .mdx .MDX .sg .SG .sgd .SGD .smd .SMD .sms .SMS .7z .7Z .zip .ZIP
(1002, '.sms', 1),
(1002, '.SMS', 0),
(1002, '.md', 0),
(1002, '.MD', 0),
(1002, '.gen', 0),
(1002, '.GEN', 0),
(1002, '.smd', 0),
(1002, '.SMD', 0),
(1002, '.gg', 0),
(1002, '.GG', 0),
(1002, '.68k', 0),
(1002, '.68K', 0),
(1002, '.bin', 0),
(1002, '.BIN', 0),
(1002, '.bms', 0),
(1002, '.BMS', 0),
(1002, '.chd', 0),
(1002, '.CHD', 0),
(1002, '.cue', 0),
(1002, '.CUE', 0),
(1002, '.iso', 0),
(1002, '.ISO', 0),
(1002, '.m3u', 0),
(1002, '.M3U', 0),
(1002, '.mdx', 0),
(1002, '.MDX', 0),
(1002, '.sg', 0),
(1002, '.SG', 0),
(1002, '.sgd', 0),
(1002, '.SGD', 0),
(1002, '.7z', 0),
(1002, '.7Z', 0),
(1002, '.zip', 0),
(1002, '.ZIP', 0),
-- Mark III  .68k .68K .bin .BIN .bms .BMS .chd .CHD .col .COL .cue .CUE .gen .GEN .gg .GG .iso .ISO .m3u .M3U .md .MD .mdx .MDX .rom .ROM .sg .SG .sgd .SGD .smd .SMD .sms .SMS .7z .7Z .zip .ZIP
(1003, '.sms', 1),
(1003, '.SMS', 0),
(1003, '.md', 0),
(1003, '.MD', 0),
(1003, '.gen', 0),
(1003, '.GEN', 0),
(1003, '.smd', 0),
(1003, '.SMD', 0),
(1003, '.gg', 0),
(1003, '.GG', 0),
(1003, '.68k', 0),
(1003, '.68K', 0),
(1003, '.bin', 0),
(1003, '.BIN', 0),
(1003, '.bms', 0),
(1003, '.BMS', 0),
(1003, '.chd', 0),
(1003, '.CHD', 0),
(1003, '.col', 0),
(1003, '.COL', 0),
(1003, '.cue', 0),
(1003, '.CUE', 0),
(1003, '.iso', 0),
(1003, '.ISO', 0),
(1003, '.m3u', 0),
(1003, '.M3U', 0),
(1003, '.mdx', 0),
(1003, '.MDX', 0),
(1003, '.rom', 0),
(1003, '.ROM', 0),
(1003, '.sg', 0),
(1003, '.SG', 0),
(1003, '.sgd', 0),
(1003, '.SGD', 0),
(1003, '.7z', 0),
(1003, '.7Z', 0),
(1003, '.zip', 0),
(1003, '.ZIP', 0),
-- TurboGrafx-16 .ccd .CCD .chd .CHD .cue .CUE .img .IMG .iso .ISO .m3u .M3U .pce .PCE .rom .ROM .sgx .SGX .toc .TOC .7z .7Z .zip .ZIP
(1004, '.pce', 1),
(1004, '.PCE', 0),
(1004, '.sgx', 0),
(1004, '.SGX', 0),
(1004, '.rom', 0),
(1004, '.ROM', 0),
(1004, '.iso', 0),
(1004, '.ISO', 0),
(1004, '.img', 0),
(1004, '.IMG', 0),
(1004, '.ccd', 0),
(1004, '.CCD', 0),
(1004, '.chd', 0),
(1004, '.CHD', 0),
(1004, '.cue', 0),
(1004, '.CUE', 0),
(1004, '.m3u', 0),
(1004, '.M3U', 0),
(1004, '.toc', 0),
(1004, '.TOC', 0),
(1004, '.7z', 0),
(1004, '.7Z', 0),
(1004, '.zip', 0),
(1004, '.ZIP', 0),
-- TurboGrafx-CD .ccd .CCD .chd .CHD .cue .CUE .img .IMG .iso .ISO .m3u .M3U .pce .PCE .sgx .SGX .toc .TOC .7z .7Z .zip .ZIP
(1005, '.iso', 1),
(1005, '.ISO', 0),
(1005, '.img', 0),
(1005, '.IMG', 0),
(1005, '.ccd', 0),
(1005, '.CCD', 0),
(1005, '.chd', 0),
(1005, '.CHD', 0),
(1005, '.cue', 0),
(1005, '.CUE', 0),
(1005, '.m3u', 0),
(1005, '.M3U', 0),
(1005, '.pce', 0),
(1005, '.PCE', 0),
(1005, '.sgx', 0),
(1005, '.SGX', 0),
(1005, '.toc', 0),
(1005, '.TOC', 0),
(1005, '.7z', 0),
(1005, '.7Z', 0),
(1005, '.zip', 0),
(1005, '.ZIP', 0),
-- Final Burn Neo  .bat .BAT .cmd .CMD .gam .GAM .lnk .LNK .neo .NEO .7z .7Z .zip .ZIP
(1006, '.zip', 1),
(1006, '.NEO', 0),
(1006, '.bat', 0),
(1006, '.BAT', 0),
(1006, '.cmd', 0),
(1006, '.CMD', 0),
(1006, '.gam', 0),
(1006, '.GAM', 0),
(1006, '.lnk', 0),
(1006, '.LNK', 0),
(1006, '.7z', 0),
(1006, '.7Z', 0),
(1006, '.neo', 0),
(1006, '.ZIP', 0),
-- MAME .bat .BAT .cmd .CMD .gam .GAM .lnk .LNK .neo .NEO .7z .7Z .zip .ZIP
(1007, '.zip', 1),
(1007, '.NEO', 0),
(1007, '.bat', 0),
(1007, '.BAT', 0),
(1007, '.cmd', 0),
(1007, '.CMD', 0),
(1007, '.gam', 0),
(1007, '.GAM', 0),
(1007, '.lnk', 0),
(1007, '.LNK', 0),
(1007, '.7z', 0),
(1007, '.7Z', 0),
(1007, '.neo', 0),
(1007, '.ZIP', 0),
-- CPS1 .bat .BAT .cmd .CMD .gam .GAM .lnk .LNK .neo .NEO .7z .7Z .zip .ZIP
(1008, '.zip', 1),
(1008, '.NEO', 0),
(1008, '.bat', 0),
(1008, '.BAT', 0),
(1008, '.cmd', 0),
(1008, '.CMD', 0),
(1008, '.gam', 0),
(1008, '.GAM', 0),
(1008, '.lnk', 0),
(1008, '.LNK', 0),
(1008, '.7z', 0),
(1008, '.7Z', 0),
(1008, '.neo', 0),
(1008, '.ZIP', 0),
-- CPS2 .bat .BAT .cmd .CMD .gam .GAM .lnk .LNK .neo .NEO .7z .7Z .zip .ZIP
(1009, '.zip', 1),
(1009, '.NEO', 0),
(1009, '.bat', 0),
(1009, '.BAT', 0),
(1009, '.cmd', 0),
(1009, '.CMD', 0),
(1009, '.gam', 0),
(1009, '.GAM', 0),
(1009, '.lnk', 0),
(1009, '.LNK', 0),
(1009, '.7z', 0),
(1009, '.7Z', 0),
(1009, '.neo', 0),
(1009, '.ZIP', 0),
-- CPS3 .bat .BAT .cmd .CMD .gam .GAM .lnk .LNK .neo .NEO .7z .7Z .zip .ZIP
(1010, '.zip', 1),
(1010, '.NEO', 0),
(1010, '.bat', 0),
(1010, '.BAT', 0),
(1010, '.cmd', 0),
(1010, '.CMD', 0),
(1010, '.gam', 0),
(1010, '.GAM', 0),
(1010, '.lnk', 0),
(1010, '.LNK', 0),
(1010, '.7z', 0),
(1010, '.7Z', 0),
(1010, '.neo', 0),
(1010, '.ZIP', 0),

-- NEO GEO .bat .BAT .cmd .CMD .gam .GAM .lnk .LNK .neo .NEO .7z .7Z .zip .ZIP
(1011, '.zip', 1),
(1011, '.NEO', 0),
(1011, '.bat', 0),
(1011, '.BAT', 0),
(1011, '.cmd', 0),
(1011, '.CMD', 0),
(1011, '.gam', 0),
(1011, '.GAM', 0),
(1011, '.lnk', 0),
(1011, '.LNK', 0),
(1011, '.7z', 0),
(1011, '.7Z', 0),
(1011, '.neo', 0),
(1011, '.ZIP', 0);