import jemu.core.*;
import jemu.core.cpu.*;
import jemu.core.device.*;
import javzed.vz.*;
import jemu.ui.*;
import jemu.util.diss.*;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.net.*;
import java.io.*;

/**
 * Title:        JAPE Version 1.0
 * Description:  Java Amstrad CPC Plus Emulator
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class JEMU extends Applet implements Runnable, KeyListener, MouseListener {

  protected Computer computer;
  protected Disassembler diss;

  protected boolean isStandalone = false;
  protected Display display = new Display();
  protected BaseControl statusBar;
  protected Debugger debug = null;

  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  public JEMU() {
    enableEvents(AWTEvent.KEY_EVENT_MASK);
  }

  public void init() {
    try {
      removeAll();
      setLayout(new BorderLayout());
      add(display,BorderLayout.CENTER);
      computer = Computer.createComputer(this,getParameter("COMPUTER","VZ300"));
      display.setImageSize(computer.getDisplaySize());
      display.setBorder(Border.blackLine);
      display.addKeyListener(this);
      display.addMouseListener(this);
      computer.setDisplay(display);

      boolean status = Util.getBoolean(getParameter("STATUS","false"));
      if (status) {
        statusBar = new BaseControl();
        add(statusBar,BorderLayout.SOUTH);
      }
      else
        statusBar = null;
      computer.initialise("rom/");
    } catch(Exception e) {
      e.printStackTrace();
    }
  }

  public void start() {
    computer.start();
    display.requestFocus();
  }

  public void stop() {
    computer.dispose();
  }

  public void destroy() { }

  public String getAppletInfo() {
    return "Applet Information";
  }

  public String[][] getParameterInfo() {
    return null;
  }

  public static void main(String[] args) {
    JEMU applet = new JEMU();
    applet.isStandalone = true;
    Frame frame;
    frame = new Frame() {

      protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
          System.exit(0);
        }
      }

      public synchronized void setTitle(String title) {
        super.setTitle(title);
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
      }

    };
    frame.setTitle("Applet Frame");
    frame.add(applet, BorderLayout.CENTER);
    applet.init();
    applet.start();
    frame.setSize(400,320);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
    frame.setVisible(true);
  }

  protected void showState(String text) {
    int[] address = new int[] { ((Z80)computer.getProcessor()).getPC() };
    for (int i = 0; i < 10; i++)
      text += diss.disassemble(computer.getMemory(),address,true,36) + "\n";
    text += computer.getProcessor().getState();
  }

  public void update(Graphics g) {
    paint(g);
  }

  public void run() {
    try {
      int addr = 0; // Util.hexValue(textField2.getText());
      computer.getProcessor().runTo(addr & 0xffff);
      showState("");
    } catch(Exception ex) { }
  }

  public void keyTyped(KeyEvent e) { }

  public void keyPressed(KeyEvent e) {
    computer.processKeyEvent(e);
  }

  public void keyReleased(KeyEvent e) {
    computer.processKeyEvent(e);
  }

  public void mouseClicked(MouseEvent e) {
    if (e.getClickCount() == 2)
      showDebugger();
  }

  public void mousePressed(MouseEvent e) { }

  public void mouseReleased(MouseEvent e) { }

  public void mouseEntered(MouseEvent e) { }

  public void mouseExited(MouseEvent e) { }

  public void showDebugger() {
    try {
      if (debug == null) {
        debug = (Debugger)Util.secureConstructor(Debugger.class,
          new Class[] { getClass() },new Object[] { this });
        debug.setBounds(0,0,500,400);
        debug.setComputer(computer);
      }
      debug.setVisible(true);
      debug.toFront();
    } catch(Exception e) {
      e.printStackTrace();
    }
  }

  public Computer getComputer() {
    return computer;
  }

}