package jape.cpc;

import java.applet.*;
import java.awt.*;
import jemu.core.cpu.*;
import jemu.core.device.*;
import jemu.core.device.crtc.*;
import jemu.core.device.memory.*;
import jemu.ui.*;

/**
 * Title:        JAPE Version 1.0
 * Description:  Java Amstrad CPC Plus Emulator
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class CPC extends Computer {

  protected Z80 z80 = new Z80();
  protected CPCMemory memory = new CPCMemory(CPCMemory.TYPE_64K);
  protected Basic6845 crtc = new Basic6845();
  protected GateArray gateArray = new GateArray(this);
  protected int offset = 0;
  protected Display display;

  public CPC(Applet applet, String name) {
    super(applet,name);
    z80.setMemoryDevice(memory);
    z80.addOutputDeviceMapping(new DeviceMapping(memory,0x2000,0x0000));    // ROM Select
    z80.setInterrupDevice(gateArray);
    z80.addOutputDeviceMapping(new DeviceMapping(gateArray,0xc000,0x4000)); // All GA functions
    z80.setCycleDevice(crtc);
    crtc.setSelectMask(0x0100,0x0000);
    crtc.setCRTCListener(gateArray);
    z80.addOutputDeviceMapping(new DeviceMapping(crtc,0x4000,0x0000));
  }

  public void initialise(String romPath) {
    memory.setLowerROM(getFile(romPath + "cpc/CPCLOW.ROM", 16384));
    memory.setUpperROM(0,getFile(romPath + "cpc/CPCBASIC.ROM", 16384));
  }

  public void setDisplay(Display value) {
    this.display = display;
    gateArray.setPixels(value.getPixels());
  }

  protected int intCount = 0;

  public void interrupt() {
    if (++intCount == 6) {
      intCount = 0;
      display.updateImage();
    }
  }

  public Memory getMemory() {
    return memory;
  }

  public Processor getProcessor() {
    return z80;
  }

  public Dimension getDisplaySize() {
    return new Dimension(384,270);
  }
}