package jape.cpc;

/**
 * Title:        JAPE Version 1.0
 * Description:  Java Amstrad CPC Plus Emulator
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class Z80 extends jemu.core.cpu.Z80 {

  // =============================================================
  // Timings for instructions. This is CPC specific
  // =============================================================

  protected static final byte[] CPC_TIME_PRE = {
    1, 3, 2, 2, 1, 1, 2, 1, 1, 3, 2, 2, 1, 1, 2, 1,   // 00 .. 0F
    3, 3, 2, 2, 1, 1, 2, 1, 3, 3, 2, 2, 1, 1, 2, 1,   // 10 .. 1F
    2, 3, 5, 2, 1, 1, 2, 1, 2, 3, 5, 2, 1, 1, 2, 1,   // 20 .. 2F
    2, 3, 4, 2, 3, 3, 3, 1, 2, 3, 4, 2, 1, 1, 2, 1,   // 30 .. 3F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // 40 .. 4F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // 50 .. 5F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // 60 .. 6F
    2, 2, 2, 2, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1,   // 70 .. 7F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // 80 .. 8F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // 90 .. 9F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // A0 .. AF
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // B0 .. BF
    2, 3, 3, 3, 3, 4, 2, 4, 2, 3, 3, 1, 3, 5, 2, 4,   // C0 .. CF
    2, 3, 3, 3, 3, 4, 2, 4, 2, 1, 3, 3, 3, 1, 2, 4,   // D0 .. DF
    2, 3, 3, 6, 3, 4, 2, 4, 2, 1, 3, 1, 3, 1, 2, 4,   // E0 .. EF
    2, 3, 3, 1, 3, 4, 2, 4, 2, 2, 3, 1, 3, 1, 2, 4    // F0 .. FF
  };

  protected static final byte[] CPC_TIME_POST = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 00 .. 0F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 10 .. 1F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 20 .. 2F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 30 .. 3F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 40 .. 4F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 50 .. 5F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 60 .. 6F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 70 .. 7F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 80 .. 8F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 90 .. 9F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // A0 .. AF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // B0 .. BF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // C0 .. CF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // D0 .. DF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // E0 .. EF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0    // F0 .. FF
  };

  protected static final byte[] CPC_TIME_PRE_CB = {
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // 00 .. 0F
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // 10 .. 1F
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // 20 .. 2F
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // 30 .. 3F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // 40 .. 4F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // 50 .. 5F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // 60 .. 6F
    1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 2, 1,   // 70 .. 7F
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // 80 .. 8F
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // 90 .. 9F
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // A0 .. AF
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // B0 .. BF
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // C0 .. CF
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // D0 .. DF
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1,   // E0 .. EF
    1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 3, 1    // F0 .. FF
  };

  protected static final byte[] CPC_TIME_POST_CB = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 00 .. 0F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 10 .. 1F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 20 .. 2F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 30 .. 3F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 40 .. 4F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 50 .. 5F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 60 .. 6F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 70 .. 7F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 80 .. 8F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 90 .. 9F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // A0 .. AF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // B0 .. BF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // C0 .. CF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // D0 .. DF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // E0 .. EF
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0    // F0 .. FF
  };

  protected static final byte[] CPC_TIME_PRE_ED = {
    3, 3, 3, 5, 1, 3, 1, 2, 3, 3, 3, 5, 1, 3, 1, 2,   // 40 .. 4F
    3, 3, 3, 5, 1, 3, 1, 2, 3, 3, 3, 5, 1, 3, 1, 2,   // 50 .. 5F
    3, 3, 3, 5, 1, 3, 1, 4, 3, 3, 3, 5, 1, 3, 1, 4,   // 60 .. 6F
    3, 3, 3, 5, 1, 3, 1, 1, 3, 3, 3, 5, 1, 3, 1, 1,   // 70 .. 7F

    4, 3, 4, 4,                                       // A0 .. A3
    4, 3, 4, 4,                                       // A8 .. AB
    4, 3, 4, 4,                                       // B0 .. B3
    4, 3, 4, 4                                        // B8 .. BB
  };

  protected static final byte[] CPC_TIME_POST_ED = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 40 .. 4F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 50 .. 5F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 60 .. 6F
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,   // 70 .. 7F

    0, 0, 0, 0,                                       // A0 .. A3
    0, 0, 0, 0,                                       // A8 .. AB
    0, 0, 0, 0,                                       // B0 .. B3
    0, 0, 0, 0                                        // B8 .. BB
  };

  protected static final int CYCLES_EXTRA_JRCC    = 0;
  protected static final int CYCLES_EXTRA_DJNZ    = 1;
  protected static final int CYCLES_EXTRA_CALLCC  = 2;
  protected static final int CYCLES_EXTRA_RETCC   = 3;
  protected static final int CYCLES_EXTRA_LDIR    = 4;
  protected static final int CYCLES_EXTRA_CPIR    = 5;
  protected static final int CYCLES_EXTRA_INIR    = 6;
  protected static final int CYCLES_EXTRA_OTIR    = 7;
  protected static final int CYCLES_EXTRA_IDXNORM = 8;
  protected static final int CYCLES_EXTRA_IDXLDIN = 9;
  protected static final int CYCLES_EXTRA_IDXCB   = 10;
  protected static final int CYCLES_EXTRA_IM0     = 11;
  protected static final int CYCLES_EXTRA_IM1     = 12;
  protected static final int CYCLES_EXTRA_IM2     = 13;
  protected static final int CYCLES_EXTRA_INTACK  = 14;

  protected static final byte[] CPC_TIME_EXTRA = {
    1, 1, 2, 2, 1, 2, 1, 1, 2, 2, 2, 1, 1, 1, 1
  };

  protected void setTimes() {
    setTimes(CPC_TIME_PRE, CPC_TIME_POST, CPC_TIME_PRE_CB, CPC_TIME_POST_CB,
      CPC_TIME_PRE_ED, CPC_TIME_POST_ED, CPC_TIME_EXTRA);
  }
}