package jemu.core.device;

/**
 * Title:        JAPE Version 1.0
 * Description:  Java Amstrad CPC Plus Emulator
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public abstract class Device {

  protected String type;

  public Device(String type) {
    this.type = type;
  }

  public int readByte(int address) {
    return -1;
  }

  public void writeByte(int address, int value) { }

  public int readPort(int port) {
    return -1;
  }

  public void writePort(int port, int value) { }

  public void cycle() { }

  public void reset() { }

  public void interrupt() { }

  public String toString() {
    return type;
  }

}