package jemu.ui;

import java.awt.*;

/**
 * Title:        JAPE Version 1.0
 * Description:  Java Amstrad CPC Plus Emulator
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class Border {

  public static final int EMPTY  = 0;
  public static final int RAISED = 1;
  public static final int SUNKEN = 2;
  public static final int ETCHED = 3;
  public static final int LINE   = 4;
  public static final int OPAQUE = 5;

  public static final Border empty     = new Border(EMPTY);
  public static final Border clear     = new Border(EMPTY,1,null);
  public static final Border opaque    = new Border(OPAQUE);
  public static final Border raised    = new Border(RAISED);
  public static final Border sunken    = new Border(SUNKEN);
  public static final Border etched    = new Border(ETCHED);
  public static final Border blackLine = new Border(LINE,1,Color.black);

  protected int width = 1;
  protected int style = RAISED;
  protected Color colour = null;

  public Border(int style) {
    this(style,style == EMPTY ? 0 : (style == ETCHED ? 2 : 1),null);
  }

  public Border(int style, int width, Color colour) {
    this.style = style;
    this.width = width;
    this.colour = colour;
  }

  public void paintBorder(BaseControl control, Graphics g, Rectangle rect) {
    g.setColor(colour != null ? colour :
      (style == LINE ? control.getForeground() : control.getBackground()));
    for (int i = 0; i < width; i++) {
      switch(style) {

        case RAISED:
        case SUNKEN:
          g.draw3DRect(rect.x,rect.y,rect.width - 1,rect.height - 1,style == RAISED);
          break;

        case ETCHED:
          g.draw3DRect(rect.x,rect.y,rect.width - 1,rect.height - 1, i >= width / 2);
          break;

        case LINE:
        case OPAQUE:
          g.drawRect(rect.x,rect.y,rect.width - 1,rect.height - 1);
          break;
      }
      rect.grow(-1,-1);
    }
  }

  public Insets getInsets() {
    return new Insets(width,width,width,width);
  }

}