package jemu.ui;

import java.awt.*;
import java.awt.event.*;
import jemu.core.device.*;
import JEMU;

/**
 * Title:        JAPE Version 1.0
 * Description:  Java Amstrad CPC Plus Emulator
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class Debugger extends EFrame implements ActionListener {

  protected EButton run = new EButton("Run");
  protected EButton stop = new EButton("Stop");
  protected EButton step = new EButton("Step");
  protected EButton stepOver = new EButton("Step Over");
  protected EDisassembler diss = new EDisassembler();
  protected Computer computer;

  public Debugger(JEMU jemu) {
    super("JEMU Debugger");
    setBackground(SystemColor.control);
    setLayout(new BorderLayout());
    BaseControl main = new BaseControl();
    add(main,BorderLayout.CENTER);
    main.setLayout(new BorderLayout());
    main.add(diss,BorderLayout.CENTER);
    diss.setComputer(jemu.getComputer());
    BaseControl panel = new BaseControl();
    panel.setBorder(Border.raised);
    panel.setLayout(new FlowLayout(FlowLayout.LEFT));
    panel.add(run);
    run.addActionListener(this);
    panel.add(stop);
    stop.addActionListener(this);
    panel.add(step);
    step.addActionListener(this);
    step.setAutoRepeatDelay(1000);
    panel.add(stepOver);
    stepOver.addActionListener(this);
    stepOver.setAutoRepeatDelay(1000);
    add(panel,BorderLayout.SOUTH);
  }

  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == run)
      computer.start();
    else if (e.getSource() == stop)
      computer.stop();
    else if (e.getSource() == step)
      computer.step();
    else if (e.getSource() == stepOver)
      computer.stepOver();
    else if (e.getSource() == computer)
      diss.setAddress(computer.getProcessor().getProgramCounter());
  }

  public void setComputer(Computer value) {
    if (computer != null)
      computer.removeActionListener(this);
    computer = value;
    if (computer != null)
      computer.addActionListener(this);
  }

}