package jemu.ui;

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;

/**
 * Title:        JAPE Version 1.0
 * Description:  Java Amstrad CPC Plus Emulator
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class Display extends BaseControl {

  protected MemoryImageSource imageSource;
  protected Image image;
  protected int[] pixels;
  protected int width, height;
  protected Rectangle imageRect = new Rectangle();
  protected int imagePos = CENTRE;
  protected boolean sameSize;

  public Display() {
    canFocus = true;
  }

  public void setImageSize(Dimension size) {
    width = size.width;
    height = size.height;
    pixels = new int[width * height];
    for (int i = 0; i < pixels.length; i++)
      pixels[i] = 0xff000000;
    imageSource = new MemoryImageSource(width,height,pixels,0,width);
    imageSource.setAnimated(true);
    image = createImage(imageSource);
    checkSize();
  }

  public void setBounds(int x, int y, int width, int height) {
    super.setBounds(x,y,width,height);
    checkSize();
  }

  public void setBorder(Border value) {
    super.setBorder(value);
    checkSize();
  }

  protected void checkSize() {
    Dimension size = getSize();
    int bw = border == null ? 0 : border.width * 1;
    int clientWidth = size.width - bw * 2;
    int clientHeight = size.height - bw * 2;
    if (imagePos == CENTRE) {
      imageRect = new Rectangle(bw + (clientWidth - width) / 2,
        bw + (clientHeight - height) / 2,width,height);
      sameSize = true;
    }
    else {
      imageRect = new Rectangle(bw,bw,clientWidth,clientHeight);
      sameSize = clientWidth == width && clientHeight == height;
    }
  }

  public int[] getPixels() {
    return pixels;
  }

  public void updateImage() {
    imageSource.newPixels();
    Graphics g = getGraphics();
    paintImage(g);
    g.dispose();
  }

  protected void paintImage(Graphics g) {
    if (sameSize)
      g.drawImage(image,imageRect.x,imageRect.y,null);
    else
      g.drawImage(image,imageRect.x,imageRect.y,imageRect.width,imageRect.height,null);
  }

  public void update(Graphics g) {
    paint(g);
  }

  public void paintContents(Graphics g, Rectangle rect, FontMetrics fm) {
    if (image != null)
      paintImage(g);
  }

  public void paintBackground(Graphics g, Rectangle rect) { }

  public int getWidth() {
    return width;
  }

  public int getHeight() {
    return height;
  }

}