package jemu.ui;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

/**
 * Title:        JAPE Version 1.0
 * Description:  Java Amstrad CPC Plus Emulator
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class EButton extends BaseControl implements TimerListener {

  protected Image image;
  protected Vector listeners = new Vector(1);
  protected boolean down = false;
  protected boolean over = false;
  protected int autoRepeatDelay = -1;
  protected int autoRepeatTime = 50;
  protected String actionCommand;
  protected Counter counter = null;
  protected Border downBorder = Border.sunken;
  protected Border upBorder = Border.opaque;
  protected Border overBorder = Border.raised;

  public EButton() {
    this(null,null);
  }

  public EButton(String text) {
    this(text,null);
  }

  public EButton(String text, Image image) {
    enableEvents(MouseEvent.MOUSE_EVENT_MASK | MouseEvent.MOUSE_MOTION_EVENT_MASK);
    setText(text);
    setImage(image);
  }

  public void setImage(Image value) {
    image = value;
  }

  public Image getImage() {
    return image;
  }

  protected void processMouseEvent(MouseEvent e) {
    if (e.getID() == MouseEvent.MOUSE_PRESSED) {
      setDown(true);
      if (autoRepeatDelay >= 0) {
        fireActionEvent();
        startTimer();
      }
    }
    else if (e.getID() == MouseEvent.MOUSE_RELEASED) {
      stopTimer();
      if (down && (autoRepeatDelay < 0))
        fireActionEvent();
      setDown(false);
    }
    else if (e.getID() == MouseEvent.MOUSE_ENTERED)
      setOver(true);
    else if (e.getID() == MouseEvent.MOUSE_EXITED)
      setOver(false);
    super.processMouseEvent(e);
  }

  protected void startTimer() {
    if (counter == null)
      counter = new Counter(this,autoRepeatDelay,null);
  }

  protected void stopTimer() {
    if (counter != null) {
      counter.stop();
      counter = null;
    }
  }

  protected void processMouseMotionEvent(MouseEvent e) {
    if (e.getID() == MouseEvent.MOUSE_DRAGGED) {
      Dimension size = getSize();
      setDown(e.getX() >= 0 && e.getX() < size.width &&
        e.getY() >= 0 && e.getY() < size.height);
    }
    super.processMouseMotionEvent(e);
  }

  public void setDown(boolean value) {
    if (down != value) {
      down = value;
      repaint();
    }
  }

  protected void setOver(boolean value) {
    if (over != value) {
      over = value;
      repaint();
    }
  }

  protected void fireActionEvent() {
    ActionEvent e = new ActionEvent(this,0,actionCommand);
    for (int i = 0; i < listeners.size(); i++)
      ((ActionListener)listeners.elementAt(i)).actionPerformed(e);
  }

  protected void paintContents(Graphics g, Rectangle rect) {
    Border border = down ? downBorder : (over ? overBorder : upBorder);
    if (border != null)
      border.paintBorder(this,g,rect);
    g.setColor(getForeground());
    super.paintContents(g,rect);
  }

  public void addActionListener(ActionListener listener) {
    listeners.addElement(listener);
  }

  public void removeActionListener(ActionListener listener) {
    listeners.removeElement(listener);
  }

  public void setActionCommand(String value) {
    actionCommand = value;
  }

  public String getActionCommand() {
    return actionCommand;
  }

  public void setAutoRepeatDelay(int value) {
    autoRepeatDelay = value;
  }

  public int getAutoRepeatDelay() {
    return autoRepeatDelay;
  }

  public void setAutoRepeatTime(int value) {
    autoRepeatTime = value;
  }

  public int getAutoRepeatTime() {
    return autoRepeatTime;
  }

  public void timerTick(Counter counter) {
    counter.setDuration(autoRepeatTime);
    if (down && this.counter != null)
      fireActionEvent();
  }

}