package jemu.ui;

import java.awt.*;
import jemu.core.device.*;
import jemu.util.diss.*;

/**
 * Title:        JAPE Version 1.0
 * Description:  Java Amstrad CPC Plus Emulator
 * Copyright:    Copyright (c) 2002
 * Company:
 * @author
 * @version 1.0
 */

public class EDisassembler extends BaseControl {

  protected int address = 0;
  protected Computer computer;

  public EDisassembler() {
    setBackground(Color.white);
    setForeground(Color.black);
    setBorder(Border.blackLine);
    setFont(new Font("Courier",0,12));
  }

  public void setComputer(Computer value) {
    computer = value;
    repaint();
  }

  public Dimension getPreferredSize() {
    return new Dimension(200,0);
  }

  protected void paintContents(Graphics g, Rectangle rect) {
    g.setFont(getFont());
    FontMetrics fm = g.getFontMetrics();
    if (computer != null) {
      Disassembler diss = computer.getDisassembler();
      if (diss != null) {
        g.setColor(getForeground());
        int a = fm.getAscent();
        int[] addr = new int[] { address };
        for (int y = rect.y; y < rect.y + rect.height; y += fm.getHeight()) {
          String line = diss.disassemble(computer.getMemory(),addr,true,30);
          g.drawString(line,rect.x,y + a);
        }
      }
    }
  }

  public void setAddress(int value) {
    address = value;
    repaint();
  }

}