#include <stdint.h>
#include <stdio.h>

#include "stb/stb_file.h"
#include "stb/bithacks.h"

void decode(uint8_t* buf, int n)
{
	uint8_t b1, b0;
	for(int i=0; i<n; i++) {
		b1 = b0 = buf[i];
		B_UNSET(b1,1); B_UNSET(b1,2);
		if(B_IS_SET(b0,1)) B_SET(b1,2);
		if(B_IS_SET(b0,2)) B_SET(b1,1);
		buf[i] = b1;
	}
}

// 1MB
uint8_t buf[1024*1024];

void gen_bin(FILE *fp, uint8_t *buf, int sz, char *h, char *rem)
{
    fprintf(fp, "%s = {	// %s\n", h, rem);

	int i;

    for(i=0; i<sz; i++) {
		fprintf(fp, "0x%02X", buf[i]);
		if(i!=sz-1)
			fprintf(fp, ",");
		if((i%16)==15)
			fprintf(fp, "\t// %06X\n", i-15);
		else
			fprintf(fp, " ");
	}

    fprintf(fp, "};\n");
}

int main(int argc, char *argv[])
{
	size_t r_len;

#define FONTROMSIZE 0x0C00
#define ROMSIZE     0x4000
#define DOSROMSIZE  0x2000

	FILE *fp;

	// Laser-310
	fp = fopen("laser310.h", "w");

	fread_buf_bin("roms/laser310/character set (1983)(vtech).rom", buf, FONTROMSIZE, &r_len);
	gen_bin(fp,	buf, FONTROMSIZE, "const uint8_t fontrom[FONTROMSIZE]", "mc6847 font");

	fread_buf_bin("roms/laser310/basic v2.0 (1983)(vtech).rom", buf, ROMSIZE, &r_len);
	gen_bin(fp,	buf, ROMSIZE, "const uint8_t laser310_rom_2_0[ROMSIZE]", "16K of rom in $0000-$3FFF");

	fread_buf_bin("roms/laser310/basic v2.1 (198x)(vtech).rom", buf, ROMSIZE, &r_len);
	gen_bin(fp,	buf, ROMSIZE, "const uint8_t laser310_rom_2_1[ROMSIZE]", "16K of rom in $0000-$3FFF");

	fread_buf_bin("roms/laser310/dos basic v1.2 (198x)(vtech).rom", buf, DOSROMSIZE,     &r_len);
	gen_bin(fp,	buf, DOSROMSIZE, "const uint8_t laser310_dosrom_1_2[DOSROMSIZE]", "8KB DOS ROM  $4000-$5FFF");

	fread_buf_bin("roms/laser310/dos basic v1.2 (198x)(vtech)_patch.rom", buf, DOSROMSIZE,     &r_len);
	gen_bin(fp,	buf, DOSROMSIZE, "const uint8_t laser310_dosrom_1_2patch[DOSROMSIZE]", "8KB DOS ROM  $4000-$5FFF");

	fclose(fp);

	// Laser-200
	fp = fopen("laser200.h", "w");

	fread_buf_bin("roms/laser310/character set (1983)(vtech).rom", buf, FONTROMSIZE, &r_len);
	gen_bin(fp,	buf, FONTROMSIZE, "const uint8_t fontrom[FONTROMSIZE]", "mc6847 font");

	fread_buf_bin("roms/laser200/vtechv12.u09", buf, ROMSIZE/2, &r_len);
	fread_buf_bin("roms/laser200/vtechv12.u10", buf+ROMSIZE/2, ROMSIZE/2, &r_len);
	gen_bin(fp,	buf, ROMSIZE, "const uint8_t laser200_rom[ROMSIZE]", "16K of rom in $0000-$3FFF");

	fread_buf_bin("roms/laser310/dos basic v1.2 (198x)(vtech).rom", buf, DOSROMSIZE,     &r_len);
	gen_bin(fp,	buf, DOSROMSIZE, "const uint8_t laser310_dosrom_1_2[DOSROMSIZE]", "8KB DOS ROM  $4000-$5FFF");

	fread_buf_bin("roms/laser310/dos basic v1.2 (198x)(vtech)_patch.rom", buf, DOSROMSIZE,     &r_len);
	gen_bin(fp,	buf, DOSROMSIZE, "const uint8_t laser310_dosrom_1_2patch[DOSROMSIZE]", "8KB DOS ROM  $4000-$5FFF");

	fclose(fp);

	// VZ200
	fp = fopen("vz200.h", "w");

	fread_buf_bin("roms/laser310/character set (1983)(vtech).rom", buf, FONTROMSIZE, &r_len);
	gen_bin(fp,	buf, FONTROMSIZE, "const uint8_t fontrom[FONTROMSIZE]", "mc6847 font");

	fread_buf_bin("roms/vz200/vzrom.lo", buf, ROMSIZE/2, &r_len);
	fread_buf_bin("roms/vz200/vzrom.hi", buf+ROMSIZE/2, ROMSIZE/2, &r_len);
	gen_bin(fp,	buf, ROMSIZE, "const uint8_t vz200_rom[ROMSIZE]", "16K of rom in $0000-$3FFF");

	fread_buf_bin("roms/laser310/dos basic v1.2 (198x)(vtech).rom", buf, DOSROMSIZE,     &r_len);
	gen_bin(fp,	buf, DOSROMSIZE, "const uint8_t laser310_dosrom_1_2[DOSROMSIZE]", "8KB DOS ROM  $4000-$5FFF");

	fread_buf_bin("roms/laser310/dos basic v1.2 (198x)(vtech)_patch.rom", buf, DOSROMSIZE,     &r_len);
	gen_bin(fp,	buf, DOSROMSIZE, "const uint8_t laser310_dosrom_1_2patch[DOSROMSIZE]", "8KB DOS ROM  $4000-$5FFF");

	fclose(fp);

    return 0;
}
