// gcc -o dsk2c dsk2c.c
#include <stdint.h>
#include <stdio.h>

#include "stb/stb_file.h"
#include "stb/bithacks.h"

// 1MB
uint8_t buf[1024*1024];

void gen_bin(FILE *fp, uint8_t *buf, int sz, char *filename)
{
    fprintf(fp, "const uint8_t dsk_data[%d] = {	// %s\n", sz, filename);

	int i;

    for(i=0; i<sz; i++) {
		fprintf(fp, "0x%02X", buf[i]);
		if(i!=sz-1)
			fprintf(fp, ",");
		if((i%16)==15)
			fprintf(fp, "\t// %06X\n", i-15);
		else
			fprintf(fp, " ");
	}

    fprintf(fp, "};\n");
}

const char path[] = "dsk/";

int main(int argc, char *argv[])
{
	size_t r_len;
	FILE *fp;
	char filename[512];

	sprintf(filename,"%s%s", path, argv[1]);

	size_t flen = fn_filesize(filename);
	
	if(flen<256*35*16) {
		printf("file size %d",flen);
		return 0;
	}

	fread_buf_bin(filename, buf, flen, &r_len);
	if(flen!=r_len) {
		printf("file read size %d",r_len);
		return 0;
	}

	printf("gen dsk.h");

	fp = fopen("dsk.h", "w");
	fprintf(fp, "const char dsk_fn[] = \"%s\";\n", filename);
	fprintf(fp, "const int dsk_len = %d;\n", flen);
	gen_bin(fp,	buf, flen, filename);
	fclose(fp);

    return 0;
}
