#include <windows.h>

#include <stdlib.h>
#include <wchar.h>


wchar_t* char2wchar(const char* cchar)
{
	wchar_t *m_wchar;
	int len = MultiByteToWideChar(CP_ACP ,0,cchar ,strlen( cchar), NULL,0);
	m_wchar= malloc(sizeof(wchar_t)*(len+1));
	MultiByteToWideChar(CP_ACP ,0,cchar,strlen( cchar),m_wchar,len);
	m_wchar[len]= '\0' ;
	return m_wchar;
}

char* wchar2char(const wchar_t* wchar)
{
	char * m_char;
	int len= WideCharToMultiByte(CP_ACP ,0,wchar ,wcslen( wchar ), NULL,0, NULL ,NULL);
	m_char= malloc(sizeof(wchar_t)*(len+1));
	WideCharToMultiByte(CP_ACP ,0,wchar ,wcslen( wchar ),m_char,len, NULL ,NULL);
	m_char[len]= '\0';
	return m_char;
}

char* UnicodeToUtf8(const wchar_t* unicode)
{
    int len;
    len = WideCharToMultiByte(CP_UTF8, 0, unicode, -1, NULL, 0, NULL, NULL);
    char *szUtf8 = (char*)malloc(len + 1);
    memset(szUtf8, 0, len + 1);
    WideCharToMultiByte(CP_UTF8, 0, unicode, -1, szUtf8, len, NULL, NULL);
    return szUtf8;
}

// Windows 平台 UTF-8 编码转换为本机编码
char* Utf8ToLoc(const char* s)
{
	int len = strlen(s);

	int wb_len = MultiByteToWideChar(CP_UTF8, 0, s, len, 0, 0);

	char *wbuf = (char*)malloc(sizeof(wchar_t)*(wb_len+1));
	memset(wbuf, 0, sizeof(wchar_t)*(wb_len+1));

	MultiByteToWideChar(CP_UTF8, 0, s, len, wbuf, wb_len);

	UINT cp = GetACP();
	int b_len = WideCharToMultiByte(cp, 0, wbuf, wb_len, 0, 0, 0, 0);
	char *buf = (char*)malloc(b_len+1);
	memset(buf, 0, b_len + 1);
	WideCharToMultiByte(cp, 0, wbuf, wb_len, buf, b_len, 0, 0);

	free(wbuf);

	return buf;
}

/*
BOOL UTF8ToUnicode(const char* UTF8, wchar_t* strUnicode)
{
    DWORD dwUnicodeLen;	//转换后Unicode的长度
    //TCHAR  *pwText;		//保存Unicode的指针
    WCHAR  *pwText;		//保存Unicode的指针
    // wchar_t* strUnicode;    //返回值

    //获得转换后的长度，并分配内存
    dwUnicodeLen = MultiByteToWideChar(CP_UTF8,0,UTF8,-1,NULL,0);

    //pwText = malloc(sizeof(TCHAR)*dwUnicodeLen);
	pwText = malloc(sizeof(WCHAR)*dwUnicodeLen);
    if(!pwText) {
        return FALSE;
    }

    //转为Unicode
    MultiByteToWideChar(CP_UTF8,0,UTF8,-1,pwText,dwUnicodeLen);

    //转为CString
    wcscpy(strUnicode, pwText);

    //清除内存
    free(pwText);
    return TRUE;
}
*/
