void emu_init(const uint8_t *fontrom, const uint8_t *sysrom, const uint8_t *dosrom)
{
	memcpy(vzcontext.mc8247font, fontrom, 1024*3);
	memset(vzcontext.memory, 0x7f, 1024*64);
	memset(vzcontext.vram, 0x7f, 1024*8);
	memcpy(vzcontext.memory + 0x0000, sysrom, 1024*16);
	//memcpy(vzcontext.memory + 0x4000, dosrom, 1024*8);

	memset(vzcontext.scancode, 0x00, sizeof(vzcontext.scancode)/sizeof(uint8_t));
	memset(vzcontext.vscancode, 0x00, sizeof(vzcontext.vscancode)/sizeof(uint8_t));

	//vzcontext.vkey_len=0;
	//vzcontext.vkey_cur=0;

	vzcontext.latched_ga = 0xff;
	vzcontext.latched_shrg = 0x08;
	//vzcontext.latched_shrg = 0x00;

	/* Emulate. */
	Z80Reset(&vzcontext.state);
	vzcontext.state.pc = 0x0000;
}

int key_map(const SDL_Keysym *keysym, int*i, int*j)
{
/*
	switch (keysym->sym) {
		case SDLK_r:			*i=0;*j=5;	break;
	}
*/
	*i=-1;*j=-1;
	switch (keysym->scancode) {
		case SDL_SCANCODE_R:		*i=0;*j=5;	break;
		case SDL_SCANCODE_Q:		*i=0;*j=4;	break;
		case SDL_SCANCODE_E:		*i=0;*j=3;	break;
		//case SDL_SCANCODE_:		*i=0;*j=2;	break;
		case SDL_SCANCODE_W:		*i=0;*j=1;	break;
		case SDL_SCANCODE_T:		*i=0;*j=0;	break;

		case SDL_SCANCODE_F:		*i=1;*j=5;	break;
		case SDL_SCANCODE_A:		*i=1;*j=4;	break;
		case SDL_SCANCODE_D:		*i=1;*j=3;	break;
		case SDL_SCANCODE_LCTRL:
		case SDL_SCANCODE_RCTRL:	*i=1;*j=2;	break;
		case SDL_SCANCODE_S:		*i=1;*j=1;	break;
		case SDL_SCANCODE_G:		*i=1;*j=0;	break;

		case SDL_SCANCODE_V:		*i=2;*j=5;	break;
		case SDL_SCANCODE_Z:		*i=2;*j=4;	break;
		case SDL_SCANCODE_C:		*i=2;*j=3;	break;
		case SDL_SCANCODE_LSHIFT:
		case SDL_SCANCODE_RSHIFT:	*i=2;*j=2;	break;
		case SDL_SCANCODE_X:		*i=2;*j=1;	break;
		case SDL_SCANCODE_B:		*i=2;*j=0;	break;

		case SDL_SCANCODE_4:		*i=3;*j=5;	break;
		case SDL_SCANCODE_1:		*i=3;*j=4;	break;
		case SDL_SCANCODE_3:		*i=3;*j=3;	break;
		//case SDL_SCANCODE_:		*i=3;*j=2;	break;
		case SDL_SCANCODE_2:		*i=3;*j=1;	break;
		case SDL_SCANCODE_5:		*i=3;*j=0;	break;

		case SDL_SCANCODE_M:		*i=4;*j=5;	break;
		case SDL_SCANCODE_SPACE:	*i=4;*j=4;	break;
		case SDL_SCANCODE_COMMA:	*i=4;*j=3;	break;
		//case SDL_SCANCODE_:		*i=4;*j=2;	break;
		case SDL_SCANCODE_PERIOD:	*i=4;*j=1;	break;
		case SDL_SCANCODE_N:		*i=4;*j=0;	break;

		case SDL_SCANCODE_7:		*i=5;*j=5;	break;
		case SDL_SCANCODE_0:		*i=5;*j=4;	break;
		case SDL_SCANCODE_8:		*i=5;*j=3;	break;
		case SDL_SCANCODE_MINUS:	*i=5;*j=2;	break;
		case SDL_SCANCODE_9:		*i=5;*j=1;	break;
		case SDL_SCANCODE_6:		*i=5;*j=0;	break;

		case SDL_SCANCODE_U:		*i=6;*j=5;	break;
		case SDL_SCANCODE_P:		*i=6;*j=4;	break;
		case SDL_SCANCODE_I:		*i=6;*j=3;	break;
		case SDL_SCANCODE_RETURN:	*i=6;*j=2;	break;
		case SDL_SCANCODE_O:		*i=6;*j=1;	break;
		case SDL_SCANCODE_Y:		*i=6;*j=0;	break;

		case SDL_SCANCODE_J:		*i=7;*j=5;	break;
		case SDL_SCANCODE_SEMICOLON:*i=7;*j=4;	break;
		case SDL_SCANCODE_K:		*i=7;*j=3;	break;
		case SDL_SCANCODE_APOSTROPHE:	*i=7;*j=2;	break;
		case SDL_SCANCODE_L:		*i=7;*j=1;	break;
		case SDL_SCANCODE_H:		*i=7;*j=0;	break;

		// 扩展按键  scancode[8] 上下左右 Backspace TAB ESC `  scancode[9] = [ ] \ / LALT RALT
		case SDL_SCANCODE_UP:		*i=8;*j=0;	break;
		case SDL_SCANCODE_DOWN:		*i=8;*j=1;	break;
		case SDL_SCANCODE_LEFT:		*i=8;*j=2;	break;
		case SDL_SCANCODE_RIGHT:	*i=8;*j=3;	break;
		case SDL_SCANCODE_BACKSPACE:*i=8;*j=4;	break;
		case SDL_SCANCODE_TAB:		*i=8;*j=5;	break;
		case SDL_SCANCODE_ESCAPE:	*i=8;*j=6;	break;
		case SDL_SCANCODE_NONUSHASH:*i=8;*j=7;	break;

		case SDL_SCANCODE_EQUALS:		*i=9;*j=1;	break;
		case SDL_SCANCODE_LEFTBRACKET:	*i=9;*j=2;	break;
		case SDL_SCANCODE_RIGHTBRACKET:	*i=9;*j=3;	break;
		case SDL_SCANCODE_BACKSLASH:	*i=9;*j=4;	break;
		case SDL_SCANCODE_SLASH:		*i=9;*j=5;	break;
		case SDL_SCANCODE_LALT:			*i=9;*j=6;	break;
		case SDL_SCANCODE_RALT:			*i=9;*j=7;	break;
		//case SDL_SCANCODE_F1:					break;
		default:	break;
	}

	return (*i==-1)?0:1;
}

void emu_drawscreen(uint8_t *screenData)
{
	//int scanlineY;
	int y, x, r, c;
	//int adr;
	uint8_t *p;
	uint8_t ch, font_bits, bits, b;
	uint8_t color, color_idx_0, color_idx_1;
	uint8_t mc6847_gm, mc6847_css;

	// 256 x 192 x 2	gm: 111
	// 128 x 192 x 4	gm: 110
	// 128 x 192 x 2	gm: 101
	// 128 x 96 x 4		gm: 100
	// 128 x 96 x 2		gm: 011
	// 128 x 64 x 4 	gm: 010
	// 128 x 64 x 2		gm: 001
	// 64 x 64 x 4		gm: 000

	//memset(screenData, 0, 0xC000);
	if(vzcontext.latched_ga&0x08) {
		if(vzcontext.latched_ga&0x10)
			mc6847_css = 0x04;
		else
			mc6847_css = 0x00;

		mc6847_gm = (vzcontext.latched_shrg>>2)&0x07;

		switch(mc6847_gm) {
		case 0x07:
			{
				// 图形方式 256*192*2
				for(y=0;y<192;y++) {
					for(x=0;x<32;x++) {
						p = screenData+y*256+x*8;
						bits = vzcontext.vram[y*32 + x];
						for(c=0;c<8;c++) {
							color = ((bits>>7)&0x01) | 0x02 | mc6847_css;
							*p	= color;
							p++;
							bits<<=1;
						}
					}
				}
			}
		break;
		case 0x06:
			{
				// 图形方式 128*192*4
				for(y=0;y<192;y++) {
					for(x=0;x<32;x++) {
						p = screenData+y*256+x*4*2;
						bits = vzcontext.vram[y*32 + x];
						for(c=0;c<4;c++) {
							color = ((bits>>6)&0x03) | mc6847_css;
							*p	= color;
							p++;
							*p	= color;
							p++;
							bits<<=2;
						}
					}
				}
			}
		break;
		case 0x05:
			{
				// 图形方式 128*192*2
				for(y=0;y<192;y++) {
					for(x=0;x<16;x++) {
						p = screenData+y*256+x*8*2;
						bits = vzcontext.vram[y*16 + x];
						for(c=0;c<8;c++) {
							color = ((bits>>7)&0x01) | 0x02 | mc6847_css;
							*p	= color;
							p++;
							*p	= color;
							p++;
							bits<<=1;
						}
					}
				}
			}
		break;
		case 0x04:
			{
				// 图形方式 128*96*4
				for(y=0;y<96;y++) {
					for(x=0;x<32;x++) {
						p = screenData+y*2*256+x*4*2;
						bits = vzcontext.vram[y*32 + x];
						for(c=0;c<4;c++) {
							color = ((bits>>6)&0x03) | mc6847_css;
							*p	= color;
							p[256]	= color;
							p++;
							*p	= color;
							p[256]	= color;
							p++;
							bits<<=2;
						}
					}
				}
			}
		break;
		case 0x03:
			{
				// 图形方式 128*96*2
				for(y=0;y<96;y++) {
					for(x=0;x<16;x++) {
						p = screenData+y*2*256+x*8*2;
						bits = vzcontext.vram[y*16 + x];
						for(c=0;c<8;c++) {
							color = ((bits>>7)&0x01) | 0x02 | mc6847_css;
							*p	= color;
							p[256]	= color;
							p++;
							*p	= color;
							p[256]	= color;
							p++;
							bits<<=1;
						}
					}
				}
			}
		break;
		case 0x02:
			{
				// 图形方式 128*64*4
				for(y=0;y<64;y++) {
					for(x=0;x<32;x++) {
						p = screenData+y*3*256+x*4*2;
						bits = vzcontext.vram[y*32 + x];
						for(c=0;c<4;c++) {
							color = ((bits>>6)&0x03) | mc6847_css;
							p[    0]	= color;
							p[    1]	= color;
							p[256  ]	= color;
							p[256+1]	= color;
							p[512  ]	= color;
							p[512+1]	= color;
							p+=2;
							bits<<=2;
						}
					}
				}
			}
		break;
		case 0x01:
			{
				// 图形方式 128*64*2
				for(y=0;y<64;y++) {
					for(x=0;x<16;x++) {
						p = screenData+y*3*256+x*8*2;
						bits = vzcontext.vram[y*16 + x];
						for(c=0;c<8;c++) {
							color = ((bits>>7)&0x01) | 0x02 | mc6847_css;
							p[    0]	= color;
							p[    1]	= color;
							p[256  ]	= color;
							p[256+1]	= color;
							p[512  ]	= color;
							p[512+1]	= color;
							p+=2;
							bits<<=1;
						}
					}
				}
			}
		break;
		default:
			{
				// 图形方式 64*64*4
				for(y=0;y<64;y++) {
					for(x=0;x<16;x++) {
						p = screenData+y*3*256+x*4*4;
						bits = vzcontext.vram[y*16 + x];
						for(c=0;c<4;c++) {
							color = ((bits>>6)&0x03) | mc6847_css;
							p[    0]	= color;
							p[    1]	= color;
							p[    2]	= color;
							p[    3]	= color;
							p[256  ]	= color;
							p[256+1]	= color;
							p[256+2]	= color;
							p[256+3]	= color;
							p[512  ]	= color;
							p[512+1]	= color;
							p[512+2]	= color;
							p[512+3]	= color;
							p+=4;
							bits<<=2;
						}
					}
				}
			}
		}
 	} else {
		// 字符方式 32*16
		for(y=0;y<16;y++) {
			for(x=0;x<32;x++) {
				ch = vzcontext.vram[y*32 + x];
				if(ch&0x80) {
					// 图形字符
					color_idx_0 = 8;
					color_idx_1 = (ch&0x70)>>4;
				} else {
					color_idx_1 = 8;
					color_idx_0 = 0;
				}
				p = screenData+y*12*256+x*8;
				for(r=0;r<12;r++) {
					font_bits = vzcontext.mc8247font[ch*12+r];
					b = 1;
					for(c=0;c<8;c++) {
						//screenData[(y*12+r)*256+x*8+c] = (font_bits&b)?color_idx_0:color_idx_1;
						// 简单的优化
						*p = (font_bits&b)?color_idx_0:color_idx_1;
						p++;
						b<<=1;
					}
					// 下一行
					p+=256-8;
				}
			}
		}
	}
}
