#include <stdbool.h>
#include <stdint.h>
#include <string.h>
#include <stdio.h>

#include <SDL2/SDL.h>

#include "stb/bithacks.h"

//#define ENABLE_LOG
#include "stb/log.h"

#include "emu_core.h"

extern uint64_t ticks;
extern uint64_t cas_ticks;

extern unsigned int cycles_count;

extern int light_pen_btn;

void playSound();

uint8_t emu_fetch_byte(void *context, uint16_t adr)
{
	uint8_t x = emu_read_byte(context, adr);
/*
	DBG("fetch %04X %02X", adr, x);
	DBG("status %d  PC %04X  BC %04X  DE %04X  HL %04X  AF %04X\n", vzcontext.state.status, vzcontext.state.pc,
		vzcontext.state.registers.word[Z80_BC], vzcontext.state.registers.word[Z80_DE], vzcontext.state.registers.word[Z80_HL], vzcontext.state.registers.word[Z80_AF]
	);
*/
	return x;
}

uint16_t emu_fetch_word(void *context, uint16_t adr)
{
	uint16_t h, l;
	l = emu_fetch_byte(context, adr);
	h = emu_fetch_byte(context, adr+1);
	return (h<<8)|l;
}

const uint8_t uint8_b0 = 1;
const uint8_t uint8_b1 = 2;
const uint8_t uint8_b2 = 4;
const uint8_t uint8_b3 = 8;
const uint8_t uint8_b4 = 16;
const uint8_t uint8_b5 = 32;
const uint8_t uint8_b6 = 64;
const uint8_t uint8_b7 = 128;

const uint16_t uint16_b0 = 1;
const uint16_t uint16_b1 = 2;
const uint16_t uint16_b2 = 4;
const uint16_t uint16_b3 = 8;
const uint16_t uint16_b4 = 16;
const uint16_t uint16_b5 = 32;
const uint16_t uint16_b6 = 64;
const uint16_t uint16_b7 = 128;

/*
   KD5 KD4 KD3 KD2 KD1 KD0 扫描用地址
A0  R   Q   E       W   T  68FEH       0
A1  F   A   D  CTRL S   G  68FDH       8
A2  V   Z   C  SHFT X   B  68FBH      16
A3  4   1   3       2   5  68F7H      24
A4  M  空格 ，      .   N  68EFH      32
A5  7   0   8   -   9   6  68DFH      40
A6  U   P   I  RETN O   Y  68BFH      48
A7  J   ；  K   :   L   H  687FH      56
*/

// KD6 录音机输入

uint8_t emu_read_byte(void *context, uint16_t adr)
{
	uint8_t x = 0xff;
	uint16_t mask = 0x0001;
	uint8_t ch;

	x = ((VZCONTEXT *)context)->memory[adr&0xffff];

	if((adr&0xf800)==0x6800) {
		//D5~D0用于读键盘信息
		x = 0x00;

/*
		mame mc6847.cpp
		逐行NTSC
		The MC6847 datasheet states that a scanline is 227.5 clock cycles, but experimentation suggests that it is 228.
		Field Sync: Total Period 262*228 clock cycles
			@ CLK(0) + DFS_F            - falling edge (high to low)
			@ CLK(32*228) + DFS_R       - rising edge (low to high)
			@ CLK(262*228) + DFS_F      - falling edge (high to low) (262.5 for the M6847Y)
*/

		// 逐行NTSC 可见区域 Top 25 + 192 + Bottom 26
		// 逐行NTSC 整体 Blanking 13 + 25 + 192 + 26 + Retrace 6
		// 逐行PAL制 如何划分312行，暂未查到资料

		// 70980 = 312*227.5
		// 50*312*227.5*5
		//if(cycles_count<(70980*(262-6)/312))
		// 70980*6/312 = 1365
	
		// 来自 MC4847 手册
		// MC6847 逐行NTSC
		// MC6847Y 隔行NTSC
		// MC6847P 逐行PAL
		
		// 时钟频率 f
		// LASER310 PAL 是晶振4分频4.375MHz

		// 每行扫描时间 tPHST = 227.5*(1/f)

		// 每帧时间 tPFS
		// MC6847  tPFS = 262   *tPHS
		// MC6847Y tPFS = 262.5 *tPHS
		// MC6847P tPFS = ????? *tPHS

		// 垂直回扫时间 tWFS
		// MC6847  tWFS = 32 * tPHST
		// MC6847Y tWFS = 32 * tPHST
		// MC6847P tWFS = ?? * tPHST
		
		// 水平回扫时间 tWHS
		// tWHS = 16.5*1/f-tDHSF+tDHSr

		//MC6847：KD7连接IC15第37脚（垂直同步信号/FS，即CPU的/INT请求信号，在场扫描期间为1，场消隐期间为0）
		// 每行扫描时间 tPHST = 227.5*(1/f)
		// 垂直回扫时间 tWFS
		// MC6847  tWFS = 32 * tPHST
		// MC6847Y tWFS = 32 * tPHST
		// MC6847P tWFS = ?? * tPHST

		// 垂直回扫 MC4847	/FS
		if(cycles_count<70980*32/312)
			B_SET(x,7);	// 这里是正向，函数最后有一句 x = ~x

		for(int i=0;i<8;i++) {
			if(!(adr&mask)) {
				x |= ((VZCONTEXT *)context)->scancode[i];
				x |= ((VZCONTEXT *)context)->vscancode[i];
			}
			mask <<=1;
		}

		// 扩展按键  scancode[8] 上下左右 Backspace TAB ESC `  scancode[9] = [ ] \ / LALT RALT
		ch = ((VZCONTEXT *)context)->scancode[8];
		// ESC    CTRL + -
		if(B_IS_SET(ch, 6)) {
			if(!(adr&uint16_b1))	B_SET(x,2);	// ctrl
			if(!(adr&uint16_b5))	B_SET(x,2);	// -
		}
		// 退格键 CTRL + M
		if(B_IS_SET(ch, 4)) {
			if(!(adr&uint16_b1))	B_SET(x,2);	// ctrl
			if(!(adr&uint16_b4))	B_SET(x,5);	// m
		}

		// KD6 录音机输入
		if(cas_ticks) {
			if(cas_read(ticks-cas_ticks)) x|=0x40;
		}

		x = ~x;
	}

	if((adr&0xf800)==0x7000) {
		x = ((VZCONTEXT *)context)->vram[(adr&0x07ff)+0x0800*(vzcontext.latched_shrg&0x03)];
	}

	//if((adr&0xff00)==0xff00) x = 0xff;
	//LOG("BR %04X %02X", adr, x);

	return x;
}

uint16_t emu_read_word(void *context, uint16_t adr)
{
	uint16_t h, l;
	l = emu_read_byte(context, adr);
	h = emu_read_byte(context, adr+1);
	return (h<<8)|l;
}

uint8_t emu_write_byte(void *context, uint16_t adr, uint8_t x)
{
	uint8_t last_x, cur_x;
	if((adr&0xf800)==0x6800) {
		// D5，D0 扬声器 00 11 都是无声 10 01 不同则发声
		last_x = ((VZCONTEXT *)context)->latched_ga&0x21;
		cur_x = x&0x21;
		if((cur_x==0x20||cur_x==0x01) && last_x!=cur_x)
			playSound();

		((VZCONTEXT *)context)->latched_ga = x;
		if(vzcontext.state.pc>=0x7800)
			LOG("%04X GA W %02X %d\n", vzcontext.state.pc, x&0x10, cycles_count);
	}
	if((adr&0xf800)==0x7000) {
		((VZCONTEXT *)context)->vram[(adr&0x07ff)+0x0800*(vzcontext.latched_shrg&0x03)] = x;
	}
	if(adr>=0x7800) {
		((VZCONTEXT *)context)->memory[adr&0xffff] = x;
	}

	//LOG("BW %04X %02X", adr, x);

	return x;
}

uint16_t emu_write_word(void *context, uint16_t adr, uint16_t x)
{
	emu_write_byte(context, adr, x&0xff);
	emu_write_byte(context, adr+1, (x>>8)&0xff);

	return x;
}


uint8_t emu_sysio_input(void *context, uint8_t port)
{
	uint8_t x = 0xff;
	uint8_t ch;

	// joystick
	if((port&0xF0)==0x20) {
		// joystick 1
		if(!(port&0x01)) {
			// 键盘模拟游戏杆输入 上下左右 tab `
			ch = ((VZCONTEXT *)context)->scancode[8];
			if(ch&0x01) B_UNSET(x,0);
			if(ch&0x02) B_UNSET(x,1);
			if(ch&0x04) B_UNSET(x,2);
			if(ch&0x08) B_UNSET(x,3);
			if(ch&0x20) B_UNSET(x,4);	// tab
		}
		if(!(port&0x02)) {
			// 键盘模拟游戏杆输入
			ch = ((VZCONTEXT *)context)->scancode[8];
			if(ch&0x80) B_UNSET(x,4);	// `
		}
/*	
		// joystick 2
		if(!(port&0x04)) {
			// 键盘模拟游戏杆输入  上下左右 tab `
			ch = ((VZCONTEXT *)context)->scancode[8];
			if(ch&0x01) B_UNSET(x,0);
			if(ch&0x02) B_UNSET(x,1);
			if(ch&0x04) B_UNSET(x,2);
			if(ch&0x08) B_UNSET(x,3);
			if(ch&0x20) B_UNSET(x,4);	// tab
		}
		if(!(port&0x08)) {
			// 键盘模拟游戏杆输入
			ch = ((VZCONTEXT *)context)->scancode[8];
			if(ch&0x80) B_UNSET(x,4);	// `
		}
*/
	}

	// LIGHT PEN
	if((port&0xF0)==0x40) {
		// 光笔是否触发
		if(light_pen_btn) B_UNSET(x,6);

		// 光笔当前位置亮度
		B_SET(x,7);
		//B_UNSET(x,7);

		if(light_pen_btn) {
			int w, h;
			SDL_Window *wdo = SDL_GetMouseFocus();
			SDL_GetWindowSize(wdo, &w, &h);

			int xx,yy;
			SDL_GetMouseState(&xx, &yy);

			if(xx>=0 && xx<w && yy>=0 && yy<h) {
				//LOG("%d %d\n", xx, yy);
				// 128 x 64
				int xxx = xx*256/w;
				int yyy = yy*192/h;
				xxx = xxx/2;
				yyy = yyy/3;

				// 判断CRT屏幕电子束的位置
				// 312*227.5
				// 7BAE 00 0 ( 13,10) ( 323 2) 15779 0000 0 0 : 1
				// 15779/227.5= 69.36
				// 21692/227.5= 95.35

				int d=(yyy*3+95)*455/2 + 94 + xxx;
				//int d=(yyy*3+95)*455/2 + 95 + xxx;
				//int d=(yyy*3+95)*455/2 + 96 + xxx;
				//int d=(yyy*3+95)*455/2 + 100 + xxx;
				LOG("%04X %d %d : %d %d\n", vzcontext.state.pc, xxx, yyy, d, cycles_count);
				// 光笔程序两次采样相隔22个CPU时钟周期。
				//if(cycles_count>=d && cycles_count<d+33) {
				//if(cycles_count>=d && cycles_count<d+25) {
				if(cycles_count>=d && cycles_count<d+24) {

					int n = 3-(xxx&0x03);
					uint8_t bits = ((VZCONTEXT *)context)->vram[yyy*128/4+xxx/4];
					uint8_t b = (bits>>(n*2))&0x03;

					int css = (((VZCONTEXT *)context)->latched_ga&0x10)?0x04:0x00;


					// 在绿色背景下，0表示绿色，1表示黄色，2表示兰色、3表示红色
					// 在淡黄色背景下，0表示淡黄色，1表示淡绿色，2表示紫色、3表示橙色
					//int lp_c[8] = {1,0,1,1, 0,1,1,1};
					int lp_c[8] = {1,0,1,1, 0,0,1,1};

					// 1 ? ? ?  0 ? ? ?
					// 1 0 1 ?  0 ? ? ? 

					LOG("%04X %02X %d (%3d,%2d) (%4d %d) %d %04X %d %d : %d\n", vzcontext.state.pc, bits, b, xxx, yyy, yyy*128/4+xxx/4, n,  cycles_count, vzcontext.state.registers.word[Z80_HL], css, b, lp_c[css+b]);

					if(!lp_c[css+b]) B_UNSET(x,7);
				}

			}
		}
	}

/*
	//if(port==ADDRESS_IO_FDC_CT||port==ADDRESS_IO_FDC_DATA||port==ADDRESS_IO_FDC_POLL||port==ADDRESS_IO_FDC_WP)
	if(port==ADDRESS_IO_FDC_WP)
		x = 0;
		//x = 0x80;

	if(port==ADDRESS_IO_FDC_POLL) {
		x = fdc_io_poll();
		//int c = fdc_io_cycles();
		//uint16_t pc = ((VZCONTEXT *)context)->state.pc;
		//if(pc==0x5663 || pc==0x5675 || pc==0x5685)
		//	LOG("adr %04X: FDC_POLL %02X, %02X (%d : %s %02x %02x %d)",((VZCONTEXT *)context)->state.pc,port,x, fd_pos, fd_date_d1(), fd_poll_dat_d1, fdc_dat_latch, c);
	}

	// IDAM 0xFE, 0xE7, 0x18, 0xC3
	if(port==ADDRESS_IO_FDC_DATA) {
		x = fdc_io_data();
		//int c = fdc_io_cycles();
		//uint16_t pc = ((VZCONTEXT *)context)->state.pc;
		//if(pc==0x5542&&x==0xFE || pc==0x55C7&&x==0xE7 || pc==0x564C&&x==0x18 || pc==0x5673 || pc==0x5683 || pc==0x56D1 || pc==0x5746)
		//if(pc==0x5673 || pc==0x5683 || pc==0x56D1 || pc==0x5746)
		//	LOG("adr %04X: FDC_DATA %02X, %02X (%d : %s %02x %02x %d)",((VZCONTEXT *)context)->state.pc,port,x, fd_pos, fd_date_d1(), fd_poll_dat_d1, fdc_dat_latch, c);

		//if(pc==0x57E6 || pc==0x5873) {	// IDAM
		//	fd_idam_sec = ((VZCONTEXT *)context)->state.registers.byte[Z80_D];
		//	LOG("adr %04X: FDC_DATA %02X, %02X (%d : S%02X)",((VZCONTEXT *)context)->state.pc,port,x, fd_pos, fd_idam_sec);
		//}


		// 引入读盘偏差
//		if(pc==0x57E6) {
//			fd_pos += rand()%5;
//			if(fd_pos>=FD_TRACK_LEN) fd_pos -= FD_TRACK_LEN;
//		}
	}
*/

	//LOG("in %d, %02x\n", port, x);

	return x;
}

uint8_t emu_sysio_output(void *context, uint8_t port, uint8_t x)
{
	//DBG("out %d, %02x", port, x);
	//LOG("out %d, %02x\n", port, x);

	if(port==32||port==222)
		vzcontext.latched_shrg = x;

/*
	if(port==ADDRESS_IO_FDC_CT)
		fdc_io_ct(x);
*/

	return x;
}

/*
void emu_video_retrace(void *context)
{
}
*/

