#ifndef C_DEFS_H_
#define C_DEFS_H_

#include <stddef.h>
#include <stdio.h>

#define C_DEFS_FILE	"c_defs.txt"

inline static __attribute__((constructor))
void c_defs_check(void)
{
	FILE* fp = fopen(C_DEFS_FILE, "w");
	if(!fp) {
		fp = stderr;
		fprintf(stderr, "Cannot open dbg file '%s'\n", C_DEFS_FILE);
	}

	#ifdef WIN32
	fprintf(fp, "WIN32\n");
	#endif

	#ifdef WIN64
	fprintf(fp, "WIN64\n");
	#endif

	#ifdef _WIN32
	fprintf(fp, "_WIN32\n");
	#endif

	#ifdef __MINGW32__
	fprintf(fp, "__MINGW32__\n");
	#endif

	#ifdef __MINGW64__
	fprintf(fp, "__MINGW64__\n");
	#endif

	#ifdef _MSC_VER
	fprintf(fp, "_MSC_VER = %d\n", _MSC_VER);
	#endif

	#ifdef __GNUC__
	fprintf(fp, "__GNUC__ = %d\n", __GNUC__);
	#endif

	#ifdef __GNUC_MINOR__
	fprintf(fp, "__GNUC_MINOR__ = %d\n",__GNUC_MINOR__);
	#endif

	fprintf(fp, "true              = %d\n",	true);
	fprintf(fp, "false             = %d\n",	false);
	fprintf(fp, "sizeof(bool)      = %d\n",	sizeof(bool));
	fprintf(fp, "sizeof(short)     = %d\n",	sizeof(short));
	fprintf(fp, "sizeof(int)       = %d\n",	sizeof(int));
	fprintf(fp, "sizeof(long)      = %d\n",	sizeof(long));
	fprintf(fp, "sizeof(long long) = %d\n",	sizeof(long long));
	fprintf(fp, "sizeof(void*)     = %d\n",	sizeof(void*));
	fprintf(fp, "sizeof(uint8_t)   = %d\n",	sizeof(uint8_t));
	fprintf(fp, "sizeof(uint16_t)  = %d\n",	sizeof(uint16_t));
	fprintf(fp, "sizeof(uint32_t)  = %d\n",	sizeof(uint32_t));
	fprintf(fp, "sizeof(uint64_t)  = %d\n",	sizeof(uint64_t));
	fprintf(fp, "sizeof(int8_t)    = %d\n",	sizeof(int8_t));
	fprintf(fp, "sizeof(int16_t)   = %d\n",	sizeof(int16_t));
	fprintf(fp, "sizeof(int32_t)   = %d\n",	sizeof(int32_t));
	fprintf(fp, "sizeof(int64_t)   = %d\n",	sizeof(int64_t));
	fprintf(fp, "sizeof(size_t)    = %d\n",	sizeof(size_t));
	fprintf(fp, "sizeof(ssize_t)   = %d\n",	sizeof(ssize_t));
	fprintf(fp, "sizeof(fpos_t)    = %d\n",	sizeof(fpos_t));
	fprintf(fp, "sizeof(off_t)     = %d\n",	sizeof(off_t));
	fprintf(fp, "sizeof(off64_t)   = %d\n",	sizeof(off64_t));

	#ifdef _FILE_OFFSET_BITS
	fprintf(fp, "_FILE_OFFSET_BITS = %d\n",	_FILE_OFFSET_BITS);
	#endif

	fclose(fp);
}

#endif	// C_DEFS_H_
