#ifndef SDL_IME_H_
#define SDL_IME_H_

#ifdef _WIN32

#include <windows.h>
#include <imm.h>
#include <SDL2/SDL_syswm.h>


// 禁用中文输入法
void SDL_IME_Disable(SDL_Window *wdo)
{
	SDL_SysWMinfo wmInfo;
	SDL_VERSION(&wmInfo.version);
	SDL_GetWindowWMInfo(wdo, &wmInfo);
	HWND hwnd = wmInfo.info.win.window;

	// 无效
	ImmDisableIME(GetCurrentThreadId());

	// 切换为英文输入法
	//const char en_US[] = "00000409";
	//const char cn_ZH[] = "00000804";
	//LoadKeyboardLayout(en_US, KLF_ACTIVATE)
	//LoadKeyboardLayout(cn_ZH, KLF_ACTIVATE)
	//PostMessage(hwnd, WM_INPUTLANGCHANGEREQUEST, IntPtr.Zero, (LPARAM)LoadKeyboardLayout(en_US, KLF_ACTIVATE));

	//const char en_US[] = "00000409";
	//PostMessage(hwnd, WM_INPUTLANGCHANGEREQUEST, (WPARAM)TRUE, (LPARAM)LoadKeyboardLayout(en_US, KLF_ACTIVATE));


	// 切换窗口后，仍然会出现输入法
	ImmAssociateContextEx(hwnd, NULL, IACE_IGNORENOCONTEXT);
	//ImmAssociateContextEx(hwnd, NULL, 0);
	//HIMC g_hIMC = NULL;//g_hIMC 用于恢复时使用
	//g_hIMC = ImmAssociateContext(hwnd, NULL);//handle 为要禁用的窗口句柄
	//ImmAssociateContext(handle, g_hIMC);//handle 为要启用的窗口句柄

	HIMC hImcId = ImmGetContext(hwnd);
	ImmReleaseContext(hwnd, hImcId);
}

#else
void SDL_IME_Disable(SDL_Window *wdo);
#endif

#endif	// SDL_IME_H_
