#include <stdint.h>
#include <string.h>

#include "vz.h"


uint32_t vz_parse(uint8_t* buf, uint32_t buf_len, uint8_t* vz_name, uint8_t *vz_type, uint16_t *vz_start, uint16_t *vz_len, uint8_t *dat)
{
	uint32_t	c, fn_len;
	uint16_t	vzf_len;
	vz_header*	h;

	*vz_type = 0;
	*vz_start = 0;
	*vz_len = 0;
	vz_name[0] = 0;
 
	if(buf_len <= sizeof(vz_header))	return 0;

	h = (vz_header*)buf;
	vzf_len = buf_len - sizeof(vz_header);

	//printf("VZF_MAGIC %02X %02X %02X %02X\n", buf[0], buf[1], buf[2], buf[3]);

	//VZF_MAGIC 0x56 0x5a 0x46 0x30 VZF
	//VZF_MAGIC 0x56 0x5a 0x46 0x4F VZFO
	//VZF_MAGIC 0x20 0x20 0x00 0x00

	if( !(h->vz_magic == VZ_MAGIC || h->vz_magic == VZ_MAGIC1 || h->vz_magic == VZ_MAGIC2) ) return 0;

	*vz_len = vzf_len;


	// VZF_FILENAME
	for(c=0;c<17;c++)
		if(h->vz_name[c]=='\0') break;
	fn_len = c;

	for(c=0;c<fn_len;c++)
		vz_name[c] = h->vz_name[c];
	vz_name[fn_len]=0;


	// VZF_TYPE
	*vz_type = h->vz_type;

	// VZF_STARTADDR
	*vz_start = h->vz_start;

	if((uint32_t)vzf_len + (*vz_start) >= 0x10000)	return 0;

	memcpy(dat, h->dat, vzf_len);

	return vzf_len;
}

int vz_load(VZCONTEXT *context, uint8_t vz_type, uint16_t vz_start, uint16_t vz_len, uint8_t *dat)
{
	uint16_t end;
	end = vz_start + vz_len;

	if((uint32_t)vz_start + vz_len >= 0x10000) return 0;

	switch(vz_type) {
	case VZ_BASIC:
		memcpy(context->memory+vz_start, dat, vz_len);
		context->memory[0x78a4] = vz_start % 256; /* start of basic program */
		context->memory[0x78a5] = vz_start / 256;
		context->memory[0x78f9] = end % 256; /* end of basic program */
		context->memory[0x78fa] = end / 256;
		context->memory[0x78fb] = end % 256; /* start variable table */
		context->memory[0x78fc] = end / 256;
		context->memory[0x78fd] = end % 256; /* start free mem, end variable table */
		context->memory[0x78fe] = end / 256;
		break;

	case VZ_MCODE:
		memcpy(context->memory+vz_start, dat, vz_len);
		context->memory[0x788e] = vz_start % 256; /* usr subroutine address */
		context->memory[0x788f] = vz_start / 256;
		context->state.pc = vz_start;
		break;

	default:
		return 0;
		//image.seterror(IMAGE_ERROR_UNSUPPORTED, "Snapshot format not supported.");
		//image.message("Snapshot format not supported.");
		//return image_init_result::FAIL;
	}

	return 1;
}

int vz_save(VZCONTEXT *context, uint8_t vz_type, uint8_t *fn, uint8_t *buf)
{
	vz_header	*ph;
	uint8_t		*mem;
	uint16_t	vz_start;
	uint16_t	vz_end;
	uint16_t	vz_len;

	uint8_t		ch;
	uint8_t		*p;
	int			l;

	mem = context->memory;


	ph = (vz_header	*)buf;
	ph->vz_magic = VZ_MAGIC;
	memset(ph->vz_name,0,17);
	ph->vz_type = vz_type;
	ph->vz_start = 0;

	// 文件名
	memset(fn,0,18);

	// 以下四个偏移适合 LASER310 BASIC V2.0
	p = mem+0x7A9D;
	l = mem[0x7AD6];	// 文件名包括0结尾长度

	for(int i=0;i<17;i++) {
		if(i>=l) break;
		ph->vz_name[i] = p[i];
		fn[i] = p[i];
	}

	// 替换 fn 非 字母 数字
	for(int i=0;i<17;i++) {
		ch = fn[i];
		if(!ch) break;
		if(ch>='A'&&ch<='Z') continue;
		if(ch>='0'&&ch<='9') continue;
		if(ch=='-'||ch<='('||ch<=')') continue;
		fn[i] = '_';
	}

	vz_start = *(uint16_t*)(mem+0x78A4);
	vz_end = *(uint16_t*)(mem+0x78F9);
	if(vz_end<=vz_start) return 0;
	vz_len = vz_end-vz_start;

	ph->vz_start = vz_start;
	memcpy(ph->dat, mem+vz_start, vz_len);

	return sizeof(vz_header)+vz_len;
}