import os

verbose=False

#verbose=True

skip_bas_file=False
#skip_bas_file=True

#用来对抗简单的修改入口加密
vz_hackaddr = 0

#65535 POKE30884,198:POKE30885,125:RUN
#78A4:C6 7D
#vz_hackaddr = 0x7DC6

def get_u16(buf):
    return (buf[1]<<8)+buf[0]

def px_u8(v):
    print("%02X"%v,end='')

def px_u16(v):
    print("%04X"%v,end='')

def px_u8_r(v):
    print("%02X"%v)

def px_u16_r(v):
    print("%04X"%v)

def str_u8(v):
    return "%02X"%v

def str_u16(v):
    return "%04X"%v

def str_list_u8(a):
    return "".join(["%02X"%n for n in a])


#全局变量
g_buf = []
g_c = 0

def g_list(n=1):
    global g_buf, g_c
    buf = g_buf[g_c:g_c+n]
    g_c+=n
    return buf

def g_tail():
    global g_buf, g_c
    sz = len(g_buf)
    buf = g_buf[g_c:sz]
    g_c=sz
    return buf

def g_u16():
    global g_buf, g_c
    v = (g_buf[g_c+1]<<8)+g_buf[g_c]
    g_c+=2
    return v

def g_u8():
    global g_buf, g_c
    v = g_buf[g_c]
    g_c+=1
    return v

def g_ch():
    global g_buf, g_c
    v = g_buf[g_c]
    g_c+=1
    return chr(v)

def g_u8_pos(pos):
    global g_buf
    return g_buf[pos]

def g_off():
    global g_c
    return g_c

def g_len():
    global g_buf
    return len(g_buf)

def g_tail_len():
    global g_buf, g_c
    return len(g_buf)-g_c

def g_empty(n=1):
    global g_buf, g_c
    return g_c+n>len(g_buf)

def g_next(n=1):
    global g_buf, g_c
    return g_c+n-1<len(g_buf)

# LASER 310 关键字

def vz_key(v,is_str):
    vkey = [
        "END","FOR","RESET","SET","CLS","RANDOM","   ","NEXT","DATA","INPUT",
        "DIM","READ","LET","GOTO","RUN","IF","RESTORE","GOSUB","RETURN","REM",
        "STOP","ELSE","COPY","COLOR","VERIFY","DEFINT","DEFSNG","DEFDBL","CRUN",
        "MODE","SOUND","RESUME","OUT","   ","DEFSTR","ERROR","   ","   ","TROFF",
        "TRON","MERGE","   ","ON","RENUM","   ","   ","   ",
        "LPRINT","   ","POKE","PRINT","CONT","LIST","LLIST","DELETE","AUTO",
        "CLEAR","CLOAD","CSAVE","NEW","TAB(","TO","   ","USING","VARPTR","USR",
        "ERL","ERR","STRING$","   ","POINT","   ","MEM","INKEY$","THEN","NOT",
        "STEP","+","-","*","/","^","AND","OR",">","=","<","SGN","INT","ABS",
        "FRE","INP","POS","SQR","RND","LOG","EXP","COS","SIN","TAN","ATN",
        "PEEK","   ","   ","   ","   ","   ","   ","   ",
        "   ","   ","   ","   ","   ","FIX","LEN","STR$","VAL","ASC",
        "CHR$","LEFT$","RIGHT$","MID$",
        "   ","   ","   ","   ","   ",]

    if v==0x00:
        return "\n"

    if v>=0x80:
        return chr(v-0x80) if is_str else vkey[v-0x80]
    return chr(v)


def dat2bas(dat,line_max=100000):
    global g_buf, g_c
    g_buf = dat
    g_c = 0

    s = ""

    line_c = 0
    cur_off = vz_startaddr

    while vz_hackaddr>cur_off:
        if g_empty(): break
        g_u8()
        cur_off+=1

    while g_next():
        #break
        # 下一行地址
        line_s = ""
        if g_empty(2): break
        start_addr = g_off()
        if g_empty(2): break
        off = g_u16()
        if off==0: break
        # 行号
        if g_empty(2): break
        line = g_u16()
        n = off-cur_off-4

        if verbose: line_s += "%04X %04X %04X %3d: "%(start_addr+4+17+1+2, line, off, n)

        line_s += "%d "%line

        is_str = False
        for i in range(n):
            if g_empty(): break
            ch = g_u8()
            if ch==ord('"'): is_str = not is_str
            line_s += vz_key(ch,is_str)
        
        cur_off = off

        line_c+=1
        #px_u16_r(off)
        #print(g_off(),g_len())

        if verbose: print(line_s)
        s+=line_s

        if g_empty(): break

        if line_c>=line_max: break

    return s

pathsep=os.path.sep
in_filepath = "./vz_files" #输入路径
out_filepath = "./bas_files" #输出路径
filename_lst = os.listdir(in_filepath) #得到文件夹下的所有文件名称

for base_name in filename_lst:
    fn = in_filepath+pathsep+base_name
    file_name, fn_ext = os.path.splitext(base_name)
    if not os.path.isfile(fn): continue
    if fn_ext.lower()!=".vz": continue
    #print(fn)
    print(base_name)

    f = open(fn, "rb")
    buf = f.read()
    #print(buf)
    f.close()
    #print(len(buf))

    buf = list(buf)

    vzf_magic = [   [0x20, 0x20, 0x00, 0x00],
                    [0x56, 0x5A, 0x46, 0x30],
                    [0x56, 0x5A, 0x46, 0x4F],]

    g_buf = buf
    g_c = 0

    vz_magic = g_list(4)
    if not vz_magic in vzf_magic:
        print("格式错误 vz_magic", vz_magic)
        quit()

    vz_filename = g_list(17)
    vz_type = g_u8()
    vz_startaddr = g_u16()
    vz_dat = g_tail()

    bas_fn = ""
    for i in range(17):
        ch=vz_filename[i]
        if ch==0: break
        bas_fn += chr(ch)

    vz_endaddr = vz_startaddr + len(vz_dat)
    sum = 0
    sum +=  vz_startaddr      & 0xFF
    sum += (vz_startaddr >>8) & 0xFF
    sum +=  vz_endaddr      & 0xFF
    sum += (vz_endaddr >>8) & 0xFF
    for n in vz_dat:
        sum += n

    sum = sum & 0xFFFF

    bas = ""
    #print(str_u8(vz_type), str_u16(vz_startaddr), str_u16(sum), bas_fn, vz_magic)
    
    #bas += "type:%s start:%s sum:%s [%s] magic:%s\n"%(str_u8(vz_type), str_u16(vz_startaddr), str_u16(sum), bas_fn, str_list_u8(vz_magic))
    bas += "%s %s %s %s\n"%(str_u8(vz_type), str_u16(vz_startaddr), str_u16(sum), bas_fn)

    if vz_type != 0xF0:
        #print("skip")
        print(bas,end="")
        continue

    #print(len(vz_dat))
    #print(vz_dat)

    print(bas)
    #bas += dat2bas(vz_dat,2)
    #bas += dat2bas(vz_dat,3)
    #print(bas,dat2bas(vz_dat,2),end="")

    if skip_bas_file:
        continue


    bas += dat2bas(vz_dat)
    #print(bas,end="")

    #print()
    #continue

    bas_fn = "%s.bas"%file_name
    out_fn = out_filepath+pathsep+bas_fn
    print(out_fn)
    with open(out_fn,"w") as f:
        f.write(bas)

    None
