uniform sampler2D color_texture;
uniform vec2 color_texture_sz; // The actual resolution of the game content

varying vec2 texCoord;

void main()
{
    vec4 color = texture2D(color_texture, texCoord);

    float intensity = 0.85;
    float frequency = 2.0;

    float scanline = sin(texCoord.y * color_texture_sz.y * 3.14159 * frequency);
    float darken = intensity + (1.0-intensity) * scanline;
    gl_FragColor = vec4(color.rgb*1.02 * darken, color.a);
}