(function () {
  "use strict";

  // m_a6502CodeList from 6502.c, converted to compact tuples:
  // [opcodeByte, opcodeId, cycles, addressType]
  // addressType matches AT_* numeric IDs in 6502.c.
  const CODE_LIST = [
    [0xa9, 0, 2, 0],
    [0xad, 0, 4, 1],
    [0xa5, 0, 3, 2],
    [0xa1, 0, 6, 5],
    [0xb1, 0, 5, 6],
    [0xb5, 0, 4, 7],
    [0xbd, 0, 4, 9],
    [0xb9, 0, 4, 10],
    [0xa2, 1, 2, 0],
    [0xae, 1, 4, 1],
    [0xa6, 1, 3, 2],
    [0xb6, 1, 4, 8],
    [0xbe, 1, 4, 10],
    [0xa0, 2, 2, 0],
    [0xac, 2, 4, 1],
    [0xa4, 2, 3, 2],
    [0xb4, 2, 4, 7],
    [0xbc, 2, 4, 9],
    [0x8d, 3, 4, 1],
    [0x85, 3, 3, 2],
    [0x81, 3, 6, 5],
    [0x91, 3, 6, 6],
    [0x95, 3, 4, 7],
    [0x9d, 3, 5, 9],
    [0x99, 3, 5, 10],
    [0x8e, 4, 4, 1],
    [0x86, 4, 3, 2],
    [0x96, 4, 4, 8],
    [0x8c, 5, 4, 1],
    [0x84, 5, 3, 2],
    [0x94, 5, 4, 7],
    [0xaa, 6, 2, 4],
    [0xa8, 7, 2, 4],
    [0xba, 8, 2, 4],
    [0x8a, 9, 2, 4],
    [0x9a, 10, 2, 4],
    [0x98, 11, 2, 4],
    [0x69, 12, 2, 0],
    [0x6d, 12, 4, 1],
    [0x65, 12, 3, 2],
    [0x61, 12, 6, 5],
    [0x71, 12, 5, 6],
    [0x75, 12, 4, 7],
    [0x7d, 12, 4, 9],
    [0x79, 12, 4, 10],
    [0x29, 13, 2, 0],
    [0x2d, 13, 4, 1],
    [0x25, 13, 3, 2],
    [0x21, 13, 6, 5],
    [0x31, 13, 5, 6],
    [0x35, 13, 4, 7],
    [0x3d, 13, 4, 9],
    [0x39, 13, 4, 10],
    [0x49, 14, 2, 0],
    [0x4d, 14, 4, 1],
    [0x45, 14, 3, 2],
    [0x41, 14, 6, 5],
    [0x51, 14, 5, 6],
    [0x55, 14, 4, 7],
    [0x5d, 14, 4, 9],
    [0x59, 14, 4, 10],
    [0x09, 15, 2, 0],
    [0x0d, 15, 4, 1],
    [0x05, 15, 3, 2],
    [0x01, 15, 6, 5],
    [0x11, 15, 5, 6],
    [0x15, 15, 4, 7],
    [0x1d, 15, 4, 9],
    [0x19, 15, 4, 10],
    [0xe9, 16, 2, 0],
    [0xed, 16, 4, 1],
    [0xe5, 16, 3, 2],
    [0xe1, 16, 6, 5],
    [0xf1, 16, 5, 6],
    [0xf5, 16, 4, 7],
    [0xfd, 16, 4, 9],
    [0xf9, 16, 4, 10],
    [0xce, 17, 6, 1],
    [0xc6, 17, 5, 2],
    [0xd6, 17, 6, 7],
    [0xde, 17, 7, 9],
    [0xca, 18, 2, 4],
    [0x88, 19, 2, 4],
    [0xee, 20, 6, 1],
    [0xe6, 20, 5, 2],
    [0xf6, 20, 6, 7],
    [0xfe, 20, 7, 9],
    [0xe8, 21, 2, 4],
    [0xc8, 22, 2, 4],
    [0x0e, 23, 6, 1],
    [0x06, 23, 5, 2],
    [0x0a, 23, 2, 3],
    [0x16, 23, 6, 7],
    [0x1e, 23, 7, 9],
    [0x4e, 24, 6, 1],
    [0x46, 24, 5, 2],
    [0x4a, 24, 2, 3],
    [0x56, 24, 6, 7],
    [0x5e, 24, 7, 9],
    [0x2e, 25, 6, 1],
    [0x26, 25, 5, 2],
    [0x2a, 25, 2, 3],
    [0x36, 25, 6, 7],
    [0x3e, 25, 7, 9],
    [0x6e, 26, 6, 1],
    [0x66, 26, 5, 2],
    [0x6a, 26, 2, 3],
    [0x76, 26, 6, 7],
    [0x7e, 26, 7, 9],
    [0x2c, 27, 4, 1],
    [0x24, 27, 3, 2],
    [0xc9, 28, 2, 0],
    [0xcd, 28, 4, 1],
    [0xc5, 28, 3, 2],
    [0xc1, 28, 6, 5],
    [0xd1, 28, 5, 6],
    [0xd5, 28, 4, 7],
    [0xdd, 28, 4, 9],
    [0xd9, 28, 4, 10],
    [0xe0, 29, 2, 0],
    [0xec, 29, 4, 1],
    [0xe4, 29, 3, 2],
    [0xc0, 30, 2, 0],
    [0xcc, 30, 4, 1],
    [0xc4, 30, 3, 2],
    [0x90, 31, 2, 11],
    [0xb0, 32, 2, 11],
    [0xf0, 33, 2, 11],
    [0x30, 34, 2, 11],
    [0xd0, 35, 2, 11],
    [0x10, 36, 2, 11],
    [0x50, 37, 2, 11],
    [0x70, 38, 2, 11],
    [0x00, 39, 7, 4],
    [0x4c, 40, 3, 1],
    [0x6c, 40, 5, 12],
    [0x20, 41, 6, 1],
    [0xea, 42, 2, 4],
    [0x40, 43, 6, 4],
    [0x60, 44, 6, 4],
    [0x18, 45, 2, 4],
    [0xd8, 46, 2, 4],
    [0x58, 47, 2, 4],
    [0xb8, 48, 2, 4],
    [0x38, 49, 2, 4],
    [0xf8, 50, 2, 4],
    [0x78, 51, 2, 4],
    [0x48, 52, 3, 4],
    [0x08, 53, 3, 4],
    [0x68, 54, 4, 4],
    [0x28, 55, 4, 4],
    [0xa7, 57, 3, 2],
    [0xb7, 57, 4, 8],
    [0xaf, 57, 4, 1],
    [0xbf, 57, 4, 10],
    [0xa3, 57, 6, 5],
    [0xb3, 57, 5, 6],
    [0x07, 58, 5, 2],
    [0x17, 58, 6, 7],
    [0x0f, 58, 6, 1],
    [0x1f, 58, 7, 9],
    [0x1b, 58, 7, 10],
    [0x03, 58, 8, 5],
    [0x13, 58, 8, 6],
    [0x1a, 42, 2, 4],
    [0x3a, 42, 2, 4],
    [0x5a, 42, 2, 4],
    [0x7a, 42, 2, 4],
    [0xda, 42, 2, 4],
    [0xfa, 42, 2, 4],
    [0xab, 59, 2, 0],
    [0x87, 60, 3, 2],
    [0x97, 60, 4, 8],
    [0x83, 60, 6, 5],
    [0x8f, 60, 4, 1],
    [0x04, 61, 3, 2],
    [0x14, 61, 4, 7],
    [0x34, 61, 4, 7],
    [0x44, 61, 3, 2],
    [0x54, 61, 4, 7],
    [0x64, 61, 3, 2],
    [0x74, 61, 4, 7],
    [0x80, 61, 2, 0],
    [0x82, 61, 2, 0],
    [0x89, 61, 2, 0],
    [0xc2, 61, 2, 0],
    [0xd4, 61, 4, 7],
    [0xe2, 61, 2, 0],
    [0xf4, 61, 4, 7],
    [0x0c, 62, 4, 1],
    [0x1c, 62, 4, 9],
    [0x3c, 62, 4, 9],
    [0x5c, 62, 4, 9],
    [0x7c, 62, 4, 9],
    [0xdc, 62, 4, 9],
    [0xfc, 62, 4, 9],
    [0x4b, 63, 2, 0],
    [0xe7, 64, 5, 2],
    [0xf7, 64, 6, 7],
    [0xef, 64, 6, 1],
    [0xff, 64, 7, 9],
    [0xfb, 64, 7, 10],
    [0xe3, 64, 8, 5],
    [0xf3, 64, 8, 6],
    [0x47, 65, 5, 2],
    [0x57, 65, 6, 7],
    [0x4f, 65, 6, 1],
    [0x5f, 65, 7, 9],
    [0x5b, 65, 7, 10],
    [0x43, 65, 8, 5],
    [0x53, 65, 8, 6],
    [0x27, 66, 5, 2],
    [0x37, 66, 6, 7],
    [0x2f, 66, 6, 1],
    [0x3f, 66, 7, 9],
    [0x3b, 66, 7, 10],
    [0x23, 66, 8, 5],
    [0x33, 66, 8, 6],
    [0x0b, 67, 2, 0],
    [0x2b, 67, 2, 0],
    [0x8b, 68, 2, 0],
    [0xc7, 69, 5, 2],
    [0xd7, 69, 6, 7],
    [0xcf, 69, 6, 1],
    [0xdf, 69, 7, 9],
    [0xdb, 69, 7, 10],
    [0xc3, 69, 8, 5],
    [0xd3, 69, 8, 6],
    [0x67, 70, 5, 2],
    [0x77, 70, 6, 7],
    [0x6f, 70, 6, 1],
    [0x7f, 70, 7, 9],
    [0x7b, 70, 7, 10],
    [0x63, 70, 8, 5],
    [0x73, 70, 8, 6],
    [0xcb, 71, 2, 0],
  ];

  function buildCodeTable() {
    const table = new Array(256);
    for (let i = 0; i < 256; i++) {
      table[i] = { opcodeId: 56, addressType: 4, cycles: 2 };
    }
    for (let j = 0; j < CODE_LIST.length; j++) {
      const e = CODE_LIST[j];
      table[e[0]] = { opcodeId: e[1], addressType: e[3], cycles: e[2] };
    }
    return table;
  }

  window.A8ECpuTables = {
    buildCodeTable: buildCodeTable,
  };
})();
