/*
 *  This file is part of Emu48, an emulator of the HP-48 Calculator.
 *  Copyright (C) 1995  Sebastien Carlier <sebc@cybera.anet.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>

#define word8  unsigned char
#define word16 unsigned short
#define word32 unsigned long

char  in[32];
word8 out[8];
FILE *IN, *OUT;

void Ncode(word8 *a, word8 s) {

  while (s--) {
     if (a[s] < '0') { a[s] = 0; continue; }
     if (a[s] <='9') { a[s]-= '0'; continue; }
     if (a[s] < 'A') { a[s] = 0; continue; }
     if (a[s] <='F') { a[s]-= ('A'-10); continue; }
     a[s] = 0;
  }   
  return;
}

word32 Nrpack(word8 *a, word8 s) {
  word32 r = 0;
  int i;

  for (i=0; i<s; i++) r = (r<<4)|a[i];
  return r;
}

int main(int argc, char *argv[]) {
  word32 d, i;

  if (argc < 2) {
    fprintf(stderr, "usage: %s hp48-dump-file\n", argv[0]);
    exit(1);
  }
  IN = fopen(argv[1], "r");
  if (IN==NULL) {
    fprintf(stderr, "%s: can\'t open %s\n", argv[0], argv[1]);
    exit(1);
  }
  OUT = fopen("rom", "wb");
  if (OUT==NULL) {
    fprintf(stderr, "%s: can\'t open %s\n", argv[0], "rom");
    exit(1);
  }
  for (i=0; i<0x100000; i+=0x10) {
    if (feof(IN)) break;
    fgets(in, 24, IN);
    if (!in[0]) break;
    if (in[5]!=':') {
      fprintf(stderr, "%s: Illegal char at %05lX\n", argv[0], i);
      fclose(OUT);
      fclose(IN);
      exit(1);
    }
    Ncode(in, 22);
    d = Nrpack(in, 5);
    if (i != d) {
      fprintf(stderr, "%s: Wrong address %05lX, expected %05lX\n", argv[0], d, i);
      fclose(OUT);
      fclose(IN);
      exit(1);
    }
    out[0] = ((in[7]<<4)|(in[6]));
    out[1] = ((in[9]<<4)|(in[8]));
    out[2] = ((in[11]<<4)|(in[10]));
    out[3] = ((in[13]<<4)|(in[12]));
    out[4] = ((in[15]<<4)|(in[14]));
    out[5] = ((in[17]<<4)|(in[16]));
    out[6] = ((in[19]<<4)|(in[18]));
    out[7] = ((in[21]<<4)|(in[20]));
    fwrite(out, 8, 1, OUT);
  }
  printf("ROM size: %05lX\n", i);
  fclose(OUT);
  fclose(IN);
  return 0;
}
