/*--------------------------------------------------------------------------
 Demo program for argproc().
 Demonstrates boolean, string, integer, and float argument-getting.

 Just about every program written here follows the scheme shown below:
    #define default values
    main() {
    declare all command-line-settable variables and initialize
    call lose_title() to register the program name for error messages
    call argproc() to parse the command line
    if any mistakes, print usage message and abort
    else loop over argv[] and do the real work.
    }
--------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include "argproc.h"

/* Default values for variables set by command line options */
#define DEF_X 32
#define DEF_PI 3.1445
#define DEF_S "this is a test"

main(argc, argv)
    int argc;
    char **argv;
{
    /* These variables are set according to the command line */
    boolean b_bool, c_bool, help_bool;
    static char s_string[256] = DEF_S;
    boolean s_string_given; /* TRUE if user gave value for s_string */
    int     x = DEF_X;
    double  pi = DEF_PI;
    char    arg_string[256]="\0";



    /* Variables */
    int i;

    /* Register program name for use in error messages generated by lose() */
    lose_title(argv[0]);

    /* Parse command-line options.
     * - and = introduce switches with single-letter names.
     * {-name...} and {=name...} introduce switches with longer names.
     * Switches introduced with = set or clear a corresponding boolean 
     * so you can tell if the user gave them; - is only useful for switches
     * that take arguments.
     *
     * Switch names followed by scanf-style format specifiers separated by 
     * commas, e.g. "-m%d" or "-m%d,%f" etc., indicate required arguments.
     * If such a switch appears in argv[i], its arguments must also appear
     * in argv[i], separated by commas.
     *
     * Format specifiers surrounded by square brackets, e.g. "=m[%d]", indicate 
     * optional arguments; both "... -m " and "... -m546 " are accepted.
     * To tell if the optional argument was given, you must either
     * check to see if its value changed during the call to argproc(), or
     * (yech!) check the bitmask returned by argproc.  Checking the bitmask
     * is rather difficult; nowadays, I just ignore argproc's return value.
     */
    argproc(argc, argv, "=bc {=help} =s%s -x%d {-pi%lf} %s",
        &b_bool, &c_bool, &help_bool, &s_string_given, s_string, 
        &x, &pi, arg_string);

    /* If user didn't give a value for arg_string, or if she gave the
     * -help switch, print a terse usage message.
     * In a real program, this usage message is very helpful for the user
     * who just needs a little reminder about which options do what.
     */

    if (!arg_string[0] || help_bool)
    lose("Usage: %s file ...\n\
Demonstration program for argproc().  Note that no spaces are allowed\n\
between a switch and its arguments (i.e. -x3 is okay, -x 3 is not allowed).\n\
Options:\n\
    -help    Print this message\n\
    -b       Set b_bool TRUE\n\
    -c       Set c_bool TRUE\n\
    -sSTRING Set string s  [default: %s]\n\
    -xINT    Set integer x [default: %d]\n\
    -piFLOAT Set double pi [default: %f]",
    argv[0], DEF_S, DEF_X, DEF_PI);

    /* argproc() accepts options anywhere on the command line; filenames
     * and switches may be freely intermixed.  (C'mon, haven't you wished you
     * could type "ls *.c -l", and have it work?)
     * Therefore, to handle an arbitrary number of filenames, you must
     * step through argv[], and treat each string not beginning with a dash
     * as a filename argument.
     */
    for (i=1; i<argc; i++) {
    if (argv[i][0] != '-') {
        /* Do something with this argument. */
        do_file(argv[i], b_bool, c_bool, s_string_given, s_string, x, pi);
    }
    }

    exit(0);
}

/* Dummy routine to do something with each file argument. */

do_file(arg, b, c, sGiven, s, x, pi)
    char *arg;
    boolean b, c, sGiven;
    char *s;
    int x;
    double pi;
{
    (void) printf("arg=%s, b=%d, c=%d, sGiven=%d, s=%s, x=%d, pi=%f\n",
    arg, b, c, sGiven, s, x, pi);
}
