#include <string.h>
#include <ctype.h>
#include "boolean.h"

#ifndef NULL
#define NULL 0L
#endif

#define MAX_ARGS 1000

/*----------------------------------------------------------------------
 Given a string, extracts the arguments (separated by white-space) 
 and creates an argv type array full of pointers to the input string. 
 Modifies the input string.
 Returns the count of arguments.
----------------------------------------------------------------------*/
int
makeargv(s, argvp)
    char *s, ***argvp;
{
    int cnt=0;
    char *vals[MAX_ARGS];   /* temporary argv until we know argc */

    while (TRUE) {
    s += strspn(s, " \t\n");
    if (*s == '\0')
        break;

    if (cnt >= MAX_ARGS)
        lose("%s: only %d args allowed to makeargv", MAX_ARGS);

    if (*s == '"') {
    /* if the quote is unmatched, just stop processing */
        vals[cnt] = s;
        if ((s = strchr(s, '"')) == NULL)
        break;

        ++cnt;
        *s++ = '\0';
    } else {
        vals[cnt++] = s;
        s += strcspn(s, " \n\t");
        if (*s == '\0')
        break;
        else
        *s++ = '\0';
    }
    }

    *argvp = malloc(sizeof(char *) * (cnt+1));

    vals[cnt] = 0;
    memcpy(vals,*argvp, (cnt+1) * sizeof(char *));
#if 0    
    bcopy(vals, *argvp, (cnt+1) * sizeof(char *));
#endif    
    

    return cnt;
}
