/* #include <afxwin.h>*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <sys\types.h>
#include <sys\timeb.h>
#include <sys\utime.h>
#include <sys\stat.h>
#include <io.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>
#include <dos.h>

#include "argproc.h"
#include "makerom.h"
#include "rom.h"              

#undef	ANSI
/* #define	DEBUG*/


#define BUFFERSIZE     255
#define MAXFILES	32
#define MAXFUNCTIONS	63
#define MAXSIZE       4096
#define OFFSET		 2

#ifndef TRUE
#   define TRUE		 1
#endif

#ifndef FALSE
#   define FALSE	 0
#endif

int	CurrentModul;
int	CurrentFileLine;
int	CurrentCodeLine;


char	*pchanged;

short	rom_id=1;
long	rom_version;
char	rom_copyright[64];
char	rom_name[16];
ushort	rom_idintern;
long	rom_date;
short	rom_ofs;




const	char	def_makefile[]="makefile.rom";
	char	makefile[MAXROMPATH];

char	szError[255];

char	rom_lib     [MAXROMPATH];
char	rom_wc	    [MAXROMPATH];
char	rom_input   [MAXROM][MAXROMPATH];
char	rom_filename[MAXROMPATH];
char	rom_output  [MAXROMPATH];
char	rom_map     [MAXROMPATH];

short	rom_files=0;



#define SZ_MAKEROM   "makerom"

#define SZHELP	     "help"
#define SZHELP1      "?"
#define SZID	     "id="
#define SZVERSION    "version="
#define SZNAME	     "name="
#define SZCOPYRIGHT  "cpr="
#define SZDATE	     "date="
#define SZIDINTERN   "idintern="
#define SZOUTPUT     "o="
#define SZOFS	     "ofs="
#define SZLIB	     "l="
#define SZEXTENSION  "w="
#define SZFILES_PRG  "f="
#define SZMAP	     "m=" 
#define SZVERBOSE	 "v"


#define SZENV_NAME	 "TTC_ROM_NAME"
#define SZENV_COPYRIGHT  "TTC_ROM_CPR"
#define SZDEF_ROM_NAME	 "ttcalc.rom"
#define SZDEF_EXTENSION  "prg"



char *code_data[MAXFILES];
int   code_size[MAXFILES];
int	  verboseFlag=0;

char function_name[MAXFUNCTIONS][12];
int  function_prgm[MAXFUNCTIONS];
int  function_offset[MAXFUNCTIONS];
int  function_begin[MAXFUNCTIONS];
int  function_end[MAXFUNCTIONS];
int  function_type[MAXFUNCTIONS];
int  function_size = 0;

short modul_size = 0;
short modul_begin[MAXFUNCTIONS];
short modul_end[MAXFUNCTIONS];


//typedef unsigned short WORD;
//typedef unsigned int	UINT;
//typedef unsigned char	BYTE;
//typedef int	       BOOL;

#define LOBYTE(w) ((BYTE) (w))
#define HIBYTE(w) ((BYTE) (((UINT)(w) >> 8) & 0x0ff))




#define TC_NUM		0x1000	// Ziffern	    0x10..0x1c
#define TC_RCL_SHORT	0x2000	// RCL 00..RCL 15   0x20..0x2f
#define TC_STO_SHORT	0x3000	// STO 00..STO 15	0x30..0x3f
#define TC_GTO_ALPHA	0x4000	// GTO 'Alpha'	    0x1d
#define TC_XEQ_ALPHA	0x5000	// XEQ 'Alpha'	    0x1e
#define TC_SPARE	0x6000	// SPARE-Bytes	    0x1f,0xaf,0xb0
#define TC_LBL_SHORT	0x7000	// Short-Labels

#define TC_GTO_XEQ_IND	0x9000	// GTO/XEQ ind	    0xae
#define TC_XROM 	0xa000	// XROM nn,mm	    0xa0..0xa7
#define TC_GTO_SHORT	0xb000	// GTO Kurzform	0xb1..0xbf
#define TC_GLOBAL	0xc000	// Globale Marken   0xc0..0xcd
#define TC_GTO_LONG	0xd000	// GTO Langform     0xd0..0xdf
#define TC_XEQ_LONG	0xe000	// XEQ Langform	0xe0..0xef
#define TC_ALPHA	0xf000	// Textmarken	    0xf0..0xff

#define TC_END		0xc001	// TestCode END
#define TC_LBL_ALPHA	0xc002	// TestCode Alpha-Marke
#define TC_LBL_LONG	0xc003	// TestCode Lokale Long Marke


WORD HP_KBSYSTEM[0x100]=
      //   0	  1	 2	3      4      5	     6	    7	   8	  9	 a	b      c      d	     e	    f
      { 0x0001,0x7000,0x7243,0x7451,0x7451,0x7000,0x7243,0x7020,0x7020,0x7080,0x7000,0x70a0,0x70a0,0x7002,0x70a0,0x7451, //0
	0x18a0,0x18a0,0x18a0,0x18a0,0x18a0,0x18a0,0x18a0,0x18a0,0x18a0,0x18a0,0x18a0,0x18a0,0x18a0,0x4c02,0x5402,0x6000, //1
	0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820,0x2820, //2
	0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800,0x3800, //3
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0020,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, //4
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, //5
	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, //6
	0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0020,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, //7
	0x0000,0x0000,0x0000,0x0020,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000, //8
	0x0122,0x0102,0x0102,0x0102,0x0102,0x0102,0x0102,0x0102,0x0102,0x0002,0x0102,0x0102,0x0001,0x0001,0x0001,0x0001, //9
	0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0xa800,0x0002,0x0002,0x0002,0x0002,0x0002,0x0002,0x9800,0x6800, //a
	0x6000,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002,0xb002, //b
	0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0xc000,0x0102,0x0442, //c
	0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002,0xd002, //d
	0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002,0xe002, //e
	0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf020,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000,0xf000};//f


char* STRING_FUNCTION[128]=
      { "NULL","+","-","*","/","1/X","10^X","ABS","ACOS","ADV","AOFF","AON",
	"ARCL","ASHF","ASIN","ASN","ASTO","ATAN","AVIEW","BEEP","BST",
	"CAT","CF","CHS","CLA","CLD","CLP","CLRG","CL~","CLST","CLX",
	"COPY","COS","D-R","DEC","DEG","DEL","DSE","END","ENG","ENTER^",
	"E^X","E^X-1","FACT","FC?","FC?C","FIX","FRC","FS?","FS?C",
	"GRAD","GTO","HMS","HMS+","HMS-","HR","INT","ISG","LASTX","LBL",
	"LN","LN1+X","LOG","MEAN","MOD","OCT","OFF","ON","P-R","PACK",
	"%","%CH","PI","PROMPT","PSE","R^","R-D","R-P","RAD","RCL","RDN",
	"RND","RTN","SDEV","SCI","SF","~+","~-","~REG","SIN","SIGN",
	"SIZE","SQRT","SST","ST+","ST-","ST*","ST/","STO","STOP","TAN",
	"TONE","VIEW","X=0?","X0?","X<0?","X<=0?","X>0?","X=Y?","XY?",
	"X<Y?","X<=Y?","X>Y?","X<>","X<>Y","XEQ","X^2","Y^X",
	"XROM","SPARE","GLOBAL","@C","2__" };

WORD  STRING_WORD[128]=
      {    0,0x40,0x41,0x42,0x43,0x60,0x57,0x61,0x5d,0x8f,0x8b,0x8c,
	0x9b,0x88,0x5c,0x0f,0x9a,0x5e,0x7e,0x86,0x07,
	0x00,0xa9,0x54,0x87,0x7f,0x04,0x8a,0x70,0x73,0x77,
	0x03,0x5a,0x6a,0x5f,0x80,0x02,0x97,0xc0,0x9e,0x83,
	0x55,0x58,0x62,0xad,0xab,0x9c,0x69,0xac,0xaa,
	0x82,0x1d,0x6c,0x49,0x4a,0x6d,0x68,0x96,0x76,0xcf,
	0x50,0x65,0x56,0x7c,0x4b,0x6f,0x8d,0x09,0x4e,0x0a,
	0x4c,0x4d,0x72,0x8e,0x89,0x74,0x6b,0x4f,0x81,0x90,0x75,
	0x6e,0x85,0x7d,0x9d,0xa8,0x47,0x48,0x99,0x59,0x7a,
	0x06,0x52,0x08,0x92,0x93,0x94,0x95,0x91,0x84,0x5b,
	0x9f,0x98,0x67,0x63,0x66,0x7b,0x64,0x78,0x79,
	0x44,0x46,0x45,0xce,0x71,0x1e,0x51,0x53,
	   0,	0,   0,   0,   0};



BYTE STRING_POS[0x100]=
      //  0   1   2   3   4   5	  6   7	  8   9	  a   b	  c   d	  e   f
      {  21,127, 36, 31, 26,  0, 91, 20, 93, 67, 69,  0,  0,128,  0, 15,  //0
	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 51,115,119,  //1
	 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79, 79,  //2
	 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98, 98,  //3
	  1,  2,  3,  4,110,112,111, 86, 87, 53, 54, 64, 70, 71, 68, 77,  //4
	 60,116, 92,117, 23, 41, 62,  6, 42, 89, 32,100, 14,  8, 17, 34,  //5
	  5,  7, 43,104,107, 61,105,103, 56, 47, 33, 76, 52, 55, 81, 65,  //6
	 28,114, 72, 29, 75, 80, 58, 30,108,109, 90,106, 63, 83, 18, 25,  //7
	 35, 78, 50, 40, 99, 82, 19, 24, 13, 74, 27, 10, 11, 66, 73,  9,  //8
	 79, 98, 94, 95, 96, 97, 57, 37,102, 88, 16, 12, 46, 84, 39,101,  //9
	118,118,118,118,118,118,118,118, 85, 22, 49, 45, 48, 44, 51,119,  //a
	119, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,  //b
	 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38,113, 59,  //c
	 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51,  //d
	115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,115,  //e
	 0,  0,	  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};  //f


void PrintWarning(int warning, char *warnstring)
{
    if (CurrentFileLine) {
	 printf("\n%s (l=%d) : warning %d ",
		 rom_input[CurrentModul],CurrentFileLine,warning);
	 if (warnstring)
	    printf(warnstring);

	 printf("\n");

    }
    else
    {
	 printf("\n%s (c=%d) : warning %d ",
		 rom_input[CurrentModul],CurrentCodeLine,warning);
	 if (warnstring)
	    printf(warnstring);

	 printf("\n");

    }
    return;
}


void PrintError(int error ,char * errstring)
{
    if (CurrentFileLine) {
	 printf("\n%s (l=%d) : error %d ",
		 rom_input[CurrentModul],CurrentFileLine,error);
	 if (errstring)
	    printf(errstring);

	 printf("\n");

    }
    else {
	 printf("\n%s (c=%d) : error %d ",
		 rom_input[CurrentModul],CurrentCodeLine,error);

	 if (errstring)
	    printf(errstring);

	 printf("\n");

    }

    return;
}


int AddFilesPrg( char* filename , int ofs )
{
    char  szBuffer[255];
    FILE *inp;
    int   files = ofs;
    int   ret;


    inp = fopen(filename,"r");
    if (!inp)
    {
		printf("makerom error: cannot open library file (%s)\n",filename);
		exit(0);
    }

    for (files=ofs;files<MAXROM;files++)
    {

	ret=fscanf(inp,"%254s",szBuffer);
	if (!ret)
	{

	    fclose(inp);

	    files -= ofs;
	    if (files==0)
	    {
			printf("makerom error: library '%s' is empty\n",filename);
			exit(0);
	    }
	    else
		return files;
	}
	if (feof(inp))
		return files-ofs;

	strcpy(rom_input[files],szBuffer);
    }


    printf("makerom error: library '%s' has too many entries\n",filename);
    fclose(inp);

    exit(0);
    return 0;


}


int AddLibPrg( char *path, char* filename , int ofs )
{
    struct _find_t find;
    int    files = 0;
    char   szWildcard[255];

    sprintf(szWildcard,"%s\\%s",path,filename);

    /* Find first matching file, then find additional matches. */
    if( _dos_findfirst( szWildcard, _A_NORMAL | _A_RDONLY , &find ) )
    {
		PrintError(ERROR_NO_FILES_IN_LIBRARY,"no programs in specified path");
		exit(0);
    }

    sprintf(rom_input[ofs],"%s\\%s",path,find.name);
    for (files=ofs+1;files<MAXROM;files++)
    {
	if ( _dos_findnext( &find ) )
	    return files-ofs;

	sprintf(rom_input[files],"%s\\%s",path,find.name);
    }

    PrintError(ERROR_TO_MANY_INPUT_FILES,"to many input files");
    exit(0);
    return 0;
}


char *SkipSpaces(char *buffer)
{
    for(;;)
    {
	switch (*buffer)
	{
	    case ' ':
	    case '\t':
		buffer++;
		break;
	    default:
		return buffer;
	}
    }
}

void Usage()
{

    lose("Usage: %s [<options>] file ...\n\n"
		 "makerom is a utility for ttCalc to compile ttCalc-Programs\n"
		 "and to link them to one ROM-Modul. You can use up to 15 moduls\n"
		 "with this calculator. The Size of one ROM-Modul is limited to\n"
		 "4094 Bytes.\n\n"
		 "Options:\n"
    	 "	-?		          Print this message\n"
    	 "	-id=<INT>	      Set ROM ID [1..15]\n"
    	 "	-name=<STRING>    Rom name [def: env var '"SZENV_NAME"']\n"
    	 "	-v                Verbose mode\n"
   		 "	[-cpr=<STRING>]   Copyright string [def:  '"SZENV_COPYRIGHT"']\n"
   		 "	[-ofs=<INT>]	  Set offset for first program\n"
   		 "	[-o=<STRING>]     Set output file name [def: "SZDEF_ROM_NAME"]\n"
   		 "	[-intid=<INT>]    Set internal ID [0..32767]\n"
   		 "	[-version=<LONG>] Set rom Version\n"
   		 "	[-date=<LONG>]    Set build date\n"
   		 "	[-l=<STRING>]     Include path for programs\n"
   		 "	[-f=<STRING>]     Filename with program names\n"
   		 "	[-m=<STRING>]     Info output to File\n"
   		 "	[-w=<STRING>]     Set wildcard for programs [def: *.prg]\n\n",
		 "makerom");

    exit(0);
}



int ScanMakeParameters(int argc, char **argv)
{


    char *szTmp;


    int   i,j;

    int  get_id 	=  1;
    int  get_idintern	=  0;
    int  get_ofs	=  1;

    long get_date	=  0;



    long get_version;
    char get_name[128]	= "\0";

    char get_outp[128]	= "\0";
    char get_cpr[128]	= "\0";
    char get_ext[128]	= "\0";
    char get_lib[128]	= "\0";
    char get_files[128] = "\0";
    char get_map[128]	= "\0";

    char arg_string[256];
    
    short help  , help1;
    short b_id	, b_idintern, b_ofs, b_date , b_files , b_map;
    short b_name, b_version , b_outp,	 b_cpr , b_lib, b_ext;
    short b_verbose;

    lose_title(argv[0]);

    (void*) argproc(argc, argv, "{="SZID"%d} {="SZNAME"%s} {="SZHELP"} {=?} "
			"{="SZOFS"%d} {="SZIDINTERN"%d} {="SZVERSION"%ld} "
			"{="SZCOPYRIGHT"%s} {="SZOUTPUT"%s} {="SZDATE"%ld} "
			"{="SZLIB"%s} {="SZEXTENSION"%s} "   
			"{="SZVERBOSE"} "
			"{="SZFILES_PRG"%s} {="SZMAP"%s} %s",
			&b_id,	    &get_id ,
			&b_name,     get_name,
			&help,
			&help1,
			&b_ofs,     &get_ofs,
			&b_idintern,&get_idintern,
			&b_version, &get_version,
			&b_cpr,      get_cpr,
			&b_outp,     get_outp,
			&b_date,    &get_date,
			&b_lib,      get_lib,
			&b_ext,      get_ext,
			&b_verbose,  
			&b_files,    get_files,
			&b_map,      get_map,
			 arg_string);


    if (help || help1 || argc<=1) {
		Usage();
    }
    else
    {
#ifdef DEBUG
	for (i=1;i<argc;i++) {
	    if (argv[i][0] != '-') {
	    /* Do something with this argument. */
		printf("[%d] arg=%s\n",i, argv[i]);
	    }
	}
	printf ("[%d] id=%d\n"
		"[%d] name=%s\n"
		"[ ] help: %d\n"
		"[ ] ?   : %d\n"
		"[%d] ofs=%d\n"
		"[%d] intd=%d\n"
		"[%d] version=%ld\n"
		"[%d] cpr=%s\n"
		"[%d] o=%s\n"
		"[%d] date=%ld\n"
		"[%d] lib=%s\n"
		"[%d] ext=%s\n"
		"[%d] map=%s\n"
		"[%d] files=%s\n",

		b_id, get_id, b_name, get_name, help, help1, b_ofs ,get_ofs,
		b_idintern, get_idintern,
		b_version, get_version, b_cpr, get_cpr,
		b_outp, get_outp, b_date, get_date,
		b_lib,get_lib,b_ext,get_ext,
		b_map,get_map,
		b_files,get_files);
#endif

	if (b_verbose)
		verboseFlag=1;

	/* Check Input Values */
	if ((!b_id) || (get_id<1) || (get_id>15)) {
	    printf("makerom: invalid parameter for ROM ID: %d\n\n",get_id);
	    exit(0);
	}

	if (!b_name) {
	    szTmp=getenv(SZENV_NAME);
	    if (!szTmp) {
			printf("makerom: no rom name\n\n");
			exit(0);
	    }

	    strcpy(get_name,szTmp);
	}

	if (!b_ofs || get_ofs <= 0 || get_ofs > 4095)
	    get_ofs = 1;

	if (!b_idintern)
	    get_idintern = 0;

	if (!b_version)
	    get_version = 0;

	if (!b_cpr)
	{
	    szTmp=getenv(SZENV_COPYRIGHT);
	    if (!szTmp)
		get_cpr[0]='\0';
	    else
		strcpy(get_cpr,szTmp);
	}

	if (!b_outp)
	    strcpy(get_outp,SZDEF_ROM_NAME);

	if (!b_date) {

	    time_t ltime;
		struct tm	   *today;

	    time(&ltime);

	    today = localtime(&ltime);

	    get_date = (long) today->tm_mon+1;
	    get_date*= 100;
	    get_date+= (long) today->tm_mday;
	    get_date*= 10000;
	    get_date+= (long) today->tm_year;
	    get_date+= 1900;
	}






	/* Copy To Global Variables */

	rom_id	     = (short) get_id;
	rom_idintern = (short) get_idintern;
	rom_date     = get_date;
	rom_version  = get_version;
	rom_ofs      = get_ofs;

	strcpy(rom_output   ,get_outp);
	strcpy(rom_name     ,get_name);
	strcpy(rom_copyright,get_cpr);
	strcpy(rom_map,      get_map);

	j = 0;

	for (i=1;i<argc;i++) {
	    if (argv[i][0] != '-') {
		strcpy(rom_input[j],argv[i]);
		j++;
	    }

	}

	if (b_lib)
	    strcpy(rom_lib,get_lib);
	else
	    strcpy(rom_lib,".");

	if (b_ext)
	    strcpy(rom_wc,get_ext);
	else
	    strcpy(rom_wc,"*.prg");

	if (b_files)
	    j+=AddFilesPrg(get_files,j);

	if (b_lib || b_ext)
	    j+=AddLibPrg(rom_lib,rom_wc,j);



	rom_files = (short) j;



#ifdef DEBUG
	printf ("[%d] id=%d\n"
		"[%d] name=%s\n"
		"[ ] help: %d\n"
		"[ ] ?   : %d\n"
		"[%d] ofs=%d\n"
		"[%d] intd=%d\n"
		"[%d] version=%ld\n"
		"[%d] cpr=%s\n"
		"[%d] o=%s\n"
		"[%d] date=%ld\n"
		"[%d] lib=%s\n"
		"[%d] ext=%s\n"
		"[%d] map=%s\n"
		"[%d] files=%s\n",

		b_id, get_id, b_name, get_name, help, help1, b_ofs ,get_ofs,
		b_idintern, get_idintern,
		b_version, get_version, b_cpr, get_cpr,
		b_outp, get_outp, b_date, get_date,
		b_lib,get_lib,b_ext,get_ext,
		b_map,get_map,
		b_files,get_files);

	for (i=0;i<rom_files;i++) {
	    printf("[%d] %s\n",i, rom_input[i]);
	}



#endif

	if(rom_files<=0)
	    Usage();


    }



    return 0;


}


int GetNulls(char *code)
{
    int nulls=0;
    while (*code++=='\0')
	nulls++;

    return nulls;
}

 char *SkipNulls(char *code)
{
    while (*code=='\0')
	code ++;

    return code;
}


 WORD TestCode(char *code)
{
    BYTE   c;
    WORD   status;

    code  = SkipNulls(code);

    c	  = (BYTE) *code;
    status  = HP_KBSYSTEM[c];
    status &= 0xf000;

    switch (status)
    {
	 case TC_NUM:
	 case TC_RCL_SHORT:
	 case TC_STO_SHORT:
	 case TC_GTO_ALPHA:
	 case TC_XEQ_ALPHA:
	 case TC_SPARE:
	 case TC_LBL_SHORT:
	 case TC_GTO_XEQ_IND:
	 case TC_XROM:
	 case TC_GTO_SHORT:
	 case TC_GTO_LONG:
	 case TC_XEQ_LONG:
	 case TC_ALPHA:
	    return status;

	 case TC_GLOBAL:
	    if ((BYTE)(code[2] & 0xf0)==(BYTE) 0xf0)
		return TC_LBL_ALPHA;
	    return TC_END;

	 default:
	    if (c==0xcf)
		return TC_LBL_LONG;
	    return 0;
    }


}


 int GetPrgmLen(char *code)
{
    int     nulls =0;

    while (*code=='\0')
    {
	code++;
	nulls++;
    }

    switch (TestCode(code))
    {
	case TC_STO_SHORT:
	case TC_RCL_SHORT:
	case TC_LBL_SHORT:
	case TC_SPARE:
	    return nulls+1;

	case TC_GTO_XEQ_IND:
	case TC_XROM:
	case TC_GTO_SHORT:
	case TC_LBL_LONG:
	    return nulls+2;

	case TC_GTO_LONG:
	case TC_XEQ_LONG:
	case TC_END:
	    return nulls+3;

	case TC_GTO_ALPHA:
	case TC_XEQ_ALPHA:
	    return nulls+2+(code[1] & 0x0f);

	case TC_LBL_ALPHA:
	    return nulls+3+(code[2] & 0x0f);

	case TC_ALPHA:
	    return nulls+1+(*code & 0x0f);

	case TC_NUM:
	    while ((*code  <=0x1c) &&
		   (*code++>=0x10))
		nulls++;
	    return nulls;

	default:
	    if ((HP_KBSYSTEM[(BYTE) *code] & 0x000f) == 0)
		return nulls+1;
	    else
		return nulls+2;

    }

}




 BOOL ScanFunction(char *input, BYTE *a)
{
    short i;
    char buffer[10];
    char string[10];

    if ((input == NULL)    ||
	(strlen(input)==0) ||
	(strlen(input)>=8))
	return FALSE;


    if (strlen(input)==7)
	memcpy(string,input,7);
    else
    {
	memset(string,0,7);
	strcpy((char*) string,input);
    }

    for (i=1;i<118;i++)
    {
	memset(buffer,0,7);
	memcpy(buffer,STRING_FUNCTION[i],strlen(STRING_FUNCTION[i]));
	if (!(memcmp(string,buffer,7)))
	{
	    *a=LOBYTE(STRING_WORD[i]);
	    return TRUE;
	}
    }
    return FALSE;
}




char *ExtractLine(char *buffer)
{
    buffer=SkipSpaces(buffer);

    for (;;)
	if (isdigit(*buffer)) buffer++; else break;

    return SkipSpaces(buffer);
}

BOOL IsConvHex(char *string)
{
    if ((*string++=='\\') &&
	(isxdigit(*string++)) &&
	(isxdigit(*string++)) &&
	(isxdigit(*string)))
	return TRUE;
    else
	return FALSE;
}

BOOL IsConvSpec(char* string)
{
    if ((*string++=='\\') &&
	(*string  =='\\'))
	return TRUE;
    else
	return FALSE;
}


int ScanAlpha(char *szText,unsigned char *code, int maxlen, BOOL conv)
{
    int  next=1;
    int  len =0;    /* Vorsicht Len hier immer 1,
		       da Fhrungsbyte voransteht
		     */
    int  hex;


    char *panfz;
    unsigned char *p  =code;

    /* Wenn Keine Ende-Anfhrungszeichen existiert zurck
     */
    szText++;
    *code++=0xf0;


    panfz=strchr(szText,'`');
    if (!panfz)
    {
	PrintError(ERROR_NO_END_QUOTE,NULL);
	return -1;
    }


    while (szText != panfz)
    {
	if (len>=maxlen)
	{
	    PrintError(ERROR_TEXT_TO_LONG,NULL);
	    return -1;
	}

	len++;

	if (conv)
	{
	    if (IsConvSpec(szText))
	    {
		szText+=2;
		*code++='\\';
	    }
	    else if (IsConvHex(szText))
	    {
		sscanf(szText+1,"%03x",&hex);
		*code++=LOBYTE(hex);
		/* printf("%s %x\n", szText, hex);*/
		szText+=4;
	    }
	    else
		*code++=*szText++;
	}
	else
	    *code++=*szText++;
    }

    /* Setzen der TextLaenge */
    *p|= 0xf0 | (len & 0x0f);

    /* Als Rueckgabewert Anzahl der Codierten Bytes
       Hier Stringlaenge + 1.
     */
    return len+1;

}

BOOL ishpdigitchar(char *szText)
{
    switch(*szText)
    {
	case '-':
	case '.':
	case ',':
	case 'E':
	    return TRUE;

	default:
	    if (isdigit(*szText))
		return TRUE;
    }
    return FALSE;
}


int ScanDigit(char *szText,char *code)
{
    int  next=1;
    int  len =0;
    BYTE c   ;

    while (next)
    {
	c=(BYTE) *szText++;
	switch(c)
	{
	    case '\t':
	    case '\r':
	    case '\n':
	    case '\0': next = 0; break;

	    case ' ':
		if (*szText!='E')
		    next=0;
		else
		{
		    *code++=0x1b;
		    szText++;
		}
		break;

	    case ',':
	    case '.': *code++= 0x1a; break;
	    case 'E': *code++= 0x1b; break;
	    case '-':
		/* Vorsicht zwischen '-' - Operator und
		 * Vozeichen einer Zahl */

		if ((len==0) && (!ishpdigitchar(szText)))
		{
		    if (!(szText[0]==' ' && szText[1]=='E'))
		    {
			/* Operator '-' */
			    return -1;
		    }
		}

		*code++= 0x1c;
		break;


	    default:
		if (isdigit(c))
		    *code++= c - '0' + 0x10;
		else
		    return -1;
	}
	/* Diese Maximallaenge darf nicht ueberschritten werden
	 */
	if (len>20)
	{
	    PrintError(ERROR_NUM_TO_LONG,NULL);
	    return -2;
	}

	if (next)
	    len++;
    }
    /* Absclieendes Null-Byte fuer Zahlen zuerst zwingend
     */
    *code++=0;

    return len+1;
}

int ScanParameter(char *szText, BYTE scancode)
{

    int ret;
    int error=0;

    switch(*szText)
    {
	/* Labels and so on */
	case 'A': return 102;
	case 'B': return 103;
	case 'C': return 104;
	case 'D': return 105;
	case 'E': return 106;
	case 'F': return 107;
	case 'G': return 108;
	case 'H': return 109;
	case 'I': return 110;
	case 'J': return 111;

	/* Stack Registers */
	case 'X': return 0x73;
	case 'Y': return 0x72;
	case 'Z': return 0x71;
	case 'T': return 0x70;
	case 'L': return 0x74;

	/* System-Registers and Labels */
	case 'M': case '[':  return 0x75;
	case 'N': case '\\': return 0x76;
	case 'O': case ']':  return 0x77;
	case 'P': case '^':  return 0x78;
	case 'Q': case '_':  return 0x79;
	case '>': case '\"': case '\'': return 0x7b;

	case 'a': return 0x7b;
	case 'b': return 0x7c;
	case 'c': return 0x7d;
	case 'd': return 0x7e;
	case 'e': return 0x7f;

	default:
	    if (isdigit(*szText))
	    {

		ret= atoi(szText);
		if (ret>=128)
		{
		    PrintError(ERROR_PARAM_TO_BIG,NULL);
		    return -1;
		}
		else
		    return ret;
	    }
    }
    return -1;
}

int ScanTextHex(char *szText, char* code, BOOL conv)
{
    int  i;
    int  pbegin =-1;
    int  pend	=-1;
    int  len	= 0;
    int  hex;



    for(i=strlen(szText)-1;i>=0;i--)
	if (szText[i]==']')
	{
	    pend = i-3;
	    break;
	}

    for(i=strlen(szText)-1;i>=0;i--)
	if (szText[i]=='[')
	{
	    pbegin = i+2;
	    break;
	}

    if ((pend<0) ||			// letzten Eintrag nicht gefunden
	(pbegin<0) ||			// ersten Eintrag nicht gefunden
	(pend<pbegin) ||		// erster Eintrag < letzter Eintrag
	(((pend-pbegin) % 3) != 0))	// Offset immer 3 Bytes
    {
	PrintError(ERROR_NO_HEX_VALUES,NULL);
	return -1;
    }

    for (i=pbegin; i<=pend; i+=3)
    {
	if (!isxdigit(szText[i]) ||
	    !isxdigit(szText[i+1]) ||
	    (szText[i+2]!=' '))
	{
	    PrintError(ERROR_INVALID_HEX_VALUES,NULL);
	    return -1;
	}

	sscanf(szText+i,"%x",&hex);
	*code++=LOBYTE(hex);
	len++;
    }

    return len;

}



int ScanTextAlpha(char *szText, unsigned char* code, BOOL conv)
{
    int  ret;
    BYTE c;


    char *pend;
    int  len	=0;
    BOOL IsAlpha=FALSE;
    BOOL IsInd	=FALSE;
    BYTE scancode;
    int  parameter;
    char *pind;
    WORD status;        
    char *pfirst;


	szText=SkipSpaces(szText);
    pfirst=szText;            
    
    c= (BYTE) *szText;
    if ((c=='\0') || (c=='#'))
	return 0;


    /* Nicht Zulaessig, da zb. ENTER^ */
    /* Daher wenn nicht erfolgreich -> weiterer Scan !! */
    if ((isdigit(c)) || (c=='.') || (c==',') || (c=='-') || (c=='E'))
    {
	ret=ScanDigit(szText,code);
	if (ret!=-1)
	    return ret;
    }

    if (c=='`')
	return ScanAlpha(szText,code,15,conv);

    /* End des Ersten Eintrags suchen
       Markiert durch Leerzeichen, Null,
       oder Anfuehrungszeichen
     */
    pend = strchr(szText,'\0');

    while(*pfirst++)
    {
	if (*pfirst=='\t')
	{
	    *pfirst='\0';
	    break;
	}

	if (*pfirst==' ')
	{
	    *pfirst='\0';
	    break;
	}

	if (*pfirst=='`')
	{
	    *pfirst='\0';
	    IsAlpha=TRUE;
	    break;
	}
    }

    /* Suche nach Standardfunktionen */
    if (!ScanFunction(szText,&scancode) || (scancode<0x10))
    {
	PrintError(ERROR_FUNCTION_NOT_FOUND,NULL);
	return -1;
    }

    /* END ebenfalls nicht erlaubt !
     */
    if (scancode==0xc0)
    {
	PrintError(ERROR_END_NOT_ALLOWED,NULL);
	return -1;
    }


    /* Anzahl der einzugebenden
       Parameter ermitteln.
     */


    status=HP_KBSYSTEM[scancode];

    /* Wenn die Anzahl der Parameter gleich Null ist
       sind wir bereits fertig */
    if (!(status & 0x000f))
    {
	*code++=(char) scancode;
	return 1;
    }

    /* Hier sind die folgenden Parameter einzulesen
       Zuerst Test ob ueberhaupt noch ein String vorliegt
     */
    if (pfirst==pend)
    {
	PrintError(ERROR_LACK_OF_PARAMETER,NULL);
	return -1;
    }
    /* Hier kann szText erhoeht werden, da noch chars vorliegen
     */

    szText=pfirst;
    szText++;
    szText=SkipSpaces(szText);

    /* Test Ob Alpha-Modus und ob Alpha-Eingaben erlaubt sind */
    if (IsAlpha)
    {
	if (!(status & 0x0400))
	{
	    PrintError(ERROR_NO_ALPHA_FUNCTION,NULL);
	    return -1;
	}



	switch (scancode)
	{
	    case 0xcf:
		/* LBL'Alpha' ummappen */


		*code++=0xc0;
		*code++=0x00;
		*code  =0xf0;

		/* *code++=0x00; */

		len=ScanAlpha(szText-1,code+1,7,conv);
		if (len<0)
		    return -1;
		*code++=0xf0 | len;
		*code  =0;
		return 3+len;

	    default:
		*code++=scancode;
		len=ScanAlpha(szText-1,code,7,conv);
		if (len<0)
		    return -1;
		else
		    return 1+len;

	}

    }
    else
    {
	/* Test auf indirekte Funktionen und deren
	   Gueltigkeit. Nur gueltig, wenn gefundene
	   Adresse gleich der Anfangsadresse ist
	 */
	pind=strstr(szText,"IND");
	if(pind == szText) IsInd=TRUE;

	if (IsInd)
	{
	    /* Zeiger hinter das 'IND' setzen
	     */
	    szText+=3;

	    pind=SkipSpaces(szText);
	    if	((status & 0x0040) ||	 /* IND Erlaubt ? */
		 (pind==szText))

	    {
		PrintError(ERROR_LACK_OF_IND_PARAM,NULL);
		return -1;
	    }
	    else
		szText=pind;

	}


	/* Hier fuehrt die Behandlung IND und nicht IND wieder zusammen */
	parameter=ScanParameter(szText,scancode);
	if (parameter<0)
	{
	    PrintError(ERROR_LACK_OF_PARAM,NULL);
	    return -1;
	}

	/* Vorsicht es fehlt noch die Behandlung der
	   Ausnahme - Befehle XEQ/GTO/LBL ...
	 */

	c=LOBYTE(parameter);

	switch (scancode)
	{
	    case 0x1d: /* GTO's */
		if (IsInd)
		{
		    *code++=0xae;
		    *code++=c;
		    return 2;
		}

		if (c<=14)
		{
		    *code++=0xb1+c;
		    *code	=0;
		    return 2;
		}

		{
		    *code++=0xd0;
		    *code++=0x00;
		    *code++=c;
		    return 3;
		}

	    case 0x1e: /* XEQ's */
		if (IsInd)
		{
		    *code++=0xae;
		    *code++=c | 0x80;
		    return 2;
		}
		else
		{
		    *code++=0xe0;
		    *code++=0x00;
		    *code++=c;
		    return 3;
		}
	    case 0xcf: /* LBL */
		if (IsInd)
		    return -1;
		if (c<=14)
		{
		    *code++=c+1;
		    return 1;
		}
		else
		{
		    *code++=0xcf;
		    *code++=c;
		    return 2;
		}
	    case 0x90: /* RCL */
		if (IsInd) c |= 0x80;
		if (c<=15)
		{
		    *code=0x20+c;
		    return 1;
		}
		else
		{
		    *code++=scancode;
		    *code++=c;
		    return 2;
		}

	    case 0x91: /* STO */
		if (IsInd) c |= 0x80;
		if (c<=15)
		{
		    *code=0x30+c;
		    return 1;
		}
		else
		{
		    *code++=scancode;
		    *code++=c;
		    return 2;
		}


	    default:
		if (IsInd) c |= 0x80;
		*code++=scancode;
		*code++=c;
		return 2;
	}
    }

}

 char * getnline(char * string1, char * string2, int ncount)
{
    int   len=0;
    char * ret;

    for (;;)
    {
	switch (*string2)
	{
	    case '#':
		if (len==0)
		{
		    *string1='\0';
		    ret=strchr(string2,'\n');
		    if(ret)
			return ret+1;
		    else
			return NULL;
		}
		*string1++=*string2;
		len++;
		break;

	    /* Windows CF_TEXT braucht CR-LF */
	    /* Diese Applikation braucht nur
	       LF */
	    case '\r':
		if (string2[1]!='\n')
		{
		    len++;
		    *string1++=*string2;
		}

		break;



	    case '\0':
	    case '\n':
		*string1='\0';
		if (len==0)
		    return NULL;
		else
		    return string2+1;

	    case '\t':
	    case ' ' :
		if (len==0)
		    break;

	    default:
		len++;
		*string1++=*string2;
	}
	string2++;
    }
    return NULL;
}



#define ClosePaste()	    \
	{ free(lpData);	    \
	return FALSE; }

#define ClosePaste1()	    \
	free(lpData);	    \
	return FALSE; }


int ReadData(FILE *input,unsigned char *code)
{
    BOOL   Line,Conv,Hex,Alpha;
    char   szText[BUFFERSIZE];
    int	   CodeLen = 0;
    int    ret;

    char   *szBuffer;

    if (!fgets(szText,sizeof(szText),input))
	return -1;

    /* Erste Zeile dient fuer Information ueber das
       Format im Clipboard, wichtig fuer spaetere
       Interpretation
     */
    if (strstr(szText,".line"))  Line	= TRUE; else Line  = FALSE;
    if (strstr(szText,".conv"))  Conv	= TRUE; else Conv  = FALSE;
    if (strstr(szText,".alpha")) Alpha = TRUE; else Alpha = FALSE;
    if (strstr(szText,".hex"))	 Hex	= TRUE; else Hex   = FALSE;

    /* Ansonsten Default - Einstellungen verwenden */
    /* und erste Zeile nochmal interpretieren */
    if (!Line && !Conv && !Alpha && !Hex)
    {
       Alpha=TRUE;
       Line =TRUE;
       rewind(input);
    }

    CurrentFileLine = 0;

    for (;;)
    {
       /* EndBedingung ist erfllt, wenn keine Daten mehr
	  im Clipboard-Puffer mehr bereitliegen, d.h wenn
		  der verbleibende Reststring von der Laenge 0 ist.
		*/




       if (!fgets(szText,sizeof(szText),input))
	    if (feof(input))
		break;
	    else
	    {
		PrintError(ERROR_UNEXPECTED_END,NULL);
		return -1;
	    }

       CurrentFileLine++;

       {
	    int slen;
	    slen = strlen(szText);
	    if (slen>0 && szText[slen-1]=='\n')
		szText[slen-1]=0;
       }

       if (Line)
	    szBuffer=ExtractLine(szText);
	else
	    szBuffer=szText;

       if (Hex)
	    ret = ScanTextHex(szBuffer,code+CodeLen,Conv);
       else
	    ret = ScanTextAlpha(szBuffer,code+CodeLen,Conv);

       CodeLen+=ret;

       if (ret<0)
	    return -1;

       if (CodeLen>=MAXSIZE)
       {
	    PrintError(ERROR_MODUL_TO_BIG,NULL);
	    return -1;
       }

    }



    if (CodeLen>0)
    {

	code[CodeLen++]=0xc0;	/* Gepacktes END anfuegen */
	code[CodeLen++]=0x00;
	code[CodeLen++]=0x09;

    }
    CurrentFileLine = 0;
    return CodeLen;
}





int GetModulName(char *code, int CodeLen)
{

    int labels=0;
    int len;
    int i,j;
    int found;

    
    if (function_size==0)
	modul_size=0;

    CurrentCodeLine = 0;

    for (i=0; i<CodeLen; )
    {
		CurrentCodeLine++;

		i   += GetNulls(code);
		code+= GetNulls(code);                               

		switch(TestCode(code))
		{
	    	case TC_END:                          
		    		
/* Fehler, da END hier nicht auftauchen darf ! */
				PrintError(ERROR_UNEXPECTED_END_CODE,NULL);
				return -1;

	    	case TC_LBL_ALPHA:                         
				if (function_size>=MAXROMFUNCTION-1)
				{                                      
		    		PrintError(ERROR_TO_MANY_FUNCTIONS,NULL);
		    		return -1;
				}

/* Kopieren der Alphamarken.
   Test auf Laenge, und auf zulaessige
   Funktionsnamen. Das Byte '\0' darf
   nicht im Namen auftreten.
 */
				len = (int) (code[2] & 0x0f);
				len --;

				if ((len<=0) || (len>7) || (memchr(code+4,0,len)))
				{                                          
		    		PrintError(ERROR_LBL_ALPHA_TEXT_SIZE,NULL);
		    		return -1;
				}

				function_size++;

				memset(function_name[function_size],0,8);
				memcpy(function_name[function_size],code+4,len);
				function_prgm[function_size]=modul_size;
				function_type[function_size]=ROMTYPE_CODE;

				labels++;

/* Gleiche Namen sind nicht erlaubt */
				found=FALSE;
				for (j=1;j<function_size;j++)
			    	if (strcmp(function_name[function_size],function_name[j])==0)
			    	{                                      
						PrintError(ERROR_LBL_ALPHA_SAME_NAME,function_name[j]);
						return -1;
		    		}

		}           
	
		i   +=GetPrgmLen(code);
		code+=GetPrgmLen(code);
    }   
    
    
    CurrentCodeLine = 0;
    modul_size++;
    
    if (labels==0)
    	PrintError(ERROR_PROGRAMM_WITHOUT_LABEL,NULL);

    return labels;
}


int PackNulls(char *code, int *CodeLen)
{
    int  len = *CodeLen;
    int  pos = 0;
    int  nulls;
    int  line= 0;

    int  packed = 0;

    WORD tc  = 0;

    BOOL    IsNumOld = FALSE;
    BOOL    IsNum;

    BOOL    PackAllowed = TRUE;


    char *pcode = code;

    while (pos <len && tc!=TC_END)
    {
	line ++;
	nulls =GetNulls(pcode+pos);
	tc    =TestCode(pcode+pos+nulls);

	IsNum = (tc==TC_NUM);


	if (IsNum && IsNumOld)
	{
	    /* printf("2 Numbers %d\n",line);*/
	    if (nulls>1)
	    {
		nulls--;
		pos++;
		/* printf("Reduced Nulls %d\n",line); */
	    }
	    else
		nulls = 0;
	}

	if (nulls>0)
	{
	    memmove(pcode+pos,pcode+pos+nulls,len-pos-nulls);
	    len-=nulls;
	    packed += nulls;

	    /* printf("Packed Nulls: %d %d\n",line,nulls); */
	}

	IsNumOld = IsNum;

	pos += GetPrgmLen(pcode+pos);

    }

    *CodeLen = len;

    return packed;

}


int ConvertXeqAlpha(char *code, int *CodeLen)
{

    int xeqs=0;
    int len;
    int i,j;
    char buffer[8];
    int found=0;

    CurrentCodeLine = 0;

    for (i=0; i<*CodeLen; )
    {
	CurrentCodeLine++;
	i   +=GetNulls(code);
	code+=GetNulls(code);

	switch(TestCode(code))
	{
	    case TC_GTO_ALPHA:
		PrintWarning(WARNING_GTO_ALPHA_FOUND,NULL);
		i += GetPrgmLen(code);
		code+=GetPrgmLen(code);
		break;

	    case TC_XEQ_ALPHA:

		/* Test auf zulaessige Alpha-Marken */
		/* Dazu wird der Offset verher subtrahiert */

		len  = GetPrgmLen(code);
		len -= 2;

		if ((len<=0) || (len>7) || (memchr(code+2,0,len)))
		    return -1;

		memset(buffer,0,sizeof(buffer));
		memcpy(buffer,code+2,len);

		found = -1;

		for (j=1;j<=function_size;j++)
		    if (strcmp(buffer,function_name[j])==0)
		    {
			found = j;
			break;
		    }

		if (found<0)
		{
		    PrintWarning(WARNING_UNREFERENCED_XEQ_FOUND,NULL);
		    i	+= GetPrgmLen(code);
		    code+=GetPrgmLen(code);

		    break;
		}

		/* Konvertieren der Befehle nach XROM's */

		*code++=0xa0+LOBYTE(( rom_id >> 2) & 0x07);
		*code++=LOBYTE(( rom_id << 6) & 0xc0) +
			LOBYTE(found & 0x003f);

		/* Verschieben des Speicherbereiches */
		memcpy(code, code+len, *CodeLen - i - len);

		xeqs ++;
		i	 += 2;
		*CodeLen -= len;

		break;

	    default:
		i   +=GetPrgmLen(code);
		code+=GetPrgmLen(code);

	}

    }
    CurrentCodeLine = 0;
    return xeqs;
}

int GetLocalLabel(char *code, int offset, int CodeLen, BYTE Label)
{
    int  i;
    BOOL EndFound=FALSE;

    /* Ermitteln des Programmbegins.
     */

    for (i=offset;;)
    {
	i    += GetNulls(code+i);

	switch (TestCode(code+i))
	{
	    case TC_END:
		/* Im Falle das die Adresse bis zum aktuellen
		* END des Programms vorstt, wird die Suche
		* am Beginn  des Programms fotgesetzt.
		* Wenn das END ein zweitesmal gefunden wird,
		* wird die Suche erfolglos abgebrochen.
		*/
		if (!EndFound)
		{
		    EndFound=TRUE;
		    i	 = 0;
		}
		else
		    return -1;
		break;


	    case TC_LBL_SHORT:
		if ((code[i] - 1) == Label)
		    return i;

		/* Sprung zum nchsten Befehl
		 */
		i   += GetPrgmLen(code+i);
		break;

	    case TC_LBL_LONG:
		if (((BYTE) code[i+1] ) == Label)
		    return i;

	    default:
		i   += GetPrgmLen(code+i);
		break;

	}
	if (i>=CodeLen)
	    return -1;
    }

    /* Die Suche war nicht erfolgreich.
     */
    return -1;
}




int ConvertJumps(unsigned char *code, int *CodeLen)
{
    int  i;
    int  jumps = 0;
    int  pos;
    BYTE label;

    int  dirty=0;


    CurrentCodeLine = 0;
    for (i=0; i< *CodeLen; )
    {
	CurrentCodeLine++;
	i    +=GetNulls(code+i);
	switch(TestCode(code+i))
	{
	    case TC_XEQ_LONG:
	    case TC_GTO_LONG:
		jumps++;
		label = ((BYTE) code[i+2] & 0x7f);
		pos=GetLocalLabel(code,i,*CodeLen,label);
		if (pos<0)
		{
		    PrintError(ERROR_LABEL_NOT_FOUND_LONG,NULL);
		    return -1;
		}

		if (pos>i+1)
		{
		    pos = pos - i - 1;
		    code[i+2]|=0x80;
		    code[i+1] =LOBYTE(pos);
		    code[i+0]&=0xf0;
		    code[i+0]|=HIBYTE(pos) & 0x0f;
		}
		else
		{
		    pos = i - pos + 1;
		    code[i+2]&=0x7f;
		    code[i+1] =LOBYTE(pos);
		    code[i+0]&=0xf0;
		    code[i+0]|=HIBYTE(pos) & 0x0f;
		}
		break;

	    case TC_GTO_SHORT:
		jumps++;
		label = ((BYTE) code[i+0] & 0x0f) - 1;
		pos=GetLocalLabel(code,i,*CodeLen,label);
		if (pos<0)
		{             
			
		    PrintError(ERROR_LABEL_NOT_FOUND_SHORT,NULL);
		    return -1;
		}


		if (pos>i+2)
		{
		    pos = pos - i - 2;
		    if (pos >= 128)
		    {
			/* Convert To Long Jump */


			PrintWarning(WARNING_SHORT_JUMP_TO_BIG_PLUS,NULL);
			dirty=1;
			memmove(code+1+i,code+i,*CodeLen-i);

			code[i	]=0xd0;
			code[i+1]=0;
			code[i+2]=label;

			*CodeLen+=1;

		    }
		    else
			code[i+1] = 0x80| LOBYTE(pos);
		}
		else
		{
		    pos = i - pos + 2;
		    if (pos >= 128)
		    {
			/* Convert To Long Jump */

			PrintWarning(WARNING_SHORT_JUMP_TO_BIG_MINUS,NULL);
			dirty=1;
			memmove(code+1+i,code+i,*CodeLen-i);

			code[i	]=0xd0;
			code[i+1]=0;
			code[i+2]=label;

			*CodeLen+=1;

		    }
		    else
			code[i+1]=LOBYTE(pos);
		}
	}
	i+=GetPrgmLen(code+i);
    }
    CurrentCodeLine = 0;
    if (dirty)
	return -2;
    else
	return jumps;
}


int GetModulPositions(int moduls,int offset)
{
    int i;
    int pos=offset;

    for (i=0;i<moduls;i++)
    {
	modul_begin[i]=pos;		    /* Start of PRGM */
	modul_end[i]  =pos+code_size[i]-3;  /* End of Prgm */
	pos	     +=code_size[i];	    /* Next Prgm */
    }
    return moduls;
}




int GetGlobalPositions(char *code,int offset, int codesize)
{
    int	   i;
    int    done	= 0;
    int    pos	= 0;
    static int function=1;
    static int end     =0;



    for (i=offset; i< codesize; )
    {
	i    +=GetNulls(code+i);
	switch(TestCode(code+i))
	{
	    case TC_LBL_ALPHA:
		done++;
		if ((!memcmp(function_name[function],code+4,
			     strlen(function_name[function]))) ||
		    (end != function_prgm[function]))
		{
		    PrintError(ERROR_INTERNAL_1,NULL);
		    return -1;
		}

		function_offset[function++]=i;


		if (pos==0)
		{
		    code[i+0]&=0xf0;
		    code[i+1] =0x00;
		}
		else
		{
		    pos       = i-pos;
		    code[i+0]&=0xf0;
		    code[i+0]|=HIBYTE(pos) & 0x0f;
		    code[i+1] =LOBYTE(pos);
		}
		pos = i;
		break;

	    case TC_END:

		done++;
		end++;

		if (pos==0)
		{
		    code[i+0]&=0xf0;
		    code[i+1] =0x00;
		}
		else
		{
		    pos       = i-pos;
		    code[i+0]&=0xf0;
		    code[i+0]|=HIBYTE(pos) & 0x0f;
		    code[i+1] =LOBYTE(pos);
		}
		pos = i;
		break;
	}

	i+=GetPrgmLen(code+i);
    }
    return done;
}




#define EXIT(a)	\
    {		\
       if (lpData) free(lpData);	\
       if (modul) free(modul); \
       if (function) free (function); \
       if (inp) fclose(inp); \
       if (oup) fclose(oup); \
       if (map) fclose(map); \
       for (CurrentModul=0;CurrentModul<MAXFILES;CurrentModul++){ \
	   if (code_data[CurrentModul]) free(code_data[CurrentModul]); \
       } return a ; \
    }




int main(int argc, char **argv)
{
    char*	lpData = NULL;	// pointers to clip data

    FILE       *inp = NULL;
    FILE       *oup = NULL;
    FILE       *map = NULL;

    ROM_FILE_HEAD	rom    ;
    ROM_CODE	*function	=NULL;
    ROM_MODUL	*modul	=NULL;

    int	       CodeLen;
    int        i,j;   
    int		   moduls;
    int		   rom_check;

    ScanMakeParameters(argc,argv);


    printf("\n\
makerom 1.0 for ttCalc 1.0b, Version \n\
copyright Stefan Seiwerth 2/12/95\n\n");

    for (CurrentModul=0;CurrentModul<MAXFILES;CurrentModul++)
	code_data[CurrentModul]=NULL;

    CurrentModul=0;

    lpData = (char *) malloc(2*MAXSIZE);
    if (!lpData)
    {
    	printf("Unable to malloc data\n");
		EXIT(0);
	}


    if (strlen(rom_map))
    {
		map = fopen(rom_map,"w");

		if (!map) {
	    	sprintf(szError,"cannot open map file '%s'",rom_map);
	    	PrintError(ERROR_OPEN_DEST_MODUL,szError);
	    	EXIT(0);
		}
    }

    oup = fopen(rom_output,"wb");
    if (!oup)
    {

		sprintf(szError,"cannot open output file (%s)",rom_output);
		PrintError(ERROR_OPEN_DEST_MODUL,szError);
		EXIT(0);
    }


    for (j=0;j<rom_files;j++)
    {
	inp = fopen(rom_input[j],"r");

	if (!inp)
	{
	    sprintf(szError,"cannot open input file (%s)",rom_input[j]);
	    PrintError(ERROR_OPEN_INPUT_MODUL,szError);
	    EXIT(0);
	}

	if (verboseFlag)
		printf ("Reading Modul %d : %s\n",CurrentModul,rom_input[j]);
		
	CodeLen = ReadData(inp,lpData);

	if (CodeLen<=0)
	{
	    PrintError(ERROR_READING_DATA,NULL);
	    EXIT(0);
	}

	code_data[CurrentModul] = (char*) malloc(CodeLen);
	if (!code_data[CurrentModul])
	{
	    PrintError(ERROR_MALLOC,NULL);
	    EXIT(0);
	}

	memcpy(code_data[CurrentModul],lpData,CodeLen);

	code_size[CurrentModul] = CodeLen;

	fclose(inp);

	CurrentModul++;


    }

    if (CurrentModul<=0)
    {
		PrintError(ERROR_NO_INPUT_MODULS,NULL);
		EXIT(0);
    }

    moduls = CurrentModul;

    /* Packen der Null-Bytes */
    if (verboseFlag)
    	printf("packing zero bytes .");
    
    for (CurrentModul=0; CurrentModul<moduls; CurrentModul++)
    
		if (PackNulls(code_data[CurrentModul],&code_size[CurrentModul])<0)
	    {   
	    	EXIT(0);                            
	    }
	    else if (verboseFlag)
	    	printf(".");
	    	                        
	if (verboseFlag)
    	printf("\n");

    /* Modulname ermitteln, ohne das END */
    /* Rueckgabeparameter Anzahl der Funktionen */
    if (verboseFlag)
    	printf("checking programnames .");
    
    for (CurrentModul=0; CurrentModul<moduls; CurrentModul++)
		if (GetModulName(code_data[CurrentModul],code_size[CurrentModul]-3)<=0)
	    {                         
	    	EXIT(0);                            
	    }	
	    else if (verboseFlag)
	    	printf(".");


	if (verboseFlag)
    	printf("\n");

    /* Lokale Alpha-XEQ nach XROM konvertieren
       und neue Gesamtlaenge dieses Moduls ermitteln
       Rueckgabewert Anzahl konvertierter XEQ's
     */                                        
     
    
    if (verboseFlag)
    	printf("converting xeq/global alpha .");
     
    for (CurrentModul=0; CurrentModul<moduls; CurrentModul++)
		if (ConvertXeqAlpha(code_data[CurrentModul],&code_size[CurrentModul])<0)
		{
	    	EXIT(0);                            
	    }
	    else if (verboseFlag)
	    	printf(".");


	if (verboseFlag)
    	printf("\n");

    /* Ruecksetzen der Funktionsnamen und neu ermitteln
       der Funktionsnamen
     */
    function_size=0;

    /* Modulname ermitteln, ohne das END */
    /* Rueckgabeparameter Anzahl der Funktionen */
    if (verboseFlag)
    	printf("checking programnames .");
    
    for (CurrentModul=0; CurrentModul<moduls; CurrentModul++)
		if (GetModulName(code_data[CurrentModul],code_size[CurrentModul]-3)<=0)
		{   
	    	EXIT(0);                            
	    }
	    else if (verboseFlag)
	    	printf(".");


	if (verboseFlag)
    	printf("\n");

    if (verboseFlag)
    	printf("converting jumps .");

    for (CurrentModul=0; CurrentModul<moduls; CurrentModul++)
    {
		int ret;

		ret=ConvertJumps(code_data[CurrentModul],&code_size[CurrentModul]);
		if (ret==-2)
	    	ret=ConvertJumps(code_data[CurrentModul],&code_size[CurrentModul]);

		if (ret<0)
		{
	    	EXIT(0);
    	}
	    else if (verboseFlag)
	    	printf(".");


	}
	if (verboseFlag)
    	printf("\n");

    /* printf("JUMP\n");*/

    	CodeLen = 0;
    for (CurrentModul=0; CurrentModul<moduls; CurrentModul++)
    {
	/* printf("%d %d \n",CurrentModul,code_size[CurrentModul]);*/
	CodeLen+=code_size[CurrentModul];
    }


    /* printf("CodeLen %d \n",CodeLen);*/

    if (CodeLen > MAXSIZE - 2)
    {
		PrintError(ERROR_MODUL_SIZE_TO_BIG,NULL);
		EXIT(0);
    }

    if (CodeLen + rom_ofs > MAXSIZE - 2)
    {
		PrintError(ERROR_MODUL_OFS_TO_BIG,NULL);
		EXIT(0);
    }


    CodeLen  = rom_ofs;

    memset(lpData,0,2*MAXSIZE);
    /* printf("CodeLen %d \n",CodeLen);*/

    for (CurrentModul=0; CurrentModul<moduls; CurrentModul++)
    {
	/* printf("CodeLen %d \n",CodeLen);*/
		memcpy(lpData+CodeLen,code_data[CurrentModul],code_size[CurrentModul]);
		CodeLen +=code_size[CurrentModul];
		free(code_data[CurrentModul]);
		code_data[CurrentModul]=NULL;
    }



    /* Adressen fuer globale Marken merken */

    if (GetModulPositions(moduls,rom_ofs)<0)
    {
		PrintError(ERROR_INTERNAL_2,NULL);
		EXIT(0);
    }
    /* printf("MODULS\n");*/

    if (GetGlobalPositions(lpData,rom_ofs,CodeLen)<0)
    {
		PrintError(ERROR_INTERNAL_3,NULL);
		EXIT(0);
    }

    /* printf("GLOBALPOS\n");*/

    memset((char*) &rom,0,sizeof(rom));

    /* printf("MEMSET\n");*/

    function_size++;



    rom.size	=sizeof(ROM_FILE_HEAD)+
		 sizeof(ROM_CODE) *function_size+
		 sizeof(ROM_MODUL)*modul_size+
		 3*ROMCHECK+
		 MAXSIZE;

    /* printf("ROM:%d\n",rom.size);*/

    rom.version =rom_version;
    rom.date	=rom_date;


    strncpy(function_name[0],rom_name,11);
    strncpy(rom.copyright,rom_copyright,63);

    function_type[0]=ROMTYPE_HEADER;

    /*printf("NEXT\n");*/

    rom.id	 =rom_id;
    rom.idintern =rom_idintern;
    rom.functions=function_size;
    rom.moduls	 =modul_size;
    rom.rom_begin=rom_ofs;
    rom.rom_end	 =CodeLen - 3;

    rom.size_functions = sizeof(ROM_CODE) * function_size;
    rom.size_moduls    = sizeof(ROM_MODUL) * modul_size;
    rom.size_rom	   = MAXSIZE;

    rom.ofs_functions  = sizeof(ROM_FILE_HEAD)+ROMCHECK;
    rom.ofs_moduls     = rom.ofs_functions + sizeof(ROM_CODE) * function_size + ROMCHECK;
    rom.ofs_rom	       = rom.ofs_moduls	+ sizeof(ROM_MODUL) * modul_size + ROMCHECK;

    /* printf("Before malloc %d %d\n",rom.size_functions,rom.size_moduls);*/

    function	= (ROM_CODE*) malloc((size_t) rom.size_functions);
    modul	= (ROM_MODUL*) malloc((size_t) rom.size_moduls);

    /* printf("Before int\n");*/




    /* int i;	*/
    /*	   "    12345678901*/

    if (map)
	fprintf(map,"    NAME       MODUL   ID  OFFSET TYPE\n");
    for(i=0;i<function_size;i++)
    {

		char	buffer[20];

		strcpy(function[i].name,function_name[i]);
		function[i].id	      =i+1;
		function[i].type      =function_type[i];
		function[i].status    =0;
		function[i].status_ext=0;
		function[i].offset    =function_offset[i];
		function[i].modul     =function_prgm[i];

		memset(buffer,' ',sizeof(buffer)-1);
		memcpy(buffer,function[i].name,strlen(function[i].name));
		buffer[12]='\0';

		if (map)
	    	fprintf (map,"    %s  %2d   %2d   %04x   %02x\n",
		     buffer,
		     function[i].modul,
		     function[i].id,
		     function[i].offset,
		     function[i].type);
    }

    for(i=0;i<moduls;i++)
    {
		modul[i].begin=modul_begin[i];
		modul[i].end  =modul_end[i];
    }

    /* short rom_check;*/

    /*printf("FWRITE\n");*/

    fwrite((char*) &rom,sizeof(rom),1,oup);

    rom_check = ROMFUNCTIONCHECK;
    fwrite((char*) &rom_check, sizeof(rom_check),1,oup);
    for (i=0;i<function_size;i++)
		fwrite( &function[i],sizeof(ROM_CODE),1,oup);

    rom_check = ROMMODULCHECK;
    fwrite((char*) &rom_check, sizeof(rom_check),1,oup);
    for (i=0;i<modul_size;i++)
		fwrite( &modul[i],sizeof(ROM_MODUL),1,oup);

    rom_check = ROMROMCHECK;
    fwrite((char*) &rom_check, sizeof(rom_check),1,oup);
    fwrite((char*) lpData,rom.size_rom,1,oup);

    fclose(oup);


    free(lpData);
    EXIT(0);
}
