
#ifndef __ROM_H__
#define __ROM_H__


#define MAXROM		    32
#define MAXROMFUNCTION	    64
#define MAXROMSIZE	  4096
#define MAXROMPATH	   128
#define MAXROMEXT	     6
#define ROMCHECK	     2

#define ROMFUNCTIONCHECK    0x1234
#define ROMMODULCHECK	    0x5678
#define ROMROMCHECK	    0x9abc
#define MAXROMHEAD	   256

#define ROMTYPE_CODE	     1
#define ROMTYPE_HEADER	     0
#define ROMTYPE_FUNCTION     2



#ifndef ushort
typedef unsigned short ushort;
#endif

#ifndef ulong
typedef unsigned long  ulong;
#endif

#ifndef WORD
typedef unsigned short WORD;
#endif

#ifndef UINT
typedef unsigned int   UINT;
#endif

#ifndef BYTE
typedef unsigned char  BYTE;
#endif

#ifndef BOOL
typedef int	       BOOL;
#endif


typedef struct ROM_CODE_tag {
    char    name[12];
    ushort  id;
    ushort  type;
    ushort  status;
    ulong   status_ext;
    ushort  offset;
    ushort  modul;
} ROM_CODE;




typedef struct ROM_MODUL_tag {
    ushort  begin;
    ushort  end;
} ROM_MODUL;

typedef ROM_CODE  _far* LP_ROM_CODE;
typedef ROM_MODUL _far* LP_ROM_MODUL;

typedef union ROM_FILE_HEAD_tag
{
    long     dummy_1[MAXROMHEAD];	/* Dummy-Block	*/

    struct
    {
    long     size;	    /* Size of the File */
    long     version;	    /* Versionnumber	*/
    long     date;	    /* Datum		*/
    char     copyright[64];  /* Tetesoft ...	*/
    char     name[16];	    /* Name of the ROM	*/
    ushort   idintern;	    /* Internal ID	*/
    ushort   id;	    /* ID: 1..31	*/

    ushort   functions;	    /* Number of functions */
    ushort   moduls;	    /* Number of Moduls    */


    ushort   rom_begin;	    /* Beginning of the ROM-Code */
    ushort   rom_end;	    /* End of the ROM-Code */

    ushort   ofs_functions;
    ushort   ofs_moduls;
    ushort   ofs_rom;

    short    size_functions;
    short    size_moduls;
    short    size_rom;



    char	_far *rom;
    LP_ROM_CODE	 function;
    LP_ROM_MODUL modul;


    };

} ROM_FILE_HEAD;



typedef ROM_FILE_HEAD ROM_HEAD;


#define MAXROMPOSSIBLE_SIZE (sizeof(ROM_HEAD) + \
			     sizeof(ROM_CODE) * MAXROMFUNCTION +   \
			     sizeof(ROM_MODUL) * MAXROMFUNCTION + \
			     3*ROMCHECK +   \
			     MAXROMSIZE)
#define MINROMPOSSIBLE_SIZE (sizeof(ROM_HEAD) +	 \
			     sizeof(ROM_CODE) +   \
			     sizeof(ROM_MODUL) + \
			     3*ROMCHECK +   \
			     MAXROMSIZE)


extern ROM_HEAD _far* rom[MAXROM];
extern char	      szRomPath[MAXROMPATH];
extern char	      szRomExt[MAXROMEXT];




extern int InitRomFiles();


#endif /* __ROM_H */
