// Debugger.cpp : implementation file
//

#include "stdafx.h"
#include "creem.h"
#include "Debugger.h"

#include "creem.h"
#include "disasm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDebugger dialog

#define LINES	18

CDebugger::CDebugger(CWnd* pParent /*=NULL*/)
	: CDialog(CDebugger::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDebugger)
	m_regs = _T("");
	m_jumpaddr = _T("$08000000");
	m_numcycles = _T("1");
	m_breakaddr = _T("$08000000");
	//}}AFX_DATA_INIT
needupdate = 1;
regs = 0;
debugaddr = 0;
cycles = 0;
up.LoadBitmap(IDB_UP);
down.LoadBitmap(IDB_DOWN);
}


BOOL CDebugger::OnInitDialog()
{
CDialog::OnInitDialog();
m_up.SetBitmap(up);
m_down.SetBitmap(down);
m_disasm.InitStorage(LINES,256);
return(TRUE);
}

void CDebugger::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDebugger)
	DDX_Control(pDX, IDC_DOWN, m_down);
	DDX_Control(pDX, IDC_UP, m_up);
	DDX_Control(pDX, IDC_DISASM, m_disasm);
	DDX_Text(pDX, IDC_REGS, m_regs);
	DDV_MaxChars(pDX, m_regs, 512);
	DDX_Text(pDX, IDC_JUMPADDR, m_jumpaddr);
	DDV_MaxChars(pDX, m_jumpaddr, 10);
	DDX_Text(pDX, IDC_NUMCYCLES, m_numcycles);
	DDV_MaxChars(pDX, m_numcycles, 10);
	DDX_Text(pDX, IDC_BREAKADDR, m_breakaddr);
	DDV_MaxChars(pDX, m_breakaddr, 10);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDebugger, CDialog)
	//{{AFX_MSG_MAP(CDebugger)
	ON_BN_CLICKED(IDC_UP, OnUp)
	ON_BN_CLICKED(IDC_DOWN, OnDown)
	ON_BN_CLICKED(IDC_JUMP, OnJump)
	ON_BN_CLICKED(IDC_RUNCYCLES, OnRuncycles)
	ON_BN_CLICKED(IDC_BREAK, OnBreak)
	ON_WM_MOVE()
	ON_EN_CHANGE(IDC_JUMPADDR, OnChangeJumpaddr)
	ON_EN_CHANGE(IDC_NUMCYCLES, OnChangeNumcycles)
	ON_EN_CHANGE(IDC_BREAKADDR, OnChangeBreakaddr)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

char *CDebugger::getmodename(u8 m,char *dest)
{
switch(m)
	{
	case SYSTEM:strcpy(dest,"system");break;
	case USER:strcpy(dest,"user");break;
	case FIQ:strcpy(dest,"fiq");break;
	case SUPERVISOR:strcpy(dest,"supervisor");break;
	case ABORT:strcpy(dest,"abort");break;
	case IRQ:strcpy(dest,"irq");break;
	case UNDEFINED:strcpy(dest,"undefined");break;
	default:strcpy(dest,"???");break;
	}
return(dest);
}

u8 read8(u32 addr)
{
switch((addr >> 24) & 0xf)
	{
	case 0x00:if(addr < 0x4000)return(bios[addr & 0x3fff]);else break;
	case 0x01:break;
	case 0x02:return(ewram[addr & 0x3ffff]);
	case 0x03:return(iwram[addr & 0x7fff]);
	case 0x04:return(read8_registers(addr));
	case 0x05:return(pram[addr & 0x3ff]);
	case 0x06:return(vram[addr % 0x18000]);
	case 0x07:return(oam[addr & 0x3ff]);
	default:return(rom[addr & rommask]);
	}
return(0);
}
u16 read16(u32 addr)
{
return((u16)(read8(addr) | (read8(addr+1) << 8)));
}
u32 read32(u32 addr)
{
return((u32)(read16(addr) | (read16(addr+2) << 16)));
}
void write8(u32 addr,u8 value)
{
switch((addr >> 24) & 0xf)
	{
	case 0x00:break;
	case 0x01:break;
	case 0x02:ewram[addr & 0x3ffff] = value;break;
	case 0x03:iwram[addr & 0x7fff] = value;break;
	case 0x04:write8_registers(addr,value);break;
	case 0x05:pram[addr & 0x3ff] = value;break;
	case 0x06:vram[addr % 0x18000] = value;break;
	case 0x07:oam[addr & 0x3ff] = value;break;
	default:break;
	}
}
void write16(u32 addr,u16 value)
{
write8(addr+0,(u8)value);
write8(addr+1,(u8)(value >> 8));
}
void write32(u32 addr,u32 value)
{
write8(addr+0,(u8)value);
write8(addr+1,(u8)(value >> 8));
write8(addr+2,(u8)(value >> 16));
write8(addr+3,(u8)(value >> 24));
}

void CDebugger::reset() //call after CCreemApp::reset
{
s32 checky;

arm7tdmi_getcontext(regs);
needupdate = 1;
//debugaddr = regs->regs[15] - 8;
debugaddr = regs->regs[15] - (regs->state==ARM_MODE?8:4) - ((LINES / 2) * (regs->state==ARM_MODE?4:2));
checky = regs->regs[15] - (regs->state==ARM_MODE?8:4) - ((LINES / 2) * (regs->state==ARM_MODE?4:2));
if(checky < 0 && (regs->regs[15] & 0x80000000) == 0)
	debugaddr = 0;
m_jumpaddr.Format("$%08x",debugaddr);
UpdateData(FALSE);
OnJump();
m_jumpaddr.Format("$%08x",settings->startaddr);
UpdateData(FALSE);
}

void CDebugger::update()
{
if(needupdate)
	{
	int i,j,sl;
	char str[256];
	u8 opsize;
	char modestr[32];
	u32 pc;

	m_regs.Format("$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n$%08X\n%c%c%c%c\n%s\n%ld",regs->regs[0],regs->regs[1],regs->regs[2],regs->regs[3],regs->regs[4],regs->regs[5],regs->regs[6],regs->regs[7],regs->regs[8],regs->regs[9],regs->regs[10],regs->regs[11],regs->regs[12],regs->regs[13],regs->regs[14],regs->regs[15],regs->regs[16],(regs->regs[16] & NEGATIVE)?'N':'-',(regs->regs[16] & ZERO)?'Z':'-',(regs->regs[16] & CARRY)?'C':'-',(regs->regs[16] & OVERFLOW)?'O':'-',getmodename((u8)(regs->regs[16] & 0x1f),modestr),arm7tdmi_getcycles());
	if(regs->state == ARM_MODE)
		opsize = 4;
	else
		opsize = 2;
	m_disasm.ResetContent();
	for(i=0;i<LINES;i++)
		{
		pc = debugaddr + (i * opsize);
		if(regs->state == THUMB_MODE)
			disasmopcode((u32)read16(pc),pc,THUMB_MODE,str);
		else
			disasmopcode(read32(pc),pc,ARM_MODE,str);
		sl = strlen(str);
		for(j=0;j<sl;j++)
			{
			if(str[j] == '\n')
				str[j] = ' ';
			}
		m_disasm.AddString(str);
		}
	if(theApp.memorydlg)
		theApp.memorydlg->update();
	m_disasm.SetCurSel(((regs->regs[15] - (regs->state==ARM_MODE?8:4)) - debugaddr) / (regs->state==ARM_MODE?4:2));
	needupdate = 0;
	UpdateData(FALSE);
	}
}

void CDebugger::incscanline()
{
if((GETREG16(DM0CNT_H) & 0xb000) == 0xa000)dma0(); //hblank dmas
if((GETREG16(DM1CNT_H) & 0xb000) == 0xa000)dma1();
if((GETREG16(DM2CNT_H) & 0xb000) == 0xa000)dma2();
if((GETREG16(DM3CNT_H) & 0xb000) == 0xa000)dma3();
if(GETREG16(IE) & 0x0002 && GETREG16(DISPSTAT) & 0x0010) //hblank irq
	{
	GETREG16(IF) |= 0x0002;
	arm7tdmi_irq();
	}
scanline++;
if(scanline == (u8)(GETREG16(DISPSTAT) >> 8)) //vcount match
	{
	GETREG16(DISPSTAT) |= 4;
	if(GETREG16(IE) & 0x0004 && GETREG16(DISPSTAT) & 0x0020) //vblank irq
		{
		GETREG16(IF) |= 0x0004;
		arm7tdmi_irq();
		}
	}
else
	GETREG16(DISPSTAT) &= ~4;
if(scanline == 160)
	{
	GETREG16(DISPSTAT) |= 1; //set vblank bit
	if((GETREG16(DM0CNT_H) & 0xb000) == 0x9000)dma0(); //hblank dmas
	if((GETREG16(DM1CNT_H) & 0xb000) == 0x9000)dma1();
	if((GETREG16(DM2CNT_H) & 0xb000) == 0x9000)dma2();
	if((GETREG16(DM3CNT_H) & 0xb000) == 0x9000)dma3();
	if(GETREG16(IE) & 0x0001 && GETREG16(DISPSTAT) & 0x0008) //vblank irq
		{
		GETREG16(IF) |= 0x0001;
		arm7tdmi_irq();
		}
	}
else if(scanline >= 228) //scanline 228 = scanline 0, end of frame
	{
	scanline = 0;
	GETREG16(DISPSTAT) &= ~1; //clear vblank bit
	}
}

/////////////////////////////////////////////////////////////////////////////
// CDebugger message handlers

void CDebugger::OnOK()
{
	// TODO: Add extra validation here
	
	CDialog::OnOK();
theApp.OnViewDebugger();
}

void CDebugger::OnUp() 
{
	// TODO: Add your control notification handler code here
if(debugaddr != 0)
	{
	if(regs->state == ARM_MODE)
		debugaddr -= 4;
	else
		debugaddr -= 2;
	needupdate = 1;
	}
}

void CDebugger::OnDown() 
{
	// TODO: Add your control notification handler code here
if(debugaddr <= 0xfffffff0)
	{
	if(regs->state == ARM_MODE)
		debugaddr += 4;
	else
		debugaddr += 2;
	needupdate = 1;
	}
}

void CDebugger::OnJump() 
{
	// TODO: Add your control notification handler code here
char *p,*stop;
int base = 10;

UpdateData(TRUE);
p = m_jumpaddr.GetBuffer(512);
if(strcmp(p,"") != 0)
	{
	if(*p == '$')
		{
		p++;
		base = 16;
		}
	else if((*p == '0' && (*(p+1) == 'x') || (*p == '0' && *(p+1) == 'X')))
		{
		p += 2;
		base = 16;
		}
	debugaddr = strtol(p,&stop,base);
	arm7tdmi_getcontext(regs);
	debugaddr &= ~(regs->state==ARM_MODE?3:1);
	needupdate = 1;
	}
}

void CDebugger::OnRuncycles() 
{
	// TODO: Add your control notification handler code here
char *p,*stop;
int base = 10;
u32 c,num,t;

UpdateData(TRUE);
p = m_numcycles.GetBuffer(512);
if(strcmp(p,"") != 0)
	{
	if(*p == '$')
		{
		p++;
		base = 16;
		}
	else if((*p == '0' && (*(p+1) == 'x') || (*p == '0' && *(p+1) == 'X')))
		{
		p += 2;
		base = 16;
		}
	num = strtol(p,&stop,base);
	num &= 0x07ffffff;
	for(c=0;c<num;)
		{
		t = arm7tdmi_executeop();
		if(t & 0xf0000000)
			{
			::MessageBox(0,"arm7tdmi error","error",MB_OK);
			break;
			}
		else
			{
			c += t;
			cycles += t;
			if(cycles > gba_timing->scanline_cycles)
				{
				cycles -= gba_timing->scanline_cycles;
				incscanline();
				}
			}
		}
	arm7tdmi_getcontext(regs);
	debugaddr = regs->regs[15] - (regs->state==ARM_MODE?8:4) - ((LINES / 2) * (regs->state==ARM_MODE?4:2));
	needupdate = 1;
	}
}

void CDebugger::OnBreak() 
{
	// TODO: Add your control notification handler code here
char *p,*stop;
int base = 10;
u32 num,t;

UpdateData(TRUE);
p = m_breakaddr.GetBuffer(512);
if(strcmp(p,"") != 0)
	{
	if(*p == '$')
		{
		p++;
		base = 16;
		}
	else if((*p == '0' && (*(p+1) == 'x') || (*p == '0' && *(p+1) == 'X')))
		{
		p += 2;
		base = 16;
		}
	num = strtol(p,&stop,base);
	for(;;)
		{
		t = arm7tdmi_execute(1);
		if(t & 0xf0000000)
			{
			::MessageBox(0,"arm7tdmi error","error",MB_OK);
			break;
			}
		else
			{
			arm7tdmi_getcontext(regs);
//emumessage("pc: %08x   -   break addr+8: %08x\n",regs->regs[15],(num + (regs->state==ARM_MODE?8:4)));
			if(regs->regs[15] == (num + (regs->state==ARM_MODE?8:4)))
				break;
			}
		if(GetAsyncKeyState(VK_F1))
			break;
		}
	arm7tdmi_getcontext(regs);
	debugaddr = regs->regs[15] - (regs->state==ARM_MODE?8:4) - ((LINES / 2) * (regs->state==ARM_MODE?4:2));
	needupdate = 1;
	}
}

void CDebugger::OnMove(int x, int y) 
{
	CDialog::OnMove(x, y);
	
	// TODO: Add your message handler code here
RECT r;

GetWindowRect(&r);
settings->debugger_x = r.left;
settings->debugger_y = r.top;
}

void CDebugger::OnChangeJumpaddr() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
}

void CDebugger::OnChangeNumcycles() 
{
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
}

void CDebugger::OnChangeBreakaddr() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CDialog::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);
}

void CDebugger::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnClose();
theApp.OnViewDebugger();
}

BOOL CDebugger::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
if(LOWORD(wParam) == IDCANCEL)
	{
	theApp.OnViewDebugger();
	return(1);
	}
else
	return CDialog::OnCommand(wParam, lParam);
}
