#if !defined(AFX_DEBUGGER_H__4AE2DF81_4E20_11D5_BCEA_00A0CCD69DE3__INCLUDED_)
#define AFX_DEBUGGER_H__4AE2DF81_4E20_11D5_BCEA_00A0CCD69DE3__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// Debugger.h : header file
//
#include "arm7tdmi.h"
/////////////////////////////////////////////////////////////////////////////
// CDebugger dialog

class CDebugger : public CDialog
{
private:
	CBitmap up,down;
	arm7tdmi *regs;
	u32 debugaddr;
	u8 needupdate;
	u32 cycles;
// Construction
public:
	void reset();
	void setaddr(u32 addr){debugaddr = addr;}
	void setregs(arm7tdmi *r){regs = r;}
	char *getmodename(u8 m,char *dest);
	void update();
	void incscanline();
	CDebugger(CWnd* pParent = NULL);   // standard constructor

// Dialog Data
	//{{AFX_DATA(CDebugger)
	enum { IDD = IDD_DEBUGGER };
	CButton	m_down;
	CButton	m_up;
	CListBox	m_disasm;
	CString	m_regs;
	CString	m_jumpaddr;
	CString	m_numcycles;
	CString	m_breakaddr;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDebugger)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	virtual BOOL OnCommand(WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

// Implementation
protected:

	// Generated message map functions
	//{{AFX_MSG(CDebugger)
	virtual void OnOK();
	afx_msg void OnUp();
	afx_msg void OnDown();
	afx_msg void OnJump();
	afx_msg void OnRuncycles();
	afx_msg void OnBreak();
	afx_msg void OnMove(int x, int y);
	afx_msg void OnChangeJumpaddr();
	afx_msg void OnChangeNumcycles();
	afx_msg void OnChangeBreakaddr();
	afx_msg void OnClose();
	virtual BOOL OnInitDialog();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DEBUGGER_H__4AE2DF81_4E20_11D5_BCEA_00A0CCD69DE3__INCLUDED_)
