#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#define THUMBHACK

typedef unsigned char u8;
typedef unsigned short u16;

char *seperator = "/*********************************************************************************************/";

void sprintfcat(char *dest,char *str,...)
{
va_list args;
char msg[512];
int sl;

va_start(args,str);
vsprintf(msg,str,args);
va_end(args);
sl = strlen(msg);
strcat(dest,msg);
}

void emit_str(char *buf,u16 bits,u8 thing)
{
char operandfunc[64] = "";
char operation[4];
char writefunc[8];
char cast[8] = "";

if(bits & 0x20) //reg
	sprintf(operandfunc,"regshift");
if(bits & 0x08) //up
	sprintf(operation,"+");
else //down
	sprintf(operation,"-");
if(bits & 0x04) //byte
	{
	sprintf(writefunc,"write8");
	sprintf(cast,"(u8)");
	}
else
	sprintf(writefunc,"write32");
if((bits & 0x02) || (bits & 0x10) == 0) //writeback (or force if its post)
	sprintfcat(operation,"=");
if(thing == 1) //get the function name
	sprintf(buf,"op_str%s_%s_%s_%s%s",(bits&0x04)?"b":"",(bits&0x20)?"reg":"imm",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits & 0x10)==0?"":(bits&0x02)?"_wb":"_nowb");
else if(thing == 2) //get the disassembly function string
	{}
else //make the function
	{
	if((bits & 0x02) && (bits & 0x10) == 0) //already made this func
		return;
	sprintfcat(buf,"void op_str%s_%s_%s_%s%s()\n",(bits&0x04)?"b":"",(bits&0x20)?"reg":"imm",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits & 0x10)==0?"":(bits&0x02)?"_wb":"_nowb");
	sprintfcat(buf,"{\n");
	if(bits & 0x10) //pre
		sprintfcat(buf,"%s((REGS((OPCODE >> 16) & 0xf) %s %s(OPCODE & 0xfff)),%sREGS((OPCODE >> 12) & 0xf));\n",writefunc,operation,operandfunc,cast);
	else //post
		{
		sprintfcat(buf,"rn = (u8)((OPCODE >> 16) & 0xf);\n");
		sprintfcat(buf,"%s(REGS(rn),%sREGS((OPCODE >> 12) & 0xf));\n",writefunc,cast);
		sprintfcat(buf,"REGS(rn) %s %s(OPCODE & 0xfff);\n",operation,operandfunc);
		}
	sprintfcat(buf,"cyclesexec += 2;\n");
	sprintfcat(buf,"incpipe();\n");
	sprintfcat(buf,"}\n");
	sprintfcat(buf,"%s\n",seperator);
	}
}

void emit_ldr(char *buf,u16 bits,u8 thing)
{
char operandfunc[64] = "";
char operation[4];
char writefunc[8];
char addrmod[12] = "";
char cast[8] = "";

if(bits & 0x20) //reg
	sprintf(operandfunc,"regshift");
if(bits & 0x08) //up
	sprintf(operation,"+");
else //down
	sprintf(operation,"-");
if(bits & 0x04) //byte
	{
	sprintf(cast,"(u32)");
	sprintf(writefunc,"read8");
	}
else
	{
	sprintf(writefunc,"read32");
	sprintf(addrmod," & ~3");
	}
if((bits & 0x02) || (bits & 0x10) == 0) //writeback (or force if its post)
	sprintfcat(operation,"=");
if(thing == 1)
	sprintf(buf,"op_ldr%s_%s_%s_%s%s",(bits&0x04)?"b":"",(bits&0x20)?"reg":"imm",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits & 0x10)==0?"":(bits&0x02)?"_wb":"_nowb");
else if(thing == 2)
	{}
else
	{
	if((bits & 0x02) && (bits & 0x10) == 0) //already made this func
		return;
	sprintfcat(buf,"void op_ldr%s_%s_%s_%s%s()\n",(bits&0x04)?"b":"",(bits&0x20)?"reg":"imm",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits & 0x10)==0?"":(bits&0x02)?"_wb":"_nowb");
	sprintfcat(buf,"{\n");
	sprintfcat(buf,"rd = (u8)((OPCODE >> 12) & 0xf);\n");
	if(bits & 0x10) //pre
		{
		sprintfcat(buf,"addr = ((REGS((OPCODE >> 16) & 0xf) %s %s(OPCODE & 0xfff)));\n",operation,operandfunc);
		sprintfcat(buf,"REGS(rd) = %s%s(addr%s);\n",cast,writefunc,addrmod);
		}
	else //post
		{
		sprintfcat(buf,"rn = (u8)((OPCODE >> 16) & 0xf);\n");
		sprintfcat(buf,"addr = REGS(rn);\n");
		sprintfcat(buf,"REGS(rd) = %s%s(addr%s);\n",cast,writefunc,addrmod);
		}
	if((bits & 0x04) == 0) //word
		{
#ifdef THUMBHACK
		sprintfcat(buf,"if(addr & ldrmask)\n");
#else
		sprintfcat(buf,"if(addr & 3)\n");
#endif
		sprintfcat(buf,"\t{\n");
		sprintfcat(buf,"\taddr = (addr & 3) * 8;\n");
		sprintfcat(buf,"\tREGS(rd) = (REGS(rd) >> addr) | (REGS(rd) << (32 - addr));\n");
		sprintfcat(buf,"\t}\n");
		}
	if((bits & 0x10) == 0) //post
		sprintfcat(buf,"REGS(rn) %s %s((OPCODE & 0xfff));\n",operation,operandfunc);
	sprintfcat(buf,"cyclesexec += 3;\n");
	sprintfcat(buf,"if(rd == 15)\n");
	sprintfcat(buf,"\t{\n");
	sprintfcat(buf,"\tPC &= ~1;\n");
	sprintfcat(buf,"\tcyclesexec += 2;\n");
	sprintfcat(buf,"\tfillpipe();\n");
	sprintfcat(buf,"\t}\n");
	sprintfcat(buf,"else\n");
	sprintfcat(buf,"\tincpipe();\n");
	sprintfcat(buf,"}\n");
	sprintfcat(buf,"%s\n",seperator);
	}
}

void emit_swp(char *buf,u16 bits,u8 thing)
{
if(thing == 1)
	sprintf(buf,"op_swp_%s",(bits&0x04)?"byte":"word");
else if(thing == 2)
	{}
else
	{
	sprintfcat(buf,"void op_swp_%s()\n",(bits&0x04)?"byte":"word");
	sprintfcat(buf,"{\n");
	sprintfcat(buf,"u32 addr = REGS((OPCODE >> 16) & 0xf);\n");
	sprintfcat(buf,"\n");
	if(bits & 0x04) //byte
		{
		sprintfcat(buf,"REGS((OPCODE >> 12) & 0xf) = (u32)read8(addr);\n");
		sprintfcat(buf,"write8(addr,(u8)REGS(OPCODE & 0xf));\n");
		}
	else
		{
		sprintfcat(buf,"REGS((OPCODE >> 12) & 0xf) = read32(addr);\n");
		sprintfcat(buf,"write32(addr,REGS(OPCODE & 0xf));\n");
		}
	sprintfcat(buf,"cyclesexec += 4;\n");
	sprintfcat(buf,"incpipe();\n");
	sprintfcat(buf,"}\n");
	sprintfcat(buf,"%s\n",seperator);
	}
}

void emit_strh(char *buf,u16 bits,u8 thing)
{
u8 lowerbits = bits & 0xf;
char operation[4];
char operand[64];

bits >>= 4;
if(bits & 0x08) //up
	sprintf(operation,"+");
else //down
	sprintf(operation,"-");
if((bits & 0x02) || (bits & 0x10) == 0) //writeback (or force if its post)
	sprintfcat(operation,"=");
if(bits & 0x04) //imm
	sprintf(operand,"(((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))");
else
	sprintf(operand,"REGS(OPCODE & 0xf)");
if(thing == 1)
	sprintf(buf,"op_strh_%s_%s_%s%s",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits & 0x04)?"imm":"reg",(bits & 0x10)==0?"":(bits&0x02)?"_wb":"_nowb");
else if(thing == 2)
	{}
else
	{
	if((bits & 0x02) && (bits & 0x10) == 0) //already made this func
		return;
	if((lowerbits & 6) != 2) //only generate one function
		return;
	sprintfcat(buf,"void op_strh_%s_%s_%s%s()\n",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits & 0x04)?"imm":"reg",(bits & 0x10)==0?"":(bits&0x02)?"_wb":"_nowb");
	sprintfcat(buf,"{\n");
	sprintfcat(buf,"rd = (u8)((OPCODE >> 12) & 0xf);\n");
	sprintfcat(buf,"rn = (u8)((OPCODE >> 16) & 0xf);\n");
	if(bits & 0x10) //pre
		sprintfcat(buf,"write16((REGS(rn) %s %s),(u16)REGS(rd));\n",operation,operand);
	else //post
		{
		sprintfcat(buf,"write16(REGS(rn),(u16)REGS(rd));\n");
		sprintfcat(buf,"REGS(rn) %s %s;\n",operation,operand);
		}
	sprintfcat(buf,"cyclesexec += 2;\n");
	sprintfcat(buf,"incpipe();\n");
	sprintfcat(buf,"}\n");
	sprintfcat(buf,"%s\n",seperator);
	}
}

void emit_ldrh(char *buf,u16 bits,u8 thing)
{
u8 lowerbits = bits & 0xf;
char loadfunc[8];
char cast[12];
char type[2];
char operation[4];
char operand[64];

bits >>= 4;
if((lowerbits & 6) == 6) //signed halfwords
	{
	sprintf(loadfunc,"read16");
	sprintf(cast,"(s32)(s16)");
	sprintf(type,"sh");
	}
else if((lowerbits & 6) == 4) //signed bytes
	{
	sprintf(loadfunc,"read8");
	sprintf(cast,"(s32)(s8)");
	sprintf(type,"sb");
	}
else if((lowerbits & 6) == 2) //unsigned halfwords
	{
	sprintf(loadfunc,"read16");
	sprintf(cast,"(u32)");
	sprintf(type,"h");
	}
if(bits & 0x08) //up
	sprintf(operation,"+");
else //down
	sprintf(operation,"-");
if((bits & 0x02) || (bits & 0x10) == 0) //writeback (or force if its post)
	sprintfcat(operation,"=");
if(bits & 0x04) //imm
	sprintf(operand,"(((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf))");
else
	sprintf(operand,"REGS(OPCODE & 0xf)");
if(thing == 1)
	sprintf(buf,"op_ldr%s_%s_%s_%s%s",type,(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits & 0x04)?"imm":"reg",(bits & 0x10)==0?"":(bits&0x02)?"_wb":"_nowb");
else if(thing == 2)
	{}
else
	{
	if((bits & 0x02) && (bits & 0x10) == 0) //already made this func
		return;
	sprintfcat(buf,"void op_ldr%s_%s_%s_%s%s()\n",type,(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits & 0x04)?"imm":"reg",(bits & 0x10)==0?"":(bits&0x02)?"_wb":"_nowb");
	sprintfcat(buf,"{\n");
	sprintfcat(buf,"rd = (u8)((OPCODE >> 12) & 0xf);\n");
	sprintfcat(buf,"rn = (u8)((OPCODE >> 16) & 0xf);\n");
	if(bits & 0x10) //pre
		sprintfcat(buf,"REGS(rd) = %s%s((REGS(rn) %s %s));\n",cast,loadfunc,operation,operand);
	else //post
		{
		sprintfcat(buf,"REGS(rd) = %s%s(REGS(rn));\n",cast,loadfunc);
		sprintfcat(buf,"REGS(rn) %s %s;\n",operation,operand);
		}
	sprintfcat(buf,"cyclesexec += 3;\n");
	sprintfcat(buf,"if(rd == 15)\n");
	sprintfcat(buf,"\t{\n");
	sprintfcat(buf,"\tPC &= ~1;\n");
	sprintfcat(buf,"\tcyclesexec += 2;\n");
	sprintfcat(buf,"\tfillpipe();\n");
	sprintfcat(buf,"\t}\n");
	sprintfcat(buf,"else\n");
	sprintfcat(buf,"\tincpipe();\n");
	sprintfcat(buf,"}\n");
	sprintfcat(buf,"%s\n",seperator);
	}
}

void emit_stm(char *buf,u16 bits,u8 thing)
{
char operation[4];

if(bits & 0x08) //up
	sprintf(operation,"+=");
else //down
	sprintf(operation,"-=");
if(thing == 1) //get the function name
	sprintf(buf,"op_stm_%s_%s_%s_%s",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits&0x04)?"load":"noload",(bits&0x02)?"wb":"nowb");
else if(thing == 2) //get the disassembly function string
	{}
else //make the function
	{
	sprintfcat(buf,"void op_stm_%s_%s_%s_%s()\n",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits&0x04)?"load":"noload",(bits&0x02)?"wb":"nowb");
	sprintfcat(buf,"{\n");
	sprintfcat(buf,"int i;\n");
	sprintfcat(buf,"\n");
	sprintfcat(buf,"rn = (u8)((OPCODE >> 16) & 0xf);\n");
	sprintfcat(buf,"addr = REGS(rn);\n");
	if(bits & 0x08) //up
		sprintfcat(buf,"for(i=0;i<16;i++)\n");
	else //down
		sprintfcat(buf,"for(i=15;i>=0;i--)\n");
	sprintfcat(buf,"\t{\n");
	sprintfcat(buf,"\tif(OPCODE & (1 << i))\n");
	sprintfcat(buf,"\t\t{\n");
	if(bits & 0x10) //pre
		sprintfcat(buf,"\t\taddr %s 4;\n",operation);
	sprintfcat(buf,"\t\twrite32(addr,REGS(i));\n");
	if((bits & 0x10) == 0) //post
		sprintfcat(buf,"\t\taddr %s 4;\n",operation);
	sprintfcat(buf,"\t\tcyclesexec++;\n");
	sprintfcat(buf,"\t\t}\n");
	sprintfcat(buf,"\t}\n");
	if(bits & 0x02) //writeback
		sprintfcat(buf,"REGS(rn) = addr;\n");
	sprintfcat(buf,"cyclesexec += 1;\n");
	sprintfcat(buf,"incpipe();\n");
	sprintfcat(buf,"}\n");
	sprintfcat(buf,"%s\n",seperator);
	}
}

void emit_ldm(char *buf,u16 bits,u8 thing)
{
char operation[4];

if(bits & 0x08) //up
	sprintf(operation,"+=");
else //down
	sprintf(operation,"-=");
if(thing == 1) //get the function name
	sprintf(buf,"op_ldm_%s_%s_%s_%s",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits&0x04)?"load":"noload",(bits&0x02)?"wb":"nowb");
else if(thing == 2) //get the disassembly function string
	{}
else //make the function
	{
	sprintfcat(buf,"void op_ldm_%s_%s_%s_%s()\n",(bits&0x10)?"pre":"post",(bits&0x08)?"up":"down",(bits&0x04)?"load":"noload",(bits&0x02)?"wb":"nowb");
	sprintfcat(buf,"{\n");
	sprintfcat(buf,"int i;\n");
	sprintfcat(buf,"\n");
	sprintfcat(buf,"rn = (u8)((OPCODE >> 16) & 0xf);\n");
	sprintfcat(buf,"addr = REGS((OPCODE >> 16) & 0xf);\n");
	if(bits & 0x08) //up
		sprintfcat(buf,"for(i=0;i<16;i++)\n");
	else //down
		sprintfcat(buf,"for(i=15;i>=0;i--)\n");
	sprintfcat(buf,"\t{\n");
	sprintfcat(buf,"\tif(OPCODE & (1 << i))\n");
	sprintfcat(buf,"\t\t{\n");
	if(bits & 0x10) //pre
		sprintfcat(buf,"\t\taddr %s 4;\n",operation);
	sprintfcat(buf,"\t\tREGS(i) = read32(addr);\n");
	if((bits & 0x10) == 0) //post
		sprintfcat(buf,"\t\taddr %s 4;\n",operation);
	sprintfcat(buf,"\t\tcyclesexec++;\n");
	sprintfcat(buf,"\t\t}\n");
	sprintfcat(buf,"\t}\n");
	if(bits & 0x02) //writeback
		sprintfcat(buf,"REGS(rn) = addr;\n");
	sprintfcat(buf,"cyclesexec += 2;\n");
	sprintfcat(buf,"incpipe();\n");
	sprintfcat(buf,"}\n");
	sprintfcat(buf,"%s\n",seperator);
	}
}

int main(int argc,char **argv)
{
char buf[16384];
u16 i;
FILE *f;
int notable = 0;

if(argc < 2)
	f = stdout;
else
	{
	if((f = fopen(argv[1],"wt")) == 0)
		{
		printf("error creating/opening file %s\n",argv[1]);
		return(0);
		}
	}
if(argc > 2)
	{
	if(strcmp(argv[2],"-notable") == 0)
		notable = 1;
	}
for(i=0;i<0x1000;i++) //do the opcodes
	{
	strcpy(buf,"");
	if((i >> 4) >= 0x40 && (i >> 4) <= 0x7f && (i & 0xf) == 0) //ldr/str
		{
		if((i >> 4) & 1)
			emit_ldr(buf,(u16)(i >> 4),0);
		else
			emit_str(buf,(u16)(i >> 4),0);
		}
	else if((i >> 4) >= 0x80 && (i >> 4) <= 0x9f && (i & 0xf) == 0) //ldm/stm
		{
		if((i >> 4) & 1)
			emit_ldm(buf,(u16)(i >> 4),0);
		else
			emit_stm(buf,(u16)(i >> 4),0);
		}
	else if((i >> 4) >= 0x00 && (i >> 4) <= 0x1f && (i & 0x9) == 9 && (i & 0xf) != 9) //ldrh/strh
		{
		if((i >> 4) & 1)
			emit_ldrh(buf,i,0);
		else if((i & 0xf) == 0xb)
			emit_strh(buf,i,0);
		}
	else if((i & 0xf) == 9 && ((i >> 4) & 0xfb) == 0x10) //swp
		emit_swp(buf,(u16)(i >> 4),0);
	fprintf(f,buf);
	}
if(notable)
	{
	if(argc >= 2)
		fclose(f);
	return(0);
	}
fprintf(f,"void fill_arm_func_table_entry(u16 poo)\n");
fprintf(f,"{\n");
fprintf(f,"ops[poo] = op_error;\n");
fprintf(f,"switch((poo >> 4) & 0xff)\n");
fprintf(f,"\t{\n");
for(i=0;i<0x1000;i++) //do the opcode table
	{
	strcpy(buf,"op_error");
	if((i >> 4) >= 0x40 && (i >> 4) <= 0x7f && (i & 0xf) == 0) //ldr/str
		{
		if((i >> 4) & 1)
			emit_ldr(buf,(u16)(i >> 4),1);
		else
			emit_str(buf,(u16)(i >> 4),1);
		}
	if(((i >> 4)) >= 0x80 && ((i >> 4)) < 0xa0) //ldm/stm
		{
		if((i >> 4) & 1)
			emit_ldm(buf,(u16)(i >> 4),1);
		else
			emit_stm(buf,(u16)(i >> 4),1);
		}
	if((i >> 4) >= 0x00 && (i >> 4) <= 0x1f && (i & 0x9) == 9 && (i & 0xf) != 9) //ldrh/strh
		{
		if((i >> 4) & 1)
			emit_ldrh(buf,i,1);
		else
			emit_strh(buf,i,1);
		}
	if((i & 0xf) == 9 && ((i >> 4) & 0xfb) == 0x10) //swp
		emit_swp(buf,(u16)(i >> 4),1);
	if((i >> 4) < 0x20)
		{
		if((i & 0xf) == 0)
			{
			fprintf(f,"\tcase 0x%02x:\n",i >> 4);
			fprintf(f,"\t\tswitch(poo & 0xf)\n");
			fprintf(f,"\t\t\t{\n");
			fprintf(f,"\t\t\tdefault:ops[poo] = %s;break;\n",buf);
			}
		else if((i & 0xf) == 0x9)
			fprintf(f,"\t\t\tcase 0x9:ops[poo] = %s;break;\n",buf);
		else if((i & 0xf) == 0xb)
			fprintf(f,"\t\t\tcase 0xb:ops[poo] = %s;break;\n",buf);
		else if((i & 0xf) == 0xd)
			fprintf(f,"\t\t\tcase 0xd:ops[poo] = %s;break;\n",buf);
		else if((i & 0xf) == 0xf)
			{
			fprintf(f,"\t\t\tcase 0xf:ops[poo] = %s;break;\n",buf);
			fprintf(f,"\t\t\t}\n");
			}
		}
	else if((i & 0xf) == 0)
		fprintf(f,"\tcase 0x%02x:ops[poo] = %s;break;\n",i >> 4,buf);
	}
fprintf(f,"\t}\n");
fprintf(f,"%s\n",seperator);
if(argc >= 2)
	fclose(f);
return(0);
}
