//generates the opcode table + nekkid funcs
#include <stdio.h>

#define LINESEP "/*********************************************************************************************/"
#define OPFUNCTYPE "static INLINE void"

int main(int argc,char *argv[])
{
int i,j,k,functable;

functable = 0;
if(argc > 1)
	functable = 1;
printf("%s\n",LINESEP);
for(i=0;i<0x100;i++) //make the nekkid opcode funcs
	{
	for(j=0;j<0x10;j++)
		{
	   printf("%s op_%02x_%01x()\n",OPFUNCTYPE,i,j);
		printf("{\n");
		printf("op_error();\n"); //default operation
		printf("}\n");
		printf("%s\n",LINESEP);
		}
	}
if(functable)
	{
	printf("typedef void (*execfunc)();\n");
	printf("execfunc ops[256*16] =\n"); //now make opcode table
	printf("\t{\n");
	for(i=0;i<16;i++)
   	{
   	for(j=0;j<16;j++)
			{
		   printf("\t");
			for(k=0;k<16;k++)
		      printf("op_%02x_%01x%c",j | (i << 4),k,((i == 15) && (j == 15))?' ':',');
			printf("\n");
			}
	   }
	printf("\t};\n"); //end of opcode table
	}
else //switch
	{
	printf("switch(((OPCODE >> 20) & 0xff0) | ((OPCODE >> 4) & 0xf))\n");
	printf("\t{\n");
	for(i=0;i<16;i++)
   	{
   	for(j=0;j<16;j++)
			{
			for(k=0;k<16;k++)
		      printf("\tcase 0x%03x:op_%02x_%01x();break;\n",((j | (i << 4)) << 4) | k,j | (i << 4),k);
			}
	   }
	printf("\t}\n");
	}
printf("%s\n",LINESEP);
return(0);
}
