#include <windows.h>
#include <ddraw.h>
#include "blitter.h"
/*********************************************************************************************/
gdiblitter::gdiblitter()
{
inited = 0;
}
/*********************************************************************************************/
gdiblitter::~gdiblitter()
{
kill();
}
/*********************************************************************************************/
int gdiblitter::init(HWND h)
{
HWND hdesktopwnd = GetDesktopWindow();
HDC hdesktopdc = GetDC(hdesktopwnd);

hwnd = h;
bpp = GetDeviceCaps(hdesktopdc,BITSPIXEL);
DeleteDC(hdesktopdc);
memset(&bmpinfo,0,sizeof(bmpinfo));
bmpinfo.bmiHeader.biSize        = sizeof(BITMAPINFOHEADER);
bmpinfo.bmiHeader.biBitCount    = (u16)bpp;
bmpinfo.bmiHeader.biWidth       = 240;
bmpinfo.bmiHeader.biHeight      = -160;
bmpinfo.bmiHeader.biPlanes      = 1;	
bmpinfo.bmiHeader.biCompression = BI_RGB;
bmpinfo.bmiHeader.biSizeImage   = 0;
switch(bpp)
	{
	case 16:
		if((hbitmap = CreateDIBSection(0,&bmpinfo,DIB_RGB_COLORS,&dest,0,0)) == 0)
			{
			MessageBox(0,"CreateDIBSection","gdiblitter::init error",MB_OK|MB_ICONERROR);
			return(0);
			}
		break;
	case 32:
		if((hbitmap = CreateDIBSection(0,&bmpinfo,DIB_RGB_COLORS,&dest,0,0)) == 0)
			{
			MessageBox(0,"CreateDIBSection","gdiblitter::init error",MB_OK|MB_ICONERROR);
			return(0);
			}
		break;
	default:
		MessageBox(0,"try using 16 or 32 bit desktop bpp","dxblitter::init error",MB_OK|MB_ICONERROR);
		return(0);
	}
hdc = GetDC(hwnd);
resize();
inited = 1;
return(bpp);
}
/*********************************************************************************************/
void gdiblitter::kill()
{
if(inited == 1)
	{
	DeleteObject(dest);
	DeleteObject(hbitmap);
	ReleaseDC(hwnd,hdc);
	}
inited = 0;
}
/*********************************************************************************************/
void gdiblitter::resize()
{
GetClientRect(hwnd,&rect);
}
/*********************************************************************************************/
void *gdiblitter::framestart()
{
return(dest);
}
/*********************************************************************************************/
void gdiblitter::framestop()
{
StretchDIBits(hdc,0,0,rect.right,rect.bottom,0,0,240,160,dest,&bmpinfo,DIB_RGB_COLORS,SRCCOPY);
}
/*********************************************************************************************/
dxblitter::dxblitter()
{
inited = 0;
lpDD = 0;
}
/*********************************************************************************************/
dxblitter::~dxblitter()
{
kill();
}
/*********************************************************************************************/
int dxblitter::init(HWND h)
{
hwnd = h;
if(DirectDrawCreateEx(0,(VOID**)&lpDD,IID_IDirectDraw7,0))
	return(0);
if(lpDD->SetCooperativeLevel(hwnd,DDSCL_NORMAL) != DD_OK)
	{
	MessageBox(0,"SetCooperativeLevel","dxblitter::init error",MB_OK|MB_ICONERROR);
	kill();
	return(0);
	}
memset(&ddsd,0,sizeof(DDSURFACEDESC2));
ddsd.dwSize = sizeof(DDSURFACEDESC2);
ddsd.dwFlags = DDSD_CAPS;
ddsd.ddsCaps.dwCaps = DDSCAPS_PRIMARYSURFACE;
if(lpDD->CreateSurface(&ddsd,&lpDDSPrimary,0) != DD_OK)
	{
	MessageBox(0,"CreateSurface","dxblitter::init error",MB_OK|MB_ICONERROR);
	kill();
	return(0);
	}
if(lpDD->CreateClipper(0,&lpClipper, NULL) != DD_OK)
	{
	MessageBox(0,"CreateClipper","dxblitter::init error",MB_OK|MB_ICONERROR);
	kill();
	return(0);
	}
lpClipper->SetHWnd(0,hwnd);
lpDDSPrimary->SetClipper(lpClipper);
lpClipper->Release();
memset(&ddsd,0,sizeof(DDSURFACEDESC2));
ddsd.dwSize = sizeof(DDSURFACEDESC2);
ddsd.dwFlags = DDSD_WIDTH | DDSD_HEIGHT | DDSD_CAPS;
ddsd.dwWidth = 240;
ddsd.dwHeight = 160;
ddsd.ddsCaps.dwCaps = DDSCAPS_OFFSCREENPLAIN;
if(lpDD->CreateSurface(&ddsd,&lpDDSBack,0) != DD_OK)
	{
	MessageBox(0,"CreateSurface","dxblitter::init error",MB_OK|MB_ICONERROR);
	kill();
	return(0);
	}
memset(&ddsd,0,sizeof(DDSURFACEDESC2));
ddsd.dwSize = sizeof(ddsd);
if(lpDDSBack->GetSurfaceDesc(&ddsd) != DD_OK)
	{
	MessageBox(0,"GetSurfaceDesc","dxblitter::init error",MB_OK|MB_ICONERROR);
	kill();
	return(0);
	}
bpp = (byte)ddsd.ddpfPixelFormat.dwRGBBitCount;
if(ddsd.ddpfPixelFormat.dwRBitMask == 0xf800 && bpp == 16)
	bpp++;
if((bpp & 16) == 0 && (bpp & 32) == 0)
	{
	MessageBox(0,"try using 16 or 32 bit desktop bpp","dxblitter::init error",MB_OK|MB_ICONERROR);
	kill();
	return(0);
	}
resize();
inited = 1;
return(bpp);
}
/*********************************************************************************************/
void dxblitter::kill()
{
if(inited == 1)
	{
	if(lpDD != 0)
		{
		lpDD->SetCooperativeLevel(hwnd,DDSCL_NORMAL);
		if(lpDDSBack != 0)
			{
			lpDDSBack->Release();
			lpDDSBack = 0;
			}
		if(lpDDSPrimary != 0)
			{
			lpDDSPrimary->Release();
			lpDDSPrimary = 0;
			}
		lpDD->Release();
		lpDD = 0;
		}
	}
inited = 0;
}
/*********************************************************************************************/
void dxblitter::resize()
{
RECT rectClient,rectWindow;
int w,h;

GetWindowRect(hwnd,&rectWindow);
GetClientRect(hwnd,&rectClient);
w = (rectWindow.right - rectWindow.left) - rectClient.right;
h = (rectWindow.bottom - rectWindow.top) - rectClient.bottom;
w /= 2;
GetWindowRect(hwnd,&rect);
rect.top += h - w;
rect.left += w;
rect.right -= w;
w++;
rect.bottom -= w;
}
/*********************************************************************************************/
void *dxblitter::framestart()
{
int ret;

if((ret = lpDDSBack->Lock(0,&ddsd,DDLOCK_WAIT,0)) == DD_OK)
	return(ddsd.lpSurface);
else
	{
	switch(ret)
		{
		case DDERR_INVALIDOBJECT:MessageBox(0,"DDERR_INVALIDOBJECT","dxvideo_blit: error",MB_OK|MB_ICONERROR);break;
		case DDERR_INVALIDPARAMS:MessageBox(0,"DDERR_INVALIDPARAMS","dxvideo_blit: error",MB_OK|MB_ICONERROR);break;
		case DDERR_OUTOFMEMORY:MessageBox(0,"DDERR_OUTOFMEMORY","dxvideo_blit: error",MB_OK|MB_ICONERROR);break;
		case DDERR_SURFACEBUSY:MessageBox(0,"DDERR_SURFACEBUSY","dxvideo_blit: error",MB_OK|MB_ICONERROR);break;
		case DDERR_SURFACELOST:MessageBox(0,"DDERR_SURFACELOST","dxvideo_blit: error",MB_OK|MB_ICONERROR);break;
		case DDERR_WASSTILLDRAWING:MessageBox(0,"DDERR_WASSTILLDRAWING","dxvideo_blit: error",MB_OK|MB_ICONERROR);break;
		}
	}
return(0);
}
/*********************************************************************************************/
void dxblitter::framestop()
{
lpDDSBack->Unlock(0);
if(lpDDSPrimary->Blt(&rect,lpDDSBack,0,DDBLT_WAIT,0) == DDERR_SURFACELOST)
	lpDDSPrimary->Restore();
}
/*********************************************************************************************/
