#include <stdio.h>
#include "disasm.h"
#include "stdafx.h"
#include "creem.h"
#include "types.h"
/*********************************************************************************************/
#define NEGATIVE		0x80000000
#define ZERO			0x40000000
#define CARRY			0x20000000
#define OVERFLOW		0x10000000
#define DP_RN			((OPCODE >> 16) & 0xf)
#define DP_RD			((OPCODE >> 12) & 0xf)
#define DP_RS			((OPCODE >> 8) & 0xf)
#define DP_RM			(OPCODE & 0xf)
#define MUL_RD			((OPCODE >> 16) & 0xf)
#define MUL_RN			((OPCODE >> 12) & 0xf)
#define MUL_RS			((OPCODE >> 8) & 0xf)
#define MUL_RM			(OPCODE & 0xf)
#define OPCODE			opcode
#define THUMBOPCODE	((u16)OPCODE)
#define PC				(pc+(pcinc*2))
/*********************************************************************************************/
static char *fuck;
static u32 opcode,pc;
static u8 mask;
static u8 pcinc;
static char shiftbuf[64];
static char shitbuf[64];
static char listbuf[64];
static char *conds[] = {"eq","ne","cs","cc","mi","pl","vs","vc","hi","ls","ge","lt","gt","le","",""};
static char *ops02table[8] = {"and","eor","sub","rsb","add","adc","sbc","rsc"};
static char *ops3table[8] = {"tst","teq","cmp","cmn","orr","mov","bic","mvn"};
static char *ops4567table[4] = {"str","ldr","strb","ldrb"};
static char *ops89table[2] = {"stm","ldm"};
static char *ops89table_mods[4] = {"da","ia","db","ib"};
static char *ops78string = "%s%s%s\tr%d%s,{%s}%s";
static char *opsastring = "b%s\t0x%08x";
static char *opsbstring = "bl%s\t0x%08x";
static char *opscdestring = "coprocessor opcode";
/*********************************************************************************************/
static char *getcond(u32 opcode)
{
return(conds[opcode >> 28]);
}
static char *getthumbbcond(u16 opcode)
{
return(conds[(opcode >> 8) & 0xf]);
}
static char *getregshift()
{
u8 shifttype = (u8)((OPCODE >> 5) & 3);
char *shiftnames[4] = {"lsl","lsr","asr","ror"};

if(OPCODE & 0x10) //shift with reg
	sprintf(shiftbuf,"%s r%d",shiftnames[shifttype],DP_RS);
else //shift with imm
	{
	u8 shiftamount = (u8)((OPCODE >> 7) & 0x1f);

	if(shifttype == 0 && shiftamount == 0)
		sprintf(shiftbuf,"r%d",DP_RM); //correct?
	else if(shifttype == 2 && shiftamount == 0)
		sprintf(shiftbuf,"r%d,%s #0x%02x",DP_RM,shiftnames[shifttype],32);
	else if(shifttype == 3 && shiftamount == 0)
		sprintf(shiftbuf,"r%d,rrx",DP_RM);
	else
		sprintf(shiftbuf,"r%d,%s #0x%02x",DP_RM,shiftnames[shifttype],shiftamount);
	}
return(shiftbuf);
}
static char *getimmshift()
{
u32 result;

__asm
	{
	mov	eax,OPCODE
	mov	ecx,eax
	and	eax,0ffh
	shr	ecx,7
	and	ecx,01eh
	ror	eax,cl
	mov	result,eax
	}
sprintf(shiftbuf,"#0x%08x",result);
return(shiftbuf);
}
static char *getreglist(u32 rlist)
{
strcpy(listbuf,"");
if(rlist & 0x0001)strcat(listbuf,"r0,");
if(rlist & 0x0002)strcat(listbuf,"r1,");
if(rlist & 0x0004)strcat(listbuf,"r2,");
if(rlist & 0x0008)strcat(listbuf,"r3,");
if(rlist & 0x0010)strcat(listbuf,"r4,");
if(rlist & 0x0020)strcat(listbuf,"r5,");
if(rlist & 0x0040)strcat(listbuf,"r6,");
if(rlist & 0x0080)strcat(listbuf,"r7,");
if(rlist & 0x0100)strcat(listbuf,"r8,");
if(rlist & 0x0200)strcat(listbuf,"r9,");
if(rlist & 0x0400)strcat(listbuf,"r10,");
if(rlist & 0x0800)strcat(listbuf,"r11,");
if(rlist & 0x1000)strcat(listbuf,"r12,");
if(rlist & 0x2000)strcat(listbuf,"r13,");
if(rlist & 0x4000)strcat(listbuf,"r14,");
if(rlist & 0x8000)strcat(listbuf,"r15,");
listbuf[strlen(listbuf)-1] = 0; //kill the last comma
return(listbuf);
}
static char *getldrstring()
{
char sign = '-';

if(OPCODE & 0x00800000)
	sign = '+';
if(OPCODE & 0x01000000) //pre
	{
	if(OPCODE & 0xfff)
		{
		if(OPCODE & 0x02000000) //offset is a register
			sprintf(shitbuf,"[r%d,%cr%s]",DP_RN,sign,getregshift());
		else //offset is immediate value
			sprintf(shitbuf,"[r%d,%c#0x%08x]",DP_RN,sign,OPCODE & 0xfff);
		if(OPCODE & 0x00200000) //write back
			strcat(shitbuf,"!");
		}
	else //zero
		sprintf(shitbuf,"[r%d]",DP_RN);
	}
else //post
	{
	if(OPCODE & 0x02000000) //offset is a register
		sprintf(shitbuf,"[r%d],%c%s",DP_RN,sign,getregshift());
	else //offset is immediate value
		sprintf(shitbuf,"[r%d],%c#0x%08x",DP_RN,sign,OPCODE & 0xfff);
	}
return(shitbuf);
}
static char *getldrstring2()
{
if(OPCODE & 0x01000000) //pre
	{
	if(OPCODE & 0x00400000) //immediate
		{
		u8 offset = (u8)(((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));

		sprintf(shitbuf,"[r%d,0x%02x]%s",DP_RN,offset,OPCODE & 0x00200000?"!":"");
		}
	else //register
		sprintf(shitbuf,"[r%d,r%d]%s",DP_RN,DP_RM,OPCODE & 0x00200000?"!":"");
	}
else //post
	{
	if(OPCODE & 0x00400000) //immediate
		{
		u8 offset = (u8)(((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));

		sprintf(shitbuf,"[r%d],0x%02x",DP_RN,offset);
		}
	else //register
		sprintf(shitbuf,"[r%d],r%d",DP_RN,DP_RM);
	}
return(shitbuf);
}
/*********************************************************************************************/
static void ops_0(char *buf)
{
switch((OPCODE & 0x0ff00000) >> 20)
	{
	case 0x00:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"mul%s\tr%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS);break;
			case 0xb:sprintf(buf,"str%sh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			case 0xd:sprintf(buf,"str%sh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			case 0xf:sprintf(buf,"str%sh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			default:sprintf(buf,"and%s\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x01:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"mul%ss\tr%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS);break;
			case 0xb:sprintf(buf,"ldr%sh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			case 0xd:sprintf(buf,"ldr%ssb\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			case 0xf:sprintf(buf,"ldr%ssh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			default:sprintf(buf,"and%ss\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x02:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"mla%s\tr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"str%sh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			case 0xd:sprintf(buf,"str%sh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			case 0xf:sprintf(buf,"str%sh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			default:sprintf(buf,"eor%s\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x03:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"mla%ss\tr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"ldr%sh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			case 0xd:sprintf(buf,"ldr%ssb\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			case 0xf:sprintf(buf,"ldr%ssh\tr%d,[r%d],-#0x%02x",getcond(OPCODE),DP_RN,((OPCODE & 0xf00) >> 4) | (OPCODE & 0xf));break;
			default:sprintf(buf,"eor%ss\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x04:
		switch((OPCODE & 0x000000f0) >> 4)
			{
//			case 0x9:ops[poo] = op_error;break;
			case 0xb:sprintf(buf,"str%sh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"str%sh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"str%sh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"sub%s\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x05:
		switch((OPCODE & 0x000000f0) >> 4)
			{
//			case 0x9:ops[poo] = op_error;break;
			case 0xb:sprintf(buf,"ldr%sh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"ldr%ssb\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"ldr%ssh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"sub%ss\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x06:
		switch((OPCODE & 0x000000f0) >> 4)
			{
//			case 0x9:ops[poo] = op_error;break;
			case 0xb:sprintf(buf,"str%sh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"str%sh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"str%sh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"rsb%s\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x07:
		switch((OPCODE & 0x000000f0) >> 4)
			{
//			case 0x9:ops[poo] = op_error;break;
			case 0xb:sprintf(buf,"ldr%sh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"ldr%ssb\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"ldr%ssh\tr%d,[r%d],-r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"rsb%ss\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x08:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"umull%s\rr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"str%sh\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"str%sh\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"str%sh\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"add%s\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x09:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"umulls%s\rr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"ldr\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"ldr%ssb\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"ldr%ssh\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"add%ss\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x0a:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"umlal%s\rr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"str%sh\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"str%sh\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"str%sh\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"adc%s\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x0b:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"umlal%ss\rr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"ldr\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"ldr%ssb\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"ldr%ssh\tr%d,[r%d],r%d",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"adc%ss\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x0c:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"smull%s\tr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"str%sh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"str%sh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"str%sh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"sbc%s\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x0d:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"smull%ss\tr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"ldr%sh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"ldr%ssb\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"ldr%ssh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"sbc%ss\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x0e:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"smlal%s\tr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"str%sh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"str%sh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"str%sh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"rsc%s\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	case 0x0f:
		switch((OPCODE & 0x000000f0) >> 4)
			{
			case 0x9:sprintf(buf,"smlal%ss\tr%d,r%d,r%d,r%d",getcond(OPCODE),MUL_RD,MUL_RM,MUL_RS,MUL_RN);break;
			case 0xb:sprintf(buf,"ldr%sh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xd:sprintf(buf,"ldr%ssb\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			case 0xf:sprintf(buf,"ldr%ssh\tr%d,[r%d],#0x%08x",getcond(OPCODE),DP_RN,OPCODE & 0xfff);break;
			default:sprintf(buf,"rsc%ss\tr%d,r%d,%s",getcond(OPCODE),DP_RD,DP_RN,getregshift());break;
			}
		break;
	}
}
/*********************************************************************************************/
static void ops_1(char *buf)
{
if((OPCODE & 0x0ffffff0) == 0x012fff10)
	sprintf(buf,"bx%s\tr%d",getcond(OPCODE),OPCODE & 0xf);
else if((OPCODE & 0x0f000ff0) == 0x01000090) //swp
	sprintf(buf,"swp%s\tr%d,r%d,[r%d]",getcond(OPCODE),DP_RD,DP_RM,DP_RN);
else if((OPCODE & 0x0ff00f90) == 0x01a00090) //strh r,[r,r]
	sprintf(buf,"str%sh\tr%d,%s",getcond(OPCODE),DP_RD,getldrstring2());
else if((OPCODE & 0x0ff00000) == 0x01b00000) //ldrh r,[r,r]
	sprintf(buf,"ldr%sh\tr%d,%s",getcond(OPCODE),DP_RD,getldrstring2());
else if((OPCODE & 0x0ff00ff0) == 0x01c000b0) //strh
	sprintf(buf,"str%sh\tr%d,%s",getcond(OPCODE),DP_RD,getldrstring2());
else if((OPCODE & 0x0ff00ff0) == 0x01d000b0) //ldrh
	sprintf(buf,"ldr%sh\tr%d,%s",getcond(OPCODE),DP_RD,getldrstring2());
else if((OPCODE & 0x0ff00ff0) == 0x01e000b0) //strh
	sprintf(buf,"str%sh\tr%d,%s",getcond(OPCODE),DP_RD,getldrstring2());
else if((OPCODE & 0x0ff00ff0) == 0x01f000b0) //ldrh
	sprintf(buf,"ldr%sh\tr%d,%s",getcond(OPCODE),DP_RD,getldrstring2());
else if((OPCODE & 0x0ff00000) == 0x01300000) //teq (op2 is reg)
	sprintf(buf,"teq%s\tr%d,%s",getcond(OPCODE),DP_RN,getregshift());
else if((OPCODE & 0x0ff00000) == 0x01500000) //cmp (op2 is reg)
	sprintf(buf,"cmp%s\tr%d,%s",getcond(OPCODE),DP_RN,getregshift());
else if((OPCODE & 0x0ff00000) == 0x01a00000) //mov (op2 is reg, dont set cond codes)
	sprintf(buf,"mov%s\tr%d,%s",getcond(OPCODE),DP_RD,getregshift());
else if((OPCODE & 0x0ff00000) == 0x01b00000) //mov (op2 is reg, set cond codes)
	sprintf(buf,"mov%ss\tr%d,%s",getcond(OPCODE),DP_RD,getregshift());
else if((OPCODE & 0x0fff0fff) == 0x010f0000) //mrs (cpsr -> reg)
	sprintf(buf,"mrs%s\tr%d,cpsr",getcond(OPCODE),(OPCODE >> 12) & 0xf);
else if((OPCODE & 0x0fff0fff) == 0x014f0000) //mrs (spsr -> reg)
	sprintf(buf,"mrs%s\tr%d,spsr",getcond(OPCODE),(OPCODE >> 12) & 0xf);
else if((OPCODE & 0x0ffffff0) == 0x0129f000) //msr (reg -> cpsr)
	sprintf(buf,"msr%s\tcpsr,r%d",getcond(OPCODE),OPCODE & 0xf);
else if((OPCODE & 0x0ffffff0) == 0x0169f000) //msr (reg -> spsr)
	sprintf(buf,"msr%s\tspsr,r%d",getcond(OPCODE),OPCODE & 0xf);
else if((OPCODE & 0x0ff00000) == 0x01e00000)
	sprintf(buf,"mvn%s\tr%d,%s",getcond(OPCODE),DP_RD,getregshift());
else if((OPCODE & 0x0ff00000) == 0x01f00000)
	sprintf(buf,"mvn%ss\tr%d,%s",getcond(OPCODE),DP_RD,getregshift());
}
/*********************************************************************************************/
static void ops_2(char *buf)
{
sprintf(buf,"%s%s%s\tr%d,r%d,%s",ops02table[mask >> 1],getcond(OPCODE),mask&1?"s":"",DP_RD,DP_RN,getimmshift());
}
/*********************************************************************************************/
static void ops_3(char *buf)
{
if((mask & 0xa) == 8)
	sprintf(buf,"%s%s%s\tr%d,r%d,%s",ops3table[mask >> 1],getcond(OPCODE),mask&1?"s":"",DP_RD,DP_RN,getimmshift());
else
	sprintf(buf,"%s%s\tr%d,%s",ops3table[mask >> 1],getcond(OPCODE),mask&8?DP_RD:DP_RN,getimmshift());
}
/*********************************************************************************************/
static void ops_4(char *buf)
{
sprintf(buf,"%s%s\tr%d,[r%d],%s#0x%03x",ops4567table[((mask >> 1) & 2) | (mask & 1)],getcond(OPCODE),DP_RD,DP_RN,mask&8?"":"-",OPCODE & 0xfff);
}
/*********************************************************************************************/
static void ops_5(char *buf)
{
sprintf(buf,"%s%s\tr%d,[r%d,%s#0x%03x]%s",ops4567table[((mask >> 1) & 2) | (mask & 1)],getcond(OPCODE),DP_RD,DP_RN,mask&8?"":"-",OPCODE & 0xfff,mask&2?"!":"");
}
/*********************************************************************************************/
static void ops_6(char *buf)
{
sprintf(buf,"%s%s\tr%d,[r%d],%sr%d",ops4567table[((mask >> 1) & 2) | (mask & 1)],getcond(OPCODE),DP_RD,DP_RN,mask&8?"":"-",DP_RM);
}
/*********************************************************************************************/
static void ops_7(char *buf)
{
sprintf(buf,"%s%s\tr%d,[r%d,%sr%d]%s",ops4567table[((mask >> 1) & 2) | (mask & 1)],getcond(OPCODE),DP_RD,DP_RN,mask&8?"":"-",DP_RM,mask&2?"!":"");
}
/*********************************************************************************************/
static void ops_8(char *buf)
{
sprintf(buf,ops78string,ops89table[mask & 1],getcond(OPCODE),ops89table_mods[mask >> 3],DP_RN,mask&2?"!":"",getreglist(OPCODE & 0xffff),mask&4?"^":"");
}
/*********************************************************************************************/
static void ops_9(char *buf)
{
sprintf(buf,ops78string,ops89table[mask & 1],getcond(OPCODE),ops89table_mods[(mask >> 3) | 2],DP_RN,mask&2?"!":"",getreglist(OPCODE & 0xffff),mask&4?"^":"");
}
/*********************************************************************************************/
static void ops_a(char *buf)
{
if(OPCODE & 0x00800000) //negative branch
	sprintf(buf,opsastring,getcond(OPCODE),(0xfc000000 | ((OPCODE & 0xffffff) << 2)) + PC);
else //positive branch
	sprintf(buf,opsastring,getcond(OPCODE),((OPCODE & 0x7fffff) << 2) + PC);
}
/*********************************************************************************************/
static void ops_b(char *buf)
{
if(OPCODE & 0x00800000) //negative branch
	sprintf(buf,opsbstring,getcond(OPCODE),PC + (0xfc000000 | ((OPCODE & 0xffffff) << 2)));
else //positive branch
	sprintf(buf,opsbstring,getcond(OPCODE),PC + ((OPCODE & 0x7fffff) << 2));
}
/*********************************************************************************************/
static void ops_c(char *buf)
{
sprintf(buf,opscdestring);
}
/*********************************************************************************************/
static void ops_d(char *buf)
{
sprintf(buf,opscdestring);
}
/*********************************************************************************************/
static void ops_e(char *buf)
{
sprintf(buf,opscdestring);
}
/*********************************************************************************************/
static void ops_f(char *buf)
{
sprintf(buf,"swi\t%08x",OPCODE & 0x00ffffff);
}
/*********************************************************************************************/
static char *thumbops0table[2] = {"lsl","lsr"};
static char *thumbops13table[2] = {"add","sub"};
static char *thumbops2table[2] = {"mov","cmp"};
static void thumbops_0(char *buf)
{
sprintf(buf,"%s\tr%d,r%d,#0x%1x",thumbops0table[mask >> 3],THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 6) & 0x1f);
}
/*********************************************************************************************/
static void thumbops_1(char *buf)
{
if(mask & 8)
	{
	if(mask & 4)
		sprintf(buf,"%s\tr%d,r%d,#0x%1x",thumbops13table[(mask >> 1) & 1],THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 6) & 7);
	else
		sprintf(buf,"%s\tr%d,r%d,r%d",thumbops13table[(mask >> 1) & 1],THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 6) & 7);
	}
else
	sprintf(buf,"asr\tr%d,r%d,#0x%1x",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 6) & 0x1f);
}
/*********************************************************************************************/
static void thumbops_2(char *buf)
{
sprintf(buf,"%s\tr%d,#0x%02x",thumbops2table[mask >> 3],(THUMBOPCODE >> 8) & 7,THUMBOPCODE & 0xff);
}
/*********************************************************************************************/
static void thumbops_3(char *buf)
{
sprintf(buf,"%s\tr%d,#0x%02x",thumbops13table[mask >> 3],(THUMBOPCODE >> 8) & 7,THUMBOPCODE & 0xff);
}
/*********************************************************************************************/
static void thumbops_4(char *buf)
{
if((THUMBOPCODE & 0xffc0) == 0x4040) //eor rd,rs
	sprintf(buf,"eor\tr%d,r%d",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x41c0) //ror rd,rs
	sprintf(buf,"ror\tr%d,r%d",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x4200) //tst rd,rs
	sprintf(buf,"tst\tr%d,r%d",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x4280) //cmp rd,rs
	sprintf(buf,"cmp\tr%d,r%d",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x4300) //orr rd,rs
	sprintf(buf,"orr\tr%d,r%d",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x4380) //bic rd,rs
	sprintf(buf,"bic\tr%d,r%d",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x43c0) //mvn rd,rs
	sprintf(buf,"mvn\tr%d,r%d",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x4500) //cmp rd,rs
	sprintf(buf,"cmp\tr%d,r%d",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x4540) //cmp rd,hs
	sprintf(buf,"cmp\tr%d,r%d",THUMBOPCODE & 7,((THUMBOPCODE >> 3) & 7) | 8);
else if((THUMBOPCODE & 0xffc0) == 0x4580) //cmp hd,rs
	sprintf(buf,"cmp\tr%d,r%d",(THUMBOPCODE & 7) | 8,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x45c0) //cmp hd,hs
	sprintf(buf,"cmp\tr%d,r%d",(THUMBOPCODE & 7) | 8,((THUMBOPCODE >> 3) & 7) | 8);
else if((THUMBOPCODE & 0xffc0) == 0x4600) //mov rd,rs
	sprintf(buf,"mov\tr%d,r%d",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x4640) //mov rd,hs
	sprintf(buf,"mov\tr%d,r%d",THUMBOPCODE & 7,((THUMBOPCODE >> 3) & 7) | 8);
else if((THUMBOPCODE & 0xffc0) == 0x4680) //mov hd,rs
	sprintf(buf,"mov\tr%d,r%d",(THUMBOPCODE & 7) | 8,(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x46c0) //mov hd,hs
	sprintf(buf,"mov\tr%d,r%d",(THUMBOPCODE & 7) | 8,((THUMBOPCODE >> 3) & 7) | 8);
else if((THUMBOPCODE & 0xffc0) == 0x4700) //bx rs
	sprintf(buf,"bx\tr%d",(THUMBOPCODE >> 3) & 7);
else if((THUMBOPCODE & 0xffc0) == 0x4740) //bx hs
	sprintf(buf,"bx\tr%d",((THUMBOPCODE >> 3) & 7) | 8);
else if((THUMBOPCODE & 0xf800) == 0x4800) //ldr rd,[r15,imm]
	sprintf(buf,"ldr\tr%d,[r15,#0x%03x]",(THUMBOPCODE >> 8) & 0x7,(THUMBOPCODE & 0xff) << 2);
}
/*********************************************************************************************/
static void thumbops_5(char *buf)
{
if((THUMBOPCODE & 0xfe00) == 0x5000) //str rd,[reg,reg]
	sprintf(buf,"str\tr%d,[r%d,r%d]",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 6) & 7);
else if((THUMBOPCODE & 0xfe00) == 0x5200) //strh rd,[reg,reg]
	sprintf(buf,"strh\tr%d,[r%d,r%d]",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 6) & 7);
}
/*********************************************************************************************/
static void thumbops_6(char *buf)
{
if((THUMBOPCODE & 0xf800) == 0x6000) //str rd,[reg,reg]
	sprintf(buf,"str\tr%d,[r%d,#0x%02x]",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 4) & 0x7c);
else if((THUMBOPCODE & 0xf800) == 0x6800) //ldr rd,[reg,reg]
	sprintf(buf,"ldr\tr%d,[r%d,#0x%02x]",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 4) & 0x7c);
}
/*********************************************************************************************/
static void thumbops_7(char *buf)
{
if((THUMBOPCODE & 0xf800) == 0x7000) //strb rd,[reg,imm]
	sprintf(buf,"strb\tr%d,[r%d,#0x%02x]",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 6) & 0x1f);
else if((THUMBOPCODE & 0xf800) == 0x7800) //ldrb rd,[reg,imm]
	sprintf(buf,"ldrb\tr%d,[r%d,#0x%02x]",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 6) & 0x1f);
}
/*********************************************************************************************/
static void thumbops_8(char *buf)
{
if((THUMBOPCODE & 0xf800) == 0x8000) //strh rd,[rb,imm]
	sprintf(buf,"strh\tr%d,[r%d,#0x%02x]",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 5) & 0x3e);
else if((THUMBOPCODE & 0xf800) == 0x8800) //ldrh rd,[rb,imm]
	sprintf(buf,"ldrh\tr%d,[r%d,#0x%02x]",THUMBOPCODE & 7,(THUMBOPCODE >> 3) & 7,(THUMBOPCODE >> 5) & 0x3e);
}
/*********************************************************************************************/
static void thumbops_9(char *buf)
{
if((THUMBOPCODE & 0xf800) == 0x9000) //str rd,[r13,imm]
	sprintf(buf,"str\tr%d,[r13,#0x%03x]",(THUMBOPCODE >> 8) & 7,(THUMBOPCODE & 0xff) << 2);
else if((THUMBOPCODE & 0xf800) == 0x9800) //ldr rd,[r13,imm]
	sprintf(buf,"ldr\tr%d,[r13,#0x%03x]",(THUMBOPCODE >> 8) & 7,(THUMBOPCODE & 0xff) << 2);
}
/*********************************************************************************************/
static void thumbops_a(char *buf)
{
if((THUMBOPCODE & 0xf800) == 0xa000) //add rd,pc,imm
	sprintf(buf,"add\tr%d,r15,#0x%02x",(THUMBOPCODE & 0x0700) >> 8,(THUMBOPCODE & 0xff) << 2);
else if((THUMBOPCODE & 0xf800) == 0xa800) //add rd,sp,imm
	sprintf(buf,"add\tr%d,r13,#0x%02x",(THUMBOPCODE & 0x0700) >> 8,(THUMBOPCODE & 0xff) << 2);
}
/*********************************************************************************************/
static void thumbops_b(char *buf)
{
if((THUMBOPCODE & 0xff00) == 0xb000) //add r13,imm
	sprintf(buf,"add\tr13,#%c0x%02x",THUMBOPCODE & 0x80?'-':'+',(THUMBOPCODE & 0x7f) << 2);
else if((THUMBOPCODE & 0xff00) == 0xb400) //push {rlist}
	sprintf(buf,"push\t{%s}",getreglist(THUMBOPCODE & 0xff));
else if((THUMBOPCODE & 0xff00) == 0xb500) //push {rlist,lr}
	{
	fuck = getreglist(THUMBOPCODE & 0xff);
	sprintf(buf,"push\t{%s%sr14}",fuck,strcmp(fuck,"")?",":"");
	}
else if((THUMBOPCODE & 0xff00) == 0xbc00) //pop {rlist}
	sprintf(buf,"pop\t{%s}",getreglist(THUMBOPCODE & 0xff));
else if((THUMBOPCODE & 0xff00) == 0xbd00) //pop {rlist,pc}
	{
	fuck = getreglist(THUMBOPCODE & 0xff);
	sprintf(buf,"pop\t{%s%sr15}",fuck,strcmp(fuck,"")?",":"");
	}
}
/*********************************************************************************************/
static void thumbops_c(char *buf)
{
if((THUMBOPCODE & 0xf800) == 0xc000) //stmia rb!,{rlist}
	sprintf(buf,"stmia\tr%d!,{%s}",(THUMBOPCODE & 0x0700) >> 8,getreglist(THUMBOPCODE & 0xff));
else if((THUMBOPCODE & 0xf800) == 0xc800) //ldmia rb!,{rlist}
	sprintf(buf,"ldmia\tr%d!,{%s}",(THUMBOPCODE & 0x0700) >> 8,getreglist(THUMBOPCODE & 0xff));
}
/*********************************************************************************************/
static void thumbops_d(char *buf)
{
if((THUMBOPCODE & 0xff00) == 0xdf00) //swi value
	sprintf(buf,"swi\t%d",THUMBOPCODE & 0xff);
else if((THUMBOPCODE & 0xf080) == 0xd000) //b positive
	sprintf(buf,"b%s\t0x%08x",getthumbbcond(THUMBOPCODE),((THUMBOPCODE & 0xff) << 1) + PC);
else if((THUMBOPCODE & 0xf080) == 0xd080) //b negative
	sprintf(buf,"b%s\t0x%08x",getthumbbcond(THUMBOPCODE),(0xfffffe00 | ((THUMBOPCODE & 0xff) << 1)) + PC);
}
/*********************************************************************************************/
static void thumbops_e(char *buf)
{
sprintf(buf,"b\t0x%08x",PC + ((THUMBOPCODE & 0x07ff) << 1));
}
/*********************************************************************************************/
u32 bldata = 0;
static void thumbops_f(char *buf)
{
if(THUMBOPCODE & 0x0800)
	{
	if(bldata == 0)
		sprintf(buf,"part 2 of bl opcode without part 1");
	else
		sprintf(buf,"bl\t#0x%08x",(bldata + ((THUMBOPCODE & 0x7ff) << 1)));
	bldata = 0;
	}
else
	{
	if(bldata)
		sprintf(buf,"part 1 of bl opcode, but another part 1 didnt finish");
	else
		{
		sprintf(buf,"part 1 of bl opcode");
		bldata = ((THUMBOPCODE & 0x7ff) << 12) + PC + ((THUMBOPCODE & 0x0400)?0xff800000:0);
		}
	}
}
/*********************************************************************************************/
void disasmopcode(u32 armopcode,u32 armpc,u8 thumbmode,char *buffer)
{
typedef void (*execfunc)(char*);
execfunc arm_ops[0x10] =
	{
	ops_0,ops_1,ops_2,ops_3,ops_4,ops_5,ops_6,ops_7,
	ops_8,ops_9,ops_a,ops_b,ops_c,ops_d,ops_e,ops_f,
	};
execfunc thumb_ops[0x10] =
	{
	thumbops_0,thumbops_1,thumbops_2,thumbops_3,thumbops_4,thumbops_5,thumbops_6,thumbops_7,
	thumbops_8,thumbops_9,thumbops_a,thumbops_b,thumbops_c,thumbops_d,thumbops_e,thumbops_f,
	};
u8 op;
char buf[128];

opcode = armopcode;
pc = armpc;
buf[0] = 0;
sprintf(buf,"unknown opcode");
mask = (u8)((opcode & 0x00f00000) >> 20);
if(thumbmode == THUMB_MODE) //thumb mode
	{
	pcinc = 2;
	op = (u8)((THUMBOPCODE >> 12) & 0xf);
	thumb_ops[op](buf);
	sprintf(buffer,"%08X:\t%04X           \t%s\n",PC-4,THUMBOPCODE,buf);
	}
else //arm mode
	{
	pcinc = 4;
	op = (u8)((OPCODE >> 24) & 0xf);
	arm_ops[op](buf);
	sprintf(buffer,"%08X:\t%08X\t%s\n",PC-8,opcode,buf);
	}
}
/*********************************************************************************************/
