#include "render.h"
#include "stdafx.h"
#include "types.h"
#include "creem.h"
/*********************************************************************************************/
#define vram_16 ((u16*)vram)
#define blitpixel(d,p,pl){u8 _p = (u8)(p);if(_p)d = (pl)[_p];}
#define drawblockline_mode0_256color(n,p)\
blitpixel(gbascreen[0 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[1 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[2 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[3 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[4 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[5 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[6 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[7 + (240 * n)],*chardata++,p);
#define drawblockline_mode0_256color_rev(n,p)\
blitpixel(gbascreen[7 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[6 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[5 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[4 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[3 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[2 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[1 + (240 * n)],*chardata++,p);\
blitpixel(gbascreen[0 + (240 * n)],*chardata++,p);
#define drawblockline_mode0_16color(n,p)\
blitpixel(gbascreen[0 + (240 * n)],*chardata & 0xf,p);\
blitpixel(gbascreen[1 + (240 * n)],(*chardata++ >> 4) & 0xf,p);\
blitpixel(gbascreen[2 + (240 * n)],*chardata & 0xf,p);\
blitpixel(gbascreen[3 + (240 * n)],(*chardata++ >> 4) & 0xf,p);\
blitpixel(gbascreen[4 + (240 * n)],*chardata & 0xf,p);\
blitpixel(gbascreen[5 + (240 * n)],(*chardata++ >> 4) & 0xf,p);\
blitpixel(gbascreen[6 + (240 * n)],*chardata & 0xf,p);\
blitpixel(gbascreen[7 + (240 * n)],(*chardata++ >> 4) & 0xf,p);
#define drawblockline_mode0_16color_rev(n,p)\
blitpixel(gbascreen[7 + (240 * n)],*chardata & 0xf,p);\
blitpixel(gbascreen[6 + (240 * n)],(*chardata++ >> 4) & 0xf,p);\
blitpixel(gbascreen[5 + (240 * n)],*chardata & 0xf,p);\
blitpixel(gbascreen[4 + (240 * n)],(*chardata++ >> 4) & 0xf,p);\
blitpixel(gbascreen[3 + (240 * n)],*chardata & 0xf,p);\
blitpixel(gbascreen[2 + (240 * n)],(*chardata++ >> 4) & 0xf,p);\
blitpixel(gbascreen[1 + (240 * n)],*chardata & 0xf,p);\
blitpixel(gbascreen[0 + (240 * n)],(*chardata++ >> 4) & 0xf,p);
static void renderbg_mode0_16(u16 bgcnt,u16 hofs,u16 vofs)
{
u8 *charbank = vram + (((bgcnt >> 2) & 3) * 0x4000);
u16 *scrbank = (u16*)(vram + (((bgcnt >> 8) & 0x1f) * 0x800));
u8 x,y; //current positions (in tiles)
u16 *gbascreen = (u16*)theApp.screen;

if(bgcnt & 0x0080) //256 color, 1 palette
	{
	for(y=0;y<20;y++) //20 rows
		{
		for(x=0;x<30;x++) //30 tiles per row
			{
			u16 c = scrbank[x]; //get character and inc pointer
			u8 *chardata = charbank + ((c & 0x1ff) * 32); //character data

			if((c & 0x0c00) == 0x0c00) //horizontal + vertical flip
				{
				drawblockline_mode0_256color_rev(7,pal16);
				drawblockline_mode0_256color_rev(6,pal16);
				drawblockline_mode0_256color_rev(5,pal16);
				drawblockline_mode0_256color_rev(4,pal16);
				drawblockline_mode0_256color_rev(3,pal16);
				drawblockline_mode0_256color_rev(2,pal16);
				drawblockline_mode0_256color_rev(1,pal16);
				drawblockline_mode0_256color_rev(0,pal16);
				}
			else if(c & 0x0400) //horizontal flip
				{
				drawblockline_mode0_256color_rev(0,pal16);
				drawblockline_mode0_256color_rev(1,pal16);
				drawblockline_mode0_256color_rev(2,pal16);
				drawblockline_mode0_256color_rev(3,pal16);
				drawblockline_mode0_256color_rev(4,pal16);
				drawblockline_mode0_256color_rev(5,pal16);
				drawblockline_mode0_256color_rev(6,pal16);
				drawblockline_mode0_256color_rev(7,pal16);
				}
			else if(c & 0x0800) //vertical flip
				{
				drawblockline_mode0_256color(7,pal16);
				drawblockline_mode0_256color(6,pal16);
				drawblockline_mode0_256color(5,pal16);
				drawblockline_mode0_256color(4,pal16);
				drawblockline_mode0_256color(3,pal16);
				drawblockline_mode0_256color(2,pal16);
				drawblockline_mode0_256color(1,pal16);
				drawblockline_mode0_256color(0,pal16);
				}
			else
				{
				drawblockline_mode0_256color(0,pal16);
				drawblockline_mode0_256color(1,pal16);
				drawblockline_mode0_256color(2,pal16);
				drawblockline_mode0_256color(3,pal16);
				drawblockline_mode0_256color(4,pal16);
				drawblockline_mode0_256color(5,pal16);
				drawblockline_mode0_256color(6,pal16);
				drawblockline_mode0_256color(7,pal16);
				}
			gbascreen += 8;
			}
		gbascreen += 240 * 7;
		scrbank += 32;
		}
	}
else //16 color, 16 palettes
	{
	for(y=0;y<20;y++) //20 rows
		{
		for(x=0;x<30;x++) //30 tiles per row
			{
			u16 c = scrbank[x]; //get character and inc pointer
			u16 *pal = pal16 + ((c >> 12) * 16); //palette for the character
			u8 *chardata = charbank + ((c & 0x1ff) * 32); //character data

			if((c & 0x0c00) == 0x0c00) //horizontal + vertical flip
				{
				drawblockline_mode0_16color_rev(7,pal);
				drawblockline_mode0_16color_rev(6,pal);
				drawblockline_mode0_16color_rev(5,pal);
				drawblockline_mode0_16color_rev(4,pal);
				drawblockline_mode0_16color_rev(3,pal);
				drawblockline_mode0_16color_rev(2,pal);
				drawblockline_mode0_16color_rev(1,pal);
				drawblockline_mode0_16color_rev(0,pal);
				}
			else if(c & 0x0400) //horizontal flip
				{
				drawblockline_mode0_16color_rev(0,pal);
				drawblockline_mode0_16color_rev(1,pal);
				drawblockline_mode0_16color_rev(2,pal);
				drawblockline_mode0_16color_rev(3,pal);
				drawblockline_mode0_16color_rev(4,pal);
				drawblockline_mode0_16color_rev(5,pal);
				drawblockline_mode0_16color_rev(6,pal);
				drawblockline_mode0_16color_rev(7,pal);
				}
			else if(c & 0x0800) //vertical flip
				{
				drawblockline_mode0_16color(7,pal);
				drawblockline_mode0_16color(6,pal);
				drawblockline_mode0_16color(5,pal);
				drawblockline_mode0_16color(4,pal);
				drawblockline_mode0_16color(3,pal);
				drawblockline_mode0_16color(2,pal);
				drawblockline_mode0_16color(1,pal);
				drawblockline_mode0_16color(0,pal);
				}
			else
				{
				drawblockline_mode0_16color(0,pal);
				drawblockline_mode0_16color(1,pal);
				drawblockline_mode0_16color(2,pal);
				drawblockline_mode0_16color(3,pal);
				drawblockline_mode0_16color(4,pal);
				drawblockline_mode0_16color(5,pal);
				drawblockline_mode0_16color(6,pal);
				drawblockline_mode0_16color(7,pal);
				}
			gbascreen += 8;
			}
		gbascreen += 240 * 7;
		scrbank += 32;
		}
	}
}
/*********************************************************************************************/
static void renderbg_mode0_17(u16 bgcnt,u16 hofs,u16 vofs)
{
u8 *charbank = vram + (((bgcnt >> 2) & 3) * 0x4000);
u16 *scrbank = (u16*)(vram + (((bgcnt >> 8) & 0x1f) * 0x800));
u8 x,y; //current positions (in tiles)
u16 *gbascreen = (u16*)theApp.screen;

if(bgcnt & 0x0080) //256 color, 1 palette
	{
	for(y=0;y<20;y++) //20 rows
		{
		for(x=0;x<30;x++) //30 tiles per row
			{
			u16 c = scrbank[x]; //get character and inc pointer
			u8 *chardata = charbank + ((c & 0x1ff) * 32); //character data

			if((c & 0x0c00) == 0x0c00) //horizontal + vertical flip
				{
				drawblockline_mode0_256color_rev(7,pal17);
				drawblockline_mode0_256color_rev(6,pal17);
				drawblockline_mode0_256color_rev(5,pal17);
				drawblockline_mode0_256color_rev(4,pal17);
				drawblockline_mode0_256color_rev(3,pal17);
				drawblockline_mode0_256color_rev(2,pal17);
				drawblockline_mode0_256color_rev(1,pal17);
				drawblockline_mode0_256color_rev(0,pal17);
				}
			else if(c & 0x0400) //horizontal flip
				{
				drawblockline_mode0_256color_rev(0,pal17);
				drawblockline_mode0_256color_rev(1,pal17);
				drawblockline_mode0_256color_rev(2,pal17);
				drawblockline_mode0_256color_rev(3,pal17);
				drawblockline_mode0_256color_rev(4,pal17);
				drawblockline_mode0_256color_rev(5,pal17);
				drawblockline_mode0_256color_rev(6,pal17);
				drawblockline_mode0_256color_rev(7,pal17);
				}
			else if(c & 0x0800) //vertical flip
				{
				drawblockline_mode0_256color(7,pal17);
				drawblockline_mode0_256color(6,pal17);
				drawblockline_mode0_256color(5,pal17);
				drawblockline_mode0_256color(4,pal17);
				drawblockline_mode0_256color(3,pal17);
				drawblockline_mode0_256color(2,pal17);
				drawblockline_mode0_256color(1,pal17);
				drawblockline_mode0_256color(0,pal17);
				}
			else
				{
				drawblockline_mode0_256color(0,pal17);
				drawblockline_mode0_256color(1,pal17);
				drawblockline_mode0_256color(2,pal17);
				drawblockline_mode0_256color(3,pal17);
				drawblockline_mode0_256color(4,pal17);
				drawblockline_mode0_256color(5,pal17);
				drawblockline_mode0_256color(6,pal17);
				drawblockline_mode0_256color(7,pal17);
				}
			gbascreen += 8;
			}
		gbascreen += 240 * 7;
		scrbank += 32;
		}
	}
else //16 color, 16 palettes
	{
	for(y=0;y<20;y++) //20 rows
		{
		for(x=0;x<30;x++) //30 tiles per row
			{
			u16 c = scrbank[x]; //get character and inc pointer
			u16 *pal = pal17 + ((c >> 12) * 16); //palette for the character
			u8 *chardata = charbank + ((c & 0x1ff) * 32); //character data

			if((c & 0x0c00) == 0x0c00) //horizontal + vertical flip
				{
				drawblockline_mode0_16color_rev(7,pal);
				drawblockline_mode0_16color_rev(6,pal);
				drawblockline_mode0_16color_rev(5,pal);
				drawblockline_mode0_16color_rev(4,pal);
				drawblockline_mode0_16color_rev(3,pal);
				drawblockline_mode0_16color_rev(2,pal);
				drawblockline_mode0_16color_rev(1,pal);
				drawblockline_mode0_16color_rev(0,pal);
				}
			else if(c & 0x0400) //horizontal flip
				{
				drawblockline_mode0_16color_rev(0,pal);
				drawblockline_mode0_16color_rev(1,pal);
				drawblockline_mode0_16color_rev(2,pal);
				drawblockline_mode0_16color_rev(3,pal);
				drawblockline_mode0_16color_rev(4,pal);
				drawblockline_mode0_16color_rev(5,pal);
				drawblockline_mode0_16color_rev(6,pal);
				drawblockline_mode0_16color_rev(7,pal);
				}
			else if(c & 0x0800) //vertical flip
				{
				drawblockline_mode0_16color(7,pal);
				drawblockline_mode0_16color(6,pal);
				drawblockline_mode0_16color(5,pal);
				drawblockline_mode0_16color(4,pal);
				drawblockline_mode0_16color(3,pal);
				drawblockline_mode0_16color(2,pal);
				drawblockline_mode0_16color(1,pal);
				drawblockline_mode0_16color(0,pal);
				}
			else
				{
				drawblockline_mode0_16color(0,pal);
				drawblockline_mode0_16color(1,pal);
				drawblockline_mode0_16color(2,pal);
				drawblockline_mode0_16color(3,pal);
				drawblockline_mode0_16color(4,pal);
				drawblockline_mode0_16color(5,pal);
				drawblockline_mode0_16color(6,pal);
				drawblockline_mode0_16color(7,pal);
				}
			gbascreen += 8;
			}
		gbascreen += 240 * 7;
		scrbank += 32;
		}
	}
}
/*********************************************************************************************/
static void renderbg_mode0_32(u16 bgcnt,u16 hofs,u16 vofs)
{
u8 *charbank = vram + (((bgcnt >> 2) & 3) * 0x4000);
u16 *scrbank = (u16*)(vram + (((bgcnt >> 8) & 0x1f) * 0x800));
u8 x,y; //current positions (in tiles)
u32 *gbascreen = (u32*)theApp.screen;

if(bgcnt & 0x0080) //256 color, 1 palette
	{
	for(y=0;y<20;y++) //20 rows
		{
		for(x=0;x<30;x++) //30 tiles per row
			{
			u16 c = scrbank[x]; //get character and inc pointer
			u8 *chardata = charbank + ((c & 0x1ff) * 32); //character data

			if((c & 0x0c00) == 0x0c00) //horizontal + vertical flip
				{
				drawblockline_mode0_256color_rev(7,pal32);
				drawblockline_mode0_256color_rev(6,pal32);
				drawblockline_mode0_256color_rev(5,pal32);
				drawblockline_mode0_256color_rev(4,pal32);
				drawblockline_mode0_256color_rev(3,pal32);
				drawblockline_mode0_256color_rev(2,pal32);
				drawblockline_mode0_256color_rev(1,pal32);
				drawblockline_mode0_256color_rev(0,pal32);
				}
			else if(c & 0x0400) //horizontal flip
				{
				drawblockline_mode0_256color_rev(0,pal32);
				drawblockline_mode0_256color_rev(1,pal32);
				drawblockline_mode0_256color_rev(2,pal32);
				drawblockline_mode0_256color_rev(3,pal32);
				drawblockline_mode0_256color_rev(4,pal32);
				drawblockline_mode0_256color_rev(5,pal32);
				drawblockline_mode0_256color_rev(6,pal32);
				drawblockline_mode0_256color_rev(7,pal32);
				}
			else if(c & 0x0800) //vertical flip
				{
				drawblockline_mode0_256color(7,pal32);
				drawblockline_mode0_256color(6,pal32);
				drawblockline_mode0_256color(5,pal32);
				drawblockline_mode0_256color(4,pal32);
				drawblockline_mode0_256color(3,pal32);
				drawblockline_mode0_256color(2,pal32);
				drawblockline_mode0_256color(1,pal32);
				drawblockline_mode0_256color(0,pal32);
				}
			else
				{
				drawblockline_mode0_256color(0,pal32);
				drawblockline_mode0_256color(1,pal32);
				drawblockline_mode0_256color(2,pal32);
				drawblockline_mode0_256color(3,pal32);
				drawblockline_mode0_256color(4,pal32);
				drawblockline_mode0_256color(5,pal32);
				drawblockline_mode0_256color(6,pal32);
				drawblockline_mode0_256color(7,pal32);
				}
			gbascreen += 8;
			}
		gbascreen += 240 * 7;
		scrbank += 32;
		}
	}
else //16 color, 16 palettes
	{
	for(y=0;y<20;y++) //20 rows
		{
		for(x=0;x<30;x++) //30 tiles per row
			{
			u16 c = scrbank[x]; //get character and inc pointer
			u32 *pal = pal32 + ((c >> 12) * 16); //palette for the character
			u8 *chardata = charbank + ((c & 0x1ff) * 32); //character data

			if((c & 0x0c00) == 0x0c00) //horizontal + vertical flip
				{
				drawblockline_mode0_16color_rev(7,pal);
				drawblockline_mode0_16color_rev(6,pal);
				drawblockline_mode0_16color_rev(5,pal);
				drawblockline_mode0_16color_rev(4,pal);
				drawblockline_mode0_16color_rev(3,pal);
				drawblockline_mode0_16color_rev(2,pal);
				drawblockline_mode0_16color_rev(1,pal);
				drawblockline_mode0_16color_rev(0,pal);
				}
			else if(c & 0x0400) //horizontal flip
				{
				drawblockline_mode0_16color_rev(0,pal);
				drawblockline_mode0_16color_rev(1,pal);
				drawblockline_mode0_16color_rev(2,pal);
				drawblockline_mode0_16color_rev(3,pal);
				drawblockline_mode0_16color_rev(4,pal);
				drawblockline_mode0_16color_rev(5,pal);
				drawblockline_mode0_16color_rev(6,pal);
				drawblockline_mode0_16color_rev(7,pal);
				}
			else if(c & 0x0800) //vertical flip
				{
				drawblockline_mode0_16color(7,pal);
				drawblockline_mode0_16color(6,pal);
				drawblockline_mode0_16color(5,pal);
				drawblockline_mode0_16color(4,pal);
				drawblockline_mode0_16color(3,pal);
				drawblockline_mode0_16color(2,pal);
				drawblockline_mode0_16color(1,pal);
				drawblockline_mode0_16color(0,pal);
				}
			else
				{
				drawblockline_mode0_16color(0,pal);
				drawblockline_mode0_16color(1,pal);
				drawblockline_mode0_16color(2,pal);
				drawblockline_mode0_16color(3,pal);
				drawblockline_mode0_16color(4,pal);
				drawblockline_mode0_16color(5,pal);
				drawblockline_mode0_16color(6,pal);
				drawblockline_mode0_16color(7,pal);
				}
			gbascreen += 8;
			}
		gbascreen += 240 * 7;
		scrbank += 32;
		}
	}
}
/*********************************************************************************************/
void renderer0_16()
{
if(scanline == (gba_timing->screen_scanlines - 1))
	{
if(GETREG16(DISPCNT) & 0x0100)
	renderbg_mode0_16(GETREG16(BG0CNT),GETREG16(BG0HOFS),GETREG16(BG0VOFS));
if(GETREG16(DISPCNT) & 0x0200)
	renderbg_mode0_16(GETREG16(BG1CNT),GETREG16(BG1HOFS),GETREG16(BG1VOFS));
if(GETREG16(DISPCNT) & 0x0400)
	renderbg_mode0_16(GETREG16(BG2CNT),GETREG16(BG2HOFS),GETREG16(BG2VOFS));
if(GETREG16(DISPCNT) & 0x0800)
	renderbg_mode0_16(GETREG16(BG3CNT),GETREG16(BG3HOFS),GETREG16(BG3VOFS));
	}
}
/*********************************************************************************************/
void renderer1_16()
{

}
/*********************************************************************************************/
void renderer2_16()
{

}
/*********************************************************************************************/
void renderer3_16()
{
//if(GETREG16(DISPCNT & 0x0400)
	{
	u32 addr = scanline * 240;
	u16 *s = vram_16 + addr;
	u16 *d = (u16*)theApp.screen + addr;
	u8 i;

	for(i=0;i<240;i++)
		{
		u16 p = *s++;

		*d++ = (u16)(((p & 0x7c00) >> 10) | (p & 0x03e0) | ((p & 0x001f) << 10));
		}
	}
}
/*********************************************************************************************/
void renderer4_16()
{
//if(GETREG16(DISPCNT & 0x0400)
	{
	u32 addr = scanline * 240;
	u8 *s = vram + addr;
	u16 *d = (u16*)theApp.screen + addr;
	u16 *pal = (u16*)pram;
	u8 i;

	if(GETREG16(DISPCNT) & 0x0010) //framebuffer 1
		s += 0xa000;
	for(i=0;i<240;i++)
		*d++ = pal[*s++];
	}
}
/*********************************************************************************************/
void renderer5_16()
{
//if(GETREG16(DISPCNT & 0x0400)
	{
	u16 *s = vram_16 + (scanline * 160);
	u16 *d = (u16*)theApp.screen + (scanline * 240);
	u8 i;

	if(GETREG16(DISPCNT) & 0x0010) //framebuffer 1
		s += 0xa000;
	for(i=0;i<128;i++)
		{
		u16 p = *s++;

		*d++ = (u16)(((p & 0x7c00) >> 10) | (p & 0x03e0) | ((p & 0x001f) << 10));
		}
	}
}
/*********************************************************************************************/
void rendererblank_16()
{
u16 *p = (u16*)theApp.screen;
int i;

for(i=0;i<(240*160);i++)
	*p++ = 0xffff;
}
/*********************************************************************************************/
void renderer0_17()
{
if(scanline == (gba_timing->screen_scanlines - 1))
	{
if(GETREG16(DISPCNT) & 0x0100)
	renderbg_mode0_17(GETREG16(BG0CNT),GETREG16(BG0HOFS),GETREG16(BG0VOFS));
if(GETREG16(DISPCNT) & 0x0200)
	renderbg_mode0_17(GETREG16(BG1CNT),GETREG16(BG1HOFS),GETREG16(BG1VOFS));
if(GETREG16(DISPCNT) & 0x0400)
	renderbg_mode0_17(GETREG16(BG2CNT),GETREG16(BG2HOFS),GETREG16(BG2VOFS));
if(GETREG16(DISPCNT) & 0x0800)
	renderbg_mode0_17(GETREG16(BG3CNT),GETREG16(BG3HOFS),GETREG16(BG3VOFS));
	}
}
/*********************************************************************************************/
void renderer1_17()
{

}
/*********************************************************************************************/
void renderer2_17()
{

}
/*********************************************************************************************/
void renderer3_17()
{
//if(GETREG16(DISPCNT & 0x0400)
	{
	u32 addr = scanline * 240;
	u16 *s = vram_16 + addr;
	u16 *d = (u16*)theApp.screen + addr;
	u8 i;

	for(i=0;i<240;i++)
		{
		u16 p = *s++;

		*d++ = (u16)(((p & 0x7c00) >> 10) | (p & 0x03e0) | ((p & 0x001f) << 10));
		}
	}
}
/*********************************************************************************************/
void renderer4_17()
{
//if(GETREG16(DISPCNT & 0x0400)
	{
	u32 addr = scanline * 240;
	u8 *s = vram + addr;
	u16 *d = (u16*)theApp.screen + addr;
	u16 *pal = (u16*)pram;
	u8 i;

	if(GETREG16(DISPCNT) & 0x0010) //framebuffer 1
		s += 0xa000;
	for(i=0;i<240;i++)
		*d++ = pal[*s++];
	}
}
/*********************************************************************************************/
void renderer5_17()
{
//if(GETREG16(DISPCNT & 0x0400)
	{
	u16 *s = vram_16 + (scanline * 160);
	u16 *d = (u16*)theApp.screen + (scanline * 240);
	u8 i;

	if(GETREG16(DISPCNT) & 0x0010) //framebuffer 1
		s += 0xa000;
	for(i=0;i<128;i++)
		{
		u16 p = *s++;

		*d++ = (u16)(((p & 0x7c00) >> 10) | (p & 0x03e0) | ((p & 0x001f) << 10));
		}
	}
}
/*********************************************************************************************/
void rendererblank_17()
{
u16 *p = (u16*)theApp.screen;
int i;

for(i=0;i<(240*160);i++)
	*p++ = 0xffff;
}
/*********************************************************************************************/
void renderer0_32()
{
if(scanline == (gba_timing->screen_scanlines - 1))
	{
if(GETREG16(DISPCNT) & 0x0100)
	renderbg_mode0_32(GETREG16(BG0CNT),GETREG16(BG0HOFS),GETREG16(BG0VOFS));
if(GETREG16(DISPCNT) & 0x0200)
	renderbg_mode0_32(GETREG16(BG1CNT),GETREG16(BG1HOFS),GETREG16(BG1VOFS));
if(GETREG16(DISPCNT) & 0x0400)
	renderbg_mode0_32(GETREG16(BG2CNT),GETREG16(BG2HOFS),GETREG16(BG2VOFS));
if(GETREG16(DISPCNT) & 0x0800)
	renderbg_mode0_32(GETREG16(BG3CNT),GETREG16(BG3HOFS),GETREG16(BG3VOFS));
	}
}
/*********************************************************************************************/
void renderer1_32()
{

}
/*********************************************************************************************/
void renderer2_32()
{

}
/*********************************************************************************************/
void renderer3_32()
{
//if(GETREG16(DISPCNT & 0x0400)
	{
	u32 addr = scanline * 240;
	u16 *s = vram_16 + addr;
	u32 *d = (u32*)theApp.screen + addr;
	u8 i;

	for(i=0;i<240;i++)
		{
		u16 p = *s++;

		*d++ = (u32)(((p & 0x7c00) >> 7) | ((p & 0x3e0) << 6) | ((p & 0x1f) << 19));
		}
	}
}
/*********************************************************************************************/
void renderer4_32()
{
//if(GETREG16(DISPCNT & 0x0400)
	{
	u32 addr = scanline * 240;
	u8 *s = vram + addr;
	u32 *d = (u32*)theApp.screen + addr;
	u8 i;

	if(GETREG16(DISPCNT) & 0x0010) //framebuffer 1
		s += 0xa000;
	for(i=0;i<240;i++)
		*d++ = pal32[*s++];
	}
}
/*********************************************************************************************/
void renderer5_32()
{
//if(GETREG16(DISPCNT & 0x0400)
	{
	u16 *s = vram_16 + (scanline * 160);
	u32 *d = (u32*)theApp.screen + (scanline * 240);
	u8 i;

	if(GETREG16(DISPCNT) & 0x0010) //framebuffer 1
		s += 0xa000;
	for(i=0;i<128;i++)
		{
		u16 p = *s++;

		*d++ = (u32)(((p & 0x7c00) >> 7) | ((p & 0x3e0) << 6) | ((p & 0x1f) << 19));
		}
	}
}
/*********************************************************************************************/
void rendererblank_32()
{
u32 *p = (u32*)theApp.screen;
int i;

for(i=0;i<(240*160);i++)
	*p++ = 0xffffffff;
}
/*********************************************************************************************/
