// Memory.cpp : implementation file
//

#include "stdafx.h"
#include "creem.h"
#include "Memory.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define LINES 23

/////////////////////////////////////////////////////////////////////////////
// CMemory dialog


CMemory::CMemory(CWnd* pParent /*=NULL*/)
	: CDialog(CMemory::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemory)
	m_jumpaddr = _T("$00000000");
	m_editaddr = _T("$00000000");
	m_editvalue = _T("$00");
	//}}AFX_DATA_INIT
font.CreateFont(14,0,0,0,0,0,0,0,0,0,0,0,0,"Courier New");
up.LoadBitmap(IDB_UP);
down.LoadBitmap(IDB_DOWN);
addr = 0;
}


void CMemory::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemory)
	DDX_Control(pDX, IDC_MEMORYVIEW, m_memory);
	DDX_Control(pDX, IDC_UP, m_up);
	DDX_Control(pDX, IDC_DOWN, m_down);
	DDX_Text(pDX, IDC_JUMPADDR, m_jumpaddr);
	DDV_MaxChars(pDX, m_jumpaddr, 10);
	DDX_Text(pDX, IDC_EDITADDR, m_editaddr);
	DDV_MaxChars(pDX, m_editaddr, 10);
	DDX_Text(pDX, IDC_EDITVALUE, m_editvalue);
	DDV_MaxChars(pDX, m_editvalue, 4);
	//}}AFX_DATA_MAP
m_up.SetBitmap(up);
m_down.SetBitmap(down);
}


BEGIN_MESSAGE_MAP(CMemory, CDialog)
	//{{AFX_MSG_MAP(CMemory)
	ON_WM_CREATE()
	ON_WM_MOVE()
	ON_WM_CLOSE()
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_UP, OnUp)
	ON_BN_CLICKED(IDC_DOWN, OnDown)
	ON_BN_CLICKED(IDC_JUMP, OnJump)
	ON_BN_CLICKED(IDC_PUTVALUE, OnPutvalue)
	ON_BN_CLICKED(IDC_UPDATE, OnUpdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CMemory::update()
{
int i;
char str[256];

m_memory.ResetContent();
m_memory.SetFont(&font);
for(i=0;i<LINES;i++)
	{
	u32 a = addr + (i * 16);

	sprintf(str,"%08x: %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x %02x",a,read(a+0x0),read(a+0x1),read(a+0x2),read(a+0x3),read(a+0x4),read(a+0x5),read(a+0x6),read(a+0x7),read(a+0x8),read(a+0x9),read(a+0xa),read(a+0xb),read(a+0xc),read(a+0xd),read(a+0xe),read(a+0xf));
	m_memory.AddString(str);
	}
}

u8 CMemory::read(u32 addr)
{
switch((addr >> 24) & 0xf)
	{
	case 0x00:if(addr < 0x4000)return(bios[addr & 0x3fff]);else break;
	case 0x01:break;
	case 0x02:return(ewram[addr & 0x3ffff]);
	case 0x03:return(iwram[addr & 0x7fff]);
	case 0x04:return(read8_registers(addr));
	case 0x05:return(pram[addr & 0x3ff]);
	case 0x06:return(vram[addr % 0x18000]);
	case 0x07:return(oam[addr & 0x3ff]);
	default:return(rom[addr & rommask]);
	}
return(0);
}

void CMemory::write(u32 addr,u8 value)
{
if(addr < 0x4000)
	::MessageBox(0,"you cant write to the bios","error",MB_OK);
else if(addr < 0x02000000)
	::MessageBox(0,"there is nothing mapped here","error",MB_OK);
else if(addr >= 0x08000000)
	::MessageBox(0,"you cant write to rom","error",MB_OK);
else
	{
	switch((addr >> 24) & 0xf)
		{
		case 0x00:break;
		case 0x01:break;
		case 0x02:ewram[addr & 0x3ffff] = value;break;
		case 0x03:iwram[addr & 0x7fff] = value;break;
		case 0x04:write8_registers(addr,value);break;
		case 0x05:pram[addr & 0x3ff] = value;break;
		case 0x06:vram[addr % 0x18000] = value;break;
		case 0x07:oam[addr & 0x3ff] = value;break;
		default:break;
		}
	}
}

/////////////////////////////////////////////////////////////////////////////
// CMemory message handlers

int CMemory::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
if(settings->memory_x < 65535 && settings->memory_y < 65535)
	SetWindowPos(0,settings->memory_x,settings->memory_y,0,0,SWP_NOZORDER | SWP_NOSIZE);
	return 0;
}

void CMemory::OnMove(int x, int y) 
{
	CDialog::OnMove(x, y);
	
	// TODO: Add your message handler code here
RECT r;

GetWindowRect(&r);
settings->memory_x = r.left;
settings->memory_y = r.top;
}

void CMemory::OnOK() 
{
	// TODO: Add extra validation here

	CDialog::OnOK();
theApp.OnViewMemory();
}

void CMemory::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	
	CDialog::OnClose();
theApp.OnViewMemory();
}

void CMemory::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	// TODO: Add your message handler code here
update();
}

void CMemory::OnUp() 
{
	// TODO: Add your control notification handler code here
addr -= 16;
update();
}

void CMemory::OnDown() 
{
	// TODO: Add your control notification handler code here
addr += 16;
update();
}

void CMemory::OnJump() 
{
	// TODO: Add your control notification handler code here
char *p,*stop;
int base = 10;

UpdateData(TRUE);
p = m_jumpaddr.GetBuffer(16);
if(strcmp(p,"") != 0)
	{
	if(*p == '$')
		{
		p++;
		base = 16;
		}
	else if((*p == '0' && (*(p+1) == 'x') || (*p == '0' && *(p+1) == 'X')))
		{
		p += 2;
		base = 16;
		}
	addr = strtol(p,&stop,base) & ~0xf;
	update();
	}
}

void CMemory::OnPutvalue() 
{
	// TODO: Add your control notification handler code here
char *a,*v,*stop;
int base;
u32 editaddr;
u8 editvalue;

UpdateData(TRUE);
a = m_editaddr.GetBuffer(16);
v = m_editvalue.GetBuffer(16);
if(strcmp(a,"") != 0 && strcmp(v,"") != 0)
	{
	base = 10;
	if(*a == '$')
		{
		a++;
		base = 16;
		}
	else if((*a == '0' && (*(a+1) == 'x') || (*a == '0' && *(a+1) == 'X')))
		{
		a += 2;
		base = 16;
		}
	editaddr = strtol(a,&stop,base);
	base = 10;
	if(*v == '$')
		{
		v++;
		base = 16;
		}
	else if((*v == '0' && (*(v+1) == 'x') || (*v == '0' && *(v+1) == 'X')))
		{
		v += 2;
		base = 16;
		}
	editvalue = (u8)strtol(v,&stop,base);
	write(editaddr,editvalue);
	update();
	}
}

void CMemory::OnUpdate() 
{
	// TODO: Add your control notification handler code here
update();
}

BOOL CMemory::OnCommand(WPARAM wParam, LPARAM lParam) 
{
	// TODO: Add your specialized code here and/or call the base class
if(LOWORD(wParam) == IDCANCEL)
	{
	theApp.OnViewMemory();
	return(1);
	}
else
	return CDialog::OnCommand(wParam, lParam);
}
