// Settings.cpp : implementation file
//

#include "stdafx.h"
#include "creem.h"
#include "Settings.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSettings dialog


CSettings::CSettings(CWnd* pParent /*=NULL*/)
	: CDialog(CSettings::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSettings)
	m_requirebios = FALSE;
	m_startwhenloaded = FALSE;
	m_startaddr = _T("");
	m_framelimit = FALSE;
	m_frameskip = _T("");
	m_miscdir = _T("");
	m_romsdir = _T("");
	//}}AFX_DATA_INIT
}


void CSettings::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSettings)
	DDX_Control(pDX, IDC_BLITTER, m_blitter);
	DDX_Check(pDX, IDC_REQUIREBIOS, m_requirebios);
	DDX_Check(pDX, IDC_STARTWHENLOADED, m_startwhenloaded);
	DDX_Text(pDX, IDC_STARTADDR, m_startaddr);
	DDV_MaxChars(pDX, m_startaddr, 10);
	DDX_Check(pDX, IDC_FRAMELIMIT, m_framelimit);
	DDX_Text(pDX, IDC_FRAMESKIP, m_frameskip);
	DDV_MaxChars(pDX, m_frameskip, 2);
	DDX_Text(pDX, IDC_MISCDIR, m_miscdir);
	DDX_Text(pDX, IDC_ROMSDIR, m_romsdir);
	//}}AFX_DATA_MAP
}

void CSettings::set_data(settings_t *t)
{
settings = t;
m_romsdir = settings->rompath;
m_miscdir = settings->miscpath;
m_frameskip.Format("%d",settings->frameskip);
m_startaddr.Format("$%08x",settings->startaddr);
m_startwhenloaded = settings->startwhenloaded;
m_requirebios = settings->requirebios;
m_framelimit = settings->framelimit;
}

BEGIN_MESSAGE_MAP(CSettings, CDialog)
	//{{AFX_MSG_MAP(CSettings)
	ON_WM_SHOWWINDOW()
	ON_BN_CLICKED(IDC_ROMSFIND, OnRomsfind)
	ON_BN_CLICKED(IDC_MISCFIND, OnMiscfind)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSettings message handlers

void CSettings::OnOK() 
{
char *p,*stop;
int base;
	// TODO: Add extra validation here
	
	CDialog::OnOK();
if(m_startwhenloaded)
	settings->startwhenloaded = 1;
else
	settings->startwhenloaded = 0;
if(m_requirebios)
	settings->requirebios = 1;
else
	settings->requirebios = 0;
if(m_framelimit)
	settings->framelimit = 1;
else
	settings->framelimit = 0;
p = m_startaddr.GetBuffer(512);
base = 10;
if(strcmp(p,"") != 0)
	{
	if(*p == '$')
		{
		p++;
		base = 16;
		}
	else if(*p == '0' && (*(p+1) == 'x' || *(p+1) == 'X'))
		{
		p += 2;
		base = 16;
		}
	settings->startaddr = strtol(p,&stop,base);
	settings->startaddr &= 0xffffffff;
	}
p = m_frameskip.GetBuffer(512);
base = 10;
if(strcmp(p,"") != 0)
	{
	if(*p == '$')
		{
		p++;
		base = 16;
		}
	else if(*p == '0' && (*(p+1) == 'x' || *(p+1) == 'X'))
		{
		p += 2;
		base = 16;
		}
	settings->frameskip = (u8)strtol(p,&stop,base);
	theApp.frameskipcounter = 0;
	}
delete theApp.m_blitter;
switch(m_blitter.GetCurSel())
	{
	default:
	case 0:settings->blitter = 0;theApp.m_blitter = new gdiblitter;break;
	case 1:settings->blitter = 1;theApp.m_blitter = new dxblitter;break;
	}
theApp.bpp = theApp.m_blitter->init(theApp.m_pMainWnd->GetSafeHwnd());
theApp.savesettings();
p = m_romsdir.GetBuffer(512);
strcpy(settings->rompath,p);
p = m_miscdir.GetBuffer(512);
strcpy(settings->miscpath,p);
}

void CSettings::OnShowWindow(BOOL bShow, UINT nStatus) 
{
	CDialog::OnShowWindow(bShow, nStatus);
	
	// TODO: Add your message handler code here
switch(settings->blitter)
	{
	default:
	case 0:m_blitter.SetCurSel(0);break;
	case 1:m_blitter.SetCurSel(1);break;
	}
}

int CSettings::finddirectory(char *d)
{
BROWSEINFO bi;
char dir[MAX_PATH];
LPITEMIDLIST pidl;

bi.hwndOwner = GetSafeHwnd();
bi.pidlRoot = 0; //change this
bi.pszDisplayName = dir;
bi.lpszTitle = "find directory";
bi.ulFlags = BIF_EDITBOX;
bi.lpfn = 0;
bi.lParam = 0;
bi.iImage = 0;
if((pidl = SHBrowseForFolder(&bi)) == 0)
	return(0);
if(pidl != 0)
	{
	LPMALLOC pMalloc;

	SHGetPathFromIDList(pidl,dir);
	SHGetMalloc(&pMalloc);
	pMalloc->Free((LPVOID)pMalloc);
	pMalloc->Release();
	strncpy(d,dir,512);
	}
return(1);
}

void CSettings::OnRomsfind() 
{
	// TODO: Add your control notification handler code here
char dir[512];

finddirectory(dir);
m_romsdir.Format("%s\\",dir);
UpdateData(FALSE);
}

void CSettings::OnMiscfind() 
{
	// TODO: Add your control notification handler code here
char dir[512];

finddirectory(dir);
m_miscdir.Format("%s\\",dir);
UpdateData(FALSE);
}
