// Timing.cpp : implementation file
//

#include "stdafx.h"
#include "creem.h"
#include "Timing.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTiming dialog


CTiming::CTiming(CWnd* pParent /*=NULL*/)
	: CDialog(CTiming::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTiming)
	m_cpuspeed = 0.0;
	m_visibledots = 0;
	m_visiblescanlines = 0;
	m_hblankdots = 0;
	m_vblankscanlines = 0;
	//}}AFX_DATA_INIT
timing = 0;
}


void CTiming::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTiming)
	DDX_Text(pDX, IDC_CPUSPEED, m_cpuspeed);
	DDX_Text(pDX, IDC_VISIBLEDOTS, m_visibledots);
	DDV_MinMaxByte(pDX, m_visibledots, 0, 255);
	DDX_Text(pDX, IDC_VISIBLESCANLINES, m_visiblescanlines);
	DDV_MinMaxByte(pDX, m_visiblescanlines, 0, 255);
	DDX_Text(pDX, IDC_HBLANKDOTS, m_hblankdots);
	DDV_MinMaxByte(pDX, m_hblankdots, 0, 255);
	DDX_Text(pDX, IDC_VBLANKSCANLINES, m_vblankscanlines);
	DDV_MinMaxByte(pDX, m_vblankscanlines, 0, 255);
	//}}AFX_DATA_MAP
}

void CTiming::set_data(gba_timing_t *t)
{
timing = t;
m_cpuspeed = ((double)timing->cpu_hz) / 1000000;
m_visibledots = timing->screen_dots;
m_visiblescanlines = timing->screen_scanlines;
m_hblankdots = timing->blank_dots;
m_vblankscanlines = timing->blank_scanlines;
}

BEGIN_MESSAGE_MAP(CTiming, CDialog)
	//{{AFX_MSG_MAP(CTiming)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTiming message handlers

void CTiming::OnOK() 
{
	// TODO: Add extra validation here
	CDialog::OnOK();
timing->cpu_hz = (u32)(m_cpuspeed * 1000000);
timing->screen_dots = m_visibledots;
timing->screen_scanlines = m_visiblescanlines;
timing->blank_dots = m_hblankdots;
timing->blank_scanlines = m_vblankscanlines;
}
